/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.RegisterGroupDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class EditRegisterGroupActionDelegate
extends ActionDelegate
implements IObjectActionDelegate {
    private IPersistableRegisterGroup fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object s;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (s = ss.getFirstElement()) instanceof IPersistableRegisterGroup) {
            this.fSelection = (IPersistableRegisterGroup)s;
        }
    }

    private IPersistableRegisterGroup getRegisterGroup() {
        return this.fSelection;
    }

    public void run(IAction action) {
        IPersistableRegisterGroup group = this.getRegisterGroup();
        try {
            IDebugTarget target;
            IRegisterDescriptor[] all = ((CDebugTarget)group.getDebugTarget()).getRegisterDescriptors();
            RegisterGroupDialog dialog = new RegisterGroupDialog(Display.getCurrent().getActiveShell(), group.getName(), all, group.getRegisterDescriptors());
            if (dialog.open() == 0 && (target = group.getDebugTarget()) instanceof ICDebugTarget) {
                ((ICDebugTarget)target).modifyRegisterGroup(group, dialog.getDescriptors());
            }
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("EditRegisterGroupActionDelegate.0"), e.getStatus());
        }
    }
}

