/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.views;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.views.GenericCodanProblemDetailsProvider;
import org.eclipse.cdt.codan.internal.ui.views.ProblemDetailsExtensions;
import org.eclipse.cdt.codan.ui.AbstractCodanProblemDetailsProvider;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ProblemDetails
extends ViewPart {
    public static final String ID = "org.eclipse.cdt.codan.internal.ui.views.ProblemDetails";
    private Composite area;
    private Link message;
    private Link description;
    private GenericCodanProblemDetailsProvider genProvider = new GenericCodanProblemDetailsProvider();
    private AbstractCodanProblemDetailsProvider curProvider = this.genProvider;

    public void createPartControl(Composite parent) {
        this.area = new Composite(parent, 0);
        this.area.setLayout((Layout)new GridLayout());
        SelectionAdapter linkSelAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String link = e.text;
                if (link == null) {
                    return;
                }
                if (link.startsWith("http")) {
                    Program.launch((String)e.text);
                    return;
                }
                if (link.startsWith("file:")) {
                    try {
                        CodanEditorUtility.openFileURL(link, ProblemDetails.this.curProvider.getMarker().getResource());
                    }
                    catch (PartInitException e1) {
                        CodanUIActivator.log(e1);
                    }
                    catch (BadLocationException e1) {
                        CodanUIActivator.log(e1);
                    }
                    return;
                }
                if (link.startsWith("help:")) {
                    return;
                }
            }
        };
        this.message = new Link(this.area, 64);
        this.message.setLayoutData((Object)new GridData(768));
        this.message.addSelectionListener((SelectionListener)linkSelAdapter);
        this.description = new Link(this.area, 64);
        this.description.setLayoutData((Object)new GridData(768));
        this.description.addSelectionListener((SelectionListener)linkSelAdapter);
        ISelectionService ser = (ISelectionService)this.getSite().getService(ISelectionService.class);
        ser.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part.getSite().getId().equals("org.eclipse.ui.views.ProblemView")) {
                    ProblemDetails.this.processSelection(selection);
                }
            }
        });
        ISelection selection = ser.getSelection("org.eclipse.ui.views.ProblemView");
        this.processSelection(selection);
    }

    protected void processSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            IMarker marker = null;
            if (firstElement instanceof IAdaptable) {
                marker = (IMarker)((IAdaptable)firstElement).getAdapter(IMarker.class);
            } else if (firstElement instanceof IMarker) {
                marker = (IMarker)firstElement;
            }
            if (marker != null) {
                this.queryProviders(marker);
                this.area.layout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryProviders(IMarker marker) {
        String id = marker.getAttribute("id", "id");
        Collection<AbstractCodanProblemDetailsProvider> providers = ProblemDetailsExtensions.getProviders(id);
        Iterator<AbstractCodanProblemDetailsProvider> iterator = providers.iterator();
        while (iterator.hasNext()) {
            AbstractCodanProblemDetailsProvider provider;
            AbstractCodanProblemDetailsProvider abstractCodanProblemDetailsProvider = provider = iterator.next();
            synchronized (abstractCodanProblemDetailsProvider) {
                provider.setMarker(marker);
                if (provider.isApplicable(id)) {
                    this.applyProvider(provider);
                    return;
                }
            }
        }
        this.genProvider.setMarker(marker);
        this.applyProvider(this.genProvider);
    }

    private void applyProvider(AbstractCodanProblemDetailsProvider provider) {
        this.curProvider = provider;
        this.setTextSafe(this.message, provider, provider.getStyledProblemMessage());
        this.setTextSafe(this.description, provider, provider.getStyledProblemDescription());
    }

    protected void setTextSafe(Link control, AbstractCodanProblemDetailsProvider provider, String text) {
        try {
            control.setText(text);
        }
        catch (Exception e) {
            control.setText("failed to set text: " + provider.getClass() + " " + e.getMessage());
        }
    }

    public void setFocus() {
        this.message.setFocus();
    }
}

