/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_OWNINGPOWERSUPPLYREDUNDANCYSETACCESS_H_
#define OPENDRIM_OWNINGPOWERSUPPLYREDUNDANCYSETACCESS_H_

#include "PowerSupply_Common.h"

#include "OpenDRIM_OwningPowerSupplyRedundancySet.h"
#include "assocOpenDRIM_OwningPowerSupplyRedundancySet.h"

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_load(const CMPIBroker* broker, string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_unload(string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OwningPowerSupplyRedundancySet>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OwningPowerSupplyRedundancySet& instance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningPowerSupplyRedundancySet& newInstance, const OpenDRIM_OwningPowerSupplyRedundancySet& oldInstance, const char** properties, string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningPowerSupplyRedundancySet& instance, string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningPowerSupplyRedundancySet& instance, string& errorMessage);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_associatorOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const char** properties, vector<Instance>& OwningElement_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_associatorOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const char** properties, vector<Instance>& OwnedElement_associatedInstances, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_referenceOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const vector<Instance>& OwningElement_instances, vector<OpenDRIM_OwningPowerSupplyRedundancySet>& OpenDRIM_OwningPowerSupplyRedundancySet_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_referenceOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const vector<Instance>& OwnedElement_instances, vector<OpenDRIM_OwningPowerSupplyRedundancySet>& OpenDRIM_OwningPowerSupplyRedundancySet_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerSupply_OpenDRIM_OwningPowerSupplyRedundancySet_populate(OpenDRIM_OwningPowerSupplyRedundancySet& instance, string& errorMessage);

#endif /*OPENDRIM_OWNINGPOWERSUPPLYREDUNDANCYSETACCESS_H_*/
