/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "assocOpenDRIM_LogManagesRecord.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorFilter(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, bool& leftToRight, string& errorMessage) {
	_E_;
	string _assocClass, _resultClass, _resultRole, _role;
	assocClass == NULL ? _assocClass = "null" : _assocClass = assocClass;
	resultClass == NULL ? _resultClass = "null" : _resultClass = resultClass;
	resultRole == NULL ?  _resultRole = "null" :  _resultRole = resultRole;
	role == NULL ?  _role = "null" :  _role = role;
	
	_DEBUG(CF_intToStr(sizeof(OpenDRIM_LogManagesRecord_classnames)/sizeof(char*)));
	for (unsigned int i=0; i<sizeof(OpenDRIM_LogManagesRecord_classnames)/sizeof(char*); i++) {
		if (CF_strCmpNoCase(_assocClass, OpenDRIM_LogManagesRecord_classnames[i])) {
			_assocClass=OpenDRIM_LogManagesRecord_classnames[0];
			break;
		}
	}
	if (!CF_strCmpNoCase(_assocClass, "null") && !CF_strCmpNoCase(_assocClass, OpenDRIM_LogManagesRecord_classnames[0]))
		return OK;
	
	Objectpath known(broker, (CMPIObjectPath*) cop);
	int errorCode = CA_associatorResolveDirection(broker, Record_classnames, Log_classnames, Record_NAMESPACE, Log_NAMESPACE, Record_role, Log_role, known, _resultClass, _role, _resultRole, leftToRight);
	if (errorCode != OK)
		return -1;
	
	if (leftToRight) {
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getRecord(broker, ctx, known, knownInstance, NULL, errorMessage));
	} else {
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getLog(broker, ctx, known, knownInstance, NULL, errorMessage));
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associator(const CMPIBroker* broker, const CMPIContext* ctx, const CMPIObjectPath* cop, Instance& knownInstance, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties, vector<Instance>& associatedInstances, bool& leftToRight, string& errorMessage, const string& dicriminant) {
	_E_;
	int errorCode = OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorFilter(broker, ctx, cop, knownInstance, assocClass, resultClass, role, resultRole, leftToRight, errorMessage);
	if (errorCode == -1)
		return OK;
	if (errorCode != OK)
		return errorCode;
	
	if (leftToRight) {
		if (role != NULL && strcasecmp(role, "Record") != 0) return OK;
		if (resultRole != NULL && strcasecmp(resultRole, "Log") != 0) return OK;
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorRecordToLog(broker, ctx, knownInstance, properties, associatedInstances, errorMessage, dicriminant));
	} else {
		if (role != NULL && strcasecmp(role, "Log") != 0) return OK;
		if (resultRole != NULL && strcasecmp(resultRole, "Record") != 0) return OK;
		CF_assert(OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_associatorLogToRecord(broker, ctx, knownInstance, properties, associatedInstances, errorMessage, dicriminant));
	}
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateRecords(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage) {
	_E_;
	/*
	 * CMPI broker version
	 */
	if (onlyNames) {
		vector<Objectpath> objectpaths;
		CF_assert(CB_enumerateInstanceNames(broker, ctx, Record_NAMESPACE, Record_classnames[0], objectpaths, errorMessage));
		for (size_t i=0; i<objectpaths.size(); i++)
			instances.push_back(Instance(broker, objectpaths[i]));
	} else {
		CF_assert(CB_enumerateInstances(broker,ctx, Record_NAMESPACE, Record_classnames[0], properties, instances, errorMessage));
	}
	/*
	 * Direct Invocation version
	 */
	/*
	vector<CIM_RecordForLog> _instances;
	if (onlyNames) {
		CF_assert(OpenDRIM_RecordLogPackage_CIM_RecordForLog_retrieve(broker, ctx, _instances, properties, errorMessage, "ein"));
	} else {
		CF_assert(OpenDRIM_RecordLogPackage_CIM_RecordForLog_retrieve(broker, ctx, _instances, properties, errorMessage, "ei"));
	}

	for (size_t i=0; i<_instances.size(); i++)
		instances.push_back(Instance(broker, OpenDRIM_RecordLogPackage_CIM_RecordForLog_toCMPIInstance(broker, _instances[i])));
	*/
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getRecord(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage) {
	_E_;
	if (!CF_strCmpNoCase(objectpath.getClassname(), Record_classnames[0]))
		return INVALID_CLASS;
	//if (!CF_strCmpNoCase(objectpath.getNamespace(), Record_NAMESPACE))
	//	return INVALID_NAMESPACE;
	/*
	 * CMPI broker version
	 */
	CF_assert(CB_getInstance(broker, ctx, objectpath, properties, instance, errorMessage));
	
	/*
	 * Direct Invocation version
	 */
	/*
	CIM_RecordForLog _instance;
	OpenDRIM_RecordLogPackage_CIM_RecordForLog_toCPP(broker, objectpath.getHdl(), _instance);
	CF_assert(OpenDRIM_RecordLogPackage_CIM_RecordForLog_getInstance(broker, ctx, _instance, properties, errorMessage));
	instance = Instance(broker, OpenDRIM_RecordLogPackage_CIM_RecordForLog_toCMPIInstance(broker, _instance));
	*/
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_enumerateLogs(const CMPIBroker* broker, const CMPIContext* ctx, vector<Instance>& instances, const char** properties, bool onlyNames, string& errorMessage) {
	_E_;
	/*
	 * CMPI broker version
	 */
	if (onlyNames) {
		vector<Objectpath> objectpaths;
		CF_assert(CB_enumerateInstanceNames(broker, ctx, Log_NAMESPACE, Log_classnames[0], objectpaths, errorMessage));
		for (size_t i=0; i<objectpaths.size(); i++)
			instances.push_back(Instance(broker, objectpaths[i]));
	} else {
		CF_assert(CB_enumerateInstances(broker,ctx, Log_NAMESPACE, Log_classnames[0], properties, instances, errorMessage));
	}
	/*
	 * Direct Invocation version
	 */
	/*
	vector<CIM_Log> _instances;
	if (onlyNames) {
		CF_assert(OpenDRIM_RecordLogPackage_CIM_Log_retrieve(broker, ctx, _instances, properties, errorMessage, "ein"));
	} else {
		CF_assert(OpenDRIM_RecordLogPackage_CIM_Log_retrieve(broker, ctx, _instances, properties, errorMessage, "ei"));
	}

	for (size_t i=0; i<_instances.size(); i++)
		instances.push_back(Instance(broker, OpenDRIM_RecordLogPackage_CIM_Log_toCMPIInstance(broker, _instances[i])));
	*/
	_L_;
	return OK;
}

int OpenDRIM_RecordLogPackage_OpenDRIM_LogManagesRecord_getLog(const CMPIBroker* broker, const CMPIContext* ctx, const Objectpath& objectpath, Instance& instance, const char** properties, string& errorMessage) {
	_E_;
	if (!CF_strCmpNoCase(objectpath.getClassname(), Log_classnames[0]))
		return INVALID_CLASS;
	//if (!CF_strCmpNoCase(objectpath.getNamespace(), Log_NAMESPACE))
	//	return INVALID_NAMESPACE;
	/*
	 * CMPI broker version
	 */
	CF_assert(CB_getInstance(broker, ctx, objectpath, properties, instance, errorMessage));

	/*
	 * Direct Invocation version
	 */
	/*
	CIM_Log _instance;
	OpenDRIM_RecordLogPackage_CIM_Log_toCPP(broker, objectpath.getHdl(), _instance);
	CF_assert(OpenDRIM_RecordLogPackage_CIM_Log_getInstance(broker, ctx, _instance, properties, errorMessage));
	instance = Instance(broker, OpenDRIM_RecordLogPackage_CIM_Log_toCMPIInstance(broker, _instance));
	*/
	_L_;
	return OK;
}
