/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.WebContentGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHttpRequestHandler
extends WebContentGenerator
implements HttpRequestHandler,
InitializingBean {
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ResourceHttpRequestHandler.class.getClassLoader());
    private List<Resource> locations;

    public ResourceHttpRequestHandler() {
        super("GET", "HEAD");
    }

    public void setLocations(List<Resource> locations) {
        Assert.notEmpty(locations, (String)"Locations list must not be empty");
        this.locations = locations;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.locations, (String)"Locations list must not be empty");
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, true);
        Resource resource = this.getResource(request);
        if (resource == null) {
            this.logger.debug((Object)"No matching resource found - returning 404");
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(resource);
        if (mediaType != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Determined media type '" + mediaType + "' for " + resource));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No media type found for " + resource + " - not sending a content-type header"));
        }
        if (new ServletWebRequest(request, response).checkNotModified(resource.lastModified())) {
            this.logger.debug((Object)"Resource not modified - returning 304");
            return;
        }
        this.setHeaders(response, resource, mediaType);
        if ("HEAD".equals(request.getMethod())) {
            this.logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, resource);
    }

    protected Resource getResource(HttpServletRequest request) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (path == null) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (!StringUtils.hasText((String)path) || this.isInvalidPath(path)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Ignoring invalid resource path [" + path + "]"));
            }
            return null;
        }
        for (Resource location : this.locations) {
            try {
                Resource resource;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Trying relative path [" + path + "] against base location: " + location));
                }
                if ((resource = location.createRelative(path)).exists() && resource.isReadable()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Found matching resource: " + resource));
                    }
                    return resource;
                }
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace((Object)("Relative resource doesn't exist or isn't readable: " + resource));
            }
            catch (IOException ex) {
                this.logger.debug((Object)"Failed to create relative resource - trying next resource location", (Throwable)ex);
            }
        }
        return null;
    }

    protected boolean isInvalidPath(String path) {
        return path.contains("WEB-INF") || path.contains("META-INF") || StringUtils.cleanPath((String)path).startsWith("..");
    }

    protected MediaType getMediaType(Resource resource) {
        MediaType jafMediaType;
        MediaType mediaType = null;
        String mimeType = this.getServletContext().getMimeType(resource.getFilename());
        if (StringUtils.hasText((String)mimeType)) {
            mediaType = MediaType.parseMediaType((String)mimeType);
        }
        if (jafPresent && (mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals((Object)mediaType)) && (jafMediaType = ActivationMediaTypeFactory.getMediaType(resource.getFilename())) != null && !MediaType.APPLICATION_OCTET_STREAM.equals((Object)jafMediaType)) {
            mediaType = jafMediaType;
        }
        return mediaType;
    }

    protected void setHeaders(HttpServletResponse response, Resource resource, MediaType mediaType) throws IOException {
        long length = resource.contentLength();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Resource content too long (beyond Integer.MAX_VALUE): " + resource);
        }
        response.setContentLength((int)length);
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
    }

    protected void writeContent(HttpServletResponse response, Resource resource) throws IOException {
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (!mappingLocation.exists()) return FileTypeMap.getDefaultFileTypeMap();
            InputStream inputStream = null;
            inputStream = mappingLocation.getInputStream();
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
            Object var4_4 = null;
            if (inputStream == null) return mimetypesFileTypeMap;
            try {
                inputStream.close();
                return mimetypesFileTypeMap;
            }
            catch (IOException ex) {
                // empty catch block
            }
            return mimetypesFileTypeMap;
            catch (IOException iOException) {
                try {
                    Object var4_5 = null;
                    if (inputStream == null) return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                    return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (IOException ex) {}
                return FileTypeMap.getDefaultFileTypeMap();
            }
        }

        public static MediaType getMediaType(String filename) {
            String mediaType = fileTypeMap.getContentType(filename);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

