#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# True Fear series:
# - True Fear: Forsaken Souls Part 1
# - True Fear: Forsaken Souls Part 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20240609.2

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_EPISODE1='true-fear-1'
GAME_NAME_EPISODE1='True Fear: Forsaken Souls Part 1'

GAME_ID_EPISODE2='true-fear-2'
GAME_NAME_EPISODE2='True Fear: Forsaken Souls Part 2'

ARCHIVE_BASE_EPISODE1_0_NAME='setup_true_fear_forsaken_souls_part_1_2.0.26_(43095).exe'
ARCHIVE_BASE_EPISODE1_0_MD5='12c98dc222047ba571e7c1ce3e6689c8'
ARCHIVE_BASE_EPISODE1_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE1_0_SIZE='660000'
ARCHIVE_BASE_EPISODE1_0_VERSION='1.2.0.26-gog43095'
ARCHIVE_BASE_EPISODE1_0_URL='https://www.gog.com/game/true_fear_forsaken_souls'

ARCHIVE_BASE_EPISODE2_0_NAME='setup_true_fear_forsaken_souls_part_2_2.0.8_(49144).exe'
ARCHIVE_BASE_EPISODE2_0_MD5='e464cb8eedd9728249efde7593c75f79'
ARCHIVE_BASE_EPISODE2_0_TYPE='innosetup'
ARCHIVE_BASE_EPISODE2_0_SIZE='900000'
ARCHIVE_BASE_EPISODE2_0_VERSION='2.0.8-gog49144'
ARCHIVE_BASE_EPISODE2_0_URL='https://www.gog.com/game/true_fear_forsaken_souls_part_2'

UNITY3D_NAME_EPISODE1='true fear'
UNITY3D_NAME_EPISODE2='true fear 2'

CONTENT_PATH_DEFAULT='.'
## TODO: Check if these files are required.
CONTENT_GAME0_DATA_FILES_EPISODE1='
branding
branding.meta'

WINE_PERSISTENT_DIRECTORIES_EPISODE1='
users/${USER}/AppData/Local/Goblinz/TrueFear_ForsakenSouls'
WINE_PERSISTENT_DIRECTORIES_EPISODE2='
users/${USER}/AppData/LocalLow/Goblinz Enterprises Limited/True Fear 2'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID_EPISODE1="${GAME_ID_EPISODE1}-data"
PKG_DATA_ID_EPISODE2="${GAME_ID_EPISODE2}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS_EPISODE1="$PKG_DATA_ID_EPISODE1"
PKG_BIN_DEPS_EPISODE2="$PKG_DATA_ID_EPISODE2"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
