!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawxcgrad
!! NAME
!! pawxcgrad
!!
!! FUNCTION
!! PAW only
!! In the case of GGA, add the contribution of gradients to the XC potential
!!
!! COPYRIGHT
!! Copyright (C) 2001-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  dvxcdgr(nrad,3)= 1/$|grad \rho_up|$ (d($\rho$*exc)/d($|grad \rho_up|$)) (hartree)
!!                   1/$|grad \rho_dn|$ (d($\rho$*exc)/d($|grad \rho_dn|$)) (hartree)
!!              and  1/$|grad \rho|$ (d($\rho$*exc)/d($|grad \rho|$))       (hartree)
!!  grho2_updn(nrad,2*nspden-1)=the square of the gradients spin-up, spin-down, and total density
!!  ngrad= must be 2
!!  nrad= number of radial points
!!  nspden=number of spin-density components
!!  nspgrad=number of spin-density and spin-density-gradient components
!!  nvxcdgr=second dimension of dvxcdgr, while for ixc=16 nvxcdgr=2
!!  pawrad<type(pawrad_type)>=paw radial mesh and related data
!!
!! OUTPUT
!!  dnexcdn(nrad,nspgrad)=derivative of Exc with respect to the (spin-)density,
!!    or to the norm of the gradient of the (spin-)density,
!!    further divided by the norm of the gradient of the (spin-)density
!!   The different components of dnexcdn will be
!!   for nspden=1,         dnexcdn(:,1)=d(n.exc)/d(n)
!!         and if ngrad=2, dnexcdn(:,2)=1/2*1/|grad n_up|*d(n.exc)/d(|grad n_up|)
!!                                      +   1/|grad n|*d(n.exc)/d(|grad n|)
!!         (do not forget : |grad n| /= |grad n_up| + |grad n_down|
!!   for nspden=2,         dnexcdn(:,1)=d(n.exc)/d(n_up)
!!                         dnexcdn(:,2)=d(n.exc)/d(n_down)
!!         and if ngrad=2, dnexcdn(:,3)=1/|grad n_up|*d(n.exc)/d(|grad n_up|)
!!                         dnexcdn(:,4)=1/|grad n_down|*d(n.exc)/d(|grad n_down|)
!!                         dnexcdn(:,5)=1/|grad n|*d(n.exc)/d(|grad n|)
!!
!! SIDE EFFECTS
!!  rhonow(nrad,nspden,ngrad*ngrad)=
!!   at input :
!!    electron (spin)-density in real space and its gradient,
!!    either on the unshifted grid (if ishift==0,
!!      then equal to rhor), or on the shifted grid
!!     rhonow(:,:,1)=electron density in electrons/bohr**3
!!     rhonow(:,:,2:4)=gradient of electron density in el./bohr**4
!!   at output :
!!    rhonow(:,:,2:4) has been multiplied by the proper factor,
!!    described above.
!!  vxci(nrad,2)=
!!   at input : contribution of the LDA part
!!   at output: contribution of the LDA part + the GGA part
!!
!! PARENTS
!!      pawxcm
!!
!! CHILDREN
!!      deducer0,nderiv_gen
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawxcgrad(dnexcdn,dvxcdgr,grho2_updn,ngrad,nrad,nspden,nspgrad,nvxcdgr,&
&                     pawrad,rhonow,vxci)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ngrad,nrad,nspden,nspgrad,nvxcdgr
 type(pawrad_type),intent(in) :: pawrad
!arrays
 real(dp),intent(in) :: dvxcdgr(nrad,nvxcdgr),grho2_updn(nrad,2*nspden-1)
 real(dp),intent(inout) :: vxci(nrad,nspden)
 real(dp),intent(out) :: dnexcdn(nrad,nspgrad),rhonow(nrad,nspden,ngrad*ngrad)

!Local variables ------------------------------
!scalars
 integer :: idir,ir,ispden
 real(dp) :: coeff,rho_tot,rho_up
!arrays
 real(dp),allocatable :: gradxc(:,:)

! *************************************************************************

!--------------------------------------------------------------------------
! First compute dnexcdn
!--------------------------------------------------------------------------
 do ir=1,nrad
  dnexcdn(ir,1)=vxci(ir,1)
  if(nspden==2) dnexcdn(ir,2)=vxci(ir,2)
! Additional terms for GGAs
! Treat explicitely spin up, spin down and total spin for spin-polarized
! Will exit when ispden=1 is finished if non-spin-polarized
  do ispden=1,3
   if(nspden==1 .and. ispden>=2) exit
!  If the norm of the gradient vanishes, then the different terms
!  vanishes, but the inverse of the gradient diverges,
!  so skip the update.
   if(grho2_updn(ir,ispden) < 1.0d-24) then
    dnexcdn(ir,ispden+nspden)=zero
    cycle
   end if
!  Compute the derivative of n.e_xc wrt the spin up, spin down,
!  or total density. In the non-spin-polarized case take the coeff.
!  that will be multiplied by the gradient of the total density.
   if (nvxcdgr /= 0 ) then
    if(nspden==1) then
      !Definition of dvxcdgr changed in v3.3
      if (nvxcdgr == 3) then
         coeff=0.5_dp*dvxcdgr(ir,1) + dvxcdgr(ir,3)
      else
         coeff=0.5_dp*dvxcdgr(ir,1)
      end if
    else if(nspden==2)then
      if (nvxcdgr == 3) then
         coeff=dvxcdgr(ir,ispden)
      else if (ispden /= 3) then
         coeff=dvxcdgr(ir,ispden)
      else if (ispden == 3) then
         coeff=zero
      end if
    end if
   end if
!!$   if(nspden==1) then
!!$    coeff=0.5_dp*dvxcdgr(ir,1) + dvxcdgr(ir,3)
!!$   else if(nspden==2)then
!!$    coeff=dvxcdgr(ir,ispden)
!!$   end if
   dnexcdn(ir,ispden+nspden)=coeff
  end do
 end do

!--------------------------------------------------------------------------
! Then calculate rhonow*dnexcdn and put it in rhonow
! Calculation of the radial part only
!--------------------------------------------------------------------------
 if (nvxcdgr /= 0 ) then
  if(nspden==1)then
   rhonow(:,1,2)=rhonow(:,1,2)*dnexcdn(:,2)
  else
!  In the spin-polarized case, there are more factors to take into account
   do ir=1,nrad
    rho_tot=rhonow(ir,1,2)
    rho_up =rhonow(ir,2,2)
    rhonow(ir,1,2)=rho_up *dnexcdn(ir,3)+&
&                         rho_tot*dnexcdn(ir,5)
    rhonow(ir,2,2)=(rho_tot-rho_up)*dnexcdn(ir,4)+&
&                          rho_tot*dnexcdn(ir,5)
   end do
  end if
 end if

!--------------------------------------------------------------------------
!Then calculate the derivative of new rhonow versus r
!--------------------------------------------------------------------------
 allocate(gradxc(nrad,nspden))
 do ispden=1,nspden
! Compute the radial part only
  call nderiv_gen(gradxc(:,ispden),rhonow(:,ispden,2),1,pawrad)
! Compute vxc
  vxci(2:nrad,ispden)=vxci(2:nrad,ispden)-gradxc(2:nrad,ispden)-2._dp*rhonow(2:nrad,ispden,2)/pawrad%rad(2:nrad)
  call deducer0(vxci(:,ispden),nrad,pawrad)
 end do
 deallocate(gradxc)

 end subroutine pawxcgrad
!!***
