/****************************************************************************

	RegExp.c

	This file contains the C code for the regular expression
	matching code.

	The routines supported act as a more friendly, user level
	interface to the regexp regular expression matching system.

 ****************************************************************************/

/*
 * Author:
 * 	Brian Totty
 * 	Department of Computer Science
 * 	University Of Illinois at Urbana-Champaign
 *	1304 West Springfield Avenue
 * 	Urbana, IL 61801
 * 
 * 	totty@cs.uiuc.edu
 * 	
 */ 

#include "RegExp.h"
#include <regex.h>

void RegExpCompile(regexp,fsm_ptr)
char *regexp;
regex_t *fsm_ptr;
{
	regcomp(fsm_ptr, regexp, REG_NOSUB|REG_EXTENDED);
/*
	compile(regexp,fsm_ptr,&(fsm_ptr[fsm_length]),'\0');
*/
} /* End RegExpCompile */


int RegExpMatch(string,fsm_ptr)
char *string;
regex_t *fsm_ptr;
{
	if (regexec(fsm_ptr, string, 0, NULL, 0) == 0)
		return(TRUE);
	return(FALSE);
/*
	if (advance(string,fsm_ptr) != 0)
		return(TRUE);
	    else
		return(FALSE);
*/
} /* End RegExpMatch */


void _RegExpError(val)
int val;
{
	fprintf(stderr,"Regular Expression Error %d\n",val);
	exit(-1);
} /* End _RegExpError */


void RegExpPatternToRegExp(pattern,reg_exp)
char *pattern,*reg_exp;
{
	int in_bracket;

	in_bracket = 0;
	while (*pattern != '\0')
	{
		if (in_bracket)
		{
			if (*pattern == ']') in_bracket = 0;
			*reg_exp++ = *pattern++;
		}
		    else
		{
			switch (*pattern)
			{
			    case '[':
				in_bracket = 1;
				*reg_exp++ = '[';
				break;
			    case '?':
				*reg_exp++ = '.';
				break;
			    case '*':
				*reg_exp++ = '.';
				*reg_exp++ = '*';
				break;
			    case '.':
				*reg_exp++ = '\\';
				*reg_exp++ = '.';
				break;
			    default:
				*reg_exp++ = *pattern;
				break;
			}
			++ pattern;
		}
	}
	*reg_exp++ = '$';
	*reg_exp++ = '\0';
} /* End RegExpPatternToRegExp */
