// ---------------------------------------------------------------------------
// - Fpoint.hpp                                                              -
// - afnix:mth module - floating point definitions                           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2019 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_FPOINT_HPP
#define  AFNIX_FPOINT_HPP

#ifndef  AFNIX_RPI_HPP
#include "Rpi.hpp"
#endif
 
namespace afnix {

  /// This Fpoint class is the default implementation of the floating point
  /// interface. Internally, the point is represented as an array of t_real.
  /// @author amaury darsch

  class Fpoint : public Rpi {
  protected:
    /// the point element
    float* p_ptab;

  public:
    /// create a null point
    Fpoint (void);

    /// create a point by size
    /// @param size the point size
    Fpoint (const t_long size);

    /// copy construct this point
    /// @param that the object to copy
    Fpoint (const Fpoint& that);

    /// destroy this point
    ~Fpoint (void);

    /// assign a point to this one
    /// @param that the object to assign
    Fpoint& operator = (const Fpoint& that);
    
    /// @return the class name
    String repr (void) const;

    /// @return a clone of this object
    Object* clone (void) const;

    /// @return the serial did
    t_word getdid (void) const;
    
    /// @return the serial sid
    t_word getsid (void) const;

    /// resize this point
    /// @param size the new point size
    void resize (const t_long size);

    /// reset this point
    void reset (void);

    /// clear this point
    void clear (void);

  public:
    /// no lock - set a point by position
    /// @param pos the point position
    /// @param val the value to set
    void nlset (const t_long pos, const t_real val);

    /// no lock - get a point value by position
    /// @param pos the point position
    t_real nlget (const t_long pos) const;

  public:
    /// create a new object in a generic way
    /// @param argv the argument point
    static Object* mknew (Vector* argv);
  };
}

#endif
