#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Basic functionality tests.
#
# $Id: basic.py 8851 2007-03-13 05:29:01Z andrewm $

import unittest
import albatross
import albatross_test
import time

class BasicCase(albatross_test.AlbatrossTestCase):
    template_dir = "basic"

    def check_file(self):
        self.html_test("file.html", "plain\n")

    def check_nxfile(self):
        self.test_raise("nxfile.html")

    def check_const_value(self):
        self.html_test("const-value.html", "27")

    def check_null_attr(self):
        self.html_test("null-attr.html", '<img alt="" ismap src="" />')

    def check_attr_quote(self):
        self.html_test("attr-quote.html", "abcdefghijkl")

    def check_value_no_expr(self):
        self.test_raise("value-no-expr.html")

    def check_value_no_expr_sp(self):
        self.test_raise("value-no-expr-sp.html")

    def check_var_value(self):
        self.ctx.locals.x = 17
        self.html_test("var-value.html", "17")

    def check_var_float(self):
        self.ctx.locals.x = 2.1
        self.html_test("var-value.html", "2.1")

    def check_var_string(self):
        self.ctx.locals.x = "abc"
        self.html_test("var-value.html", "abc")

    def check_var_escape(self):
        self.ctx.locals.x = '<img src="http://rude.pictures.r.us/">'
        self.html_test("var-value.html", "&lt;img src=&quot;http://rude.pictures.r.us/&quot;&gt;")

    def check_var_noescape(self):
        self.ctx.locals.x = '<img src="http://rude.pictures.r.us/">'
        self.html_test("var-value-noescape.html", '<img src="http://rude.pictures.r.us/">')

    def check_date(self):
        t = time.strftime("%A, %B %d, %Y, %I:%M%p", 
                          time.localtime(996113203.67031395))
        self.html_test("date.html", t)

    def check_comment(self):
        self.html_test("comment.html", "one\nfour\n")

    def check_exec(self):
        self.html_test("exec.html", " 2 3 5 7")

class BasicSuite(unittest.TestSuite):
    test_list = (
        "check_file",
        "check_nxfile",
        "check_const_value",
        "check_null_attr",
        "check_attr_quote",
        "check_value_no_expr",
        "check_value_no_expr_sp",
        "check_var_value",
        "check_var_float",
        "check_var_string",
        "check_var_escape",
        "check_var_noescape",
        "check_date",
        "check_comment",
        "check_exec",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(BasicCase, self.test_list))

def suite():
    return BasicSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
