# I.8 Does revolutionary Spain show that libertarian socialism can work in
practice?

Yes. Revolutionary Spain _"shows you what human beings are like when they are
trying to behave as human beings and not as cogs in the capitalist machine."_
[George Orwell, **Orwell in Spain** , p. 254] At the heart of the
transformation were the CNT (the National Confederation of Labour, an anarcho-
syndicalist union) and the FAI (Iberian Anarchist Federation). As Murray
Bookchin put it:

> _"In Spain, millions of people took large segments of the economy into their
> own hands, collectivised them, administered them, even abolished money and
> lived by communistic principles of work and distribution -- all of this in
> the midst of a terrible civil war, yet without producing the chaos or even
> the serious dislocations that were and still are predicted by authoritarian
> 'radicals.' Indeed, in many collectivised areas, the efficiency with which
> an enterprise worked by far exceeded that of a comparable one in
> nationalised or private sectors. This 'green shoot' of revolutionary reality
> has more meaning for us than the most persuasive theoretical arguments to
> the contrary. On this score it is not the anarchists who are the
> 'unrealistic day-dreamers,' but their opponents who have turned their backs
> to the facts or have shamelessly concealed them."_ [ _"Introductory Essay,"_
> **The Anarchist Collectives** , Sam Dolgoff (ed.), p. xxxix]

Anarchist and CNT activist Gaston Leval comments that in those areas which
defeated the fascist uprising on the 19th of July 1936 a profound social
revolution took place based, mostly, on anarchist ideas:

> _"In Spain, during almost three years, despite a civil war that took a
> million lives, despite the opposition of the political parties . . . this
> idea of libertarian communism was put into effect. Very quickly more than
> 60% of the land was collectively cultivated by the peasants themselves,
> without landlords, without bosses, and without instituting capitalist
> competition to spur production. In almost all the industries, factories,
> mills, workshops, transportation services, public services, and utilities,
> the rank and file workers, their revolutionary committees, and their
> syndicates reorganised and administered production, distribution, and public
> services without capitalists, high-salaried managers, or the authority of
> the state._

> _"Even more: the various agrarian and industrial collectives immediately
> instituted economic equality in accordance with the essential principle of
> communism, 'From each according to his ability and to each according to his
> needs.' They co-ordinated their efforts through free association in whole
> regions, created new wealth, increased production (especially in
> agriculture), built more schools, and bettered public services. They
> instituted not bourgeois formal democracy but genuine grass roots functional
> libertarian democracy, where each individual participated directly in the
> revolutionary reorganisation of social life. They replaced the war between
> men, 'survival of the fittest,' by the universal practice of mutual aid, and
> replaced rivalry by the principle of solidarity . . ._

> _"This experience, in which about eight million people directly or
> indirectly participated, opened a new way of life to those who sought an
> alternative to anti-social capitalism on the one hand, and totalitarian
> state bogus socialism on the other."_ [ **Op. Cit.** , pp. 6-7]

Thus about eight million people directly or indirectly participated in the
libertarian based new economy during the short time it was able to survive the
military assaults of the fascists and the attacks and sabotage of the
Communists and Republican state. This in itself suggests that libertarian
socialist ideas are of a practical nature.

Lest the reader think that Leval and Bookchin are exaggerating the
accomplishments and ignoring the failures of the Spanish collectives, in the
following subsections we will present specific details and answer some
objections often raised by misinformed critics. We will try to present an
objective analysis of the revolution, its many successes, its strong and weak
points, the mistakes made and possible lessons to be drawn from the
experience, both from the successes and the failures. However, this will
hardly do justice to the collectivisation as it _"assumed an infinite
diversity of forms from village to village, and even in the different firms
collectivised in the cities . . . there was an element of improvisation and of
the exceptional wartime conditions experienced by the country (i.e., the war
against fascism) and the arrangements had their flaws as well as their good
points."_ [Jose Peirats, **The CNT in the Spanish Revolution** , vol. 1, p.
223]

This libertarian influenced revolution has (generally) been ignored by
historians, or its existence mentioned in passing. Some so-called historians
and "objective investigators" have slandered it and lied about (when not
ignoring) the role anarchists played in it. Communist histories are
particularly unreliable (to use a polite word for their activities) but it
seems that almost **every** political perspective has done this (including
liberal, so-called right-wing "libertarian", Stalinist, Trotskyist, Marxist,
and so on). So any attempt to investigate what actually occurred in Spain and
the anarchists' role in it is subject to a great deal of difficulty. Moreover,
the positive role that Anarchists played in the revolution and the positive
results of our ideas when applied in practice are also downplayed, if not
ignored. Indeed, the misrepresentations of the Spanish Anarchist movement are
downright amazing (see Jerome R. Mintz's wonderful book **The Anarchists of
Casa Viejas** and J. Romero Maura's article _"The Spanish case"_ [ **Anarchism
Today** , J. Joll and D. Apter (eds.)] for a refutation of many of the
standard assertions and distortions about the Spanish anarchist movement by
historians). The myths generated by Marxists of various shades are, perhaps
needless to say, the most extensive.

All we can do here is present a summary of the social revolution that took
place and attempt to explode a few of the myths that have been created around
the work of the CNT and FAI during those years. We must stress that this can
be nothing but a short introduction to the Spanish Revolution. We concentrate
on the economic and political aspects of the revolution as we cannot cover
everything. However, we must mention the social transformations that occurred
all across non-fascist Spain. The revolution saw the traditional social
relationships between men and women, adults and children, individual and
individual transformed, revolutionised in a libertarian way. CNT militant Abel
Paz gave a good idea of what happened:

> _"Industry is in the hands of the workers and all the production centres
> conspicuously fly the red and black flags as well as inscriptions announcing
> that they have really become collectives. The revolution seems to be
> universal. Changes are also evident in social relations. The former barriers
> which used to separate men and woman arbitrarily have been destroyed. In the
> cafes and other public places there is a mingling of the sexes which would
> have been completely unimaginable before. The revolution has introduced a
> fraternal character to social relations which has deepened with practice and
> show clearly that the old world is dead."_ [ **Durruti: The People Armed** ,
> p. 243]

The social transformation empowered individuals and these, in turn,
transformed society. Anarchist militant Enriqueta Rovira presents a vivid
picture of the self-liberation the revolution generated:

> _"The atmosphere then, the feelings were very special. It was beautiful. A
> feeling of -- how shall I say it -- of power, not in the sense of
> domination, but in the sense of things being under **our** control, of under
> anyone's. Of **possibility**. We **had** everything. We had Barcelona: It
> was ours. You'd walk out in the streets, and they were ours -- here, CNT;
> there, **comite** this or that. It was totally different. Full of
> possibility. A feeling that we could, together, really **do** something.
> That we could make things different."_ [quoted by Martha A. Ackelsberg and
> Myrna Margulies Breithart, _"Terrains of Protest: Striking City Women"_ ,
> pp. 151-176, **Our Generation** , vol. 19, No. 1, pp. 164-5]

Moreover, the transformation of society that occurred during the revolution
extended to all areas of life and work. For example, the revolution saw _"the
creation of a health workers' union, a true experiment in socialised medicine.
They provided medical assistance and opened hospitals and clinics."_ [Juan
Gomez Casas, **Anarchist Organisation: The History of the FAI** , p. 192] We
discuss this example in some detail in [section I.5.12](secI5.md#seci512)
and so will not do so here. We simply stress that this section of the FAQ is
just an introduction to what happened and does not (indeed, cannot) discuss
all aspects of the revolution. We just present an overview, bringing out the
libertarian aspects of the revolution, the ways workers' self-management was
organised, how the collectives organised and what they did.

Needless to say, many mistakes were made during the revolution. We point out
and discuss some of them in what follows. Moreover, much of what happened did
not correspond exactly with what many people consider as the essential steps
in a communist (libertarian or otherwise) revolution. Nor, it must be
stressed, did much of it reflect the pre-revolution stated aims of the CNT
itself. Economically, for example, the collectives themselves were an
unexpected development, one which was based on libertarian principles but also
reflected the reality of the situation the CNT militants found themselves in.
Much the same can be said of the fact that few collectives reached beyond
mutualism or collectivism in spite of the CNT seeking a libertarian communist
economy. Politically, the fear of a fascist victory made many anarchists
accept collaboration with the state as a lesser evil. However, to dismiss the
Spanish Revolution because it did not meet the ideals laid out by a handful of
revolutionaries beforehand would be sectarian and elitist nonsense. No working
class revolution is pure, no mass struggle is without its contradictions, no
attempt to change society is perfect. _"It is only those who do nothing who
make no mistakes,"_ as Kropotkin so correctly pointed out. [ **Anarchism** ,
p. 143] The question is whether the revolution creates a system of
institutions which will allow those involved to discuss the problems they
face, change the decisions reached and correct any mistakes they make. In
this, the Spanish Revolution clearly succeeded, creating organisations based
on the initiative, autonomy and power of working class people.

For more information about the social revolution, Sam Dolgoff's anthology
**The Anarchist Collectives** is an excellent starting place. Gaston Leval's
**Collectives in the Spanish Revolution** is another essential text. Jose
Peirats' **Anarchists in the Spanish Revolution** and his three volume quasi-
official history **The CNT in the Spanish Revolution** are key works. Vernon
Richards' **Lessons of the Spanish Revolution** is an excellent critical
anarchist work on the revolution and the role of the anarchists. **Spain
1936-1939: Social Revolution and Counter-Revolution** (edited by Vernon
Richards) is a useful collection of articles from the time. Abel Paz's
**Durruti in the Spanish Revolution** is a classic biography of Spanish
anarchism's most famous militant (this is an expanded version of his earlier
**Durruti: The People Armed** ). Emma Goldman's opinions on the Spanish
Revolution are collected in **Vision on Fire**.

Robert Alexander's **The Anarchists in the Spanish Civil War** is a good
general overview of the anarchist's role in the revolution and civil war, as
is Burnett Bolloten's **The Spanish Civil War**. Daniel Guérin's anthology
**No Gods, No Masters** has two sections on the Spanish Revolution, one
specifically on the collectives. Noam Chomsky's excellent essay _"Objectivity
and Liberal Scholarship"_ indicates how liberal books on the Spanish Civil War
can be misleading, unfair and essentially ideological in nature (this classic
essay can be found in **Chomsky on Anarchism** , **The Chomsky Reader** , and
**American Power and the New Mandarins** ). George Orwell's **Homage to
Catalonia** cannot be bettered as an introduction to the subject (Orwell was
in the POUM militia at the Aragón Front and was in Barcelona during the May
Days of 1937). This classic account is contained along with other works by
Orwell about the conflict in the anthology **Orwell in Spain**. Murray
Bookchin's **The Spanish Anarchists** is a useful history, but ends just as
the revolution breaks out and so needs to be completed by his **To Remember
Spain** and the essay _"Looking Back at Spain"_. Stuart Christie's **We, The
Anarchists!** is an important history of the Iberian Anarchist Federation.

## I.8.1 Is the Spanish Revolution inapplicable as a model for modern
societies?

Quite the reverse. More urban workers took part in the revolution than in the
countryside. So while it is true that collectivisation was extensive in rural
areas, the revolution also made its mark in urban areas and in industry.

In total, the _"regions most affected"_ by collectivisation _"were Catalonia
and Aragón, where about 70 per cent of the workforce was involved. The total
for the whole of Republican territory was nearly 800,000 on the land and a
little more than a million in industry. In Barcelona workers' committees took
over all the services, the oil monopoly, the shipping companies, heavy
engineering firms such as Volcano, the Ford motor company, chemical companies,
the textile industry and a host of smaller enterprises . . . Services such as
water, gas and electricity were working under new management within hours of
the storming of the Atarazanas barracks . . . a conversion of appropriate
factories to war production meant that metallurgical concerns had started to
produce armed cars by 22 July . . . The industrial workers of Catalonia were
the most skilled in Spain . . . One of the most impressive feats of those
early days was the resurrection of the public transport system at a time when
the streets were still littered and barricaded."_ Five days after the fighting
had stopped, 700 tramcars rather than the usual 600, all painted in the black-
and-red colours of the CNT-FAI, were operating in Barcelona. [Antony Beevor,
**The Spanish Civil War** , pp. 91-2]

About 75% of Spanish industry was concentrated in Catalonia, the stronghold of
the anarchist labour movement, and widespread collectivisation of factories
took place there. As Sam Dolgoff rightly observed, this _"refutes decisively
the allegation that anarchist organisational principles are not applicable to
industrial areas, and if at all, only in primitive agrarian societies or in
isolated experimental communities."_ [ **The Anarchist Collectives** , pp.
7-8] According to Augustin Souchy:

> _"It is no simple matter to collectivise and place on firm foundations an
> industry employing almost a quarter of a million textile workers in scores
> of factories scattered in numerous cities. But the Barcelona syndicalist
> textile union accomplished this feat in a short time. It was a tremendously
> significant experiment. The dictatorship of the bosses was toppled, and
> wages, working conditions and production were determined by the workers and
> their elected delegates. All functionaries had to carry out the instructions
> of the membership and report back directly to the men on the job and union
> meetings. The collectivisation of the textile industry shatters once and for
> all the legend that the workers are incapable of administrating a great and
> complex corporation."_ [ **Op. Cit.** , p. 94]

Moreover, Spain in the 1930s was **not** a backward, peasant country, as is
sometimes supposed. Between 1910 and 1930, the industrial working class more
than doubled to over 2,500,000. This represented just over 26% of the working
population (compared to 16% twenty years previously). In 1930, only 45% of the
working population were engaged in agriculture. [Ronald Fraser, **The Blood of
Spain** , p. 38] In Catalonia alone, 200,000 workers were employed in the
textile industry and 70,000 in metal-working and machinery manufacturing. This
was very different than the situation in Russia at the end of World War I,
where the urban working class made up only 10% of the population.

Capitalist social relations had also penetrated the rural economy by the 1930s
with agriculture oriented to the world market and approximately 90% of
farmland in the hands of the bourgeoisie. [Fraser, **Op. Cit.** , p. 37] So by
1936 agriculture was predominately capitalist, with Spanish agribusiness
employing large numbers of labourers who either did not own enough land to
support themselves or were landless. The labour movement in the Spanish
countryside in the 1930s was precisely based on this large population of rural
wage-earners (the socialist UGT land workers union had 451,000 members in
1933, 40% of its total membership, for example). In Russia at the time of the
revolution of 1917, agriculture mostly consisted of small farms on which
peasant families worked mainly for their own subsistence, bartering or selling
their surplus.

Therefore the Spanish Revolution cannot be dismissed as a product of a pre-
industrial society. The urban collectivisations occurred predominately in the
most heavily industrialised part of Spain and indicate that anarchist ideas
are applicable to modern societies. Indeed, comforting Marxist myths aside,
the CNT organised most of the unionised urban working class and agricultural
workers were a minority of its membership (by 1936, the CNT was making inroads
in Madrid, previously a socialist stronghold while the UGT main area of growth
in the 1930s was with, ironically, rural workers). The revolution in Spain was
the work (mostly) of rural and urban wage labourers (joined with poor
peasants) fighting a well developed capitalist system.

In summary, then, the anarchist revolution in Spain has many lessons for
revolutionaries in developed capitalist countries and cannot be dismissed as a
product of industrial backwardness. The main strength of the anarchist
movement was in urban areas and unsurprisingly, the social revolution took
place in the most heavily industrialised areas as well as on the land.

## I.8.2 How were the anarchists able to obtain mass popular support in Spain?

Revolutionary anarchism was introduced in Spain in 1868 by Giuseppi Fanelli,
an associate of Michael Bakunin, and found fertile soil among both the workers
and the peasants. Those historians who gleefully note that Bakunin sent
someone who did not speak Spanish to spread his message in Spain forget how
close the Latin languages are to each other. Fanelli was more than able to be
understood by his Spanish and Catalan speaking hosts who, it should be noted,
were already familiar with Proudhon's ideas.

The key reason why Bakunin's ideas gained such ready support in Spain was that
they reflected ideas that they had already developed themselves. The peasants
supported anarchism because of the rural tradition of Iberian collectivism
which had existed for generations. The urban workers supported it because its
ideas of direct action, solidarity and free federation of unions corresponded
to their needs in their struggle against capitalism and the state. Neither
needed to be told that capitalism was oppressive and exploitative or that the
state existed to defend this class system. In addition, many Spanish workers
were well aware of the dangers of centralisation and the republican tradition
in Spain was very much influenced by federalist ideas (coming, in part, from
Proudhon's work as popularised by Pi y Margall, soon to become the President
of the first Republic). The movement spread back and forth between countryside
and cities as urban based union organisers and anarchist militants visited
villages and peasants and landless agricultural workers came to industrial
cities, like Barcelona, looking for work.

Therefore, from the start anarchism in Spain was associated with the labour
movement (as Bakunin desired) and so anarchists had a practical area to apply
their ideas and spread the anarchist message. By applying their principles in
everyday life, the anarchists in Spain ensured that anarchist ideas became
commonplace and accepted in a large section of the population.

This acceptance of anarchism cannot be separated from the structure and
tactics of the CNT and its forerunners. The practice of direct action and
solidarity encouraged workers to rely on themselves, to identify and solve
their own problems. The decentralised structure of the anarchist unions had an
educational effect on their members. By discussing issues, struggles, tactics,
ideals and politics in their union assemblies, the members of the union
educated themselves and, by the process of self-management in the struggle,
prepared themselves for a free society. The very organisational structure of
the CNT ensured the dominance of anarchist ideas and the political evolution
of the union membership. As one CNT militant from Casas Viejas put it, new
members _"asked for too much, because they lacked education. They thought they
could reach the sky without a ladder . . . they were beginning to learn . . .
There was good faith but lack of education. For that reason we would submit
ideas to the assembly, and the bad ideas would be thrown out."_ [quoted by
Jerome R. Mintz, **The Anarchists of Casas Viejas** , p. 27]

It was by working in the union meetings that anarchists influenced their
fellow workers. The idea that the anarchists, through the FAI, controlled the
CNT is a myth. Not all anarchists in the CNT were members of the FAI, for
example, while FAI members were also rank-and-file members of the CNT who took
part in union meetings as equals. Anarchists who were not members of the FAI
indicate this. Jose Borras Casacarosa confirmed that _"[o]ne has to recognise
that the FAI did not intervene in the CNT from above or in an authoritarian
manner as did other political parties in the unions. It did so from the base
through militants . . . the decisions which determined the course taken by the
CNT were taken under constant pressure from these militants."_ Jose Campos
noted that FAI militants _"tended to reject control of confederal committees
and only accepted them on specific occasions . . . if someone proposed a
motion in assembly, the other FAI members would support it, usually
successfully. It was the individual standing of the **faista** in open
assembly."_ [quoted by Stuart Christie, **We, the Anarchists** , p. 62]

This explains the success of anarchism in the CNT. Anarchist ideas, principles
and tactics, submitted to the union assemblies, proved to be good ideas and
were not thrown out. The structure of the organisation, in other words,
decisively influenced the **content** of the decisions reached as ideas,
tactics, union policy and so on were discussed by the membership and those
which best applied to the members' lives were accepted and implemented. The
CNT assemblies showed the validity of Bakunin's arguments for self-managed
unions as a means of ensuring workers' control of their own destinies and
organisations. As he put it, the union _"sections could defend their rights
and their autonomy [against union bureaucracy] in only one way: the workers
called general membership meetings . . . In these great meetings of the
sections, the items on the agenda were amply discussed and the most
progressive opinion prevailed."_ [ **Bakunin on Anarchism** , p. 247] The CNT
was built on such _"popular assemblies,"_ with the same radicalising effect.
It showed, in practice, that bosses (capitalist as well as union ones) were
not needed -- workers can manage their own affairs directly. As a school for
anarchism it could not be bettered as it showed that anarchist principles were
not utopian. The CNT, by being based on workers' self-management of the class
struggle, prepared its members for self-management of the revolution and the
new society.

The Spanish Revolution also shows the importance of anarchist education and
media. In a country with a very high illiteracy rate, huge quantities of
literature on social revolution were disseminated and read out at meetings for
those who could not read. Anarchist ideas were widely discussed: _"There were
tens of thousands of books, pamphlets and tracts, vast and daring cultural and
popular educational experiments (the Ferrer schools) that reached into almost
every village and hamlet throughout Spain."_ [Sam Dolgoff, **The Anarchist
Collectives** , p. 27] The discussion of political, economic and social ideas
was continuous, and _"the centro [local union hall] became the gathering place
to discuss social issues and to dream and plan for the future. Those who
aspired to learn to read and write would sit around . . . studying."_ [Mintz,
**Op. Cit.** , p. 160] One anarchist militant described it as follows:

> _"With what joy the orators were received whenever a meeting was held . . .
> We spoke that night about everything: of the ruling inequality of the regime
> and of how one had a right to a life without selfishness, hatred, without
> wars and suffering. We were called on another occasion and a crowd gathered
> larger than the first time. That's how the pueblo started to evolve,
> fighting the present regime to win something by which they could sustain
> themselves, and dreaming of the day when it would be possible to create that
> society some depict in books, others by word of mouth. Avid for learning,
> they read everything, debated, discussed, and chatted about the different
> modes of perfect social existence."_ [Perez Cordon, quoted by Mintz, **Op.
> Cit.** , p. 158]

Newspapers and periodicals were extremely important. By 1919, more than 50
towns in Andalusia had their own libertarian newspapers. By 1934 the CNT had a
membership of around one million and the anarchist press covered all of Spain.
In Barcelona the CNT published a daily, **Solidaridad Obrera** (Worker
Solidarity), with a circulation of 30,000. The FAI's magazine **Tierra y
Libertad** (Land and Liberty) had a circulation of 20,000. In Gijon there was
**Vida Obrera** (Working Life), in Seville **El Productor** (The Producer) and
in Saragossa **Accion y Cultura** (Action and Culture), each with a large
circulation. There were many more.

As well as leading struggles, organising unions, and producing books, papers
and periodicals, the anarchists also organised libertarian schools, cultural
centres, co-operatives, anarchist groups (the FAI), youth groups (the
Libertarian Youth) and women's organisations (the Free Women movement). They
applied their ideas in all walks of life and so ensured that ordinary people
saw that anarchism was practical and relevant to them.

This was the great strength of the Spanish Anarchist movement. It was a
movement _"that, in addition to possessing a revolutionary ideology [sic], was
also capable of mobilising action around objectives firmly rooted in the life
and conditions of the working class . . . It was this ability periodically to
identify and express widely felt needs and feelings that, together with its
presence at community level, formed the basis of the strength of radical
anarchism, and enabled it to build a mass base of support."_ [Nick Rider,
_"The practice of direct action: the Barcelona rent strike of 1931"_ , pp.
79-105, **For Anarchism** , David Goodway (Ed.), p. 99]

Historian Temma Kaplan stressed this in her work on the Andalusian anarchists.
She argued that the anarchists were _"rooted in"_ social life and created _"a
movement firmly based in working-class culture."_ They _"formed trade unions,
affinity groups such as housewives' sections, and broad cultural associations
such as workers' circles, where the anarchist press was read and discussed."_
Their _"great strength . . . lay in the merger of communal and militant trade
union traditions. In towns where the vast majority worked in agriculture,
agricultural workers' unions came to be identified with the community as a
whole . . . anarchism . . . show[ed] that the demands of agricultural workers
and proletarians could be combined with community support to create an
insurrectionary situation . . . It would be a mistake . . . to argue that
'village anarchism' in Andalusia was distinct from militant unionism, or that
the movement was a surrogate religion."_ [ **Anarchists of Andalusia:
1868-1903** , p. 211, p. 207 and pp. 204-5]

The Spanish anarchists, before and after the CNT was formed, fought in and out
of the factory for economic, social and political issues. This refusal of the
anarchists to ignore any aspect of life ensured that they found many willing
to hear their message, a message based around the ideas of individual liberty.
Such a message could do nothing but radicalise workers for _"the demands of
the CNT went much further than those of any social democrat: with its emphasis
on true equality, **autogestion** [self-management] and working class dignity,
anarchosyndicalism made demands the capitalist system could not possibly grant
to the workers."_ [J. Romero Maura, _"The Spanish case"_ , pp. 60-83,
**Anarchism Today** , D. Apter and J. Joll (eds.), p. 79]

Strikes, due to the lack of strike funds, depended on mutual aid to be won,
which fostered a strong sense of solidarity and class consciousness in the CNT
membership. Strikes did not just involve workers. For example, workers in
Jerez responded to bosses importing workers from Malaga _"with a weapon of
their own -- a boycott of those using strike-breakers. The most notable
boycotts were against landowners near Jerez who also had commercial
establishments in the city. The workers and their wives refused to buy there,
and the women stationed themselves nearby to discourage other shoppers."_
[Mintz, **Op. Cit.** , p. 102]

The structure and tactics of the CNT encouraged the politicisation, initiative
and organisational skills of its members. It was a federal, decentralised
body, based on direct discussion and decision making from the bottom up (
_"The CNT tradition was to discuss and examine everything"_ , as one militant
put it). In addition, the CNT created a viable and practical example of an
alternative method by which society could be organised. A method which was
based on the ability of ordinary people to direct society themselves and which
showed in practice that special ruling authorities are undesirable and
unnecessary. This produced a revolutionary working class the likes of which
the world has rarely seen. As Jose Peirats pointed out, _"above the union
level, the CNT was an eminently political organisation . . ., a social and
revolutionary organisation for agitation and insurrection."_ [ **Anarchists in
the Spanish Revolution** , p. 239] The CNT was organised in such a way as to
encourage solidarity and class consciousness. Its organisation was based on
the **sindicato unico** (one union) which united all workers of the same
workplace in the same union. Instead of organising by trade, and so dividing
the workers into numerous different unions, the CNT united all workers in a
workplace into the same organisation, all trades, skilled and unskilled, were
in a single organisation and so solidarity was increased and encouraged as
well as increasing their fighting power by eliminating divisions within the
workforce. All the unions in an area were linked together into a local
federation, the local federations into a regional federation and so on. As J.
Romero Maura argued, the _"territorial basis of organisation linkage brought
all the workers from one area together and fomented working-class solidarity
over and above corporate [industry or trade] solidarity."_ [ **Op. Cit.** p.
75]

Thus the structure of the CNT encouraged class solidarity and consciousness.
In addition, being based on direct action and self-management, the union
ensured that working people became accustomed to managing their own struggles
and acting for themselves, directly. This prepared them to manage their own
personal and collective interests in a free society (as seen by the success of
the self-managed collectives created in the revolution). Thus the process of
self-managed struggle and direct action prepared people for the necessities of
the social revolution and an anarchist society -- it built, as Bakunin argued,
the seeds of the future in the present.

In other words, _"the route to radicalisation . . . came from direct
involvement in struggle and in the design of alternative social
institutions."_ Every strike and action empowered those involved and created a
viable alternative to the existing system. For example, while the strikes and
food protests in Barcelona at the end of the First World War _"did not topple
the government, patterns of organisation established then provided models for
the anarchist movement for years to follow."_ [Martha A. Ackelsberg and Myrna
Margulies Breithart, _"Terrains of Protest: Striking City Women"_ , pp.
151-176, **Our Generation** , vol. 19, No. 1, p. 164] The same could be said
of every strike, which confirmed Bakunin's and Kropotkin's stress on the
strike as not only creating class consciousness and confidence but also the
structures necessary to not only fight capitalism, but to replace it.

In summary, then, anarchism gained mass support by anarchists participating in
mass struggles and movements, showing that its ideas and ideals were
applicable to working class experiences. In fact, to even wonder why anarchism
gained support in Spain is, to some degree, to implicitly assume, with
Marxists of various shades, that only state socialism reflects the needs of
working class people. Discussing the question why the social democratic or
Communist movements did not replace anarchism in Spain, historian J. Romero
Maura correctly pointed out that this _"is based on the false assumption that
the anarcho-syndicalist conception of the workers' struggle in pre-
revolutionary society was completely at odds with what the **real** social
process signified (hence the constant reference to 'religious' 'messianic'
models as explanations)."_ After discussing and refuting five common
suggestions for the success of anarchism in Spain, he concluded that the
_"explanation of Spanish anarcho-syndicalism's success in organising a mass
movement with a sustained revolutionary **elan** should initially be sought in
the very nature of the anarchist conception of society and of how to achieve
revolution."_ [ **Op. Cit.** p. 78 and p. 65]

It was the revolutionary nature of the CNT that created a militant membership
who were willing and able to use direct action to defend their liberty. Unlike
the Marxist led German workers, organised in a centralised fashion and trained
in the obedience required by hierarchy, who did nothing to stop Hitler, the
Spanish working class (like their comrades in anarchist unions in Italy) took
to the streets to stop fascism.

The revolution in Spain did not "just happen"; it was the result of nearly
seventy years of persistent anarchist agitation and revolutionary struggle,
including a long series of strikes, protests, boycotts, uprisings and other
forms of direct action that prepared the peasants and workers to organise
popular resistance to the attempted fascist coup in July 1936 and to take
control of society when they had defeated it in the streets.

## I.8.3 How were Spanish industrial collectives organised?

Martha A. Ackelsberg gives us an excellent short summary of how the industrial
collectives where organised:

> _"Pre-existing structures of worker organisation made possible a workers'
> take-over of much of the industrial economy, especially in Catalonia . . .
> Factory committees formed to direct production and co-ordinate with other
> units within the same industry. Union organisations co-ordinated both the
> production and distribution of manufactured goods across industries and
> regions . . . In most collectivised industries, general assemblies of
> workers decided policy, while elected committees managed affairs on a day-
> to-day basis."_ [ **Free Women of Spain** , p. 100]

The collectives were based on workers' democratic self-management of their
workplaces, using productive assets that were under the custodianship of the
entire working community and administered through federations of workers'
associations:

> _"The collectives organised during the Spanish Civil War were workers'
> economic associations without private property. The fact that collective
> plants were managed by those who worked in them did not mean that these
> establishments became their private property. The collective had no right to
> sell or rent all or any part of the collectivised factory or workshop. The
> rightful custodian was the CNT, the National Confederation of Workers
> Associations. But not even the CNT had the right to do as it pleased.
> Everything had to be decided and ratified by the workers themselves through
> conferences and congresses."_ [Augustin Souchy, **The Anarchist
> Collectives** , p. 67]

In Catalonia _"every factory elected its administrative committee composed of
its most capable workers. Depending on the size of the factory, the function
of these committees included inner plant organisation, statistics, finance,
correspondence, and relations with other factories and with the community . .
. Several months after collectivisation the textile industry of Barcelona was
in far better shape than under capitalist management. Here was yet another
example to show that grass roots socialism from below does not destroy
initiative. Greed is not the only motivation in human relations."_ [Souchy,
**Op. Cit.** , p 95]

Thus the individual collective was based on a mass assembly of those who
worked there. This assembly nominated administrative staff who were mandated
to implement the decisions of the assembly and who had to report back, and
were accountable, to that assembly. For example, in Castellon de la Plana
_"[e]very month the technical and administrative council presented the general
assembly of the Syndicate with a report which was examined and discussed if
necessary, and finally introduced when this majority thought it of use. Thus
all the activities were known and controlled by all the workers. We find here
a practical example of libertarian democracy."_ [Gaston Leval, **Collectives
in the Spanish Revolution** , p. 303] Power rested at the base of the
collective, with _"all important decisions [being] taken by the general
assemblies of the workers"_ which _"were widely attended and regularly held .
. . if an administrator did something which the general assembly had not
authorised, he was likely to be deposed at the next meeting."_ An example of
this process can be seen from the Casa Rivieria company. After the defeat of
the army coup _"a control committee (Comite de Control) was named by the
Barcelona Metal Workers' Union to take over temporary control of the
enterprises . . . A few weeks after July 19th, there was the first general
assembly of the firm's workers . . . It elected an enterprise committee
(Comite de Empresa) to take control of the firm on a more permanent basis. . .
. Each of the four sections of the firm -- the three factories and the office
staff -- held their own general assemblies at least once a week. There they
discussed matters ranging from the most important affairs to the most
trivial."_ [Robert Alexander, **The Anarchists in the Spanish Civil War** ,
vol. 1, p. 469 and p. 532]

In summary, the collectives in Spain were marked by workplace self-management.
They successfully implemented the long-standing libertarian goal of turning
industry from an autocracy to a democracy, of replacing wage-labour with free-
labour based on the association of equals (see [section
I.3.1](secI3.md#seci31)). However, it would be a mistake to assume (as many
do, particularly Marxists) that the CNT and FAI considered the creation of
self-managed collectives as the end of the revolution. Far from it. While they
embodied such key libertarian principles as workers' self-management, they
were fundamentally a product of both anarchist ideas **and** the specific
situation in which they were created. Rather than seek a market system of
producer co-operatives, the CNT was committed to the full socialisation of the
economy and the creation of libertarian communism. The collectives were, as a
result, seen as development towards that goal rather than as an end in
themselves. Moreover, as historian Ronald Fraser notes, it _"was doubtful that
the CNT had seriously envisaged collectivisation of industry . . . before this
time."_ [ **The Blood of Spain** , p. 212] CNT policy was opposed to the
collectivisation decree of the Catalonian government, for example, which
formalised (and controlled) the spontaneous gains of the revolution as
expressed by the collectives.

Therefore, the collectives were (initially) a form of _"self-management
straddling capitalism and socialism, which we maintain would not have occurred
had the Revolution been able to extend itself fully under the direction of our
syndicates."_ In other words, the revolution saw the abolition of wage-labour
but not of the wages system. Thus capitalism was replaced by mutualism, not
the socialism desired by most anarchists (namely libertarian communism). As
economic and political development are closely related, the fact that the CNT
did not carry out the **political** aspect of the revolution meant that the
revolution in the economy was doomed to failure. As Leval stressed, in _"the
industrial collectives, especially in the large towns, matters proceeded
differently as a consequence of contradictory factors and of opposition
created by the co-existence of social currents emanating from different social
classes."_ [Gaston Leval, **Collectives in the Spanish Revolution** , pp.
227-8 and p. 227]

That the initial forms of the revolution were not as expected should, perhaps,
be unsurprising. After all, no social transformation ever exactly matches the
hopes of those who had advocated it and the people had more pressing matters
to attend to such as re-starting production and fighting Franco. So it is
utterly understandable that the collectives only embodied some and not all
aspects of aims of the CNT and FAI! Moreover, social change does not produce
instant perfect transformations and the workers _"had to build new circuits of
consumption and distribution, new types of social relations between the
proletariat and the peasantry, and new modes of production."_ [Abel Paz,
**Durruti in the Spanish Revolution** , p. 451] That process was started, even
if it were initially incomplete. That a wider goal was envisioned by these
organisations can be seen from the fact that union activists sought to extend
the degree of socialisation. So, and again in line with libertarian theory,
the collectives also expressed a desire to co-operate within and across
industries (see [section I.3.5](secI3.md#seci35)). These attempts at
federation and co-ordination will be discussed in [next
section](secI8.md#seci84), along with some of the conclusions that can be
drawn from these experiments. For, as would be expected, this attempt to
introduce libertarian socialism had its drawbacks as well as successes.

## I.8.4 How were the Spanish industrial collectives co-ordinated?

The methods of co-operation tried by the collectives varied considerably.
Initially, there were very few attempts to co-ordinate economic activities
beyond the workplace. This is hardly surprising, given that the overwhelming
need was to restart production, convert a civilian economy to a wartime one
and to ensure that the civilian population and militias were supplied with
necessary goods. This lead to a situation of anarchist mutualism developing,
with many collectives selling the product of their own labour on the market.

This lead to some economic problems as there existed no framework of
institutions between collectives to ensure efficient co-ordination of activity
and so led to pointless competition between collectives (which led to even
more problems). As there were initially no confederations of collectives nor
mutual/communal banks this led to the continuation of any inequalities that
initially existed between collectives (due to the fact that workers took over
rich and poor capitalist firms) and it made the many ad hoc attempts at mutual
aid between collectives difficult and often of an ad hoc nature.

Given that the CNT programme of libertarian communism recognised that a fully
co-operative society must be based upon production for use, CNT militants
fought against this system of mutualism and for inter-workplace co-ordination.
They managed to convince their fellow workers of the difficulties of mutualism
by free debate and discussion within their unions and collectives. Given this
the degree of socialisation varied over time (as would be expected).
Initially, after the defeat of Franco's forces, there was little formal co-
ordination and organisation. The most important thing was to get production
started again. However, the needs of co-ordination soon became obvious (as
predicted in anarchist theory and the programme of the CNT). Gaston Leval
gives the example of Hospitalet del Llobregat with regards to this process:

> _"Local industries went through stages almost universally adopted in that
> revolution . . . [I]n the first instance, **comités** [committees] nominated
> by the workers employed in them [were organised]. Production and sales
> continued in each one. But very soon it was clear that this situation gave
> rise to competition between the factories . . . creating rivalries which
> were incompatible with the socialist and libertarian outlook. So the CNT
> launched the watchword: 'All industries must be ramified in the Syndicates,
> completely socialised, and the regime of solidarity which we have always
> advocated be established once and for all.'_

> _"The idea won support immediately."_ [ **Collectives in the Spanish
> Revolution** , pp. 291-2]

Another example was the woodworkers' union which had a massive debate on
socialisation and decided to do so (the shopworkers' union had a similar
debate, but the majority of workers rejected socialisation). According to
Ronald Fraser a _"union delegate would go round the small shops, point out to
the workers that the conditions were unhealthy and dangerous, that the
revolution was changing all this, and secure their agreement to close down and
move to the union-built Double-X and the 33 EU."_ [Ronald Fraser, **Blood of
Spain** , p. 222]

A plenum of syndicates met in December of 1936 and formulated norms for
socialisation in which the inefficiency of the capitalist industrial system
was analysed. The report of the plenum stated:

> _"The major defect of most small manufacturing shops is fragmentation and
> lack of technical/commercial preparation. This prevents their modernisation
> and consolidation into better and more efficient units of production, with
> better facilities and co-ordination . . . For us, socialisation must correct
> these deficiencies and systems of organisation in every industry . . . To
> socialise an industry, we must consolidate the different units of each
> branch of industry in accordance with a general and organic plan which will
> avoid competition and other difficulties impeding the good and efficient
> organisation of production and distribution."_ [quoted by Souchy,
> **Anarchist Collectives** , p. 83]

As Souchy pointed out, this document is very important in the evolution of
collectivisation, because it indicates a realisation that _"workers must take
into account that partial collectivisation will in time degenerate into a kind
of bourgeois co-operativism."_ [ **Op. Cit.** , p. 83] Thus many collectives
did not compete with each other for profits, as surpluses were pooled and
distributed on a wider basis than the individual collective.

This process went on in many different unions and collectives and,
unsurprisingly, the forms of co-ordination agreed to led to different forms of
organisation in different areas and industries, as would be expected in a free
society. However, the two most important forms can be termed syndicalisation
and confederationalism (we will ignore the forms created by the
collectivisation decree as these were not created by the workers themselves).

**_Syndicalisation_** (our term) meant that the CNT's industrial union ran the
whole industry. This solution was tried by the woodworkers' union after
extensive debate. One section of the union, _"dominated by the FAI, maintained
that anarchist self-management meant that the workers should set up and
operate autonomous centres of production so as to avoid the threat of
bureaucratisation."_ However, those in favour of syndicalisation won the day
and production was organised in the hands of the union, with administration
posts and delegate meetings elected by the rank and file. However, the _"major
failure . . . (and which supported the original anarchist objection) was that
the union became like a large firm"_ and its _"structure grew increasingly
rigid."_ [Fraser, **Op. Cit.** , p. 222] According to one militant, _"From the
outside it began to look like an American or German trust"_ and the workers
found it difficult to secure any changes and _"felt they weren't particularly
involved in decision making."_ [quoted by Fraser, **Op. Cit.** , p. 222 and p.
223] However, this did not stop workers re-electing almost all posts at the
first Annual General Assembly.

In the end, the major difference between the union-run industry and a
capitalist firm organisationally appeared to be that workers could vote for
(and recall) the industry management at relatively regular General Assembly
meetings. While a vast improvement on capitalism, it is hardly the best
example of participatory self-management in action. However, it must be
stressed that the economic problems caused by the Civil War and Stalinist led
counter-revolution obviously would have had an effect on the internal
structure of any industry and so we cannot say that the form of organisation
created was totally responsible for any marginalisation that took place.

The other important form of co-operation was what we will term
**_confederalisation_**. This system was based on horizontal links between
workplaces (via the CNT union) and allowed a maximum of self-management
**and** mutual aid. This form of co-operation was practised by the Badalona
textile industry (and had been defeated in the woodworkers' union). It was
based upon each workplace being run by its elected management, selling its own
production, getting its own orders and receiving the proceeds. However,
_"everything each mill did was reported to the union which charted progress
and kept statistics. If the union felt that a particular factory was not
acting in the best interests of the collectivised industry as a whole, the
enterprise was informed and asked to change course."_ This system ensured that
the _"dangers of the big 'union trust' as of the atomised collective were
avoided."_ [Fraser, **Op. Cit.** , p. 229] According to one militant, the
union _"acted more as a socialist control of collectivised industry than as a
direct hierarchised executive."_ The federation of collectives created _"the
first social security system in Spain"_ (which included retirement pay, free
medicines, sick and maternity pay) and a compensation fund was organised _"to
permit the economically weaker collectives to pay their workers, the amount
each collective contributed being in direct proportion to the number of
workers employed."_ [quoted by Fraser, **Op. Cit.** , p. 229]

As can be seen, the industrial collectives co-ordinated their activity in many
ways, with varying degrees of success. As would be expected, mistakes were
made and different solutions found as an anarchist society can hardly be
produced "overnight" (as discussed in [section H.2.5](secH2.md#sech25),
anarchists have always been aware that social transformation takes time). So
it is hardly surprising that the workers of the CNT faced numerous problems
and had to develop their self-management experiment as objective conditions
allowed them to. Unfortunately, thanks to fascist aggression and Communist
Party and Republican back-stabbing, the experiment did not last long enough to
fully answer all the questions we have about the viability of the solutions
tried. Given time, however, we are sure they would have solved the problems
they faced for the social experimentation which was conducted was not only
highly successful but also rich in promise.

## I.8.5 How were the Spanish agricultural co-operatives organised and co-
ordinated?

Jose Peirats described collectivisation among the peasantry as follows:

> _"The expropriated lands were turned over to the peasant syndicates, and it
> was these syndicates that organised the first collectives. Generally the
> holdings of small property owners were respected, always on the condition
> that only they or their families would work the land, without employing wage
> labour. In areas like Catalonia, where the tradition of petty peasant
> ownership prevailed, the land holdings were scattered. There were no great
> estates. Many of these peasants, together with the CNT, organised
> collectives, pooling their land, animals, tools, chickens, grain,
> fertiliser, and even their harvested crops._

> _"Privately owned farms located in the midst of collectives interfered with
> efficient cultivation by splitting up the collectives into disconnected
> parcels. To induce owners to move, they were given more or even better land
> located on the perimeter of the collective._

> _"The collectivist who had nothing to contribute to the collective was
> admitted with the same rights and the same duties as the others. In some
> collectives, those joining had to contribute their money (Girondella in
> Catalonia, Lagunarrotta in Aragón, and Cervera del Maestra in Valencia)."_ [
> **The Anarchist Collectives** , p. 112]

Dolgoff observed that _"supreme power was vested in, and actually exercised
by, the membership in general assemblies, and all power derived from, and
flowed back to, the grass roots organisations of the people."_ [ **Op. Cit.**
, p 119fn] Peirats also noted that the collectives were _"fiercely
democratic"_ as regards decision-making. For example, in Ademuz _"assemblies
were held every Saturday"_ while in Alcolea de Cinca _"they were held whenever
necessary."_ [ **Anarchists in the Spanish Revolution** , p. 146] Eyewitness
Gaston Leval summarised this explosion in self-management as follows:

> _"Regular general membership meetings were convoked weekly, bi-weekly, or
> monthly . . . and these meetings were completely free of the tensions and
> recriminations which inevitably emerge when the power of decisions is vested
> in a few individuals -- even if democratically elected. The Assemblies were
> open for everyone to participate in the proceedings. Democracy embraced all
> social life. In most cases, even the 'individualists' who were not members
> of the collective could participate in the discussions, and they were
> listened to by the collectivists."_ [ **The Anarchist Collectives** , p
> 119fn]

Work was _"usually done in groups on a co-operative basis. In smaller
collectives, all workers gathered to discuss the work needed to be done and
how to allocate it. In larger collectives, representatives of each work group
would gather at regular intervals. General assemblies of the collective met on
a weekly, biweekly, or monthly basis, and took up issues ranging from hours
and wages to the distribution of food and clothing."_ [Martha A. Ackelsberg in
**Free Women of Spain** , p. 106] It was in these face-to-face assemblies that
decisions upon the distribution of resources were decided both within and
outwith the collective. Here, when considering the importance of mutual aid,
appeals were made to an individual's sense of empathy. As one activist
remembered:

> _"There were, of course, those who didn't want to share and who said that
> each collective should take care of itself. But they were usually convinced
> in the assemblies. We would try to speak to them in terms they understood.
> We'd ask, 'Did you think it was fair when the **cacique** [local boss] let
> people starve if there wasn't enough work?' and they said, 'Of course not.'
> They would eventually come around. Don't forget, there were three hundred
> thousand collectivists [in Aragón], but only ten thousand of us had been
> members of the CNT. We had a lot of educating to do."_ [quoted by
> Ackelsberg, **Op. Cit.** , p. 107]

In addition, regional federations of collectives were formed in many areas of
Spain (for example, in Aragón and the Levant). The federations were created at
congresses to which the collectives in an area sent delegates. These
congresses agreed a series of general rules about how the federation would
operate and what commitments the affiliated collectives would have to each
other. The congress elected an administration council, which took
responsibility for implementing agreed policy. The Levant Federation was
organised as follows:

> _"The 900 Collectives were brought together in 54 cantonal federations which
> grouped themselves and at the same time subdivided into five provincial
> federations which at the top level ended in the Regional **Comite** . . .
> [This] was nominated directly by the annual congresses answerable to them
> and to the hundreds of peasant delegates chosen by their comrades . . . . It
> was also on their initiative that the Levante Federation was divided into 26
> general sections in accordance with specialisations in work and other
> activities. Those 26 sections constituted a whole which embraced probably
> for the first time in history outside the State and governmental structures,
> the whole of social life."_ [Gaston Leval, **Collectives in the Spanish
> Revolution** , p. 154]

The Aragón Federation statues were agreed at its founding congress in mid-
February 1937 by 500 delegates. These stated that there would be _"as many
county federations"_ as deemed _"necessary for the proper running of the
collectives"_ and the Federation would _"hold its ordinary congress at
intervals of six months, in addition to whatever extraordinary ones . . .
deemed appropriate."_ New collectives could join after _"consent in general
assembly of the inhabitants of the collective"_. The federation aimed to
_"coordinate the economic potential of the region and . . . be geared towards
solidarity in accordance with the norms of autonomy and federalism."_ [quoted
by Jose Peirats, **The CNT in the Spanish Revolution** , vol. 1, p. 240]

These federations had many tasks. They ensured the distribution of surplus
produce to the front line and to the cities, cutting out middlemen and
ensuring the end of exploitation. They also arranged for exchanges between
collectives to take place. In addition, the federations allowed the individual
collectives to pool resources together in order to improve the infrastructure
of the area (building roads, canals, hospitals and so on) and invest in means
of production which no one collective could afford. In this way individual
collectives pooled their resources, increased and improved the means of
production and the social and economic infrastructure of their regions. All
this, combined with an increase of consumption in the villages and towns as
well as the feeding of militia men and women fighting the fascists at the
front.

Rural collectivisations allowed the potential creative energy that existed
among the rural workers and peasants to be unleashed, an energy that had been
wasted under private property. The popular assemblies allowed community
problems and improvements to be identified and solved directly, drawing upon
the ideas and experiences of everyone and enriched by discussion and debate.
To quote one participant: _"We were always prepared to adapt our ideas in
every area of collective life if things did not work. That was the advantage
of our collectives over state-created ones like those in Russia. We were free.
Each village could do as it pleased. There was local stimulus, local
initiative."_ [quoted by Ronald Fraser, **Blood of Spain** , p. 357] As we
discuss in the the [next section](secI8.md#seci86), this enabled rural Spain
to be transformed from one marked by poverty and fear into one of increased
well-being and hope.

## I.8.6 What did the agricultural collectives accomplish?

Most basically, self-management in collectives combined with co-operation in
rural federations allowed an improvement in quality of rural life. From a
purely economic viewpoint, production increased and as historian Benjamin
Martin summarises: _"Though it is impossible to generalise about the rural
land take-overs, there is little doubt that the quality of life for most
peasants who participated in co-operatives and collectives notably improved."_
[ **The Agony of Modernisation** , p. 394] Another historian, Antony Beevor,
notes that _"[i]n terms of production and improved standards for the peasants,
the self-managed collectives appear to have been successful. They also seem to
have encouraged harmonious community relations."_ [ **The Spanish Civil War**
, p. 95]

More importantly, however, this improvement in the quality of life included an
increase in freedom as well as in consumption. To re-quote the member of the
Beceite collective in Aragón: _"it was marvellous . . . to live in a
collective, a free society where one could say what one thought, where if the
village committee seemed unsatisfactory one could say. The committee took no
big decisions without calling the whole village together in a general
assembly. All this was wonderful."_ [quoted by Ronald Fraser, **Blood of
Spain** , p. 288] As Beevor suggests, _"self-managed collectives were much
happier when no better off than before. What mattered was that the labourers
ran their own collectives -- a distinct contrast to the disasters of state
collectivisation in the Soviet Union."_ [ **Op. Cit.** , p. 95] Here are a few
examples provided by Jose Peirats:

> _"In Montblanc the collective dug up the old useless vines and planted new
> vineyards. The land, improved by modern cultivation with tractors, yielded
> much bigger and better crops . . . Many Aragón collectives built new roads
> and repaired old ones, installed modern flour mills, and processed
> agricultural and animal waste into useful industrial products. Many of these
> improvements were first initiated by the collectives. Some villages, like
> Calanda, built parks and baths. Almost all collectives established
> libraries, schools, and cultural centres."_ [ **The Anarchist Collectives**
> , p. 116]

Gaston Leval pointed out that _"the Peasant Federation of Levant . . .
produced more than half of the total orange crop in Spain: almost four million
kilos (1 kilo equals about 2 and one-fourth pounds). It then transported and
sold through its own commercial organisation (no middlemen) more than 70% of
the crop. (The Federation's commercial organisation included its own
warehouses, trucks, and boats. Early in 1938 the export section established
its own agencies in France: Marseilles, Perpignan, Bordeaux, Cherbourg, and
Paris.) Out of a total of 47,000 hectares in all Spain devoted to rice
production, the collective in the Province of Valencia cultivated 30,000
hectares."_ [ **Op. Cit.** , p. 124] To quote Peirats again:

> _"Preoccupation with cultural and pedagogical innovations was an event
> without precedent in rural Spain. The Amposta collectivists organised
> classes for semi-literates, kindergartens, and even a school of arts and
> professions. The Seros schools were free to all neighbours, collectivists or
> not. Grau installed a school named after its most illustrious citizen,
> Joaquin Costa. The Calanda collective (pop. only 4,500) schooled 1,233
> children. The best students were sent to the Lyceum in Caspe, with all
> expenses paid by the collective. The Alcoriza (pop. 4,000) school was
> attended by 600 children. Many of the schools were installed in abandoned
> convents. In Granadella (pop. 2,000), classes were conducted in the
> abandoned barracks of the Civil Guards. Graus organised a print library and
> a school of arts and professions, attended by 60 pupils. The same building
> housed a school of fine arts and high grade museum. In some villages a
> cinema was installed for the first time. The Penalba cinema was installed in
> a church. Viladecana built an experimental agricultural laboratory._ [ **Op.
> Cit.** , p. 116]

Peirats summed up the accomplishments of the agricultural collectives as
follows:

> _"In distribution the collectives' co-operatives eliminated middlemen, small
> merchants, wholesalers, and profiteers, thus greatly reducing consumer
> prices. The collectives eliminated most of the parasitic elements from rural
> life, and would have wiped them out altogether if they were not protected by
> corrupt officials and by the political parties. Non-collectivised areas
> benefited indirectly from the lower prices as well as from free services
> often rendered by the collectives (laundries, cinemas, schools, barber and
> beauty parlours, etc.)."_ [ **Op. Cit.** , p. 114]

Leval emphasised the following achievements (among others):

> _"In the agrarian collectives solidarity was practised to the greatest
> degree. Not only was every person assured of the necessities, but the
> district federations increasingly adopted the principle of mutual aid on an
> inter-collective scale. For this purpose they created common reserves to
> help out villages less favoured by nature. In Castile special institutions
> for this purpose were created. In industry this practice seems to have begun
> in Hospitalet, on the Catalan railways, and was applied later in Alcoy. Had
> the political compromise not impeded open socialisation, the practices of
> mutual aid would have been much more generalised . . . A conquest of
> enormous importance was the right of women to livelihood, regardless of
> occupation or function. In about half of the agrarian collectives, the women
> received the same wages as men; in the rest the women received less,
> apparently on the principle that they rarely live alone . . . In all the
> agrarian collectives of Aragón, Catalonia, Levant, Castile, Andalusia, and
> Estremadura, the workers formed groups to divide the labour or the land;
> usually they were assigned to definite areas. Delegates elected by the work
> groups met with the collective's delegate for agriculture to plan out the
> work. This typical organisation arose quite spontaneously, by local
> initiative . . . In addition . . . the collective as a whole met in weekly,
> bi-weekly or monthly assembly . . . The assembly reviewed the activities of
> the councillors it named, and discussed special cases and unforeseen
> problems. All inhabitants -- men and women, producers and non-producers --
> took part in the discussion and decisions . . . In land cultivation the most
> significant advances were: the rapidly increased use of machinery and
> irrigation; greater diversification; and forestation. In stock raising: the
> selection and multiplication of breeds; the adaptation of breeds to local
> conditions; and large-scale construction of collective stock barns."_ [
> **Op. Cit.** , pp. 166-167]

Collectivisation, as Graham Kelsey notes, _"allowed a rationalisation of
village societies and a more efficient use of the economic resources
available. Instead of carpenters and bricklayers remaining idle because no
wealthy landowner had any use for their services they were put to work
constructing agricultural facilities and providing the villages with the kind
of social amenities which until then they had scarcely been able to imagine."_
[ **Anarchosyndicalism, Libertarian Communism and the State** , p. 169] Martha
A. Ackelsberg sums up the experience well:

> _"The achievements of these collectives were extensive. In many areas they
> maintained, if not increased, agricultural production [not forgetting that
> many young men were at the front line], often introducing new patterns of
> cultivation and fertilisation . . . collectivists built chicken coups,
> barns, and other facilities for the care and feeding of the community's
> animals. Federations of collectives co-ordinated the construction of roads,
> schools, bridges, canals and dams. Some of these remain to this day as
> lasting contributions of the collectives to the infrastructure of rural
> Spain. The collectivists also arranged for the transfer of surplus produce
> from wealthier collectives to those experiencing shortages, either directly
> from village to village or through mechanisms set up by regional
> committees."_ [ **The Free Women of Spain** , pp. 106-7]

As well as this inter-collective solidarity, the rural collectives also
supplied food to the front-line troops:

> _"The collectives voluntarily contributed enormous stocks of provisions and
> other supplies to the fighting troops. Utiel sent 1,490 litres of oil and
> 300 bushels of potatoes to the Madrid front (in addition to huge stocks of
> beans, rice, buckwheat, etc.). Porales de Tujana sent great quantities of
> bread, oil, flour, and potatoes to the front, and eggs, meat, and milk to
> the military hospital._

> _"The efforts of the collectives take on added significance when we take
> into account that their youngest and most vigorous workers were fighting in
> the trenches. 200 members of the little collective of Vilaboi were at the
> front; from Viledecans, 60; Amposta, 300; and Calande, 500."_ [Jose Peirats,
> **The Anarchist Collectives** , p. 120]

Therefore, as well as significant economic achievements, the collectives
ensured social and political ones too. Solidarity was practised and previously
marginalised people took direct and full management of the affairs of their
communities, transforming them to meet their own needs and desires.

## I.8.7 Were the rural collectives created by force?

No, they were not. The myth that the rural collectives were created by
"terror," organised and carried out by the anarchist militia, was started by
the Stalinists of the Spanish Communist Party. More recently, certain right-
wing "libertarians" have warmed up and repeated these Stalinist fabrications.
Anarchists have been disproving these allegations since 1936 and it is
worthwhile to do so again here. As Vernon Richards noted: _"However
discredited Stalinism may appear to be today the fact remains that the
Stalinist lies and interpretation of the Spanish Civil War still prevail,
presumably because it suits the political prejudices of those historians who
are currently interpreting it."_ [ _"Introduction"_ , Gaston Leval,
**Collectives in the Spanish Revolution** , p. 11] Here we shall present
evidence to refute claims that the rural collectives were created by force.

Firstly, we should point out that rural collectives were created in many
different areas of Spain, such as the Levant (900 collectives), Castile (300)
and Estremadera (30), where the anarchist militia did not exist. In Catalonia,
for example, the CNT militia passed through many villages on its way to Aragón
and only around 40 collectives were created unlike the 450 in Aragón. In other
words, the rural collectivisation process occurred independently of the
existence of anarchist troops, with the majority of the 1,700 rural
collectives created in areas without a predominance of anarchist militias.

One historian, Ronald Fraser, seems to imply that collectives were imposed
upon the Aragón population. As he put it, the _"collectivisation, carried out
under the general cover, if not necessarily the direct agency, of CNT militia
columns, represented a revolutionary minority's attempt to control not only
production but consumption for egalitarian purposes and the needs of the
war."_ Notice that he does not suggest that the anarchist militia actually
**imposed** the collectives, a claim for which there is little or no evidence.
Moreover, Fraser presents a somewhat contradictory narrative to the facts he
presents. On the one hand, he suggests that _"[o]bligatory collectivisation
was justified, in some libertarians' eyes, by a reasoning closer to war
communism than to libertarian communism."_ On the other hand, he presents
extensive evidence that the collectives did not have a 100% membership rate.
How can collectivisation be obligatory if people remain outside the
collectives? Similarly, he talks of how **some** CNT militia leaders justified
_"[f]orced collectivisation"_ in terms of the war effort while acknowledging
the official CNT policy of opposing forced collectivisation, an opposition
expressed in practice as only around 20 (i.e., 5%) of the collectives were
total. [ **Blood of Spain** , p. 370, p. 349 and p. 366] This is shown in his
own book as collectivists interviewed continually note that people remained
outside their collectives!

Thus Fraser's attempts to paint the Aragón collectives as a form of _"war
communism"_ imposed upon the population by the CNT and obligatory for all
fails to co-incide with the evidence he presents.

Fraser states that _"[t]here was no need to dragoon them [the peasants] at
pistol point [into collectives]: the coercive climate, in which 'fascists'
were being shot, was sufficient. 'Spontaneous' and 'forced' collectives
existed, as did willing and unwilling collectivists within them."_ [ **Op.
Cit.** , p. 349] Therefore, his implied suggestion that the Aragón collectives
were imposed upon the rural population is based upon the insight that there
was a _"coercive climate"_ in Aragón at the time. Of course a civil war
against fascism would produce a _"coercive climate"_ particularly near the
front line. However, the CNT can hardly be blamed for that. As historian
Gabriel Jackson summarised, while such executions took place the CNT did not
conduct a general wave of terror:

> _"the anarchists made a constant effort to separate active political enemies
> from those who were simply bourgeois by birth or ideology or economic
> function. Anarchist political committees wanted to know what the accused
> monarchists or conservatives had done, not simply what they thought or how
> they voted . . . There is no inherent contradiction involved in recognising
> both that the revolution included some violence and that its social and
> economic results . . . were approved of by the majority of peasants in an
> area."_ [quoted in Jose Peirats, **The CNT in the Spanish Revolution** ,
> vol. 1, p. 146]

This was a life and death struggle against fascism, in which the fascists were
systematically murdering vast numbers of anarchists, socialists and
republicans in the areas under their control. It is hardly surprising that
some anarchist troops took the law into their own hands and murdered some of
those who supported and would help the fascists. Given what was going on in
fascist Spain, and the experience of fascism in Germany and Italy, the CNT
militia knew exactly what would happen to them and their friends and family if
they lost.

The question does arise, however, of whether the climate was made so coercive
by the war and the nearness of the anarchist militia that individual choice
was impossible. The facts speak for themselves. At its peak, rural
collectivisation in Aragón embraced around 70% of the population in the area
saved from fascism. Around 30% of the population felt safe enough not to join
a collective, a sizeable percentage. If the collectives had been created by
anarchist terror or force, we would expect a figure of 100% membership. This
was not the case, indicating the basically voluntary nature of the experiment
(we should point out that other figures suggest a lower number of
collectivists which makes the forced collectivisation argument even less
likely). Historian Antony Beevor (while noting that there _"had undoubtedly
been pressure, and no doubt force was used on some occasions in the fervour
after the rising"_ ) just stated the obvious when he wrote that _"the very
fact that every village was a mixture of collectivists and individualists
shows that peasants had not been forced into communal farming at the point of
a gun."_ [ **The Spanish Civil War** , p. 206] In addition, if the CNT militia
had forced peasants into collectives we would expect the membership of the
collectives to peak almost overnight, not grow slowly over time:

> _"At the regional congress of collectives, held at Caspe in mid-February
> 1937, nearly 80 000 collectivists were represented from 'almost all the
> villages of the region.' This, however, was but a beginning. By the end of
> April the number of collectivists had risen to 140,000; by the end of the
> first week of May to 180,000; and by the end of June to 300,000."_ [Graham
> Kelsey, _"Anarchism in Aragón,"_ pp. 60-82, **Spain in Conflict 1931-1939**
> , Martin Blinkhorn (ed.), p. 61]

If the collectives had been created by force, then their membership would have
been 300,000 in February, 1937, not increasing steadily to reach that number
four months later. Neither can it be claimed that the increase was due to new
villages being collectivised, as almost all villages had sent delegates in
February. This indicates that many peasants joined the collectives because of
the advantages associated with common labour, the increased resources it
placed at their hands and the fact that the surplus wealth which had in the
previous system been monopolised by the few was used instead to raise the
standard of living of the entire community.

The voluntary nature of the collectives is again emphasised by the number of
collectives which allowed people to remain outside. There _"were few villages
which were completely collectivised."_ [Beevor, **Op. Cit.** , p. 94] One eye-
witness in Aragón, an anarchist schoolteacher, noted that the forcing of
smallholders into a collective _"wasn't a widespread problem, because there
weren't more than twenty or so villages where collectivisation was total and
no one was allowed to remain outside."_ [quoted by Fraser, **Op. Cit.** , p.
366] Instead of forcing the minority in a village to agree with the wishes of
the majority, the vast majority (95%) of Aragón collectives stuck to their
libertarian principles and allowed those who did not wish to join to remain
outside.

So, only around 20 were _"total"_ collectives (out of 450) and around 30% of
the population felt safe enough **not** to join. In other words, in the vast
majority of collectives those joining could see that those who did not were
safe. These figures indicate of the basically spontaneous and voluntary nature
of the movement as do the composition of the new municipal councils created
after July 19th. As Graham Kelsey notes: _"What is immediately noticeable from
the results is that although the region has often been branded as one
controlled by anarchists to the total exclusion of all other forces, the CNT
was far from enjoying the degree of absolute domination often implied and
inferred."_ [ **Anarchosyndicalism, Libertarian Communism and the State** , p.
198]

In his account of the rural revolution, Burnett Bolloten noted that it
_"embraced more than 70 percent of the population"_ in liberated Aragón and
that _"many of the 450 collectives of the region were largely voluntary"_
although _"it must be emphasised that this singular development was in some
measure due to the presence of militiamen from the neighbouring region of
Catalonia, the immense majority of whom were members of the CNT and FAI."_ [
**The Spanish Civil War** , p. 74] This, it should be noted, was not denied by
anarchists. As Gaston Leval pointed out, _"it is true that the presence of
these forces . . . favoured indirectly these constructive achievements by
preventing active resistance by the supporters of the bourgeois republic and
of fascism."_ [ **Collectives in the Spanish Revolution** , p. 90]

So the presence of the militia changed the balance of class forces in Aragón
by destroying the capitalist state (i.e. the local bosses -- caciques -- could
not get state aid to protect their property) and many landless workers took
over the land. The presence of the militia ensured that land could be taken
over by destroying the capitalist "monopoly of force" that existed before the
revolution (the power of which will be highlighted below) and so the CNT
militia allowed the possibility of experimentation by the Aragónese
population. This class war in the countryside is reflected by Bolloten: _"If
the individual farmer viewed with dismay the swift and widespread
collectivisation of agriculture, the farm workers of the Anarchosyndicalist
CNT and the Socialist UGT saw it as the commencement of a new era."_ [ **Op.
Cit.** , p. 63] Both were mass organisations and supported collectivisation.

Therefore, anarchist militias allowed the rural working class to abolish the
artificial scarcity of land created by private property (and enforced by the
state). The rural bosses obviously viewed with horror the possibility that
they could not exploit day workers' labour (as Bolloten pointed out _"the
collective system of agriculture threaten[ed] to drain the rural labour market
of wage workers."_ [ **Op. Cit.** , p. 62]). Little wonder the richer peasants
and landowners hated the collectives. A report on the district of Valderrobes
which indicates popular support for the collectives:

> _"Collectivisation was nevertheless opposed by opponents on the right and
> adversaries on the left. If the eternally idle who have been expropriated
> had been asked what they thought of collectivisation, some would have
> replied that it was robbery and others a dictatorship. But, for the elderly,
> the day workers, the tenant farmers and small proprietors who had always
> been under the thumb of the big landowners and heartless usurers, it
> appeared as salvation."_ [quoted by Bolloten, **Op. Cit.** , p. 71]

However, many historians ignore the differences in class that existed in the
countryside and explain the rise in collectives in Aragón (and ignore those
elsewhere) as the result of the CNT militia. For example, Fraser:

> _"Very rapidly collectives . . . began to spring up. It did not happen on
> instructions from the CNT leadership -- no more than had the [industrial]
> collectives in Barcelona. Here, as there, the initiative came from CNT
> militants; here, as there, the 'climate' for social revolution in the
> rearguard was created by CNT armed strength: the anarcho-syndicalists'
> domination of the streets of Barcelona was re-enacted in Aragón as the CNT
> militia columns, manned mainly by Catalan anarcho-syndicalist workers,
> poured in. Where a nucleus of anarcho-syndicalists existed in a village, it
> seized the moment to carry out the long-awaited revolution and collectivised
> spontaneously. Where there was none, villagers could find themselves under
> considerable pressure from the militias to collectivise."_ [ **Op. Cit.** ,
> p. 347]

Fraser implies that the revolution was mostly imported into Aragón from
Catalonia. However, as he himself notes, the CNT column leaders (except
Durruti) _"opposed"_ the creation of the Council of Aragón (a confederation
for the collectives). Hardly an example of Catalan CNT imposed social
revolution! Moreover, the Aragón CNT was a widespread and popular
organisation, suggesting that the idea that the collectives were imported into
the region by the Catalan CNT is simply **false**. Fraser states that in
_"some [of the Aragónese villages] there was a flourishing CNT, in others the
UGT was strongest, and in only too many there was no unionisation at all."_ [
**Op. Cit.** , p. 350 and p. 348] The question arises of how extensive was
that strength. The evidence shows that the rural CNT in Aragón was extensive,
strong and growing, so making the suggestion of imposed collectives a false
one. In fact, by the 1930s the _"authentic peasant base of the CNT . . . lay
in Aragón."_ CNT growth in Zaragoza _"provided a springboard for a highly
effective libertarian agitation in lower Aragón, particularly among the
impoverished labourers and debt-ridden peasantry of the dry steppes region."_
[Murray Bookchin, **The Spanish Anarchists** , p. 203]

Graham Kelsey, in his social history of the CNT in Aragón between 1930 and
1937, provides more evidence on this matter. He points out that as well as the
_"spread of libertarian groups and the increasing consciousness among CNT
members of libertarian theories . . . contribu[ting] to the growth of the
anarchosyndicalist movement in Aragón"_ the existence of _"agrarian unrest"_
also played an important role in that growth. This all lead to the
_"revitalisation of the CNT network in Aragón"_. So by 1936, the CNT had built
upon the _"foundations laid in 1933"_ and _"had finally succeeded in
translating the very great strength of the urban trade-union organisation in
Zaragoza into a regional network of considerable extent."_ [ **Op. Cit.** ,
pp. 80-81, p. 82 and p. 134]

Kelsey notes the long history of anarchism in Aragón, dating back to the late
1860s. However, before the 1910s there had been little gains in rural Aragón
by the CNT due to the power of local bosses (called **caciques** ):

> _"Local landowners and small industrialists, the **caciques** of provincial
> Aragón, made every effort to enforce the closure of these first rural
> anarchosyndicalist cells [created after 1915]. By the time of the first
> rural congress of the Aragónese CNT confederation in the summer of 1923,
> much of the progress achieved through the organisation's considerable
> propaganda efforts had been countered by repression elsewhere."_ [
> _"Anarchism in Aragón"_ , **Op. Cit.** , p. 62]

A CNT activist indicated the power of these bosses and how difficult it was to
be a union member in Aragón:

> _"Repression is not the same in the large cities as it is in the villages
> where everyone knows everybody else and where the Civil Guards are
> immediately notified of a comrade's slightest movement. Neither friends nor
> relatives are spared. All those who do not serve the state's repressive
> forces unconditionally are pursued, persecuted and on occasions beaten up."_
> [quoted by Kelsey, **Op. Cit.** , p. 74]

However, while there were some successes in organising rural unions, even in
1931 _"propaganda campaigns which led to the establishment of scores of
village trade-union cells, were followed by a counter-offensive from village
**caciques** which forced them to close."_ [ **Op. Cit.** p. 67] Even in the
face of this repression the CNT grew and _"from the end of 1932"_ there was
_"a successful expansion of the anarchosyndicalist movement into several parts
of the region where previously it had never penetrated."_ [Kelsey,
**Anarchosyndicalism, Libertarian Communism and the State** , p. 185] This
growth was built upon in 1936, with increased rural activism which had slowly
eroded the power of the **caciques** (which in part explains their support for
the fascist coup). After the election of the Popular Front, years of anarchist
propaganda and organisation paid off with _"dramatic growth in rural anarcho-
syndicalist support"_ in the six weeks after the general election. This _"was
emphasised"_ in the Aragón CNT's April congress's agenda and it was decided to
direct _"attention to rural problems"_ while the agreed programme was
_"exactly what was to happen four months later in liberated Aragón."_ In its
aftermath, a series of intensive propaganda campaigns was organised through
each of the provinces of the regional confederation. Many meetings were held
in villages which had never before heard anarcho-syndicalist propaganda. This
was very successful and by the beginning of June, 1936, the number of Aragón
unions had topped 400, compared to only 278 one month earlier. [Kelsey,
_"Anarchism in Aragón"_ , **Op. Cit.** , pp. 75-76]

This increase in union membership reflected increased social struggle by the
Aragónese working population and their attempts to improve their standard of
living, which was very low for most of the population. A journalist from the
conservative Catholic **Heraldo de Aragón** visited lower Aragón in the summer
of 1935 and noted _"[t]he hunger in many homes, where the men are not working,
is beginning to encourage the youth to subscribe to misleading teachings."_
[quoted by Kelsey, **Op. Cit.** , p. 74] Little wonder, then, the growth in
CNT membership and social struggle Kelsey indicates:

> _"Evidence of a different kind was also available that militant trade
> unionism in Aragón was on the increase. In the five months between mid-
> February and mid-July 1936 the province of Zaragoza experienced over seventy
> strikes, more than had previously been recorded in any entire year, and
> things were clearly no different in the other two provinces . . . the great
> majority of these strikes were occurring in provincial towns and villages.
> Strikes racked the provinces and in at least three instances were actually
> transformed into general strikes."_ [ **Op. Cit.** , p. 76]

So in the spring and summer of 1936 there was a massive growth in CNT
membership which reflected the growing militant struggle by the urban and
rural population of Aragón. Years of propaganda and organising had ensured
this growth in libertarian influence, a growth which was reflected in the
creation of collectives in liberated Aragón during the revolution. Therefore,
the construction of a collectivised society was founded directly upon the
emergence, during the five years of the Second Republic, of a mass trade-union
movement infused by anarchist principles. These collectives were constructed
in accordance with the programme agreed at the Aragón CNT conference of April
1936 which reflected the wishes of the rural membership of the unions within
Aragón (and due to the rapid growth of the CNT afterwards obviously reflected
popular feelings in the area):

_"libertarian dominance in post-insurrection Aragón itself reflected the
predominance that anarchists had secured before the war; by the summer of 1936
the CNT had succeeded in establishing throughout Aragón a mass trade-union
movement of strictly libertarian orientation, upon which widespread and well-
supported network the extensive collective experiment was to be founded."_
[Kelsey, **Op. Cit.** , p. 61]

Additional evidence that supports a high level of CNT support in rural Aragón
can be provided by the fact that it was Aragón that was the centre of the
December 1933 insurrection organised by the CNT. As Bookchin noted, _"only
Aragón rose on any significant scale, particularly Saragossa . . . many of the
villages declared libertarian communism and perhaps the heaviest fighting took
place between the vineyard workers in Rioja and the authorities"_. [ **Op.
Cit.** , p. 238] It is unlikely for the CNT to organise an insurrection in an
area within which it had little support or influence. According to Kelsey,
_"it was precisely those areas which had most important in December 1933"_
which were in 1936 _"seeking to create a new pattern of economic and social
organisation, to form the basis of libertarian Aragón."_ [
**Anarchosyndicalism, Libertarian Communism and the State** , p. 161]

So the majority of collectives in Aragón were the product of CNT (and UGT)
influenced workers taking the opportunity to create a new form of social life,
a form marked by its voluntary and directly democratic nature. Far from being
unknown in rural Aragón, the CNT was well established and growing at a fast
rate: _"Spreading out from its urban base . . . the CNT, first in 1933 and
then more extensively in 1936, succeeded in converting an essentially urban
organisation into a truly regional confederation."_ [Kelsey, **Op. Cit.** , p.
184]

The evidence suggests that historians like Fraser are wrong to imply that the
Aragón collectives were created by the CNT militia and enforced upon a
unwilling population. The Aragón collectives were the natural result of years
of anarchist activity within rural Aragón and directly related to the massive
growth in the CNT between 1930 and 1936. Thus Kelsey is correct to state that
libertarian communism and agrarian collectivisation _"were not economic terms
or social principles enforced upon a hostile population by special teams of
urban anarchosyndicalists."_ [ **Op. Cit.** , p. 161] This is not to suggest
that there were **no** examples of people joining collectives involuntarily
because of the _"coercive climate"_ of the front line nor that there were
villages which did not have a CNT union within them before the war and so
created a collective because of the existence of the CNT militia. It is to
suggest that these can be considered as exceptions to the rule.

Moreover, the way the CNT handled such a situation is noteworthy. Fraser
indicates such a situation in the village of Alloza. In the autumn of 1936,
representatives of the CNT district committee had come to suggest that the
villagers collectivise (we would like to stress here that the CNT militia
which had passed through the village had made no attempt to create a
collective there). A village assembly was called and the CNT members explained
their ideas and suggested how to organise the collective. However, who would
join and how the villagers would organise the collective was left totally up
to them (the CNT representatives _"stressed that no one was to be maltreated"_
). Within the collective, self-management was the rule and one member recalled
that _"[o]nce the work groups were established on a friendly basis and worked
their own lands, everyone got on well enough."_ _"There was no need for
coercion, no need for discipline and punishment . . . A collective wasn't a
bad idea at all."_ [Fraser, **Op. Cit.** , p. 360] This collective, like the
vast majority, was voluntary and democratic: _"I couldn't oblige him to join;
we weren't living under a dictatorship."_ [quoted by Fraser, **Op. Cit.** , p.
362] In other words, **no** force was used to create the collective and the
collective was organised by local people directly.

Of course, as with any public good (to use economic jargon), all members of
the community had to pay for the war effort and feed the militia. As Kelsey
notes, _"[t]he military insurrection had come at a critical moment in the
agricultural calendar. Throughout lower Aragón there were fields of grain
ready for harvesting . . . At the assembly in Albalate de Cinca the opening
clause of the agreed programme had required everyone in the district,
independent farmers and collectivists alike, to contribute equally to the war
effort, thereby emphasising one of the most important considerations in the
period immediately following the rebellion."_ [ **Op. Cit.** , p. 164] In
addition, the collectives controlled the price of crops in order to ensure
that speculation and inflation were controlled. However, these policies as
with the equal duties of individualists and collectivists in the war effort
were enforced upon the collectives by the war.

Lastly, in support of the popular nature of the rural collectives, we will
indicate the effects of the suppression of the collectives in August 1937 by
the Communists, namely the collapse of the rural economy. This sheds
considerable light on the question of popular attitudes.

In October 1937, the Communist-controlled Regional Delegation of Agrarian
Reform acknowledged that _"in the majority of villages agricultural work was
paralysed causing great harm to our agrarian economy."_ This is confirmed by
Jose Silva, a Communist Party member and general secretary of the Institute of
Agrarian Reform, who commented that after Lister had attacked Aragón, _"labour
in the fields was suspended almost entirely, and a quarter of the land had not
been prepared at the time for sowing."_ At a meeting of the agrarian
commission of the Aragónese Communist Party (October 9th, 1937), Silva
emphasised _"the little incentive to work of the entire peasant population"_
and that the situation brought about by the dissolution of the collectives was
_"grave and critical."_ [quoted by Bolloten, **Op. Cit.** , p. 530] Jose
Peirats explained the reasons for this economic collapse as a result of
popular boycott:

> _"When it came time to prepare for the next harvest, smallholders could not
> by themselves work the property on which they had been installed [by the
> communists]. Dispossessed peasants, intransigent collectivists, refused to
> work in a system of private property, and were even less willing to rent out
> their labour."_ [ **Anarchists in the Spanish Revolution** , p. 258]

If the collectives were unpopular, created by anarchist force, then why did
the economy collapse after the suppression? If Lister had overturned a
totalitarian anarchist regime, why did the peasants not reap the benefit of
their toil? Could it be because the collectives were essentially a spontaneous
Aragónese development and supported by most of the population there? This
analysis is supported by historian Yaacov Oved:

> _"Those who were responsible for this policy [of attacking the Aragón
> collectives], were convinced that the farmers would greet it joyfully
> because they had been coerced into joining the collectives. But they were
> proven wrong. Except for the rich estate owners who were glad to get their
> land back, most of the members of the agricultural collectives objected and
> lacking all motivation they were reluctant to resume the same effort in the
> agricultural work. This phenomenon was so widespread that the authorities
> and the communist minister of agriculture were forced to retreat from their
> hostile policy."_ [ **"Communismo Libertario" and Communalism in the Spanish
> Collectivisations (1936-1939)** , pp. 53-4]

Even in the face of Communist repression, most of the collectives kept going.
This, if nothing else, proves that the collectives were popular institutions.
_"Through the widespread reluctance of collectivists to co-operate with the
new policy,"_ Oved argues, _"it became evident that most members had
voluntarily joined the collectives and as soon as the policy was changed a new
wave of collectives was established. However, the wheel could not be turned
back. An atmosphere of distrust prevailed between the collectives and the
authorities and every initiative was curtailed"_ [ **Op. Cit.** , p. 54]

Jose Peirats summed up the situation after the communist attack on the
collectives and the legalisation of the collectives as follows:

> _"It is very possible that this second phase of collectivisation better
> reflects the sincere convictions of the members. They had undergone a severe
> test and those who had withstood it were proven collectivists. Yet it would
> be facile to label as anti-collectivists those who abandoned the collectives
> in this second phase. Fear, official coercion and insecurity weighed heavily
> in the decisions of much of the Aragónese peasantry."_ [ **Op. Cit.** , p.
> 258]

While the collectives had existed, there was a 20% increase in production (and
this is compared to the pre-war harvest which had been _"a good crop"_
[Fraser, **Op. Cit.** p. 370]). After the destruction of the collectives, the
economy collapsed. Hardly the result that would be expected if the collectives
were forced upon an unwilling peasantry (the forced collectivisation by Stalin
in Russia resulted in a famine). Only the victory of fascism made it possible
to restore the so-called "natural order" of capitalist property in the Spanish
countryside. The same land-owners who welcomed the Communist repression of the
collectives also, we are sure, welcomed the fascists who ensured a lasting
victory of property over liberty.

So, overall, the evidence suggests that the Aragón collectives, like their
counterparts in the Levante, Catalonia and so on, were **popular**
organisations, created by and for the rural population and, essentially, an
expression of a spontaneous and popular social revolution. Claims that the
anarchist militia created them by force of arms are **false.** While acts of
violence **did** occur and some acts of coercion **did** take place (against
CNT policy, we may add) these were the exceptions to the rule. Bolloten's
summary best fits the facts:

> _"But in spite of the cleavages between doctrine and practice that plagued
> the Spanish Anarchists whenever they collided with the realities of power,
> it cannot be overemphasised that notwithstanding the many instances of
> coercion and violence, the revolution of July 1936 distinguished itself from
> all others by the generally spontaneous and far-reaching character of its
> collectivist movement and by its promise of moral and spiritual renewal.
> Nothing like this spontaneous movement had ever occurred before."_ [ **Op.
> Cit.** , p. 78]

## I.8.8 But did the Spanish collectives innovate?

Yes. In contradiction to the old capitalist claim that no one will innovate
unless private property exists, the workers and peasants exhibited much more
incentive and creativity under libertarian socialism than they had under the
private enterprise system. This is apparent from Gaston Leval's description of
the results of collectivisation in Cargagente in the southern part of the
province of Valencia:

> _"The climate of the region is particularly suited for the cultivation of
> oranges . . . All of the socialised land, without exception, is cultivated
> with infinite care. The orchards are thoroughly weeded. To assure that the
> trees will get all the nourishment needed, the peasants are incessantly
> cleaning the soil. 'Before,' they told me with pride, 'all this belonged to
> the rich and was worked by miserably paid labourers. The land was neglected
> and the owners had to buy immense quantities of chemical fertilisers,
> although they could have gotten much better yields by cleaning the soil . .
> .' With pride, they showed me trees that had been grafted to produce better
> fruit._

> _"In many places I observed plants growing in the shade of the orange trees.
> 'What is this?,' I asked. I learned that the Levant peasants (famous for
> their ingenuity) have abundantly planted potatoes among the orange groves.
> The peasants demonstrate more intelligence than all the bureaucrats in the
> Ministry of Agriculture combined. They do more than just plant potatoes.
> Throughout the whole region of the Levant, wherever the soil is suitable,
> they grow crops. They take advantage of the four month [fallow period] in
> the rice fields. Had the Minister of Agriculture followed the example of
> these peasants throughout the Republican zone, the bread shortage problem
> would have been overcome in a few months."_ [ **Anarchist Collectives** , p.
> 153]

This is just one from a multitude of examples presented in the accounts of
both the industrial and rural collectives. We have already noted some examples
of the improvements in efficiency realised by collectivisation during the
Spanish Revolution ([section I.4.10](secI4.md#seci410)). Another example was
the baking industry. Souchy reported that, _"[a]s in the rest of Spain,
Barcelona's bread and cakes were baked mostly at night in hundreds of small
bakeries. Most of them were in damp, gloomy cellars infested with roaches and
rodents. All these bakeries were shut down. More and better bread and cake
were baked in new bakeries equipped with new modern ovens and other
equipment."_ [ **Op. Cit.** , p. 82] In Granollers, the syndicate _"was at all
times a prime-mover. All kinds of initiatives tending to improve the operation
and structure of the local economy could be attributed to it."_ The
collectivised hairdressing, shoe-making, wood-working and engineering
industries were all improved, with small, unhealthy and inefficient workplaces
closed and replaced by larger, more pleasant and efficient establishments.
_"Socialisation went hand in hand with rationalisation."_ [Gaston Leval,
**Collectives in the Spanish Revolution** , p. 287] For more see
[sectionI.8.6](secI8.md#seci86) as well as [section
C.2.8](secC2.md#secc28) (in which we present more examples when refuting the
charge that workers' control would stifle innovation).

The substantial evidence available, of which these examples are but a small
number, proves that the membership of the collectives showed a keen awareness
of the importance of investment and innovation in order to increase
production, to make work both lighter and more interesting **and** that the
collectives allowed that awareness to be expressed freely. The collectives
indicate that, given the chance, everyone will take an interest in their own
affairs and express a desire to use their minds to improve their lives and
surroundings. In fact, capitalism distorts what innovation exists under
hierarchy by channelling it purely into how to save money and maximise
investor profit, ignoring other, more important, issues. As Gaston Leval
suggested, self-management encouraged innovation:

> _"The theoreticians and partisans of the liberal economy affirm that
> competition stimulates initiative and, consequently, the creative spirit and
> invention without which it remains dormant. Numerous observations made by
> the writer in the Collectives, factories and socialised workshops permit him
> to take quite the opposite view. For in a Collective, in a grouping where
> each individual is stimulated by the wish to be of service to his fellow
> beings, research, the desire for technical perfection and so on are also
> stimulated. But they also have as a consequence that other individuals join
> those who were first to get together. Furthermore, when, in present society,
> an individualist inventor discovers something, it is used only by the
> capitalist or the individual employing him, whereas in the case of an
> inventor living in a community not only is his discovery taken up and
> developed by others, but is immediately applied for the common good. I am
> convinced that this superiority would very soon manifest itself in a
> socialised society."_ [ **Op. Cit.** , p. 347]

Therefore the actual experiences of self-management in Spain support the
points made in [section I.4.11](secI4.md#seci411). Freed from hierarchy,
individuals will creatively interact with the world to improve their
circumstances. For the human mind is an active agent and unless crushed by
authority it can no more stop thinking and acting than the Earth can stop
revolving round the Sun. In addition, the Collectives indicate that self-
management allows ideas to be enriched by discussion.

The experience of self-management proved Bakunin's point that society is
collectively more intelligent than even the most intelligent individual simply
because of the wealth of viewpoints, experience and thoughts contained there.
Capitalism impoverishes individuals and society by its artificial boundaries
and authority structures.

## I.8.9 Why, if it was so good, did it not survive?

Just because something is good does not mean that it will survive. For
example, the Warsaw Ghetto uprising against the Nazis failed but that does not
mean that the uprising was a bad cause or that the Nazi regime was correct,
far from it. Similarly, while the experiment in workers' self-management and
free communes undertaken across Republican Spain is one of the most important
social experiments in a free society ever undertaken, this cannot change the
fact that Franco's forces and the Communists had access to more and better
weapons.

Faced with the aggression and terrorism of Franco, and behind him the military
might of Fascist Italy and Nazi Germany, the treachery of the Communists, and
the aloofness of the Western "democratic" states (whose policy of "non-
intervention" was strangely ignored when their citizens aided Franco) it is
amazing the revolution lasted as long as it did.

This does not excuse the actions of the anarchists themselves. As is well
known, the CNT co-operated with the other anti-fascist parties and trade
unions on the Republican side ultimately leading to anarchists joining the
government (see [next section](secI8.md#seci810)). This co-operation helped
ensure the defeat of the revolution. While much of the blame can be placed at
the door of the would-be "leaders" (who like most leaders started to think
themselves irreplaceable), it must be stated that the rank-and-file of the
movement did little to stop them. Most of the militant anarchists were at the
front-line (and so excluded from union and collective meetings) and so could
not influence their fellow workers (it is no surprise that the radical
_"Friends of Durruti"_ anarchist group were mostly ex-militia men). However,
it seems that the mirage of anti-fascist unity proved too much for the
majority of CNT members (see [section I.8.12](secI8.md#seci812)).

A few anarchists still maintain that the Spanish anarchist movement had no
choice and that collaboration (while having unfortunate effects) was the only
choice available. This view was defended by Sam Dolgoff and finds some support
in the writings of Gaston Leval, August Souchy and other participants in the
revolution. However, most anarchists today oppose collaboration and think it
was a terrible mistake (at the time, this position was held by the majority of
non-Spanish anarchists plus a large minority of the Spanish movement, becoming
a majority as the implications of collaboration became clear). This viewpoint
finds its best expression in Vernon Richard's **Lessons of the Spanish
Revolution** and, in part, in such works as **Anarchists in the Spanish
Revolution** by Jose Peirats, **Anarchist Organisation: The History of the
FAI** by Juan Gomaz Casas and **Durruti in the Spanish Revolution** by Abel
Paz as well as in a host of pamphlets and articles written by anarchists ever
since.

So, regardless of how good a social system is, objective facts will overcome
that experiment. Saturnino Carod (a leader of a CNT Militia column at the
Aragón Front) summed up the successes of the revolution as well as its
objective limitations:

> _"Always expecting to be stabbed in the back, always knowing that if we
> created problems, only the enemy across the lines would stand to gain. It
> was a tragedy for the anarcho-syndicalist movement; but it was a tragedy for
> something greater -- the Spanish people. For it can never be forgotten that
> it was the working class and peasantry which, by demonstrating their ability
> to run industry and agriculture collectively, allowed the republic to
> continue the struggle for thirty-two months. It was they who created a war
> industry, who kept agricultural production increasing, who formed militias
> and later joined the army. Without their creative endeavour, the republic
> could not have fought the war . . ."_ [quoted by Ronald Fraser, **Blood of
> Spain** , p. 394]

So, regardless of its benefits, regardless of its increase in liberty and
equality, the revolution was defeated. This should not blind us to its
achievements or the potential it expressed. Rather, it should be used both as
a source of inspiration and lessons.

## I.8.10 Why did the CNT collaborate with the state?

As is well known, in September 1936 the CNT joined the Catalan government,
followed by the central government in November. This flowed from the decision
made on July 21st to not speak of Libertarian Communism until after Franco had
been defeated. In other words, to collaborate with other anti-fascist parties
and unions in a common front against fascism. This decision, initially,
involved the CNT agreeing to join a _"Central Committee of Anti-Fascist
Militias"_ proposed by the leader of the Catalan government, Louis Companys.
This committee was made up of representatives of various anti-fascist parties
and groups. From this it was only a matter of time until the CNT joined an
official government as no other means of co-ordinating activities existed (see
[section I.8.13](secI8.md#seci813)).

The question must arise, **why** did the CNT decide to collaborate with the
state, forsake its principles and, in its own way, contribute to the counter-
revolution and the loosing of the war. This is an important question. Indeed,
it is one Marxists always throw up in arguments with anarchists or in anti-
anarchist diatribes. Does the failure of the CNT to implement anarchism after
July 19th mean that anarchist politics are flawed? Or, rather, does the
experience of the CNT and FAI during the Spanish revolution indicate a failure
of **anarchists** rather than of **anarchism,** a mistake made under difficult
objective circumstances and one which anarchists have learnt from? Needless to
say, anarchists argue that the latter is correct. In other words, as Vernon
Richards argued, _"the basis of [this] criticism is not that anarchist ideas
were proved to be unworkable by the Spanish experience, but that the Spanish
anarchists and syndicalists failed to put their theories to the test, adopting
instead the tactics of the enemy."_ [ **Lessons of the Spanish Revolution** ,
p. 14]

So, why **did** the CNT collaborate with the state during the Spanish Civil
War? Simply put, rather than being the fault of anarchist theory (as Marxists
like to claim), its roots can be discovered in the situation facing the
Catalan anarchists on July 20th. The objective conditions facing the leading
militants of the CNT and FAI influenced the decisions they took, decisions
which they later justified by **mis** -using anarchist theory.

What was the situation facing the Catalan anarchists on July 20th? Simply put,
it was an unknown situation, as the report made by the CNT to the
**International Workers Association** made clear:

> _"Levante was defenceless and uncertain . . . We were in a minority in
> Madrid. The situation in Andalusia was unknown . . . There was no
> information from the North, and we assumed the rest of Spain was in the
> hands of the fascists. The enemy was in Aragón, at the gates of Catalonia.
> The nervousness of foreign consular officials led to the presence of a great
> number of war ships around our ports."_ [quoted by Jose Peirats,
> **Anarchists in the Spanish Revolution** , p. 180]

Anarchist historian Jose Peirats noted that according to the report _"the CNT
was in absolute control of Catalonia in July 19, 1936, but its strength was
less in Levante and still less in central Spain where the central government
and the traditional parties were dominant. In the north of Spain the situation
was confused. The CNT could have mounted an insurrection on its own 'with
probable success' but such a take-over would have led to a struggle on three
fronts: against the fascists, the government and foreign capitalism. In view
of the difficulty of such an undertaking, collaboration with other antifascist
groups was the only alternative."_ [ **Op. Cit.** , p. 179] In the words of
the CNT report itself:

> _"The CNT showed a conscientious scrupulousness in the face of a difficult
> alternative: to destroy completely the State in Catalonia, to declare war
> against the Rebels [i.e. the fascists], the government, foreign capitalism,
> and thus assuming complete control of Catalan society; or collaborating in
> the responsibilities of government with the other antifascist fractions."_
> [quoted by Robert Alexander, **The Anarchists in the Spanish Civil War** ,
> vol. 2, p. 1156]

Moreover, as Gaston Leval later argued, given that the _"general
preoccupation"_ of the majority of the population was _"to defeat the fascists
. . . the anarchists would, if they came out against the state, provoke the
antagonism . . . of the majority of the people, who would accuse them of
collaborating with Franco."_ Implementing an anarchist revolution would, in
all likelihood, also result in _"the instant closing of the frontier and the
blockade by sea by both fascists and the democratic countries. The supply of
arms would be completely cut off, and the anarchists would rightly be held
responsible for the disastrous consequences."_ [ **The Anarchist Collectives**
, p. 52 and p. 53]

While the supporters of Lenin and Trotsky will constantly point out the
objective circumstances in which their heroes made their decisions during the
Russian Revolution, they rarely mention those facing the anarchists in Spain
on the 20th of July, 1936. It seems hypocritical to point to the Russian Civil
War as the explanation of all of the Bolsheviks' crimes against the working
class (indeed, humanity) while remaining silent on the forces facing the CNT-
FAI at the start of the Spanish Civil War. The fact that **if** the CNT had
decided to implement libertarian communism in Catalonia they would have to
face the fascists (commanding the bulk of the Spanish army), the Republican
government (commanding the rest) **plus** those sections in Catalonia which
supported the republic is rarely mentioned. Moreover, when the decision to
collaborate was made it was **immediately after the defeat of the army
uprising in Barcelona** \-- the situation in the rest of the country was
uncertain and when the social revolution was in its early days. Stuart
Christie indicates the dilemma facing the leadership of the CNT at the time:

> _"The higher committees of the CNT-FAI-FIJL in Catalonia saw themselves
> caught on the horns of a dilemma: social revolution, fascism or bourgeois
> democracy. Either they committed themselves to the solutions offered by
> social revolution, regardless of the difficulties involved in fighting both
> fascism and international capitalism, or, through fear of fascism (or of the
> people), they sacrificed their anarchist principles and revolutionary
> objectives to bolster, to become, part of the bourgeois state . . . Faced
> with an imperfect state of affairs and preferring defeat to a possibly
> Pyrrhic victory, the Catalan anarchist leadership renounced anarchism in the
> name of expediency and removed the social transformation of Spain from their
> agenda._

> _"But what the CNT-FAI leaders failed to grasp was that the decision whether
> or not to implement Libertarian Communism, was not theirs to make. Anarchism
> was not something which could be transformed from theory into practice by
> organisational decree . . . [the] spontaneous defensive movement of 19 July
> had developed a political direction of its own."_ [ **We, the Anarchists!**
> , p. 99]

Given that the pro-fascist army still controlled a third or more of Spain
(including Aragón) and that the CNT was not the dominant force in the centre
and north of Spain, it was decided that a war on three fronts would only aid
Franco. Moreover, it was a distinct possibility that by introducing
libertarian communism in Catalonia, Aragón and elsewhere, the workers'
militias and self-managed industries would have been starved of weapons,
resources and credit. That isolation was a real problem can be seen from Abad
de Santillán's later comments on why the CNT joined the government:

> _"The Militias Committee guaranteed the supremacy of the people in arms . .
> . but we were told and it was repeated to us endlessly that as long as we
> persisted in retaining it, that is, as long as we persisted in propping up
> the power of the people, weapons would not come to Catalonia, nor would we
> be granted the foreign currency to obtain them from abroad, nor would we be
> supplied with the raw materials for our industry. And since losing the war
> meant losing everything and returning to a state like that prevailed in the
> Spain of Ferdinand VII, and in the conviction that the drive given by us and
> our people could not vanish completely from the new economic life, we quit
> the Militias Committee to join the Generalidad government."_ [quoted by
> Christie, **Op. Cit.** , p. 109]

It was decided to collaborate and reject the basic ideas of anarchism until
the war was over. A terrible mistake, but one which can be understood given
the circumstances in which it was made. This is not, we stress, to justify the
decision but rather to explain it and place it in context. Ultimately, the
**experience** of the Civil War saw a blockade of the Republic by both
"democratic" and fascist governments, the starving of the militias and self-
managed collectives of resources and credit as well as a war on two fronts
when the State felt strong enough to try and crush the CNT and the semi-
revolution its members had started. Most CNT members did not think that when
faced with the danger of fascism, the liberals, the right-wing socialists and
communists would prefer to undermine the anti-fascist struggle by attacking
the CNT. They were wrong and, in this, history proved Durruti totally correct:

> _"For us it is a matter of crushing Fascism once and for all. Yes, and in
> spite of the Government._

> _"No government in the world fights Fascism to the death. When the
> bourgeoisie sees power slipping from its grasp, it has recourse to Fascism
> to maintain itself. The liberal government of Spain could have rendered the
> fascist elements powerless long ago. Instead it compromised and dallied.
> Even now at this moment, there are men in this Government who want to go
> easy on the rebels. You can never tell, you know -- he laughed -- the
> present Government might yet need these rebellious forces to crush the
> workers' movement . . ._

> _"We know what we want. To us it means nothing that there is a Soviet Union
> somewhere in the world, for the sake of whose peace and tranquillity the
> workers of Germany and China were sacrificed to Fascist barbarians by
> Stalin. We want revolution here in Spain, right now, not maybe after the
> next European war. We are giving Hitler and Mussolini far more worry to-day
> with our revolution than the whole Red Army of Russia. We are setting an
> example to the German and Italian working class on how to deal with
> fascism._

> _"I do not expect any help for a libertarian revolution from any Government
> in the world. Maybe the conflicting interests of the various imperialisms
> might have some influence in our struggle. That is quite possible . . . But
> we expect no help, not even from our own Government, in the last analysis."_

> _"You will be sitting on a pile of ruins if you are victorious,"_ said [the
> journalist] van Paasen.

> Durruti answered: _"We have always lived in slums and holes in the wall. We
> will know how to accommodate ourselves for a time. For, you must not forget,
> we can also build. It is we the workers who built these palaces and cities
> here in Spain and in America and everywhere. We, the workers, can build
> others to take their place. And better ones! We are not in the least afraid
> of ruins. We are going to inherit the earth; there is not the slightest
> doubt about that. The bourgeoisie might blast and ruin its own world before
> it leaves the stage of history. We carry a new world here, in our hearts.
> That world is growing this minute."_ [quoted by Vernon Richards, **Lessons
> of the Spanish Revolution** , pp. 193-4f]

This desire to push the revolution further was not limited to Durruti, as can
be seen from this communication from the Catalan CNT leadership in August
1936. It also expresses the fears driving the decisions which had been made:

> _"Reports have also been received from other regions. There has been some
> talk about the impatience of some comrades who wish to go further than
> crushing fascism, but for the moment the situation in Spain as a whole is
> extremely delicate. In revolutionary terms, Catalonia is an oasis within
> Spain._

> _"Obviously no one can foresee the changes which may follow the civil war
> and the conquest of that part of Spain which is still under the control of
> mutinous reactionaries."_ [quoted by Jose Peirats, **Op. Cit.** , pp. 151-2]

Isolation, the uneven support for a libertarian revolution across Spain and
the dangers of fascism were real problems, but they do not excuse the
libertarian movement for its mistakes. The biggest of these mistakes was
forgetting basic anarchist ideas and an anarchist approach to the problems
facing the Spanish people. If these ideas had been applied in Spain, the
outcome of the Civil War and Revolution could have been different.

In summary, while the decision to collaborate is one that can be understood
(due to the circumstances under which it was made), it cannot be justified in
terms of anarchist theory. Indeed, as we argue in the [next
section](secI8.md#seci811), attempts by the CNT leadership to justify the
decision in terms of anarchist principles are not convincing and cannot be
done without making a mockery of anarchism.

## I.8.11 Was the decision to collaborate a product of anarchist theory?

Marxist critics of Anarchism point to CNT's decision to collaborate with the
bourgeois state against Franco as the key proof that libertarian socialism is
flawed. Such a claim, anarchists reply, is false for rather than being the
product of anarchist ideology, the decision was made in light of the immediate
danger of fascism and the situation in other parts of the country. The fact is
that the circumstances in which the decision to collaborate was made are
rarely mentioned by Marxists. To quote a sadly typical Marxist diatribe:

> _"This question of state power, and which class holds it, was to prove
> crucial for revolutionaries during the Spanish Civil War and in particular
> during the revolutionary upheavals in Catalonia. Here anarchism faced its
> greatest test and greatest opportunity, yet it failed the former and
> therefore missed the latter._

> _"When the government in the region under the leadership of Companys
> admitted its impotence and offered to dissolve, effectively handing power to
> the revolutionary forces, the anarchists turned them down. CNT leader and
> FAI . . . militant Garcia Oliver explained, 'The CNT and the FAI decided on
> collaboration and democracy, renouncing revolutionary totalitarianism which
> would lead to the strangulation of the revolution by the anarchist and
> Confederal dictatorship. We had to choose, between Libertarian Communism,
> which meant anarchist dictatorship, and democracy, which meant
> collaboration.' The choice was between leaving the state intact and paving
> the way for Franco's victory or building a workers' government in Catalonia
> which could act as a focal point for the defeat of Franco and the creation
> of the structures of a new workers' state. In choosing the former the
> anarchists were refusing to distinguish between a capitalist state and a
> workers' state . . . The movement that started by refusing to build a
> workers' state ended up by recognising a capitalist one and betraying the
> revolution in the process."_ [Pat Stack, _"Anarchy in the UK?"_ ,
> **Socialist Review** , no. 246]

There are four key flaws in this kind of argument. First, there is the actual
objective situation in which the decision to collaborate was made in.
Strangely, for all his talk of anarchists ignoring _"material conditions"_
when we discuss the Russian revolution, Stack fails to mention any when he
discusses Spain. As such, his critique is pure idealism, without any attempt
to ground it in the objective circumstances facing the CNT and FAI. Second,
the quote provided as the only evidence for Stack's analysis dates from a year
**after** the decision was made. Rather than reflect the actual concerns of
the CNT and FAI at the time, they reflect the attempts of the leaders of an
organisation which had significantly departed from its libertarian principles
to justify their actions. While this obviously suits Stack's idealist analysis
of events, its use is flawed for that reason. Thirdly, clearly the decision of
the CNT and FAI **ignored** anarchist theory. As such, it seems ironic to
blame anarchism when anarchists ignore its recommendations, yet this is what
Stack does. Lastly, there is the counter-example of Aragón, which clearly
refutes Stack's case.

To understand why the CNT and FAI made the decisions it did, it is necessary
to do what Stack fails to do, namely to provide some context. The decision to
ignore anarchist theory, ignore the state rather than smashing it and work
with other anti-fascist organisations was made immediately after the army had
been defeated on the streets of Barcelona on the 20th of July, 1936. As we
indicated in the [last section](secI8.md#seci810), the decision of the CNT
to collaborate with the state was driven by the fear of isolation. The
possibility that by declaring libertarian communism it would have had to fight
the Republican government and foreign interventions **as well as** the
military coup influenced the decision reached by the militants of Catalan
anarchism. They concluded that pursuing implementing anarchism in the
situation they faced would only aid Franco and result in a quick defeat.

As such, the **real** choice facing the CNT was not _"between leaving the
state intact . . . or building a workers' government in Catalonia which could
act as a focal point for the defeat of Franco"_ but rather something
drastically different: Either work with other anti-fascists against Franco so
ensuring unity against the common enemy and pursue anarchism after victory
**or** immediately implement libertarian communism and possibly face a
conflict on two fronts, against Franco **and** the Republic (and, possibly,
imperialist intervention against the social revolution). This situation made
the CNT-FAI decided to collaborate with other anti-fascist groups in the
Catalan **Central Committee of Anti-Fascist Militias**. To downplay these
objective factors and the dilemma they provoked and instead simply blame the
decision on anarchist politics is a joke.

Similarly, the Garcia Oliver quote provided by Stack dated from July 1937.
They were made as justifications of CNT-FAI actions and were designed for
political effect. As such, they simply cannot be taken at face value for these
two reasons. It is significant, though, that rather than discuss the actual
problems facing the CNT Marxists like Stack prefer to ritualistically trot out
a quote made over a year later. They argue that it exposes the bankruptcy of
anarchist theory. So convinced of this, they rarely bother discussing the
problems facing the CNT after the defeat of the military coup nor do they
compare these quotes to the anarchist theory they claim inspired them.

There are good reasons for this. Firstly, if they presented the objective
circumstances the CNT found itself it then their readers may see that the
decision, while wrong, is understandable and had nothing to do with anarchist
theory. Secondly, by comparing this quote to anarchist theory their readers
would soon see how at odds they are with each other. Indeed, Garcia Oliver
invoked anarchism to justify conclusions that were the exact **opposite** to
what that theory actually recommends!

So what can be made of Garcia Oliver's argument? As Abel Paz noted: _"It is
clear that the explanations given . . . were designed for their political
effect, hiding the atmosphere in which these decisions were taken. These
declarations were made a year later when the CNT were already far removed from
their original positions. It is also the period when they had become involved
in the policy of collaboration which led to them taking part in the Central
Government. But in a certain way they shed light on the unknown factors which
weighted so heavily on these who took part in the historic Plenum."_ [
**Durruti: The People Armed** , p. 215]

For example, when the decision was made, the revolution had not started yet.
The street fighting had just ended and the Plenum decided _"not to speak about
Libertarian Communism as long as part of Spain was in the hands of the
fascists."_ [Mariano R. Vesquez, quoted by Paz, **Op. Cit.** , p. 214] The
revolution took place **from below** in the days following the decision,
independently of the wishes of the Plenum. In the words of Abel Paz:

> _"When the workers reached their workplaces . . . they found them deserted .
> . . The major centres of production had been abandoned by their owners . . .
> The CNT and its leaders had certainly not foreseen this situation; if they
> had, they would have given appropriate guidance to the workers when they
> called off the General Strike and ordered a return to work. What happened
> next was the result of the workers' spontaneous decision to take matters
> into their own hands._

> _"Finding the factories deserted, and no instructions from their unions,
> they resolved to operate the machines themselves."_ [ **The Spanish Civil
> War** , pp. 54-5]

The rank and file of the CNT, on their own initiative, took advantage of the
collapse of state power to transform the economy and social life of Catalonia.
Paz stressed that _"no orders were given for expropriation or collectivisation
-- which proved that the union, which represented the will of their members
until July 18th, had now been overtaken by events"_ and the _"union leaders of
the CNT committees were confronted with a revolution that they had not
foreseen . . . the workers and peasants had bypassed their leaders and taken
collective action."_ [ **Op. Cit.** , p. 40 and p. 56] As historian Ronald
Fraser summarises the _"revolutionary initiative had sprung not from the CNT's
leading committees -- how could it when the libertarian revolution had been
officially 'postponed'? -- but from individual CNT unions impelled by the most
advanced syndicalist militants."_ So while the Catalan CNT _"had 'put off'
libertarian revolution . . . daily, the revolution in Barcelona was taking
root in CNT collectives and union-run industries."_ [ **Blood of Spain** , p.
139 and p. 179]

As the revolution had not yet begun and the CNT Plenum had decided **not** to
call for its start, it is difficult to see how _"libertarian communism"_ (i.e.
the revolution) could _"lead to the strangulation of the revolution"_ (i.e.
libertarian communism). In other words, this particular rationale put forward
by Garcia Oliver could not reflect the real thoughts of those present at the
CNT plenum and so, obviously, was a later justification for the CNT's actions.
Moreover, the decision made then clearly stated that Libertarian Communism
would be back on the agenda once Franco was defeated. Oliver's comments were
applicable **after** Franco was defeated just as much as on July 20th, 1936.

Similarly, Libertarian Communism is based on self-management, by its nature
opposed to dictatorship. According to the CNT's resolution at its congress in
Zaragoza in May, 1936, _"the foundation of this administration will be the
Commune"_ which is _"autonomous"_ and _"federated at regional and national
levels."_ The commune _"will undertake to adhere to whatever general norms
[that] may be agreed by majority vote after free debate."_ [quoted by Jose
Peirats, **The CNT in the Spanish Revolution** , vol. 1, p. 106] It stressed
the free nature of society aimed at by the CNT:

> _"The inhabitants of a commune are to debate among themselves their internal
> problems . . . Federations are to deliberate over major problems affecting a
> country or province and all communes are to be represented at their reunions
> and assemblies, thereby enabling their delegates to convey the democratic
> viewpoint of their respective communes . . . every commune which is
> implicated will have its right to have its say . . . On matters of a
> regional nature, it is the duty of the regional federation to implement
> agreements . . . So the starting point is the individual, moving on through
> the commune, to the federation and right on up finally to the
> confederation."_ [quoted by Peirats, **Op. Cit.** , p. 107]

Hardly a picture of _"anarchist dictatorship"_! Indeed, it is far more
democratic than the capitalist state Oliver described as _"democracy."_ So
Oliver's arguments from 1937 are totally contradictory. After all, he is
arguing that libertarian communism (a society based on self-managed free
associations organised and run from the bottom up) is an _"anarchist
dictatorship"_ and **less** democratic than the capitalist Republic he had
been fighting against between 1931 and 1936! Moreover, libertarian communism
**inspired** the revolution and so to reject it in favour of capitalist
democracy to stop _"the strangulation of the revolution"_ makes no sense.

Clearly, these oft quoted words of Garcia Oliver cannot be taken at face
value. Made in 1937, they present an attempt to misuse anarchist ideals to
defend the anti-anarchist activities of the CNT leadership rather than a
meaningful explanation of the decisions made on the 20th of July, 1936. It is
safe to take his words with a large pinch of salt. To rely upon them for an
analysis of the actions of the Spanish Anarchists or the failings of anarchism
suggests an extremely superficial perspective. This is particularly the case
when we look at both the history of the CNT and anarchist theory.

This can clearly been seen from the report made by the CNT to the
**International Workers Association** to justify the decision to forget
anarchist theory and collaborate with bourgeois parties and join the
government. The report states that _"the CNT, loyal to its ideals and its
purely anarchist nature, did not attack the forms of the State, nor try
publicly to penetrate or dominate it . . . none of the political or juridical
institutions were abolished."_ [quoted by Robert Alexander, **The Anarchists
in the Spanish Civil War** , vol. 2, p. 1156] In other words, according to
this report, "anarchist" ideals do not, in fact, mean the destruction of the
state, but rather the **ignoring** of the state. That this is nonsense,
concocted to justify the CNT leaderships' betrayal of its ideals, is clear. To
prove this we just need to look at Bakunin and Kropotkin and look at the
activities of the CNT **before** the start of the war.

According to anarchist ideas, to quote Bakunin, _"the revolution must set out
from the first to radically and totally destroy the State"_ and that the
_"natural and necessary consequence of this destruction"_ will include the
_"dissolution of army, magistracy, bureaucracy, police and priesthood"_ as
well as the _"confiscation of all productive capital and means of production
on behalf of workers' associations, who are to put them to use"_. The state
would be replaced by _"the federative Alliance of all working men's
associations"_ which _"will constitute the Commune."_ These communes, in turn,
would _"constitute the federation of insurgent associations . . . and organise
a revolutionary force capable of defeating reaction."_ [ **Michael Bakunin:
Selected Writings** , pp. 170-1] For Kropotkin, the _"Commune . . . must break
the State and replace it by the Federation."_ [ **Words of a Rebel** , p. 83]

Thus anarchism has always been clear on what to do with the state, and it is
obviously not what the CNT did to it! The CNT ignored these recommendations
and so given that it did **not** destroy the state, nor create a federation of
workers' councils, then how can anarchist theory be blamed? It seems strange
to point to the failure of anarchists to apply their politics as an example of
the failure of those politics, yet this is what the likes of Stack are doing.

Nor had the CNT always taken this perspective. Before the start of the Civil
War, the CNT had organised numerous insurrections against the state. For
example, in the spontaneous revolt of CNT miners in January 1932, the workers
_"seized town halls, raised the black-and-red flags of the CNT, and declared
**communismo liberatario.** "_ In Tarassa, the same year, the workers again
_"seiz[ed] town halls"_ and the town was _"swept by street fighting."_ The
revolt in January 1933 began with _"assaults by Anarchist action groups . . .
on Barcelona's military barracks . . . Serious fighting occurred in working-
class **barrios** and the outlying areas of Barcelona . . . Uprising occurred
in Tarassa, Sardanola-Ripollet, Lerida, in several **pueblos** in Valencia
province, and in Andalusia."_ In December 1933, the workers _"reared
barricades, attacked public buildings, and engaged in heavy street fighting .
. . many villages declared libertarian communism."_ [Murray Bookchin, **The
Spanish Anarchists** , p. 225, p. 226, p. 227 and p. 238]

It seems that the CNT leadership's loyalty to _"its ideals and its purely
anarchist nature"_ which necessitated _"not attack[ing] the forms of the
State"_ was a very recent development!

As can be seen, the rationales later developed to justify the betrayal of
anarchist ideas and the revolutionary workers of Spain have no real
relationship to anarchist theory. They were created to justify a non-anarchist
approach to the struggle against fascism, an approach based on ignoring
struggle from below and instead forging alliances with parties and unions at
the top. This had been not always been the case. Throughout the 1930s the UGT
and Socialist Party had rejected the CNT's repeated calls for a revolutionary
alliance from below in favour of a top-down _"Workers' Alliance"_ which, they
believed, would be the only way which would allow them to control the labour
movement. The CNT, rightly, rejected such a position in favour of an alliance
from the bottom up yet, in July 1936, the need for unity was obvious and the
UGT was not changing its position. So while in Barcelona the state had been
destroyed in all but name, _"in Madrid, thanks to the Socialist Party,
bourgeois structures were left intact and even fortified: a semi-dead state
received a new lease of life and no dual power was created to neutralise it."_
[Abel Paz, **Durruti in the Spanish Revolution** , p. 462]

Rather than trying to cement a unity with other organisations at the top level
in July 1936, the leadership of the CNT should have applied their anarchist
ideas by inciting the oppressed to enlarge and consolidate their gains (which
they did anyway). This would have liberated all the potential energy within
the country (and elsewhere), energy that clearly existed as can be seen from
the spontaneous collectivisations that occurred after the fateful Plenum of
July 20th and the creation of volunteer workers' militia columns sent to
liberate those parts of Spain which had fallen to Franco.

The role of anarchists, therefore, was that of _"inciting the people to
abolish capitalistic property and the institutions through which it exercises
its power for the exploitation of the majority by a minority"_ and _"to
support, to incite and encourage the development of the social revolution and
to frustrate any attempts by the bourgeois capitalist state to reorganise
itself, which it would seek to do."_ This would involve _"seeking to destroy
bourgeois institutions through the creation of revolutionary organisms."_
[Vernon Richards, **Lessons of the Spanish Revolution** , p. 44, p. 46 and p.
193] In other words, to encourage, the kind of federation of communities and
workplaces Bakunin and Kropotkin had called for.

Indeed, such an organisation already existing in embryo in the CNT's
**barrios** defence committees which had led and co-ordinated the struggle
against the military coup throughout Barcelona. _"The Neighbourhood
Committees, which had diverse names but all shared a libertarian outlook,
federated and created a revolutionary Local Co-ordination Committee."_ They
_"became Revolutionary Committees and formed what was called the 'Federation
of Barricades.' It was the Committees that held power in Barcelona that
evening."_ [Paz, **Op. Cit.** , p. 470 and p. 445] Rather than collaborate
with political parties and the UGT at the top, in the Central Committee of
Anti-Fascist Militias, the CNT should have developed these organs of community
self-organisation:

> _"Power lay in the street on July 20, represented by the people in arms . .
> . Life took on a new momentum and it both destroyed and created as the
> people worked to resolve practical necessities born from a collective life
> that lived -- and wanted to continue living -- in the street . . . The
> street and the people in arms were the living force of the revolution . . .
> The Defence Committees, now transformed into Revolutionary Committees, back
> up this force. They organised what was called the 'Federation of
> Barricades.' Militants, standing resolutely behind these barricades,
> represented them in the Revolutionary Committees."_ [Paz, **Op. Cit.** , pp.
> 450-1]

Later, a delegate meeting from the various workplaces (whether previously
unionised or not) would have had to been arranged to organise, to re-quote
Bakunin, _"the federal Alliance of all working men's associations"_ which
would _"constitute the Commune"_ and complement the _"federation of the
barricades."_ [ **Op. Cit.** , p. 170] In more modern terminology, a
federation of workers' councils combined with a federation of workers'
militias and community assemblies. Without this, the revolution was doomed as
was the war against Franco. A minority of anarchists **did** see this
genuinely libertarian solution at the time, but sadly they were a minority.
For example, the members of the **Nosotros** Group, which included Durruti,
thought _"it was necessary to transcend the alliance between the CNT and the
political parties and create an authentic revolutionary organisation. That
organisation would rest directly on Barcelona's and Catalonia's unions and
Revolutionary Committees. Together, those groups would form a Regional
Assembly, which would be the revolution's executive body."_ [Paz, **Op. Cit.**
, p. 471] Such a development, applying the basic ideas of anarchism (and as
expounded in the CNT's May resolution on Libertarian Communism), was not an
impossibility. After all, as we will see, the CNT-FAI organised along those
lines in Aragón.

Concern that Catalonia would be isolated from the rest of the Republic was
foremost in the minds of many in the CNT and FAI. The fear that if libertarian
communism was implemented then a civil war within the anti-fascist forces
would occur (so aiding Franco) was a real one. Unfortunately, the conclusion
drawn from that fear, namely to win the war against Franco before talking
about the revolution, was the wrong one. After all, a civil war within the
Republican side **did** occur, when the state had recovered enough to start
it. Similarly, with the fear of a blockade by foreign governments. This
happened anyway, confirming the analysis of activists like Durruti.

Organising a full and proper delegate meeting in the first days of the
revolution would have allowed all arguments and suggestions to be discussed by
the whole membership of the CNT and, perhaps, a different decision may have
been reached on the subject of collaboration. After all, many CNT members were
applying anarchist politics by fighting fascism via a revolutionary war. This
can be seen by the rank and file of the CNT and FAI ignoring the decision to
"postpone" the revolution in favour of an anti-fascist war. All across
Republican Spain, workers and peasants started to expropriate capital and the
land, placing it under workers' self-management. They did so on their own
initiative. It is also possible, as discussed in the [next
section](secI8.md#seci812), that anti-fascist unity would have prevailed and
so the some decision would have been reached.

Be that as it may, by thinking they could postpone the revolution until after
the war, the CNT leadership made two mistakes. Firstly, they should have known
that their members would hardly miss this opportunity to implement libertarian
ideas so making their decision redundant (and a statist backlash inevitable).
Secondly, they abandoned their anarchist ideas, failing to understand that the
struggle against fascism would never be effective without the active
participation of the working class. Such participation could never be achieved
by placing the war before the revolution and by working in top-down, statist
structures or within a state.

Indeed, the mistake made by the CNT, while understandable, cannot be justified
given that their consequences had been predicted by numerous anarchists
beforehand, including Kropotkin. Decades earlier in an essay on the Paris
Commune, the Russian anarchist refuted the two assumptions of the CNT
leadership -- first, of placing the war before the revolution and, second,
that the struggle could be waged by authoritarian structures or a state. He
explicitly attacked the mentality and logic of those who argued _"Let us first
make sure of victory, and then see what can be done"_ :

> _"Make sure of victory! As if there were any way of transforming society
> into a free commune without laying hands upon property! As if there were any
> way of defeating the enemy so long as the great mass of the people is not
> directly interested in the triumph of the revolution, in witnessing the
> arrival of material, moral and intellectual well-being for all! They sought
> to consolidate the Commune first of all while postponing the social
> revolution for later on, while the only effective way of proceeding was **to
> consolidate the Commune by the social revolution**!"_ [ **Words of a Rebel**
> , p. 97]

Kropotkin's argument was sound, as the CNT discovered. By waiting until
victory in the war they were defeated (as Abel Paz suggested, the workers of
Spain _"had to build a new world to secure and defend their victory."_ [ **Op.
Cit.** , p. 451]). Kropotkin also indicated the inevitable effects of the
CNT's actions in co-operating with the state and joining representative
bodies:

> _"Paris . . . sent her devoted sons to the Hotel-de-Ville [town hall].
> Indeed, immobilised there by fetters of red tape, forced to discuss when
> action was needed, and losing the sensitivity that comes from continual
> contact with the masses, they saw themselves reduced to impotence. Paralysed
> by their distancing from the revolutionary centre -- the people -- they
> themselves paralysed the popular initiative."_ [ **Op. Cit.** , pp. 97-8]

Which, in a nutshell, was what happened to the leading militants of the CNT
who collaborated with the state. Kropotkin was proved right, as was anarchist
theory from Bakunin onwards. As Vernon Richards argued, _"there can be no
excuse"_ for the CNT's decision, as _"they were not mistakes of judgement but
the deliberate abandonment of the principles of the CNT."_ [ **Op. Cit.** ,
pp. 41-2] It seems difficult to blame anarchist theory for the decisions of
the CNT when that theory argues the opposite position. That enemies of
anarchism quote Garcia Oliver's words from 1937 to draw conclusions about
anarchist theory says more about their politics than about anarchism!

Moreover, while the experience of Spain confirms anarchist theory
**negatively** , it also confirms it **positively** by the creation of the
Regional Defence Council of Aragón. The Council of Aragón was created by a
meeting of delegates from CNT unions, village collectives and militia columns
to protect the new society based on libertarian communism the people of Aragón
were building. The meeting also decided to press for the setting up of a
National Defence Committee which would link together a series of regional
bodies that were organised on principles similar to the one now established in
Aragón. Durruti stressed that the collectives _"had to build their own means
of self-defence and not rely on the libertarian columns which would leave
Aragón as the war evolved. They needed to co-ordinate themselves, although he
also warned them against forming an anti-fascist political front like the type
existing in other parts of Spain. They needn't make the same error as their
compatriots elsewhere . . . The popular assembly must be sovereign."_ After a
CNT regional assembly militants decided to _"form the Aragón Defence Council
and the Aragón Federation of Collectives."_ [Paz, **Op. Cit.** , pp. 540-1]
This exposes as false the claim that anarchism failed during the Spanish Civil
War. In Aragón, the CNT **did** follow the ideas of anarchism, abolishing both
the state and capitalism. If they had done this in Catalonia, the outcome of
the Civil War may have been different.

The continuity of what happened in Aragón with the ideas of anarchism and the
CNT's 1936 Zaragoza Resolution on Libertarian Communism is obvious. The
formation of the Regional Defence Council was an affirmation of commitment to
the principles of libertarian communism. This principled stand for
revolutionary social and economic change stands at odds with the claims that
the Spanish Civil War indicates the failure of anarchism. After all, in Aragón
the CNT **did** act in accordance with anarchist theory as well as in its own
history and politics. It created a federation of workers' associations as
argued by Bakunin. To contrast Catalonia and Aragón shows the weakness of
Stack's argument. The same organisation, with the same politics, yet different
results. How can anarchist ideas be blamed for what happened in Catalonia when
they had been applied in Aragón? Such a position could not be logically argued
and, unsurprisingly, Aragón usually fails to get mentioned by Marxists when
discussing Anarchism during the Spanish Civil War.

Therefore, the activities of the CNT during the Civil War cannot be used to
discredit anarchism although it can be used to show that anarchists, like
everyone else, can and do make wrong decisions in difficult circumstances.
That Marxists always point to this event in anarchist history is unsurprising,
for it **was** a terrible mistake. Yet how could anarchism have "failed"
during the Spanish Revolution when it was ignored in Catalonia (for fear of
fascism) and applied in Aragón? How can it be argued that anarchist politics
were to blame when those very same politics had formed the Council of Aragón?
It cannot. Simply put, the Spanish Civil War showed the failure of certain
anarchists to apply their ideas in a difficult situation rather than the
failure of anarchism. As Emma Goldman argued, the _"contention that there is
something wrong with Anarchism . . . because the leading comrades in Spain
failed Anarchism seems to be very faulty reasoning . . . the failure of one or
several individuals can never take away from the depth and truth of an
ideal."_ [ **Vision on Fire** , p. 299]

To use the Catalan CNT to generalise about anarchism is false as it, firstly,
requires a dismissal of the objective circumstances the decision was made in
and, secondly, it means ignoring anarchist theory and history. It also gives
the impression that anarchism as a revolutionary theory must be evaluated
purely from one event in its history. The experiences of the Makhnovists in
the Ukraine, the USI and UAI in the factory occupations of 1920 and fighting
fascism in Italy, the insurrections of the CNT during the 1930s, the Council
of Aragón created by the CNT in the Spanish Revolution and so on, are all
ignored. Hardly convincing, although handy for Marxists. As is clear from the
experiences of the Makhnovists and the Council of Aragón, anarchism has been
applied successfully on a large scale, both politically and economically, in
revolutionary situations.

Equally flawed are any attempts to suggest that those anarchists who remained
true to libertarian theory somehow, by so doing, rejected it and moved towards
Marxism. This is usually done to the anarchist group the **Friends of
Durruti** (FoD). In the words of Pat Stack:

> _"Interestingly the one Spanish anarchist group that developed the most
> sophisticated critique of all this was the Friends of Durutti [sic!]. As
> [Trotskyist] Felix Morrow points out, 'They represented a conscious break
> with the anti-statism of traditional anarchism. They explicitly declared the
> need for democratic organs of power, juntas or soviets, in the overthrow of
> capitalism, and the necessary state measures of repression against the
> counter-revolution.' The failure of the Spanish anarchists to understand
> exactly that these were the stark choices‚ workers' power, or capitalist
> power followed by reaction."_ [ **Op. Cit.** ]

That Stack could not bother to spell Durruti's name correctly shows how
seriously we should take this analysis. The FoD were an anarchist grouping
within the CNT and FAI which, like a large minority of others, strongly and
consistently opposed the policy of anti-fascist unity. Rather than signify a
_"conscious break"_ with anarchism, it signified a conscious **return** to it.
This can be clearly seen when we compare their arguments to those of Bakunin.
As noted by Stack, the FoD argued for _"juntas"_ in the overthrow of
capitalism and to defend against counter-revolution. Yet this was **exactly**
what revolutionary anarchists have argued for since Bakunin (see [section
H.2.1](secH2.md#sech21) for details). The continuity of the ideas of the FoD
with the pre-Civil War politics of the CNT and the ideas of revolutionary
anarchism are clear. As such, the FoD were simply arguing for a return to the
traditional positions of anarchism and cannot be considered to have broken
with it. If Stack or Morrow knew anything about anarchism, then they would
have known this.

As such, the failure of the Spanish anarchists was not the _"stark choice"_
between _"workers' power"_ and _"capitalist power"_ but rather the making of
the wrong choice in the real dilemma of introducing anarchism (which would, by
definition, be based on workers' power, organisation and self-management) or
collaborating with other anti-fascist groups in the struggle against the
greater enemy of Franco (i.e. fascist reaction). That Stack does not see this
suggests that he simply has no appreciation of the dynamics of the Spanish
Revolution and prefers abstract sloganeering to a serious analysis of the
problems facing it. He ends by summarising:

> _"The most important lesson . . . is that whatever ideals and gut instincts
> individual anarchists may have, anarchism, both in word and deed, fails to
> provide a roadworthy vehicle for human liberation. Only Marxism, which sees
> the centrality of the working class under the leadership of a political
> party, is capable of leading the working class to victory."_ [ **Op. Cit.**
> ]

As a useful antidote to these claims, we need simply quote Trotsky on what the
Spanish anarchists should have done. In his words: _"Because the leaders of
the CNT renounced dictatorship **for themselves** they left the place open for
the Stalinist dictatorship."_ Hardly an example of "workers' power"! Or, as he
put it earlier in the same year, a _"revolutionary party, even having seized
power (of which the anarchist leaders were incapable in spite of the heroism
of the anarchist workers), is still by no means the sovereign ruler of
society."_ Ultimately, it was the case that the failure of the Spanish
Revolution confirmed for Trotsky the truism that the _"revolutionary
dictatorship of a proletarian party . . . is an objective necessity . . . The
revolutionary party (vanguard) which renounces **its own dictatorship**
surrenders the masses to the counter-revolution."_ Rather than seeing, as
anarchists do, workers' councils as being key, Trotsky considered the party,
in fact the _"dictatorship of a party"_ , as being the decisive factor. [our
emphasis, **Writings of Leon Trotsky 1936-37** , p. 514, p. 488 and pp. 513-4]
At best, such organs would be used to achieve party power and would simply be
a figleaf for its rule (see [section H.3.8](secH3.md#sech38)).

Clearly, the leading Marxist at the time was not arguing for the _"centrality
of the working class under the leadership of a political party."_ He was
arguing for the dictatorship of a "revolutionary" party **_over_** the working
class. Rather than the working class being "central" to the running of a
revolutionary regime, Trotsky saw the party taking that position. What sort of
_"victory"_ is possible when the party has dictatorial power over the working
class and the _"sovereign ruler"_ of society? Simply the kind of "victory"
that leads to Stalinism. Rather than seeing working class organisations as the
means by which working people run society, Leninists see them purely in
instrumental terms -- the means by which the party can seize power. As the
Russian Revolution proved beyond doubt, in a conflict between workers' power
and party power Leninists will suppress the former to ensure the latter.

To paraphrase Stack, the most important lesson from both the Russian and
Spanish revolutions is that whatever ideals and gut instincts individual
Leninists may have, Leninism, both in word and deed, fails to provide a
roadworthy vehicle for human liberation. Only Anarchism, which sees the
centrality of working class self-management of the class struggle and
revolution, is capable of ensuring the creation of a real, free, socialist
society.

Lastly, it could be argued that our critique of the standard Leninist attack
on Spanish anarchism is similar to that presented by Leninists to justify
Bolshevik authoritarianism during the Russian Revolution. After all, Leninists
like Stack point to the objective circumstances facing Lenin's regime -- its
isolation, civil war and economic problems -- as explaining its repressive
actions. Yet any similarity is superficial as the defeat of the Revolution in
Spain was due to anarchists **not** applying all of our ideas, while, in
Russia, it was due to the Bolsheviks **applying** their ideology. The
difficulties that faced the Russian Revolution pushed the Bolsheviks further
down the road they were already travelling down (not to mention that Bolshevik
ideology significantly contributed to making many of these problems worse). As
we discuss in [section H.6](secH6.md), the notion that "objective
circumstances" explains Bolshevik tyranny is simply unconvincing, particularly
given the role Bolshevik ideology played in this process.

So, to conclude, rather than show the failure of anarchism, the experience of
the Spanish Revolution indicates the failure of anarchists to apply their
ideas in practice. Faced with extremely difficult circumstances, they
compromised their ideas in the name of anti-fascist unity. Their compromises
**confirmed** rather than refuted anarchist theory as they led to the defeat
of both the revolution **and** the civil war.

## I.8.12 Was the decision to collaborate imposed on the CNT's membership?

A few words have to be said about the development of the CNT and FAI after the
19th of July, 1936. It is clear that both changed in nature and were the not
same organisations as they were **before** that date. Both organisations
became more centralised and bureaucratic, with the membership excluded from
many major decisions. As Peirats suggested:

> _"In the CNT and among militant anarchists there had been a tradition of the
> most scrupulous respect for the deliberations and decisions of the
> assemblies, the grassroots of the federalist organisation. Those who held
> administrative office had been merely the mandatories of those decisions.
> The regular motions adopted by the National congresses spelled out to the
> Confederation and its representative committees ineluctable obligations of a
> basic and general nature incumbent upon very affiliated member regardless of
> locality or region. And the forming of such general motions was the direct
> responsibility of all of the unions by means of motions adopted at their
> respective general assemblies. Similarly, the Regional or Local Congresses
> would establish the guidelines of requirement and problems that obtained
> only at regional or local levels. In both instances, sovereignty resided
> always with the assemblies of workers whether in their unions or in their
> groups._

> _"This sense of rigorous, everyday federalist procedure was abruptly amended
> from the very outset of the revolutionary phase. . . This amendment of the
> norms of the organisation was explained away by reference to the exceptional
> turn of events, which required a greater agility of decisions and
> resolutions, which is to say a necessary departure from the circuitous
> procedures of federalist practice which operated from the bottom upwards."_
> [ **The CNT in the Spanish Revolution** , vol. 1, p. 213]

In other words, the CNT had become increasingly hierarchical, with the higher
committees becoming transformed into executive bodies rather than
administrative ones as _"it is safe to assert that the significant resolutions
in the organisation were adopted by the committees, very rarely by the mass
constituency. Certainly, circumstances required quick decisions from the
organisation, and it was necessary to take precautions to prevent damaging
leaks. These necessities tempted the committees to abandon the federalist
procedures of the organisation."_ [Jose Peirats, **Anarchists in the Spanish
Revolution** , p. 188]

Ironically, rather than the _"anarchist leaders"_ of the CNT failing to
_"seize power"_ as Trotsky and his followers lament (see [last
section](secI8.md#seci811)), they did -- **in their own organisations.**
Such a development proved to be a disaster and re-enforced the anarchist
critique against hierarchical and centralised organisations. The CNT higher
committees became isolated from the membership, pursued their own policies and
compromised and paralysed the creative work being done by the rank and file --
as predicted in anarchist theory. However, be that as it may, as we will
indicate below, it would be false to assert that these higher committees
simply imposed the decision to collaborate on their memberships (as, for
example, Vernon Richards seems to imply in his **Lessons of the Spanish
Revolution** ). While it **is** true that the committees presented many
decisions as a **fait accompli,** the rank-and-file of the CNT and FAI did not
simply follow orders nor ratify all of the decisions blindly.

In any revolutionary situation decisions have to be made quickly and sometimes
without consulting the base of the organisation. However, such decisions must
be accountable to the membership who must discuss and ratify them (this was
the policy within the CNT militias, for example). The experience of the CNT
and FAI in countless strikes, insurrections and campaigns had proven the
decentralised, federal structure was more than capable of pursuing the class
war -- revolution is no exception as it is the class war in its most
concentrated form. In other words, the organisational principles of the CNT
and FAI were more than adequate for a revolutionary situation.

The centralising tendencies, therefore, cannot be blamed on the exceptional
circumstances of the war. Rather, it was the policy of collaboration which
explains them. Unlike the numerous strikes and revolts that occurred before
July 19th, 1936, the CNT higher committees had started to work within the
state structure. This, by its very nature, must generate hierarchical and
centralising tendencies as those involved must adapt to the states basic
structure and form. The violations of CNT policy flowed from the initial
decision to compromise in the name of _"anti-fascist unity"_ and a vicious
circle developed -- each compromise pushed the CNT leadership further into the
arms of the state, which increased hierarchical tendencies, which in turn
isolated these higher committees from the membership, which in turn encouraged
a conciliatory policy by those committees.

This centralising and hierarchical tendency did not mean that the higher
committees of the CNT simply imposed their will on the rest of the
organisation. It is very clear that the decision to collaborate had,
initially, the passive support of the majority of the CNT and FAI (probably
because they thought the war would be over after a few weeks or months). As
visiting French anarchist Sebastian Faure noted, while _"effective
participation in central authority has had the approval of the majority within
the unions and in the groups affiliated to the FAI, that decision has in many
places encountered the opposition of a fairly substantial minority. Thus there
has been no unanimity."_ [quoted by Jose Peirats, **The CNT in the Spanish
Revolution** , vol. 1, p. 183] In the words of Peirats:

> _"Were all of the militants of the same mind? . . . Excepting some vocal
> minorities which expressed their protests in their press organs and through
> committees, gatherings, plenums and assemblies, the dismal truth is that the
> bulk of the membership was in thrall to a certain fatalism which was itself
> a direct consequence of the tragic realities of the war."_ [ **Op. Cit.** ,
> p. 181]

And:

> _"We have already seen how, on the economic plane, militant anarchism forged
> ahead, undaunted, with its work of transforming the economy. It is not to be
> doubted -- for to do so would have been to display ignorance of the
> psychology of the libertarian rank and file of the CNT -- that a muffled
> contest, occasionally erupting at plenums and assemblies and manifest in
> some press organs broke out as soon as the backsliding began. In this
> connection, the body of opinion hostile to any possible deviation in tactics
> and principles was able to count throughout upon spirited champions."_ [
> **Op. Cit.** , p. 210]

Thus, within the libertarian movement, there was a substantial minority who
opposed the policy of collaboration and made their opinions known in various
publications and meetings. While many (if not most) revolutionary anarchists
volunteered for the militias and so were not active in their unions as before,
there were various groups (such as Catalan Libertarian Youth, the Friends of
Durruti, other FAI groups, and so on) which were opposed to collaboration and
argued their case openly in the streets, collectives, organisational meetings
and so on. Moreover, outside the libertarian movement the two tiny Trotskyist
groups also argued against collaboration, as did sections of the POUM.
Therefore it is impossible to state that the CNT membership were unaware of
the arguments against the dominant policy. Also the Catalan CNT's higher
committees, for example, after the May Days of 1937 could not get union
assemblies or plenums to expel the Friends of Durruti nor to get them to
withhold financial support for the Libertarian Youth, who opposed
collaboration vigorously in their publications, nor get them to call upon
various groups of workers to stop distributing opposition publications in the
public transit system or with the daily milk. [Abe Bluestein, _"Translator's
Note"_ , Juan Gomez Casas, **Anarchist Organisation: The History of the FAI**
, p. 10]

This suggests that in spite of centralising tendencies, the higher committees
of the CNT were still subject to some degree of popular influence and control
and should not be seen as having dictatorial powers over the organisation.
While many decisions **were** presented as **fait accompli** to the union
plenums (often called by the committees at short notice), in violation of past
CNT procedures, the plenums could not be railroaded into ratifying **any**
decision the committees wanted. The objective circumstances associated with
the war against Franco and fascism convinced most CNT members and libertarian
activists that working with other parties and unions within the state was the
only feasible option. Also to do otherwise, they thought, was to weaken the
war effort by provoking another Civil War in the anti-Franco camp. While such
a policy did not work (when it was strong enough the Republican state did
start a civil war against the CNT which gutted the struggle against fascism)
it cannot be argued that it was imposed upon the membership nor that they did
not hear opposing positions. Sadly, the call for anti-fascist unity dominated
the minds of the libertarian movement.

In the early stages, the majority of rank-and-file militants believed that the
war would be over in a matter of weeks. After all, a few days had been
sufficient to rout the army in Barcelona and other industrial centres. This
inclined them to, firstly, tolerate (indeed, support) the collaboration of the
CNT with the _"Central Committee of Anti-Fascist Militias"_ and, secondly, to
start expropriating capitalism in the belief that the revolution would soon be
back on track (the opportunity to start introducing anarchist ideas was simply
too good to waste, regardless of the wishes of the CNT leadership). They
believed that the revolution and libertarian communism, as debated and adopted
by the CNT's Zaragoza Congress of May that year, was an inseparable aspect of
the struggle against fascism and proceeded appropriately. The ignoring of the
state, rather than its destruction, was seen as a short-term compromise, soon
to be corrected. Sadly, they were wrong -- collaboration had a logic all its
own, one which got worse as the war dragged on (and soon it was too late).

Which, we must note indicates the superficial nature of most Marxist attacks
on anarchism using the CNT as the key evidence. After all, it was the
anarchists and anarchist influenced members of the CNT who organised the
collectives, militias and started the transformation of Spanish society. They
did so inspired by anarchism and in an anarchist way. To praise their actions,
while attacking "anarchism", shows a lack of logic. Indeed, these actions have
more in common with anarchist ideas than the actions and rationales of the CNT
leadership. Thus, to attack "anarchism" by pointing to the anti-anarchist
actions of a few leaders while ignoring the anarchist actions of the majority
is flawed.

Therefore, to summarise, it is clear that while the internal structure of the
CNT was undermined and authoritarian tendencies increased by its collaboration
with the state, the CNT was not transformed into a mere appendage to the
higher committees of the organisation. The union plenums could and did reject
the calls made by the leadership of the CNT. Support for "anti-fascist unity"
was widespread among the CNT membership (in spite of the activities and
arguments of large minority of anarchists) and was reflected in the policy of
collaboration pursued by the organisation. While the CNT higher committees
were transformed into a bureaucratic leadership, increasingly isolated from
the rank and file, it cannot be argued that their power was absolute nor
totally at odds with the wishes of the membership. Ironically, but
unsurprisingly, the divergences from the CNT's previous libertarian
organisational principles confirmed anarchist theory, becoming a drag on the
revolution and a factor in its defeat.

As we argued in [section I.8.11](secI8.md#seci811), the initial compromise
with the state, the initial betrayal of anarchist theory and CNT policy,
contained all the rest. Moreover, rather than refute anarchism, the experience
of the CNT after it had rejected anarchist theory confirmed it -- centralised,
hierarchical organisations hindered and ultimately destroyed the revolution.
The experience of the CNT and FAI suggests that those, like Leninists, who
argue for **more** centralisation and for "democratic" hierarchical structures
have refused to understand, let alone learn from, history. The increased
centralisation within the CNT aided and empowered the leadership (a minority)
and disempowered the membership (the majority). Rather than federalism
hindering the revolution, it, as always, was centralism which did so.

Therefore, in spite of a sizeable minority of anarchists **within** the CNT
and FAI arguing against the dominant policy of "anti-fascist unity" and
political collaboration, this policy was basically agreed to by the CNT
membership and was not imposed upon them. The membership of the CNT could, and
did, reject suggestions of the leadership and so, in spite of the
centralisation of power that occurred in the CNT due to the policy of
collaboration, it cannot be argued that this policy was alien to the wishes of
the rank-and-file however lamentable the results of that position were.

## I.8.13 What political lessons were learned from the revolution?

The most important political lesson learned from the Spanish Revolution is
that a revolution cannot compromise with existing power structures. In this,
it just confirmed anarchist theory and the basic libertarian position that a
social revolution will only succeed if it follows an anarchist path and does
not seek to compromise in the name of fighting a "greater evil." As Kropotkin
put it, a _"revolution that stops half-way is sure to be soon defeated."_ [
**The Great French Revolution** , vol. 2, p. 553]

On the 20th of July, after the fascist coup had been defeated in Barcelona,
the CNT sent a delegation of its members to meet the leader of the Catalan
Government. A plenum of CNT union shop stewards, in the light of the fascist
coup, agreed that libertarian communism would be postponed until Franco had
been defeated (the rank and file ignored them and collectivised their
workplaces). They organised a delegation to visit the Catalan president to
discuss the situation:

> _"The delegation . . . was intransigent . . . Either Companys [the Catalan
> president] must accept the creation of a Central Committee [of Anti-Fascist
> Militias] as the ruling organisation or the CNT would **consult the rank and
> file and expose the real situation to the workers.** Companys backed down."_
> [our emphasis, Abel Paz, **Durruti: The People Armed** , p. 216]

The CNT committee members used their new-found influence in the eyes of Spain
to unite with the leaders of other organisations/parties but not the rank and
file. This process lead to the creation of the **Central Committee of Anti-
Fascist Militias** , in which political parties as well as labour unions were
represented. This committee was not made up of mandated delegates from
workplaces, communities or barricades, but of representatives of existing
organisations, nominated by committees. Instead of a genuine confederal body
(made up of mandated delegates from workplace, militia and neighbourhood
assemblies) the CNT created a body which was not accountable to, nor could
reflect the ideas of, working class people expressed in their assemblies. The
state and government was not abolished by self-management, only ignored. This
was a mistake and many soon came _"to realise that once they went into the so-
called united-front, they could do nothing else but go further. In other
words, the one mistake, the one wrong step inevitably led to others as it
always does. I am more than ever convinced that if the comrades had remained
firm on their own grounds they would have remained stronger than they are now.
But I repeat, once they had made common cause for the period of the anti-
Fascist war, they were driven by the logic of events to go further."_ [Emma
Goldman, **Vision on Fire** , pp. 100-1]

The most obvious problem, of course, was that collaboration with the state
ensured that a federation of workers' associations could not be created to co-
ordinate the struggle against fascism and the social revolution. As Stuart
Christie argues: _"By imposing their leadership from above, these partisan
committees suffocated the mushrooming popular autonomous revolutionary centres
-- the grass-roots factory and local revolutionary committees -- and prevented
them from proving themselves as an efficient and viable means of co-ordinating
communications, defence and provisioning. They also prevented the Local
Revolutionary committees from integrating with each other to form a regional,
provincial and national federal network which would facilitate the
revolutionary task of social and economic reconstruction."_ [ **We, the
Anarchists!** , pp. 99-100] Without such a federation, it was only a matter of
time before the CNT joined the bourgeois government.

Rather than being _"a regime of **dual power** "_ and the _"most important"_
of the _"new organs of power"_ as many Trotskyists, following Felix Morrow,
maintain, the **Central Committee of Anti-Fascist Militias** created on July
20th, 1936, was, in fact, an organ of class collaboration and a handicap to
the revolution. [ **Revolution and Counter-Revolution in Spain** , p. 85 and
p. 83] Stuart Christie was correct to call it an _"artificial and hybrid
creation,"_ a _"compromise, an artificial political solution, an officially
sanctioned appendage of the Generalidad government"_ which _"drew the CNT-FAI
leadership inexorably into the State apparatus, until then its principal
enemy."_ [ **Op. Cit.** , p. 105] Only a true federation of delegates from the
fields, factories and workplaces could have been the framework of a true
organisation of (to use Bakunin's expression) _"the social (and, by
consequence, anti-political) power of the working masses."_ [ **Michael
Bakunin: Selected Writings** , pp. 197-8]

Therefore, the CNT forgot a basic principle of anarchism, namely _"the
destruction . . . of the States."_ Instead, like the Paris Commune, the CNT
thought that _"in order to combat . . . reaction, they had to organise
themselves in reactionary Jacobin fashion, forgetting or sacrificing what they
themselves knew were the first conditions of revolutionary socialism."_ The
real basis of the revolution, the basic principle of anarchism, was that the
_"future social organisation must be made solely from the bottom upwards, by
the free association or federation of workers, firstly in their unions, then
in communes, regions, nations and finally in a great federation, international
and universal."_ [Bakunin, **Op. Cit.** , p. 198, p. 202 and p. 204] By not
doing this, by working in a top-down compromise body rather than creating a
federation of workers' councils, the CNT leadership could not help eventually
sacrificing the revolution in favour of the war.

Of course, if a full plenum of CNT unions and **barrios** defence committees,
with delegates invited from UGT and unorganised workplaces, had taken place
there is no guarantee that the decision reached would have been in line with
anarchist theory. The feelings for antifascist unity were strong. However, the
decision would have been fully discussed by the rank and file of the union,
under the influence of the revolutionary anarchists who were later to join the
militias and leave for the front. It is likely, given the wave of
collectivisation and what happened in Aragón, that the decision would have
been different and the first step would have made to turn this plenum into the
basis of a free federation of workers associations -- i.e. the framework of a
self-managed society -- which could have smashed the state and ensured no
other appeared to take its place.

So the basic idea of anarchism, the need to create a federation of workers
councils, was ignored. In the name of "antifascist" unity, the CNT worked with
parties and classes which hated both them and the revolution. In the words of
Sam Dolgoff _"both before and after July 19th, an unwavering determination to
crush the revolutionary movement was the leitmotif behind the policies of the
Republican government; irrespective of the party in power."_ [ **The Anarchist
Collectives** , p. 40] Without creating a means to organise the _"social
power"_ of the working class, the CNT was defenceless against these parties
once the state had re-organised itself.

To justify their collaboration, the leaders of the CNT-FAI argued that not to
do so would have lead to a civil war within the civil war, so allowing Franco
easy victory. In practice, while paying lip service to the revolution, the
Communists and republicans attacked the collectives, murdered anarchists,
restricted supplies to collectivised industries (even **war** industries) and
disbanded the anarchist militias after refusing to give them weapons and
ammunition (preferring to arm the Civil Guard in the rearguard in order to
crush the CNT and the revolution). By collaborating, a civil war was not
avoided. One occurred anyway, with the working class as its victims, as soon
as the state felt strong enough.

Garcia Oliver (the first ever, and hopefully last, "anarchist" minister of
justice) stated in 1937 that collaboration was necessary and that the CNT had
_"renounc[ed] revolutionary totalitarianism, which would lead to the
strangulation of the revolution by anarchist and Confederal [CNT]
dictatorship. We had confidence in the word and in the person of a Catalan
democrat"_ Companys (who had in the past jailed anarchists). [quoted by Vernon
Richards, **Lessons of the Spanish Revolution** , p. 34] Which means that only
by working with the state, politicians and capitalists can an anarchist
revolution be truly libertarian! Furthermore:

> _"This argument contains . . . two fundamental mistakes, which many of the
> leaders of the CNT-FAI have since recognised, but for which there can be no
> excuse, since they were not mistakes of judgement but the deliberate
> abandonment of the principles of the CNT. Firstly, that an armed struggle
> against fascism or any other form of reaction could be waged more
> successfully within the framework of the State and subordinating all else,
> including the transformation of the economic and social structure of the
> country, to winning the war. Secondly, that it was essential, and possible,
> to collaborate with political parties -- that is politicians -- honestly and
> sincerely, and at a time when power was in the hands of the two workers
> organisations . . ._

> _"All the initiative . . . was in the hands of the workers. The politicians
> were like generals without armies floundering in a desert of futility.
> Collaboration with them could not, by any stretch of the imagination,
> strengthen resistance to Franco. On the contrary, it was clear that
> collaboration with political parties meant the recreation of governmental
> institutions and the transferring of initiative from the armed workers to a
> central body with executive powers. By removing the initiative from the
> workers, the responsibility for the conduct of the struggle and its
> objectives were also transferred to a governing hierarchy, and this could
> not have other than an adverse effect on the morale of the revolutionary
> fighters."_ [Richards, **Op. Cit.** , p. 42]

The dilemma of _"anarchist dictatorship"_ or _"collaboration"_ raised in 1937
was fundamentally wrong. It was never a case of banning parties, and other
organisations under an anarchist system, far from it. Full rights of free
speech, organisation and so on should have existed for all but the parties
would only have as much influence as they exerted in union, workplace,
community and militia assemblies, as should be the case! "Collaboration" yes,
but within the rank and file and within organisations organised in an
anarchist manner. Anarchism does not respect the "freedom" to be a boss or
politician. In his history of the FAI, Juan Gomaz Casas (an active FAI member
in 1936) made this clear:

> _"How else could libertarian communism be brought about? It would always
> signify dissolution of the old parties dedicated to the idea of power, or at
> least make it impossible for them to pursue their politics aimed at seizure
> of power. There will always be pockets of opposition to new experiences and
> therefore resistance to joining 'the spontaneity of the unanimous masses.'
> In addition, the masses would have complete freedom of expression in the
> unions and in the economic organisations of the revolution as well as their
> political organisations in the district and communities."_ [ **Anarchist
> Organisation: the History of the FAI** , p. 188f]

Instead of this "collaboration" from the bottom up, by means of a federation
of workers' associations, community assemblies and militia columns as argued
for by anarchists from Bakunin onwards, the CNT and FAI committees favoured
"collaboration" from the top down. The leaders ignored the state and co-
operated with other trade unions officials as well as political parties in the
**Central Committee of Anti-Fascist Militias**. In other words, they ignored
their political ideas in favour of a united front against what they considered
the greater evil, namely fascism. This inevitably lead the way to counter-
revolution, the destruction of the militias and collectives, as they was no
means by which these groups could co-ordinate their activities independently
of the state. The continued existence of the state ensured that economic
confederalism between collectives (i.e. extending the revolution under the
direction of the syndicates) could not develop naturally nor be developed far
enough in all places. Due to the political compromises of the CNT the
tendencies to co-ordination and mutual aid could not develop freely (see [next
section](secI8.md#seci814)).

It is clear that the defeat in Spain was due to a failure not of anarchist
theory and tactics but a failure of anarchists to **apply** their theory and
tactics. Instead of destroying the state, the CNT-FAI ignored it. For a
revolution to be successful it needs to create organisations which can
effectively replace the state and the market; that is, to create a widespread
libertarian organisation for social and economic decision-making through which
working class people can start to set their own agendas. Only by going down
this route can the state and capitalism be effectively smashed.

In building the new world we must destroy the old one. Revolutions may be, as
Engels suggested, "authoritarian" by their very nature, but only in respect to
institutions, structures and social relations which promote injustice,
hierarchy and inequality. As discussed in [section H.7.4](secH4.md#sech47),
it is not "authoritarian" to destroy authority and not tyrannical to dethrone
tyrants! Revolutions, above all else, must be libertarian in respect to the
oppressed. That is, they must develop structures that involve the great
majority of the population, who have previously been excluded from decision-
making on social and economic issues. In fact, a revolution is the most
**libertarian** thing ever.

As the **Friends of Durruti** argued a _"revolution requires the absolute
domination of the workers' organisations."_ [ _"The Friends of Durruti
accuse"_ , **Class War on the Home Front** , Wildcat Group (ed.), p. 34] Only
this, the creation of viable anarchist social organisations, can ensure that
the state and capitalism can be destroyed and replaced with a just system
based on liberty, equality and solidarity. Just as Bakunin, Kropotkin and a
host of other anarchist thinkers had argued decades previously (see [section
H.1.4](secH1.md#sech14)). Thus the most important lesson gained from the
Spanish Revolution is simply the correctness of anarchist theory on the need
to organise the social and economic power of the working class by a free
federation of workers associations to destroy the state. Without this, no
revolution can be lasting. As Gomez Casas correctly argued, _"if instead of
condemning that experience [of collaboration], the movement continues to look
for excuses for it, the same course will be repeated in the future . . .
exceptional circumstances will again put . . . anarchism on [its] knees before
the State."_ [ **Op. Cit.** , p. 251]

The second important lesson is on the nature of anti-fascism. The CNT
leadership, along with many (if not most) of the rank-and-file, were totally
blinded by the question of anti-fascist unity, leading them to support a
"democratic" state against a "fascist" one. While the basis of a new world was
being created around them by the working class, inspiring the fight against
fascism, the CNT leaders collaborated with the system that spawns fascism.
While the anti-fascist feelings of the CNT leadership were sincere, the same
cannot be said of their "allies" (who seemed happier attacking the gains of
the semi-revolution than fighting fascism). As the Friends of Durruti make
clear: _"Democracy defeated the Spanish people, not Fascism."_ [ **Op. Cit.**
, p. 30] To be opposed to fascism is not enough, you also have to be anti-
capitalist. As Durruti stressed, _"[n]o government in the world fights fascism
to the death. When the bourgeoisie sees power slipping from its grasp, it has
recourse to fascism to maintain itself."_ [quoted by Vernon Richards, **Op.
Cit.** , p. 193f] In Spain, anti-fascism destroyed the revolution, not
fascism. As the Scottish Anarchist Ethel McDonald argued at the time:
_"Fascism is not something new, some new force of evil opposed to society, but
is only the old enemy, Capitalism, under a new and fearful sounding name . . .
Anti-Fascism is the new slogan by which the working class is being betrayed."_
[ **Workers Free Press** , October 1937]

Thirdly, the argument of the CNT that Libertarian Communism had to wait until
after the war was a false one. Fascism can only be defeated by ending the
system that spawned it (i.e. capitalism). In addition, in terms of morale and
inspiration, the struggle against fascism could only be effective if it were
also a struggle **for** something better -- namely a free society. To fight
fascism for a capitalist democracy which had repressed the working class would
hardly inspire those at the front. Similarly, the only hope for workers' self-
management was to push the revolution as far as possible, i.e. to introduce
libertarian communism while fighting fascism. The idea of waiting for
libertarian communism ultimately meant sacrificing it for the war effort. This
would, by necessity, mean the end of the revolutionary spirit and hope which
could inspire and sustain the war effort. Why would people fight for a return
to the status quo? A status quo that they had rebelled against before the
start of the civil war and which had provoked the fascist coup in the first
place.

Fourthly, the role of anarchists in a social revolution is to always encourage
organisation _"from below"_ (to use one of Bakunin's favourite expressions),
revolutionary organisations which can effectively smash the state. Bakunin
himself argued (see [section I.8.11](secI8.md#seci811)) in favour of
workers' councils, complemented by community assemblies (the federation of the
barricades) and a self-managed militia. This model is still applicable today
and was successfully applied in Aragón by the CNT.

Therefore, the political lessons gained from the experience of the CNT come as
no surprise. They simply repeat long standing positions within anarchist
theory. As anarchists have argued since Bakunin, no revolution is possible
unless the state is smashed, capital expropriated and a free federation of
workers' associations created as the framework of libertarian socialism.
Rather than refuting anarchism, the experience of the Spanish Revolution
confirms it.

## I.8.14 What economic lessons were learned from the revolution?

The most important economic lesson from the revolution is the fact that
working class people took over the management of industry and did an amazing
job of keeping (and improving!) production in the face of the direst
circumstances (a factor often overlooked by the opponents of anarchism and the
revolution). Not only did workers create a war industry from almost nothing in
Catalonia, they also improved working conditions and innovated with new
techniques and processes. The Spanish Revolution shows that self-management is
possible and that the constructive powers of people inspired by an ideal can
transform society.

Self-management allowed a massive increase in innovation and new ideas. The
Spanish Revolution is clear proof of the anarchist case against hierarchy and
validates Isaac Puente's words that in _"a free collective each benefits from
accumulated knowledge and specialised experiences of all, and vice versa.
There is a reciprocal relationship wherein information is in continuous
circulation."_ [ **The Anarchist Collectives** , p. 32] The workers, freed
from economic autocracy, started to transform their workplaces and how they
produced goods.

From the point of view of individual freedom, it is clear that self-management
allowed previously marginalised people to take an active part in the decisions
that affected them. Egalitarian organisations provided the framework for a
massive increase in participation and individual self-government, which
expressed itself in the extensive innovations carried out by the Collectives.
The Collectives indicate, in Stirner's words, that _"[o]nly in the union can
you assert yourself as unique, because the union does not possess you, but you
possess it or make it of use to you."_ [ **The Ego and Its Own** , p. 312] A
fact Emma Goldman confirmed from her visits to collectives and discussions
with their members:

> _"I was especially impressed with the replies to my questions as to what
> actually had the workers gained by the collectivisation . . . the answer
> always was, first, greater freedom. And only secondly, more wages and less
> time of work. In two years in Russia [1920-21] I never heard any workers
> express this idea of greater freedom."_ [ **Vision on Fire** , p. 62]

As predicted in anarchist theory, and borne out by actual experience, there
exists large untapped reserves of energy and initiative in the ordinary person
which self-management can call forth. The collectives proved Kropotkin's
argument that co-operative work is more productive and that if the economists
wish to prove _"their thesis in favour of **private property** against all
other forms of **possession** , should not the economists demonstrate that
under the form of communal property land never produces such rich harvests as
when the possession is private. But this they could not prove; in fact, it is
the contrary that has been observed."_ [ **The Conquest of Bread** , p. 146]

Beyond this five important lessons can be derived from the actual experience
of a libertarian socialist economy:

Firstly, that an anarchist society cannot be created overnight, but is a
product of many different influences as well as the objective conditions. In
this the anarchist collectives confirmed the ideas of anarchist thinkers like
Bakunin and Kropotkin (see [section I.2.2](secI2.md#seci22)). The
collectives although, as mentioned in [section I.8.3](secI8.md#seci83),
based on key libertarian principles they were a somewhat unexpected
development. They reflected objective circumstances facing the revolution as
well as libertarian theory and, with regards the latter, were somewhat
limited. However, they were organisations created from below by the revolution
and so capable of development and progress.

The lesson from every revolution is that the mistakes made in the process of
liberation by people themselves are always minor compared to the results of a
self-proclaimed vanguard creating institutions **for** people. The Spanish
Revolution is a clear example of this, with the Catalan state's
_"collectivisation decree"_ causing more harm than good (as intended, it
controlled and so limited the economic transformation of the economy).
Luckily, the Spanish anarchists recognised the importance of having the
freedom to make mistakes, as can be seen by the many different forms of
collectives and federations tried. The actual process in Spain towards
industrial co-ordination and so socialisation was dependent on the wishes of
the workers involved -- as would be expected in a true social revolution. As
Bakunin argued, the _"revolution should not only be made for the people's
sake; it should also be made by the people."_ [ **No Gods, No Masters** , vol.
1, p. 141] The problems faced by a social revolution will be solved in the
interests of the working class only if working class people solve them
themselves. For this to happen it requires working class people to manage
their own affairs directly -- and this implies anarchism, not centralisation
or state control/ownership. The experience of the collectives in Spain
supports this.

Secondly, the importance of decentralisation of management. As discussed in
[section I.8.4](secI8.md#seci84), different areas and industries tried
different forms of federation. The woodworkers' union experience indicates
that a collectivised industry can became centralised, with even a
democratically elected administration leading to rank-and-file workers
becoming marginalised which could soon result in apathy developing within it.
This was predicted by Kropotkin and other anarchist theorists (and by many
anarchists in Spain at the time). While undoubtedly better than capitalist
hierarchy, such democratically run industries are only close approximations to
anarchist ideas of self-management. Importantly, however, the collectivisation
experiments also indicate that co-operation need not imply centralisation (as
can be seen from the Badelona collectives).

Thirdly, the importance of building links of solidarity between workplaces as
soon as possible. While the importance of starting production after the
fascist uprising made attempts at co-ordination seem of secondary importance
to the collectives, the competition that initially occurred between workplaces
helped the state to undermine self-management (for example, the state _"was
actively using its control of finances to contain and stifle radical change"_
[Graham Kelsey, **Anarchosyndicalism, Libertarian Communism and the State** ,
p. 172]). As there was no People's Bank or federal body to co-ordinate credit
and production, state control of credit and the gold reserves made it easier
for the Republican state to undermine the revolution by controlling the
collectives and (effectively) nationalising them in time (Durruti and a few
others planned to seize the gold reserves but were advised not to by Abad de
Santillán).

This attack on the revolution started when the Catalan State issued a decree
legalising (and so controlling) the collectives in October 1936 (the infamous
_"Collectivisation Decree"_ ). The counter-revolution also withheld funds for
collectivised industries, even war industries, until they agreed to come under
state control. The industrial organisation created by this decree was a
compromise between anarchist ideas and those of other parties (particularly
the communists) and in the words of Gaston Leval, _"the decree had the baneful
effect of preventing the workers' syndicates from extending their gains. It
set back the revolution in industry."_ [ **The Anarchist Collectives** , p.
54]

And lastly, that an economic revolution can only succeed if the existing state
is destroyed. As Kropotkin argued, _"a new form of economic organisation will
necessarily require a new form of political structure."_ [ **Anarchism** , p.
181] Capitalism needs the state, socialism needs anarchy. Without the new
political structure, the new economic organisation cannot develop to its full
potential. Due to the failure to consolidate the revolution **politically** ,
it was lost **economically**. The decree _"legalising"_ collectivisation
_"distorted everything right from the start."_ [Leval, **Collectives in the
Spanish Revolution** , p. 227] This helped undermine the revolution by
ensuring that the mutualism of the collectives did not develop freely into
libertarian communism ( _"The collectives lost the economic freedom they had
won at the beginning"_ due to the decree, as one participant put it).
Collectives, of course, tried to ignore the state. As an eyewitness pointed
out, the CNT's _"policy was thus not the same as that pursued by the decree."_
[quoted by Ronald Fraser, **Blood of Spain** , p. 230 and p. 213] Indeed,
leading anarchists like Abad de Santillán opposed it:

> _"I was an enemy of the decree because I considered it premature . . . when
> I became councillor, I had no intention of taking into account or carrying
> out the decree: I intended to allow our great people to carry on the task as
> they best saw fit, according to their own inspiration."_ [quoted by Fraser,
> **Op. Cit.** , p. 212fn]

However, with the revolution lost politically, the CNT was soon forced to
compromise and support the decree (the CNT did propose more libertarian forms
of co-ordination between workplaces but these were undermined by the state). A
lack of effective mutual aid organisations allowed the state to gain power
over the collectives and so undermine and destroy self-management. Working
class control over the economy (important as it is) does not automatically
destroy the state. In other words, the economic aspects of the revolution
cannot be considered in isolation from its political ones.

Yet these points do not diminish the successes of the Spanish revolution. As
Gaston Leval argued, _"in spite of these shortcomings"_ caused by lack of
complete socialisation _"the important fact is that the factories went on
working, the workshops and works produced without the owners, capitalists,
shareholders and without high management executives."_ [ **Collectives in the
Spanish Revolution** , p. 228] Beyond doubt, these months of economic liberty
in Spain show not only that libertarian socialism **works** and that working
class people can manage and run society but also that we can improve the
quality of life and increase freedom. Given the time and breathing space, the
experiment would undoubtedly have ironed out its problems. Even in the very
difficult environment of a civil war (and with resistance of almost all other
parties and unions) the workers and peasants of Spain showed that a better
society is possible. They gave a concrete example of what was previously just
a vision, a world which was more humane, more free, more equitable and more
civilised than that run by capitalists, managers, politicians and bureaucrats.

[‹ I.7 Won't Libertarian Socialism destroy individuality?](secI7.md "Go to
previous page") [up](secIcon.md "Go to parent page") [Section J - What do
anarchists do? ›](secJcon.md "Go to next page")

