use Argus;

package Argus::Watcher;   # config vars for particular scripts

use vars qw (%Busy_Machines $Period $ReReport $RA_Filter $Testing
             $Local_Interest_Threshold $Remote_Interest_Threshold
             $Packet_Save $Sources);


#Default reporting threshold etc. These control the resource usage
# (memory) and sensitivity of the detector. Raising $Period and
# $Sources will make the program more sensitive but use more memory

$Period =  900;  ## seconds -- reporting period

# keep info for this number of source IPs at most.

$Sources = 10000;

$ReReport = 3600;  ## seconds - wait this long before sending more 
                   #            reports of continuing activity

# report when machine talks to more than this many port/addresses 
# during $Period seconds

$Local_Interest_Threshold =  100;
$Remote_Interest_Threshold =  40;

$Packet_Save = 20;      ## Only save this many sample flows

# File where you can specify rate thresholds for noisy system
# format is:
#    ip   rate 'per' second|minute|hour|day
#eg
#    130.216.1.1   2 per sec    # net.auckland
#    130.216.1.1   2
# above lines are equivalent 
# "#" is a comment  i.e. the above lines would be ignored in real file
#
#  Watcher checks the file before reporting any scans to see if it
#  has changed and rereads it if necessary.

$RateFile = '/home/argus/config/watcher_rates';

$RA_Filter = "ip and not \\( arp or " .
       "\\( src net $Argus::Local_IP and dst net $Argus::Local_IP \\) \\)";

1;
