! This file is part of the 'atomes' software.
!
! 'atomes' is free software: you can redistribute it and/or modify it under the terms
! of the GNU Affero General Public License as published by the Free Software Foundation,
! either version 3 of the License, or (at your option) any later version.
!
! 'atomes' is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
! without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
! See the GNU General Public License for more details.
!
! You should have received a copy of the GNU Affero General Public License along with 'atomes'.
! If not, see <https://www.gnu.org/licenses/>
!
! Copyright (C) 2022-2025 by CNRS and University of Strasbourg
!
!>
!! @file mendeleiev.F90
!! @short Periodic table and diffraction data
!! @author Sébastien Le Roux <sebastien.leroux@ipcms.unistra.fr>

MODULE MENDELEIEV

INTEGER :: MAXE=118

CHARACTER (LEN=2), DIMENSION(118), PARAMETER :: ATSYM=(/ &
  'H ', 'He', 'Li', 'Be', 'B ', 'C ', 'N ', 'O ', 'F ',  &
  'Ne', 'Na', 'Mg', 'Al', 'Si', 'P ', 'S ', 'Cl', 'Ar',  &
  'K ', 'Ca', 'Sc', 'Ti', 'V ', 'Cr', 'Mn', 'Fe', 'Co',  &
  'Ni', 'Cu', 'Zn', 'Ga', 'Ge', 'As', 'Se', 'Br', 'Kr',  &
  'Rb', 'Sr', 'Y ', 'Zr', 'Nb', 'Mo', 'Tc', 'Ru', 'Rh',  &
  'Pd', 'Ag', 'Cd', 'In', 'Sn', 'Sb', 'Te', 'I ', 'Xe',  &
  'Cs', 'Ba', 'La', 'Ce', 'Pr', 'Nd', 'Pm', 'Sm', 'Eu',  &
  'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm', 'Yb', 'Lu', 'Hf',  &
  'Ta', 'W ', 'Re', 'Os', 'Ir', 'Pt', 'Au', 'Hg', 'Tl',  &
  'Pb', 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac', 'Th',  &
  'Pa', 'U ', 'Np', 'Pu', 'Am', 'Cm', 'Bk', 'Cf', 'Es',  &
  'Fm', 'Md', 'No', 'Lr', 'Rf', 'Db', 'Sg', 'Bh', 'Hs',  &
  'Mt', 'Ds', 'Rg', 'Cn', 'Nh', 'Fl', 'Mc', 'Lv', 'Ts', 'Og' /)

CHARACTER (LEN=14), DIMENSION(118), PARAMETER :: ELEMENT=(/ &
  'Hydrogen      ', 'Helium        ', 'Lithium       ', 'Beryllium     ', &
  'Boron         ', 'Carbon        ', 'Nitrogen      ', 'Oxygen        ', &
  'Fluorine      ', 'Neon          ', 'Sodium        ', 'Magnesium     ', &
  'Aluminum      ', 'Silicon       ', 'Phosphorus    ', 'Sulfur        ', &
  'Chlorine      ', 'Argon         ', 'Potassium     ', 'Calcium       ', &
  'Scandium      ', 'Titanium      ', 'Vanadium      ', 'Chromium      ', &
  'Manganese     ', 'Iron          ', 'Cobalt        ', 'Nickel        ', &
  'Copper        ', 'Zinc          ', 'Gallium       ', 'Germanium     ', &
  'Arsenic       ', 'Selenium      ', 'Bromine       ', 'Krypton       ', &
  'Rubidium      ', 'Strontium     ', 'Yttrium       ', 'Zirconium     ', &
  'Niobium       ', 'Molybdenum    ', 'Technetium    ', 'Ruthenium     ', &
  'Rhodium       ', 'Palladium     ', 'Silver        ', 'Cadmium       ', &
  'Indium        ', 'Tin           ', 'Antimony      ', 'Tellurium     ', &
  'Iodine        ', 'Xenon         ', 'Caesium       ', 'Barium        ', &
  'Lanthanum     ', 'Cerium        ', 'Praseodymium  ', 'Neodymium     ', &
  'Promethium    ', 'Samarium      ', 'Europium      ', 'Gadolinium    ', &
  'Terbium       ', 'Dysprosium    ', 'Holmium       ', 'Erbium        ', &
  'Thulium       ', 'Ytterbium     ', 'Lutetium      ', 'Hafnium       ', &
  'Tantalum      ', 'Tungsten      ', 'Rhenium       ', 'Osmium        ', &
  'Iridium       ', 'Platinum      ', 'Gold          ', 'Mercury       ', &
  'Thallium      ', 'Lead          ', 'Bismuth       ', 'Polonium      ', &
  'Astatine      ', 'Radon         ', 'Francium      ', 'Radium        ', &
  'Actinium      ', 'Thorium       ', 'Protactinium  ', 'Uranium       ', &
  'Neptunium     ', 'Plutonium     ', 'Americium     ', 'Curium        ', &
  'Berkelium     ', 'Californium   ', 'Einsteinium   ', 'Fermium       ', &
  'Mendelevium   ', 'Nobelium      ', 'Lawrencium    ', 'Rutherfordium ', &
  'Dubnium       ', 'Seaborgium    ', 'Bohrium       ', 'Hassium       ', &
  'Meitnerium    ', 'Darmstadtium  ', 'Roentgenium   ', 'Copernicium   ', &
  'Nihonium      ', 'Flerovium     ', 'Moscovium     ', 'Livermorium   ', &
  'Tennessine    ', 'Oganesson     ' /)

DOUBLE PRECISION, DIMENSION(118), PARAMETER :: AMASS=(/ &
  1.008, 4.003, 6.94, 9.012, 10.81, 12.011, 14.007, 15.99, &
  18.998, 20.18, 22.99, 24.305, 26.982, 28.085, 30.974, &
  32.06, 35.45, 39.948, 39.098, 40.078, 44.956, 47.867, &
  50.942, 51.996, 54.938, 55.845, 58.933, 58.693, 63.546, &
  65.38, 69.723, 72.63, 74.922, 78.971, 79.904, 83.798, &
  85.468, 87.62, 88.906, 91.224, 92.906, 95.95, 98.00, &
  101.07, 102.906, 106.42, 107.868, 112.414, 114.818, &
  118.71, 121.76, 127.60, 126.904, 131.293, 132.905, &
  137.327, 138.905, 140.116, 140.908, 144.242, 145.00, &
  150.36, 151.964, 157.25, 158.925, 162.50, 164.93, &
  167.259, 168.934, 173.045, 174.967, 178.49, 180.948, &
  183.84, 186.207, 190.23, 192.217, 195.084, 196.967, &
  200.592, 204.38, 207.20, 208.98, 209.00, 210.00, &
  222.00, 223.00, 226.00, 227.00, 232.038, 231.036, &
  238.029, 237.00, 244.00, 243.00, 247.00, 247.00, &
  251.00, 252.00, 257.00, 258.00, 258.00, 262.00, 267.00, &
  268.00, 269.00, 270.00, 271.00, 278.00, 281.00, 282.00, &
  285.00, 286.00, 289.00, 289.00, 293.00, 294.00, 294.00 /)

! Source: Beatriz Cordero and al.
! in "Covalent radii revisited",
! Dalton Trans., 2008, [DOI: 10.1039/b801115j].
DOUBLE PRECISION, DIMENSION(118), PARAMETER :: ARCOV=(/ &
  0.31, 0.28, 1.28, 0.96, 0.84, 0.76, 0.71, 0.66, 0.57, &
  0.58, 1.66, 1.41, 1.21, 1.11, 1.07, 1.05, 1.02, 1.06, &
  2.03, 1.76, 1.70, 1.60, 1.53, 1.39, 1.39, 1.32, 1.26, &
  1.24, 1.32, 1.22, 1.22, 1.20, 1.19, 1.20, 1.20, 1.16, &
  2.20, 1.95, 1.90, 1.75, 1.64, 1.54, 1.47, 1.46, 1.42, &
  1.39, 1.45, 1.44, 1.42, 1.39, 1.39, 1.38, 1.39, 1.40, &
  2.44, 2.15, 2.07, 2.04, 2.03, 2.01, 1.99, 1.98, 1.98, &
  1.96, 1.94, 1.92, 1.92, 1.89, 1.90, 1.87, 1.87, 1.75, &
  1.70, 1.62, 1.51, 1.44, 1.41, 1.36, 1.36, 1.32, 1.45, &
  1.46, 1.48, 1.40, 1.50, 1.50, 2.60, 2.21, 2.15, 2.06, &
  2.00, 1.96, 1.90, 1.87, 1.80, 1.69, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00 /)

! Source: Slater, Journal of Chemical Physics, 41, 3199 (1964).
DOUBLE PRECISION, DIMENSION(118), PARAMETER :: ARION=(/ &
  -0.24, 0.000, 0.900, 0.590, 0.250, 0.300, 1.320, 1.260, &
  1.190, 0.000, 1.160, 0.860, 0.675, 0.400, 0.310, 1.700, &
  1.670, 0.000, 1.520, 1.140, 0.885, 0.745, 0.680, 0.755, &
  0.670, 0.690, 0.790, 0.830, 0.870, 0.880, 0.760, 0.670, &
  0.720, 1.840, 1.820, 0.000, 1.660, 1.320, 1.040, 0.860, &
  0.780, 0.730, 0.700, 0.705, 0.690, 0.755, 1.290, 1.090, &
  0.940, 0.830, 0.740, 2.070, 2.060, 0.000, 1.810, 1.490, &
  1.172, 1.010, 1.130, 1.123, 1.110, 1.098, 1.087, 1.078, &
  1.063, 1.052, 1.041, 1.030, 1.020, 1.008, 1.001, 0.850, &
  0.780, 0.650, 0.670, 0.530, 0.710, 0.710, 0.710, 1.160, &
  1.025, 1.330, 1.170, 0.810, 0.760, 0.000, 1.940, 1.620, &
  1.260, 0.000, 0.920, 1.030, 0.850, 0.850, 1.350, 0.990, &
  0.970, 0.961, 0.000, 0.000, 0.000, 1.240, 0.000, 0.000, &
  0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, 0.000, &
  0.000, 0.000, 0.000, 0.000, 0.000, 0.000 /)

! Source: A. Bondi, J. Phys. Chem., 68, 441 (1964).
DOUBLE PRECISION, DIMENSION(118), PARAMETER :: ARVDW=(/ &
  1.20, 1.40, 1.82, 0.00, 0.00, 1.70, 1.55, 1.52, 1.47, &
  1.54, 2.27, 1.73, 0.00, 2.10, 1.80, 1.80, 1.75, 1.88, &
  2.75, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  1.63, 1.40, 1.39, 1.87, 0.00, 1.85, 1.90, 1.85, 2.02, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  1.63, 1.72, 1.58, 1.93, 2.17, 0.00, 2.06, 1.98, 2.16, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 1.75, 1.66, 1.55, 1.96, &
  2.02, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 1.86, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00 /)

! Source:
! R D Shannon and C T Prewitt (1969) Acta Cryst. B25:925-946
! R D Shannon (1976) Acta Cryst. A23:751-767.
DOUBLE PRECISION, DIMENSION(118), PARAMETER :: ARCRY=(/ &
  0.10, 0.00, 0.90, 0.41, 0.25, 0.29, 0.30, 1.21, 1.19, &
  0.00, 1.16, 0.86, 0.53, 0.40, 0.31, 0.43, 1.67, 0.00, &
  1.52, 1.14, 0.89, 0.75, 0.68, 0.76, 0.81, 0.69, 0.54, &
  0.70, 0.71, 0.74, 0.76, 0.53, 0.72, 0.56, 1.82, 0.00, &
  1.66, 1.32, 1.04, 0.86, 0.78, 0.79, 0.79, 0.82, 0.81, &
  0.78, 1.29, 0.92, 0.94, 0.69, 0.90, 1.11, 2.06, 0.62, &
  1.81, 1.49, 1.36, 1.15, 1.32, 1.30, 1.28, 1.10, 1.31, &
  1.08, 1.18, 1.05, 1.04, 1.03, 1.02, 1.13, 1.00, 0.85, &
  0.78, 0.74, 0.77, 0.77, 0.77, 0.74, 1.51, 0.83, 1.03, &
  1.49, 1.17, 1.08, 0.76, 0.00, 1.94, 1.62, 1.26, 1.19, &
  1.09, 0.87, 0.00, 1.00, 1.12, 1.11, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, &
  0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00 /)

! Source: http://www.ncnr.nist.gov/resources/n-lengths/
! Neutron News - Sears, Varley F.
! "Neutron scattering lengths and cross sections"
! 1992 - Vol 3, Issue 3, p26-37
! http://www.informaworld.com/10.1080/10448639208218770
DOUBLE PRECISION, DIMENSION(105), PARAMETER :: COHEB=(/ &
       -3.739, 3.26, -1.90, 7.79, 5.304, 6.646, 9.36, &
    5.803, 5.654, 4.566, 3.580, 5.375, 3.349, 4.1491, &
       5.131, 2.847, 9.577, 1.909, 3.67, 4.70, 12.29, &
     -3.438, -0.3824, 3.635, -3.73, 9.45, 2.49, 10.3, &
      7.718, 5.680, 7.288, 8.185, 6.58, 7.970, 6.795, &
     7.81, 7.09, 7.02, 7.75, 7.16, 7.054, 6.715, 6.8, &
   7.03, 5.88, 5.91, 5.922, 4.87, 4.065, 6.225, 5.57, &
      5.80, 5.28, 4.92, 5.42, 5.07, 8.24, 4.84, 4.58, &
       7.69, 12.6, 0.80, 7.22, 6.5, 7.38, 16.9, 8.01, &
      7.79, 7.07 , 12.43, 7.21, 7.7, 6.91, 4.86, 9.2, &
  10.7, 10.6, 9.6, 7.63, 12.692, 8.776, 9.405, 8.532, &
      0.00, 0.00, 0.00, 0.00, 10.0, 0.00, 10.31, 9.1, &
     8.417, 10.55, 0.00, 8.3, 0.00, 0.00, 0.00, 0.00, &
           0.00, 0.00, 0.00, 0.00, 0.00, 0.00 /)

! Source: Acta Cryst. (1968). A24, 321
! X-ray scattering factors computed from numerical Hartree-Fock wave functions
! By DON T. CROMER and JOSEPH B. MANN, University of California
DOUBLE PRECISION, DIMENSION(98), PARAMETER :: a1 = (/ &
       0.413048,  0.732354,  0.974637,  1.533712,  2.085185, &
       2.657506, 11.893780,  2.960427,  3.511943,  4.183749,  4.910127, &
       4.708971,  4.730796,  5.275329,  1.950541,  6.372157,  1.446071, &
       7.188004,  8.163991,  8.593655,  1.476566,  9.818524, 10.473575, &
      11.007069, 11.709542, 12.311098, 12.914510, 13.521865, 14.014192, &
      14.741002, 15.758946, 16.540613, 17.025642, 17.354071, 17.550570, &
      17.655279,  8.123134, 17.730219, 17.792040, 17.859772, 17.958399, &
       6.236218, 17.840963,  6.271624,  6.216648,  6.121511,  6.073874, &
       6.080986,  6.196477, 19.325171,  5.394956,  6.660302, 19.884502, &
      19.978920, 17.418674, 19.747343, 19.966019, 17.355122, 21.551311, &
      17.331244, 17.286388, 23.700363, 17.186195, 24.898117, 25.910013, &
      26.671785, 27.150190, 28.174887, 28.925894, 29.676760, 30.122866, &
      30.617033, 31.066359, 31.507900, 31.888456, 32.210297, 32.004436, &
      31.273891, 16.777390, 16.839890, 16.630795, 16.419567, 16.282274, &
      16.289164, 16.011461, 16.070229, 16.007385, 32.563690, 15.914053, &
      15.784024, 32.740208, 15.679275, 32.999901, 33.281178, 33.435162, &
      15.804837, 15.889072, 33.7 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: b1 = (/ &
       15.569946, 11.553918,  4.334946, 42.662079, 23.494068, &
       14.780758,  0.000158, 14.182259, 10.687859,  8.175457,  3.281434, &
        4.875207,  3.628931,  2.631338,  0.908139,  1.514347,  0.052357, &
        0.956221, 12.816323, 10.460644, 53.131023,  8.001879,  7.081940, &
        6.366281,  5.597120,  5.009415,  4.507138,  4.077277,  3.738280, &
        3.388232,  3.121754,  2.866618,  2.597739,  2.349787,  2.119226, &
        1.908231, 15.142385,  1.563060,  1.429691,  1.310692,  1.211590, &
        0.090780,  1.005729,  0.077040,  0.070789,  0.062549,  0.055333, &
        0.048990,  0.042072,  6.118104, 33.326523, 33.031654,  4.628591, &
        4.143356,  0.399828,  3.481823,  3.197408,  0.328369,  2.995675, &
        0.300269,  0.286620,  2.689539,  0.261678,  2.435028,  2.373912, &
        2.282593,  2.169660,  2.120995,  2.046203,  1.977630,  1.883090, &
        1.795613,  1.708732,  1.629485,  1.549238,  1.473531,  1.353767, &
        1.316992,  0.122737,  0.115905,  0.110704,  0.105499,  0.101180, &
        0.098121,  0.092639,  0.090437,  0.087031,  0.801980,  0.080511, &
        0.077067,  0.709545,  0.071206,  0.657086,  0.634999,  0.612785, &
        0.058619,  0.055503,  0.550447 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: a2 = (/ &
       0.294953,  0.753896,  0.158472,  0.638283,  1.064580, &
       1.078079,  3.277479,  2.508818,  2.772244,  2.905726,  3.081783, &
       1.194814,  2.313951,  3.191038,  4.146930,  5.154568,  6.870609, &
       6.638454,  7.146945,  1.477324,  1.487278,  1.522646,  1.547881, &
       1.555477,  1.733414,  1.876623,  2.481908,  6.947285,  4.784577, &
       6.907748,  6.841123,  1.567900,  4.503441,  4.653248,  5.411882, &
       6.848105,  2.138042,  9.795867, 10.253252, 10.911038, 12.063054, &
      17.987711,  3.428236, 17.906738, 17.919739,  4.784063, 17.155437, &
      18.019468, 18.816183,  6.281571,  6.549570,  6.940756,  6.736593, &
      11.774945,  8.314444, 17.368477, 27.329655, 43.988499, 17.161730, &
      62.783924, 51.560162, 23.072214, 37.156837, 17.104952, 32.344139, &
      88.687576, 16.999819, 82.493271, 76.173798, 65.624069, 15.099346, &
      15.145351, 15.341823, 15.682498, 16.117104, 16.678440,  1.975454, &
      18.445440, 19.317156, 20.023823, 19.386616, 32.738590, 32.725136, &
      32.807171, 32.615547, 32.641106, 32.663830, 21.396671, 32.535042, &
      32.454899, 21.973675, 32.824306, 22.638077, 23.148544, 23.657259, &
      33.480801, 33.625286, 25.467693 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: b2 = (/ &
       32.398468,  4.595831,  0.342451,  0.595420,  1.137894, &
        0.776775, 10.232723,  5.936858,  4.380466,  3.252536,  9.119178, &
      108.506081, 43.051167, 33.730728, 27.044952, 22.092527,  1.193165, &
       15.339877,  0.808945,  0.041891,  0.035325,  0.029763,  0.026040, &
        0.023987,  0.017800,  0.014461,  0.009126,  0.286763,  0.003744, &
        0.243315,  0.226057,  0.012198,  0.003012,  0.002550, 16.557184, &
       16.606236, 33.542667, 14.310868, 13.132816, 12.319285, 12.246687, &
        1.108310, 41.901382,  0.928222,  0.856121,  0.784031,  7.896512, &
        7.273646,  6.695665,  0.036915,  0.030974,  0.025750,  0.027754, &
        0.010142,  0.016872,  0.371224,  0.003446,  0.002047,  0.312491, &
        0.001320,  0.001550,  0.003491,  0.001995,  0.246961,  0.002034, &
        0.000665,  0.215414,  0.000640,  0.000656,  0.000720, 10.342764, &
        9.934469,  9.618455,  9.446448,  9.233474,  9.049695, 81.014175, &
        8.797154,  8.621570,  8.256927,  7.181401,  1.055049,  1.002287, &
        0.966265,  0.904416,  0.876409,  0.840187,  4.590666,  0.770669, &
        0.735137,  4.050881,  0.681177,  3.854918,  3.856168,  3.792942, &
        0.590160,  0.569571,  3.581973 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: a3 = (/ &
       0.187491,  0.283819,  0.811855,  0.601052,  1.062788, &
       1.490909,  1.858092,  0.637853,  0.678385,  0.520513, 1.262067, &
       1.558157,  1.541980,  1.511514,  1.494560,  1.473732, 6.151801, &
       0.454180,  1.070140,  1.436254,  1.600187,  1.703101, 1.986381, &
       2.985293,  2.673141,  3.066177,  3.466894,  3.866028, 5.056806, &
       4.642337,  4.121016,  3.727829,  3.715904,  4.259489, 3.937180, &
       4.171004,  6.761702,  6.099763,  5.714949,  5.821115, 5.007015, &
      12.973127,  1.373012, 14.123269,  3.854252, 16.631683, 4.173344, &
       4.018197,  4.050479,  4.498866, 19.650681, 19.847015, 8.110516, &
       9.332182, 10.323193, 10.465718, 11.018425, 20.546650, 11.903859, &
      12.160097, 12.478557, 12.777782, 13.103387, 13.222581, 13.765117, &
      14.065445, 14.059334, 14.624002, 14.904704, 15.160854, 56.314899, &
      54.933548, 49.278297, 37.960129, 42.390297, 48.559906, 17.070105, &
      17.063745, 32.979683, 28.428564, 32.808571,  6.530247,  6.678302, &
      21.095163,  8.113899, 21.489658, 21.594351, 11.298093, 21.553976, &
      21.849222, 12.957398, 13.660459, 14.219973, 15.153755, 15.576339, &
      24.150198, 24.710381, 16.048487 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: b3 = (/ &
      5.711404,  1.546299,  97.102966, 99.106499, 61.238976, &
     42.086842,  30.344690,  0.112726,   0.093982,  0.063295,  0.102763, &
      0.111516,   0.095960,  0.081119,   0.071280,  0.061373, 18.343416, &
     15.339862, 210.327011, 81.390381, 137.319489, 39.885422, 31.909672, &
     23.244839,  21.788420, 18.743040,  16.438129, 14.622634, 13.034982, &
     11.903689,  12.482196, 13.432163,  14.272119, 15.579460,  0.002481, &
      0.001598,   0.129372,  0.120574,   0.112173,  0.104353,  0.098615, &
     11.468720, 119.320541,  9.555345,  33.889484,  8.751391, 28.443739, &
     29.119284,  31.009790, 32.529045,   5.564929,  5.065547, 31.849096, &
     28.796200,  25.605827, 21.226641,  19.955492,  3.088196, 17.716705, &
     17.026001,  16.223755, 15.495437,  14.787360, 13.996325, 13.481969, &
     12.920230,  12.213148, 11.915256,  11.465375, 11.044622,  0.000780, &
      0.000739,   0.000760,  0.000898,   0.000689,  0.000519,  0.128093, &
      0.124741,   1.256902,  1.195250,   1.119730, 25.025890, 25.714146, &
      6.046622,  26.543257,  5.239687,   4.954467, 22.758972,  4.352206, &
      4.097976,  19.231543, 18.236156,  17.435474, 16.849735, 16.195778, &
      3.674720,   3.615472, 14.357388 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: a4 = (/ &
       0.080701, 0.190003, 0.262416, 0.106139,  0.140515, &
      -4.241070,  0.858927, 0.722838, 0.915159, 1.135641,  1.098938, &
       1.170413,  1.117564, 1.356849, 1.522042, 1.635073,  1.750347, &
       1.929593,  0.877316, 1.182839, 9.177463, 1.768774,  1.865616, &
       1.347855,  2.023368, 2.070451, 2.106351, 2.135900,  1.457971, &
       2.191766,  2.714681, 3.345098, 3.937200, 4.136455,  3.880645, &
       3.446760,  1.156051, 2.620025, 3.170516, 3.512513,  3.287667, &
       3.451426, 12.947364, 3.746008, 0.840326, 4.318258,  0.852238, &
       1.303510,  1.638929, 1.856934, 1.827820, 1.557175,  1.170953, &
       1.244749,  1.383834, 2.592602, 3.086696, 3.130670,  2.679103, &
       2.663483,  2.675515, 2.684217, 2.707246, 3.266152,  2.751404, &
       2.768497,  3.386979, 2.802756, 2.814812, 2.830288,  3.540980, &
       4.096253,  4.577665, 4.885509, 5.211669, 5.455839, 15.939454, &
       5.555933,  5.595453, 5.881564, 1.747191, 2.342742,  2.694750, &
       2.505901,  2.884082, 2.299218, 1.598497, 2.834688, 11.433394, &
       4.239077,  3.683832, 3.687261, 3.672950, 3.031492,  3.027023, &
       3.655563,  3.707139, 3.657525 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: b4 = (/ &
      61.889874,  26.463964, 201.363831,   0.151340,   0.114886, &
      -0.000294,   0.656065,  34.958481,  27.255203,  21.813910, 132.013947, &
      48.292408, 108.932388,  86.288643,  67.520187,  55.445175,  46.398396, &
      39.043823,  39.597652, 169.847839,   9.098031, 120.157997, 108.022842, &
     105.774498,  89.517914,  82.767876,  76.987320,  71.966080,  72.554794, &
      63.312130,  66.203621,  58.866047,  50.437996,  45.181202,  42.164009, &
      39.917473, 224.132507, 135.771317, 108.197029,  91.777542,  75.011948, &
      66.684151,   9.781542,  35.860680, 121.686691,  34.489983, 110.376106, &
      95.831207, 103.284348,  95.037186,  87.130966,  84.101616,  84.406387, &
      75.280685, 233.339676, 173.834274, 141.381973, 134.907654, 152.192825, &
     148.748993, 143.984512, 139.862473, 134.816299, 110.863091, 125.836510, &
     121.937187, 100.506783, 114.529938, 111.411980, 108.139153,  89.559250, &
      76.189705,  66.346199,  59.980675,  54.516373,  50.210201,   7.661196, &
      40.177994,  38.008820,  39.247227,  90.660263,  80.906593,  77.057549, &
      76.598068,  68.372963,  69.188477, 199.805801, 160.404388,  21.381622, &
     109.464111, 117.255005, 112.500038, 109.464485, 121.292038, 117.757004, &
     100.736191,  97.694786,  96.064972 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: a5 = (/ &
       0.023736,  0.039139,  0.790108,  1.118414,  0.641784, &
       0.713791,  0.912985,  1.142756,  1.089261,  1.228065,  0.560991, &
       3.239403,  3.154754,  2.519114,  5.729711,  1.209372,  0.634168, &
       1.523654,  1.486434,  7.113258,  7.099750,  7.082555,  7.056250, &
       7.034779,  7.003180,  6.975185,  6.960892,  4.284731,  6.932996, &
      38.424042,  2.395246,  6.785079,  6.790175,  6.749163,  6.707793, &
       6.685200, 17.679546,  0.600053,  0.918251,  0.746965,  1.531019, &
       0.210899,  6.335469,  0.908235, 15.173498, 13.246773, 17.988686, &
      17.974669, 17.962912, 17.917318, 17.867832, 17.802427, 17.548716, &
      17.737501, 19.876251, 11.003653, 17.335455, 11.353665,  9.564197, &
      22.239950, 22.960947, 17.204367, 24.419271, 48.995213, 17.064405, &
      17.067781, 46.546471, 17.018515, 16.998117, 16.997850, 16.943729, &
      16.896156, 16.828321, 16.792112, 16.767591, 16.735533,  5.990003, &
       1.575270, 10.576854,  4.714706,  6.356862, 19.916475, 20.576559, &
       7.254589, 21.377867,  9.480184, 11.121192, 15.914965,  3.612409, &
      11.736191, 15.744058, 22.279434, 15.683245, 15.704215, 15.746100, &
      15.499866, 15.839268, 16.008982 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: b5 = (/ &
       1.334118,   0.377523,  1.409234,  1.843093,   0.399036, &
       0.239535,  0.217287,   0.390240,  0.313066,  0.224952,   0.405878, &
       1.928171,  1.555918,   1.170087,  1.981173,  0.646925,   0.401005, &
       0.062409,  0.052821,   0.688098,  0.602102,  0.532405,   0.474882, &
       0.429369,  0.383054,   0.346506,  0.314418,  0.004437,   0.265666, &
       0.000397,  0.007238,   0.210974,  0.193015,  0.177432,   0.162121, &
       0.146896,  1.713368,   0.120574,  0.112173,  0.104353,   0.098615, &
       0.090780,  0.083391, 123.552246,  9.029517,  0.784031,   0.716809, &
       0.661231,  0.610714,   0.565651,  0.523992,  0.487660,   0.463550, &
       0.413616,  3.826915,   0.010719,  0.341817, 18.832960,   0.010468, &
       2.910268,  2.796480,   0.274536,  2.581883,  0.001383,   0.236916, &
       0.225531,  0.001211,   0.207519,  0.199376,  0.192110,   0.183849, &
       0.175914,  0.168002,   0.160798,  0.152815,  0.145771,  26.659403, &
       1.316997,  0.000601,   1.195250, 26.014978,  6.664449,   6.291882, &
      28.096128,  5.499512,  27.632641, 26.905106,  0.083544, 130.500748, &
      20.512138,  0.074040,   3.930325,  0.068033,  0.064857,   0.061755, &
      15.408296, 14.754303,   0.052450 /)

DOUBLE PRECISION, DIMENSION(98), PARAMETER :: c = (/ &
     0.000049,   0.000487,   0.002542,   0.002511,   0.003823, &
     4.297983, -11.804902,   0.027014,   0.032557,   0.025576,   0.079712, &
     0.126842,   0.139509,   0.145073,   0.155233,   0.154722,   0.146773, &
     0.265954,   0.253614,   0.196255,   0.157765,   0.102473,   0.067744, &
     0.065510,  -0.147293,  -0.304931,  -0.936572,  -2.762697,  -3.254477, &
   -36.915829,  -0.847395,   0.018726,  -2.984117,  -3.160982,  -2.492088, &
    -2.810592,   1.139548,   1.140251,   1.131787,   1.124859,   1.123452, &
     1.108770,   1.074784,   1.043992,   0.995452,   0.883099,   0.756603, &
     0.603504,   0.333097,   0.119024,  -0.290506,  -0.806668,  -0.448811, &
    -6.065902,  -2.322802,  -5.183497, -21.745489, -38.386017,  -3.871068, &
   -57.189842, -45.973682, -17.452166, -31.586687, -43.505684, -26.851971, &
   -83.279831, -41.165253, -77.135223, -70.839813, -60.313812, -51.049416, &
   -49.719837, -44.119026, -32.864574, -37.412682, -43.677956,   4.018893, &
     4.050394,  -6.279078,   4.076478,   4.066939,   4.049824,   4.040914, &
     4.046556,   3.995684,   4.020977,   4.003472,   3.981773,   3.939212, &
     3.922533,   3.886066,   3.854444,   3.769391,   3.664200,   3.541160, &
     3.390840,   3.213169,   3.005326 /)

END MODULE
