/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

import de.jarnbjo.jsnappy.Buffer;
import de.jarnbjo.jsnappy.IntIterator;
import de.jarnbjo.jsnappy.IntListHashMap;

class MapBasedCompressor {
    public static final int DEFAULT_MAX_OFFSET = 65536;

    MapBasedCompressor() {
    }

    static Buffer compress(byte[] in, int offset, int length, Buffer out, boolean useFirstHit) {
        int i;
        if (out == null) {
            out = new Buffer(length * 6 / 5);
        } else {
            out.ensureCapacity(length * 6 / 5);
        }
        byte[] target = out.getData();
        int targetIndex = 0;
        int lasthit = offset;
        for (int l = length; l > 0; l >>= 7) {
            target[targetIndex++] = l >= 128 ? (byte)(0x80 | l & 0x7F) : (byte)l;
        }
        IntListHashMap ilhm = new IntListHashMap(length / 13);
        for (i = offset; i + 4 < length && i < offset + 4; ++i) {
            ilhm.put(MapBasedCompressor.toInt(in, i), i);
        }
        for (i = offset + 4; i < offset + length; ++i) {
            Hit h = MapBasedCompressor.search(in, i, length, ilhm, useFirstHit);
            if (i + 4 < offset + length) {
                ilhm.put(MapBasedCompressor.toInt(in, i), i);
            }
            if (h != null) {
                if (lasthit < i) {
                    int len = i - lasthit - 1;
                    if (len < 60) {
                        target[targetIndex++] = (byte)(len << 2);
                    } else if (len < 256) {
                        target[targetIndex++] = -16;
                        target[targetIndex++] = (byte)len;
                    } else if (len < 65536) {
                        target[targetIndex++] = -12;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                    } else if (len < 0x1000000) {
                        target[targetIndex++] = -8;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                        target[targetIndex++] = (byte)(len >> 16);
                    } else {
                        target[targetIndex++] = -4;
                        target[targetIndex++] = (byte)len;
                        target[targetIndex++] = (byte)(len >> 8);
                        target[targetIndex++] = (byte)(len >> 16);
                        target[targetIndex++] = (byte)(len >> 24);
                    }
                    System.arraycopy(in, lasthit, target, targetIndex, i - lasthit);
                    targetIndex += i - lasthit;
                    lasthit = i;
                }
                if (h.length <= 11 && h.offset < 2048) {
                    target[targetIndex] = 1;
                    int n = targetIndex;
                    target[n] = (byte)(target[n] | h.length - 4 << 2);
                    int n2 = targetIndex++;
                    target[n2] = (byte)(target[n2] | h.offset >> 3 & 0xE0);
                    target[targetIndex++] = (byte)(h.offset & 0xFF);
                } else if (h.offset < 65536) {
                    target[targetIndex] = 2;
                    int n = targetIndex++;
                    target[n] = (byte)(target[n] | h.length - 1 << 2);
                    target[targetIndex++] = (byte)h.offset;
                    target[targetIndex++] = (byte)(h.offset >> 8);
                } else {
                    target[targetIndex] = 3;
                    int n = targetIndex++;
                    target[n] = (byte)(target[n] | h.length - 1 << 2);
                    target[targetIndex++] = (byte)h.offset;
                    target[targetIndex++] = (byte)(h.offset >> 8);
                    target[targetIndex++] = (byte)(h.offset >> 16);
                    target[targetIndex++] = (byte)(h.offset >> 24);
                }
                while (i < lasthit) {
                    if (i + 4 < in.length) {
                        ilhm.put(MapBasedCompressor.toInt(in, i), i);
                    }
                    ++i;
                }
                lasthit = i + h.length;
                while (i < lasthit - 1) {
                    if (i + 4 < in.length) {
                        ilhm.put(MapBasedCompressor.toInt(in, i), i);
                    }
                    ++i;
                }
                continue;
            }
            if (i + 4 >= length) continue;
            ilhm.put(MapBasedCompressor.toInt(in, i), i);
        }
        if (lasthit < offset + length) {
            int len = offset + length - lasthit - 1;
            if (len < 60) {
                target[targetIndex++] = (byte)(len << 2);
            } else if (len < 256) {
                target[targetIndex++] = -16;
                target[targetIndex++] = (byte)len;
            } else if (len < 65536) {
                target[targetIndex++] = -12;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
            } else if (len < 0x1000000) {
                target[targetIndex++] = -8;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
                target[targetIndex++] = (byte)(len >> 16);
            } else {
                target[targetIndex++] = -4;
                target[targetIndex++] = (byte)len;
                target[targetIndex++] = (byte)(len >> 8);
                target[targetIndex++] = (byte)(len >> 16);
                target[targetIndex++] = (byte)(len >> 24);
            }
            System.arraycopy(in, lasthit, target, targetIndex, length - lasthit);
            targetIndex += length - lasthit;
        }
        out.setLength(targetIndex);
        return out;
    }

    private static Hit search(byte[] source, int index, int length, IntListHashMap map, boolean useFirstHit) {
        int fp;
        int offset;
        if (index + 4 >= length) {
            return null;
        }
        if (index > 0 && source[index] == source[index - 1] && source[index] == source[index + 1] && source[index] == source[index + 2] && source[index] == source[index + 3]) {
            int len = 0;
            for (int i = index; len < 64 && i < length && source[index] == source[i]; ++i, ++len) {
            }
            return new Hit(1, len);
        }
        if (useFirstHit) {
            int fp2 = map.getFirstHit(MapBasedCompressor.toInt(source, index), index - 4);
            if (fp2 < 0) {
                return null;
            }
            int offset2 = index - fp2;
            int l = 0;
            int o = fp2;
            for (int io = index; io < length && source[o] == source[io] && o < index && l < 64; ++l, ++o, ++io) {
            }
            return new Hit(offset2, l);
        }
        IntIterator ii = map.getReverse(MapBasedCompressor.toInt(source, index));
        if (ii == null) {
            return null;
        }
        Hit res = null;
        while (ii.next() && (offset = index - (fp = ii.get())) <= 65536) {
            if (offset < 4) continue;
            int l = 0;
            int o = index - offset;
            for (int io = index; io < length && source[o] == source[io] && o < index && l < 64; ++l, ++o, ++io) {
            }
            if (res == null) {
                res = new Hit();
                res.offset = offset;
                res.length = l;
                continue;
            }
            if (l <= res.length) continue;
            res.offset = offset;
            res.length = l;
        }
        return res;
    }

    private static int toInt(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
    }

    private static class Hit {
        int offset;
        int length;

        Hit() {
        }

        Hit(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

