# SPDX-FileCopyrightText: 2022 Blender Authors
#
# SPDX-License-Identifier: GPL-2.0-or-later

set(BOOST_ADDRESS_MODEL 64)
if(BLENDER_PLATFORM_ARM)
  set(BOOST_ARCHITECTURE arm)
else()
  set(BOOST_ARCHITECTURE x86)
endif()

if(WIN32)
  if(MSVC_TOOLSET_VERSION GREATER_EQUAL 143) # 2022
    set(BOOST_TOOLSET toolset=msvc-14.3)
    set(BOOST_COMPILER_STRING -vc143)
  elseif(MSVC_TOOLSET_VERSION GREATER_EQUAL 142) # 2019
    set(BOOST_TOOLSET toolset=msvc-14.2)
    set(BOOST_COMPILER_STRING -vc142)
  else() # 2017
    set(BOOST_TOOLSET toolset=msvc-14.1)
    set(BOOST_COMPILER_STRING -vc141)
  endif()
endif()

set(DEFAULT_BOOST_FLAGS
  -DBoost_COMPILER:STRING=${BOOST_COMPILER_STRING}
  -DBoost_USE_MULTITHREADED=ON
  -DBoost_USE_STATIC_LIBS=OFF
  -DBoost_USE_STATIC_RUNTIME=OFF
  -DBOOST_ROOT=${LIBDIR}/boost
  -DBoost_NO_SYSTEM_PATHS=ON
  -DBoost_NO_BOOST_CMAKE=ON
  -DBoost_ADDITIONAL_VERSIONS=${BOOST_VERSION_SHORT}
  -DBOOST_LIBRARYDIR=${LIBDIR}/boost/lib/
  -DBoost_USE_DEBUG_PYTHON=On
)
