# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gtk.glade import XML as glade_XML
from ConfigParser import ConfigParser, DuplicateSectionError
from os.path import join
from os import getcwd

class Config:
    def __init__(self, module, player_gui, config_file, get_configuration):
        self.module = module
        self.player_gui = player_gui
        self.config_file = config_file
        self.get_configuration = get_configuration

    def save_config(self, name):
        if name == self.module['name']:
            check_popup = self.conf_widgets.get_widget('checkbutton4')
            check_title = self.conf_widgets.get_widget('checkbutton3')
            radio_gstpb_default = self.conf_widgets.get_widget('radiobutton1')
            radio_gstpb_gapless = self.conf_widgets.get_widget('radiobutton2')
            check_minimize = self.conf_widgets.get_widget('checkbutton1')

            popup = check_popup.get_active()
            title = check_title.get_active()

            if radio_gstpb_default.get_active():
                playback = 'default'
            elif radio_gstpb_gapless.get_active():
                playback = 'gapless'

            start = check_minimize.get_active()

            configparser = ConfigParser()
            configparser.read(self.config_file)

            try:
                configparser.add_section(self.module['name'])
            except DuplicateSectionError:
                pass

            configparser.set(self.module['name'], 'popup', int(popup))
            configparser.set(self.module['name'], 'title', int(title))
            configparser.set(self.module['name'], 'gstplayback', playback)
            configparser.set(self.module['name'], 'startminimized', int(start))

            configparser.write(open(self.config_file, 'w'))
            self.player_gui.reload_config(self.get_configuration())

    def configuration(self, args):
        (name, widgets) = args
        if name == self.module['name']:
            # Load the glade and put the vertical box in the module's
            # configuration one
            config = self.get_configuration()

            self.conf_widgets = glade_XML(join(getcwd(), 'modules',
                                          'player', 'configuration.glade'),
                                          'vbox1', domain='bluemindo')

            hbox = widgets.get_widget('hbox1')

            try:
                kids = hbox.get_children()
                hbox.remove(kids[2])
            except:
                pass

            hbox.add(self.conf_widgets.get_widget('vbox1'))

            check_popup = self.conf_widgets.get_widget('checkbutton4')
            if config['popup']:
                check_popup.set_active(True)

            check_title = self.conf_widgets.get_widget('checkbutton3')
            if config['title']:
                check_title.set_active(True)

            radio_gstpb_default = self.conf_widgets.get_widget('radiobutton1')
            radio_gstpb_gapless = self.conf_widgets.get_widget('radiobutton2')

            radio_gstpb_gapless.set_group(radio_gstpb_default)

            if config['gstplayback'] == 'default':
                radio_gstpb_default.set_active(True)
            elif config['gstplayback'] == 'gapless':
                radio_gstpb_gapless.set_active(True)

            check_minimized = self.conf_widgets.get_widget('checkbutton1')

            if config['startminimized']:
                check_minimized.set_active(True)