from bzrlib import tests
from bzrlib.plugins.pipeline.pipeline import (
    PipeManager,
    PipeStorage,
)


class TestCaseWithPipes(tests.TestCaseWithTransport):

    def make_branch_and_checkout(self, branch_path, checkout_path='checkout'):
        branch = self.make_branch(branch_path)
        return branch.create_checkout(checkout_path, lightweight=True)

    def connect_many(self, *branches):
        prev = None
        for branch in branches:
            if prev is not None:
                PipeStorage.connect(prev, branch)
            prev = branch

    def assertBaseEqual(self, left, right):
        self.assertEqual([l.base for l in left], [r.base for r in right])

    def create_long_pipeline(self):
        foo = self.make_branch('foo')
        bar = self.make_branch('bar')
        baz = self.make_branch('baz')
        qux = self.make_branch('qux')
        quxx = self.make_branch('quxx')
        self.connect_many(foo, bar, baz, qux, quxx)
        return [foo, bar, baz, qux, quxx]

    def create_conflict_pipeline(self, base=None, other=None, this=None):
        if base is None:
            base = 'base text\n'
        if other is None:
            other = 'merge text\n'
        if this is None:
            this = 'tree text\n'
        foo = self.make_branch_and_checkout('foo')
        self.build_tree_contents([('checkout/foo', base)])
        foo.add('foo')
        foo.commit('added foo')
        foo_manager = PipeManager(foo.branch, foo)
        last = PipeStorage(foo.branch).insert_pipe('last')
        first = foo.branch
        foo_manager.switch_to_pipe(last)
        foo = foo_manager._refresh_tree(foo)
        self.build_tree_contents([('checkout/foo', this)])
        foo.commit('commiting this text')
        foo_manager.switch_to_pipe(first)
        foo = foo_manager._refresh_tree(foo)
        self.build_tree_contents([('checkout/foo', other)])
        foo.commit('commiting other text')
        return foo


# Compatibility with bzr 2.2
if getattr(TestCaseWithPipes, 'assertPathExists', None) is None:
    TestCaseWithPipes.assertPathExists = TestCaseWithPipes.failUnlessExists

if getattr(TestCaseWithPipes, 'assertPathDoesNotExist', None) is None:
    TestCaseWithPipes.assertPathDoesNotExist = TestCaseWithPipes.failIfExists
