#include "types.h"
#include "dballe/core/data.h"
#include <cstring>

using namespace wreport;

namespace dballe {
namespace python {

template<typename Enq>
void data_enq_generic(const core::Data& data, Enq& enq)
{
    if (enq.search_b_values(data.values)) return;

    const auto key = enq.key;
    const auto len = enq.len;

    switch (len) {
        case 2:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(data.level.l1);
                            break;
                        case '2':
                            enq.set_dballe_int(data.level.l2);
                            break;
                        default: enq.search_alias_values(data.values);
                    }
                    break;
                case 'p':
                    switch (key[1]) {
                        case '1':
                            enq.set_dballe_int(data.trange.p1);
                            break;
                        case '2':
                            enq.set_dballe_int(data.trange.p2);
                            break;
                        default: enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 3:
            switch (key[0]) {
                case 'l':
                    switch (key[1]) {
                        case 'a':
                            if (key[2] == 't') {
                                enq.set_lat(data.station.coords.lat);
                            } else {
                                enq.search_alias_values(data.values);
                            }
                            break;
                        case 'o':
                            if (key[2] == 'n') {
                                enq.set_lon(data.station.coords.lon);
                            } else {
                                enq.search_alias_values(data.values);
                            }
                            break;
                        default: enq.search_alias_values(data.values);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        enq.set_int(data.datetime.day);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "in", 2) == 0) {
                        enq.set_int(data.datetime.minute);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "ec", 2) == 0) {
                        enq.set_int(data.datetime.second);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        enq.set_int(data.datetime.year);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        enq.set_int(data.datetime.hour);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        enq.set_ident(data.station.ident);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        enq.set_int(data.datetime.month);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "evel", 4) == 0) {
                        enq.set_level(data.level);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "eport", 5) == 0) {
                        enq.set_string(data.station.report);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'a':
                    if (memcmp(key + 1, "na_id", 5) == 0) {
                        enq.set_dballe_int(data.station.id);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "obile", 5) == 0) {
                        enq.set_bool(data.station.ident.is_missing());
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "oords", 5) == 0) {
                        enq.set_coords(data.station.coords);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "range", 5) == 0) {
                        enq.set_trange(data.trange);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 7:
            if (memcmp(key + 0, "station", 7) == 0) {
                enq.set_station(data.station);
            } else {
                enq.search_alias_values(data.values);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        enq.set_string(data.station.report);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "atetime", 7) == 0) {
                        enq.set_datetime(data.datetime);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'l':
                    if (memcmp(key + 1, "eveltype", 8) == 0) {
                        switch (key[9]) {
                            case '1':
                                enq.set_dballe_int(data.level.ltype1);
                                break;
                            case '2':
                                enq.set_dballe_int(data.level.ltype2);
                                break;
                            default: enq.search_alias_values(data.values);
                        }
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "indicator", 9) == 0) {
                        enq.set_dballe_int(data.trange.pind);
                    } else {
                        enq.search_alias_values(data.values);
                    }
                    break;
                default: enq.search_alias_values(data.values);
            }
            break;
        default: enq.search_alias_values(data.values);
    }
}

}
}
