"""
Django settings for testapp project.

Generated by 'django-admin startproject' using Django 1.8.

For more information on this file, see
https://docs.djangoproject.com/en/1.8/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.8/ref/settings/
"""

import django
# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
import os

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.8/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = ')0-t%mc5y1^fn8e7i**^^v166@5iu(&-2%9#kxud0&4ap#k!_k'

# SECURITY WARNING: don't run with debug turned on in production!
#
# BIGGER SECURITY WARNING: if you're trying to disable DEBUG, you're
# probably trying to run the testapp in production. DO NOT RUN THE
# TESTAPP IN PRODUCTION. It contains several features that are
# horrible hacks or even intentional security holes, to facilitate
# automated or manual testing (like /sql which lets you, or anyone,
# execute arbitrary SQL queries). DO NOT RUN THE TESTAPP IN
# PRODUCTION.
DEBUG = True

ALLOWED_HOSTS = []


# Application definition

INSTALLED_APPS = (
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_prometheus',
    'testapp',
)


def GetMiddlewareClasses():
    classes = ['django_prometheus.middleware.PrometheusBeforeMiddleware']
    classes.extend([
        'django.contrib.sessions.middleware.SessionMiddleware',
        'django.middleware.common.CommonMiddleware',
        'django.middleware.csrf.CsrfViewMiddleware',
        'django.contrib.auth.middleware.AuthenticationMiddleware'])
    if django.VERSION >= (1, 7):
        classes.append(
            'django.contrib.auth.middleware.SessionAuthenticationMiddleware')
    classes.extend([
        'django.contrib.messages.middleware.MessageMiddleware',
        'django.middleware.clickjacking.XFrameOptionsMiddleware'])
    if django.VERSION >= (1, 8):
        classes.append('django.middleware.security.SecurityMiddleware')
    classes.append('django_prometheus.middleware.PrometheusAfterMiddleware')
    return classes


MIDDLEWARE_CLASSES = GetMiddlewareClasses()

ROOT_URLCONF = 'testapp.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'testapp.wsgi.application'


# Database
# https://docs.djangoproject.com/en/1.8/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django_prometheus.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    },

    # Uncomment this to test django_prometheus.db.backends.mysql.
    # 'mysql': {
    #     'ENGINE': 'django_prometheus.db.backends.mysql',
    #     'NAME': 'django_prometheus_1',
    #     'USER': '',
    #     'PASSWORD': '',
    #     'HOST': 'localhost',
    #     'PORT': '3306',
    # },

    # The following databases are used by test_db.py only
    'test_db_1': {
        'ENGINE': 'django_prometheus.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'test_db_1.sqlite3'),
    },
    'test_db_2': {
        'ENGINE': 'django_prometheus.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'test_db_2.sqlite3'),
    },
}


# Internationalization
# https://docs.djangoproject.com/en/1.8/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.8/howto/static-files/

STATIC_URL = '/static/'
