﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;
using System.Collections.Immutable;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.CodeAnalysis.Host;
using Microsoft.VisualStudio.Text;

namespace Microsoft.CodeAnalysis.EditAndContinue;

internal interface IActiveStatementTrackingService : IWorkspaceService, IActiveStatementSpanLocator
{
    void StartTracking(Solution solution, IActiveStatementSpanFactory spanProvider);

    void EndTracking();

    /// <summary>
    /// Triggered when tracking spans have changed.
    /// </summary>
    event Action TrackingChanged;

    /// <summary>
    /// Updates tracking spans with the latest positions of all active statements in the specified document snapshot (#line target document) and returns them.
    /// </summary>
    ValueTask<ImmutableArray<ActiveStatementTrackingSpan>> GetAdjustedTrackingSpansAsync(TextDocument document, ITextSnapshot snapshot, CancellationToken cancellationToken);
}
