// gcc -o efl_ui_grid_view_example_1 efl_ui_grid_view_example_1.c `pkg-config --cflags --libs elementary`

#define EFL_BETA_API_SUPPORT 1

#include <Efl.h>
#include <Efl_Ui.h>
#include <Elementary.h>
#include "efl_ui_grid_view.eo.h"


static Efl_Model*
_make_model(Evas_Object *win)
{
   Eina_Value vtext;
   Efl_Generic_Model *model, *child;

   model = efl_add(EFL_GENERIC_MODEL_CLASS, win);
   eina_value_setup(&vtext, EINA_VALUE_TYPE_STRING);

#define IC(x) \
        child = efl_model_child_add(model); \
        eina_value_set(&vtext, x); \
        efl_model_property_set(child, "title", &vtext);

   IC("user-home")
   IC("user-bookmarks")
   IC("user-desktop")
   IC("user-trash")
   IC("folder")
   IC("folder-drag-accept")
   IC("folder-remote")
   IC("folder-open")
   IC("folder-home")
   IC("folder-download")
   IC("folder-recent")
   IC("folder-documents")
   IC("folder-pictures")
   IC("folder-music")
   IC("folder-videos")
   IC("folder-visiting")
   IC("network-server")
   IC("network-workgroup")
   IC("start-here")
   IC("emblem-default")
   IC("emblem-documents")
   IC("emblem-downloads")
   IC("emblem-favorite")
   IC("emblem-important")
   IC("emblem-mail")
   IC("emblem-photos")
   IC("emblem-readonly")
   IC("emblem-shared")
   IC("emblem-symbolic-link")
   IC("emblem-unreadable")
   IC("emblem-system")
   IC("emblem-synchronized")
   IC("emblem-synchronizing")
   IC("address-book-new")
   IC("application-exit")
   IC("appointment-new")
   IC("call-start")
   IC("call-stop")
   IC("contact-new")
   IC("document-open")
   IC("document-open-recent")
   IC("document-page-setup")
   IC("document-properties")
   IC("document-save")
   IC("document-save-as")
   IC("document-send")
   IC("document-close")
   IC("document-new")
   IC("document-print")
   IC("document-print-preview")
   IC("document-revert")
   IC("document-export")
   IC("document-import")
   IC("edit-clear")
   IC("edit-copy")
   IC("edit-cut")
   IC("edit-delete")
   IC("edit-find")
   IC("edit-find-replace")
   IC("edit-paste")
   IC("edit-redo")
   IC("edit-undo")
   IC("edit-select-all")
   IC("folder-copy")
   IC("folder-move")
   IC("folder-new")
   IC("format-indent-less")
   IC("format-indent-more")
   IC("format-justify-center")
   IC("format-justify-fill")
   IC("format-justify-left")
   IC("format-justify-right")
   IC("format-text-direction-ltr")
   IC("format-text-direction-rtl")
   IC("format-text-bold")
   IC("format-text-italic")
   IC("format-text-underline")
   IC("format-text-strikethrough")
   IC("go-home")
   IC("go-bottom")
   IC("go-down")
   IC("go-first")
   IC("go-jump")
   IC("go-last")
   IC("go-next")
   IC("go-previous")
   IC("go-top")
   IC("go-up")
   IC("insert-image")
   IC("insert-link")
   IC("insert-object")
   IC("insert-text")
   IC("list-add")
   IC("list-remove")
   IC("mail-forward")
   IC("mail-mark-important")
   IC("mail-mark-junk")
   IC("mail-mark-notjunk")
   IC("mail-mark-read")
   IC("mail-mark-unread")
   IC("mail-message-new")
   IC("mail-reply-all")
   IC("mail-reply-sender")
   IC("mail-send")
   IC("mail-send-receive")
   IC("media-eject")
   IC("media-playback-pause")
   IC("media-playback-start")
   IC("media-playback-stop")
   IC("media-record")
   IC("media-seek-backward")
   IC("media-seek-forward")
   IC("media-skip-backward")
   IC("media-skip-forward")
   IC("object-flip-horizontal")
   IC("object-flip-vertical")
   IC("object-rotate-left")
   IC("object-rotate-right")
   IC("process-stop")
   IC("tools-check-spelling")
   IC("view-list-compact")
   IC("view-list-details")
   IC("view-list-icons")
   IC("view-fullscreen")
   IC("view-refresh")
   IC("view-restore")
   IC("view-sort-ascending")
   IC("view-sort-descending")
   IC("view-close")
   IC("window-close")
   IC("window-new")
   IC("system-run")
   IC("system-shutdown")
   IC("system-reboot")
   IC("system-lock-screen")
   IC("system-log-out")
   IC("system-search")
   IC("help-about")
   IC("help-contents")
   IC("help-faq")
   IC("zoom-in")
   IC("zoom-out")
   IC("zoom-original")
   IC("zoom-fit")
   IC("zoom-fill")
   IC("zoom-fit-best")
   IC("appointment-missed")
   IC("appointment-soon")
   IC("audio-volume-high")
   IC("audio-volume-low")
   IC("audio-volume-medium")
   IC("audio-volume-muted")
   IC("audio-volume")
   IC("battery-caution")
   IC("battery-empty")
   IC("battery-low")
   IC("battery-good")
   IC("battery-full")
   IC("battery-caution-charging")
   IC("battery-empty-charging")
   IC("battery-low-charging")
   IC("battery-good-charging")
   IC("battery-full-charging")
   IC("bluetooth-active")
   IC("bluetooth-disabled")
   IC("changes-allow")
   IC("changes-prevent")
   IC("dialog-error")
   IC("dialog-information")
   IC("dialog-password")
   IC("dialog-question")
   IC("dialog-warning")
   IC("media-playlist-repeat")
   IC("media-playlist-shuffle")
   IC("network-cellular-3g")
   IC("network-cellular-4g")
   IC("network-cellular-edge")
   IC("network-cellular-gprs")
   IC("network-cellular-umts")
   IC("network-cellular-connected")
   IC("network-cellular-signal-excellent")
   IC("network-cellular-signal-good")
   IC("network-cellular-signal-none")
   IC("network-cellular-signal-ok")
   IC("network-cellular-signal-weak")
   IC("network-cellular-signal-acquiring")
   IC("network-error")
   IC("network-offline")
   IC("network-receive")
   IC("network-transmit-receive")
   IC("network-transmit")
   IC("network-idle")
   IC("network-vpn")
   IC("network-vpn-acquiring")
   IC("network-wireless-acquiring")
   IC("network-wireless-encrypted")
   IC("network-wireless-signal-excellent")
   IC("network-wireless-signal-good")
   IC("network-wireless-signal-none")
   IC("network-wireless-signal-ok")
   IC("network-wireless-signal-weak")
   IC("printer-error")
   IC("printer-printing")
   IC("printer-warning")
   IC("security-high")
   IC("security-medium")
   IC("security-low")
   IC("software-update-available")
   IC("software-update-urgent")
   IC("task-due")
   IC("task-past-due")
   IC("user-available")
   IC("user-away")
   IC("user-busy")
   IC("user-invisible")
   IC("user-idle")
   IC("user-offline")
   IC("user-trash-full")
   IC("weather-clear-night")
   IC("weather-clear")
   IC("weather-clouds-night")
   IC("weather-clouds")
   IC("weather-few-clouds-night")
   IC("weather-few-clouds")
   IC("weather-fog")
   IC("weather-overcast")
   IC("weather-severe-alert")
   IC("weather-showers-scattered")
   IC("weather-showers")
   IC("weather-snow")
   IC("weather-storm")
   IC("mail-attachment")
   IC("mail-unread")
   IC("mail-read")
   IC("mail-replied")
   IC("mail-signed")
   IC("mail-signed-verified")
   IC("starred")
   IC("non-starred")
   IC("audio-card")
   IC("audio-input-microphone")
   IC("battery")
   IC("camera")
   IC("camera-photo")
   IC("camera-web")
   IC("camera-video")
   IC("drive-harddisk")
   IC("drive-harddisk-ieee1394")
   IC("drive-harddisk-usb")
   IC("drive-optical")
   IC("drive-removable-media")
   IC("drive-removable-media-ieee1394")
   IC("drive-removable-media-usb")
   IC("computer")
   IC("computer-laptop")
   IC("multimedia-player")
   IC("media-optical")
   IC("media-optical-cd")
   IC("media-optical-audio")
   IC("media-optical-dvd")
   IC("media-optical-bd")
   IC("media-flash")
   IC("media-flash-cf")
   IC("media-flash-ms")
   IC("media-flash-sd")
   IC("media-flash-sm")
   IC("media-floppy")
   IC("media-zip")
   IC("media-tape")
   IC("media-memory")
   IC("processor")
   IC("input-mouse")
   IC("input-tablet")
   IC("input-keyboard")
   IC("input-gaming")
   IC("pda")
   IC("phone")
   IC("printer")
   IC("scanner")
   IC("modem")
   IC("video-display")
   IC("network-wired")
   IC("network-wireless")
   IC("applications-accessories")
   IC("applications-development")
   IC("applications-games")
   IC("applications-graphics")
   IC("applications-internet")
   IC("applications-multimedia")
   IC("applications-office")
   IC("applications-other")
   IC("applications-science")
   IC("applications-system")
   IC("applications-utilities")
   IC("preferences-desktop")
   IC("preferences-system")
   IC("preferences-other")
   IC("preferences-color")
   IC("preferences-profile")
   IC("preferences-desktop-display")
   IC("preferences-desktop-font")
   IC("preferences-desktop-keyboard")
   IC("preferences-desktop-locale")
   IC("preferences-desktop-multimedia")
   IC("preferences-desktop-screensaver")
   IC("preferences-desktop-theme")
   IC("preferences-desktop-wallpaper")
   IC("system-file-manager")
   IC("flag-ad")
   IC("flag-af")
   IC("flag-al")
   IC("flag-am")
   IC("flag-ar")
   IC("flag-at")
   IC("flag-au")
   IC("flag-az")
   IC("flag-ba")
   IC("flag-bd")
   IC("flag-be")
   IC("flag-bg")
   IC("flag-br")
   IC("flag-bt")
   IC("flag-bw")
   IC("flag-by")
   IC("flag-ca")
   IC("flag-cd")
   IC("flag-ch")
   IC("flag-cm")
   IC("flag-cn")
   IC("flag-cz")
   IC("flag-de")
   IC("flag-dk")
   IC("flag-ee")
   IC("flag-es")
   IC("flag-et")
   IC("flag-fi")
   IC("flag-fo")
   IC("flag-fr")
   IC("flag-gb")
   IC("flag-ge")
   IC("flag-gh")
   IC("flag-gn")
   IC("flag-gr")
   IC("flag-hr")
   IC("flag-hu")
   IC("flag-ie")
   IC("flag-il")
   IC("flag-in")
   IC("flag-iq")
   IC("flag-ir")
   IC("flag-is")
   IC("flag-it")
   IC("flag-jp")
   IC("flag-ke")
   IC("flag-kg")
   IC("flag-kh")
   IC("flag-kr")
   IC("flag-ku")
   IC("flag-kz")
   IC("flag-la")
   IC("flag-lk")
   IC("flag-lt")
   IC("flag-lv")
   IC("flag-ma")
   IC("flag-md")
   IC("flag-me")
   IC("flag-mk")
   IC("flag-ml")
   IC("flag-mm")
   IC("flag-mn")
   IC("flag-mt")
   IC("flag-mv")
   IC("flag-my")
   IC("flag-ng")
   IC("flag-nl")
   IC("flag-no")
   IC("flag-np")
   IC("flag-ph")
   IC("flag-pk")
   IC("flag-pl")
   IC("flag-pt")
   IC("flag-ro")
   IC("flag-rs")
   IC("flag-ru")
   IC("flag-se")
   IC("flag-si")
   IC("flag-sk")
   IC("flag-sn")
   IC("flag-sy")
   IC("flag-th")
   IC("flag-tj")
   IC("flag-tm")
   IC("flag-tr")
   IC("flag-tw")
   IC("flag-tz")
   IC("flag-ua")
   IC("flag-us")
   IC("flag-uz")
   IC("flag-vn")
   IC("flag-za")
   IC("inode-directory")

   eina_value_flush(&vtext);
   return model;
}

static void
_item_constructing(void *data EINA_UNUSED, const Efl_Event *ev)
{
   Efl_Gfx_Entity *item = ev->info;

   if (!efl_key_data_get(item, "efl.ui.widget.factory.size_set"))
     efl_gfx_hint_size_min_set(item, EINA_SIZE2D(100, 100));
}

EAPI_MAIN void
efl_main(void *data EINA_UNUSED, const Efl_Event *ev EINA_UNUSED)
{
   Efl_Ui_Factory *factory, *image_factory;
   Efl_Ui_Win *win;
   Efl_Ui_Grid_View *grid;
   Eo *model;

   elm_policy_set(ELM_POLICY_QUIT, ELM_POLICY_QUIT_LAST_WINDOW_CLOSED);

   win = efl_add(EFL_UI_WIN_CLASS, efl_main_loop_get(),
                 efl_ui_win_type_set(efl_added, EFL_UI_WIN_TYPE_BASIC),
                 efl_text_set(efl_added, "Efl.Ui.Grid_View example"),
                 efl_ui_win_autodel_set(efl_added, EINA_TRUE)
                );

   model = _make_model(win);
   image_factory = efl_add(EFL_UI_LAYOUT_FACTORY_CLASS, win);
   efl_ui_widget_factory_item_class_set(image_factory, EFL_UI_IMAGE_CLASS);
   efl_ui_property_bind(image_factory, "icon", "title");

   factory = efl_add(EFL_UI_LAYOUT_FACTORY_CLASS, win);
   efl_ui_widget_factory_item_class_set(factory, EFL_UI_GRID_DEFAULT_ITEM_CLASS);
   efl_ui_property_bind(factory, "efl.text", "title");
   efl_ui_factory_bind(factory, "icon", image_factory);
   efl_event_callback_add(factory, EFL_UI_FACTORY_EVENT_ITEM_CONSTRUCTING, _item_constructing, NULL);

   grid = efl_add(EFL_UI_GRID_VIEW_CLASS, win,
     efl_ui_collection_view_factory_set(efl_added, factory),
     efl_ui_view_model_set(efl_added, model)
   );
   evas_object_size_hint_weight_set(grid, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
   evas_object_size_hint_align_set(grid, EVAS_HINT_FILL, EVAS_HINT_FILL);

   efl_content_set(win, grid);
   efl_gfx_entity_size_set(win, EINA_SIZE2D(320, 320));
}
EFL_MAIN()
