!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_merge
!! NAME
!!  etsf_io_split_merge
!!
!! FUNCTION
!!    This is a complex routine that create a larger split definition (@output_split)
!!    from an input split definition (@split). For each associated array in @split,
!!    it copies all values of this array into the corresponding array in @output_split.
!!    The position in the corresponding array is the first unused index (i.e. with a
!!    negative value).
!!
!!    The input @split definition is then modified to reflect the new position of values
!!    in @output_split.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!! SIDE EFFECTS
!! * output_split <type(etsf_split)> = 
!! * split <type(etsf_split)> = 
!!     the value from this structure are copied into the right arrays in
!!     @output_split and the values are changed then to be the indexes used in
!!     @output_split.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_merge(output_split, split, lstat, error_data)

  !Arguments ------------------------------------
  type(etsf_split), intent(inout) :: output_split
  type(etsf_split), intent(inout) :: split
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_merge'
  integer :: ivar
  integer :: len


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_merge : enter'
!ENDDEBUG

  lstat = .false.
  if (associated(output_split%my_kpoints)) then
    if (.not. associated(split%my_kpoints)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_kpoints), 1
      if (output_split%my_kpoints(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_kpoints) - 1) > size(output_split%my_kpoints)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_kpoints(ivar:ivar + size(split%my_kpoints) - 1) = &
      & split%my_kpoints
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_kpoints = &
      & (/ (len, len = ivar, ivar + size(split%my_kpoints) - 1, 1) /)
  end if
  if (associated(output_split%my_grid_points_vector3)) then
    if (.not. associated(split%my_grid_points_vector3)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_grid_points_vector3), 1
      if (output_split%my_grid_points_vector3(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_grid_points_vector3) - 1) > size(output_split%my_grid_points_vector3)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_grid_points_vector3(ivar:ivar + size(split%my_grid_points_vector3) - 1) = &
      & split%my_grid_points_vector3
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_grid_points_vector3 = &
      & (/ (len, len = ivar, ivar + size(split%my_grid_points_vector3) - 1, 1) /)
  end if
  if (associated(output_split%my_spins)) then
    if (.not. associated(split%my_spins)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_spins), 1
      if (output_split%my_spins(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_spins) - 1) > size(output_split%my_spins)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_spins(ivar:ivar + size(split%my_spins) - 1) = &
      & split%my_spins
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_spins = &
      & (/ (len, len = ivar, ivar + size(split%my_spins) - 1, 1) /)
  end if
  if (associated(output_split%my_grid_points_vector1)) then
    if (.not. associated(split%my_grid_points_vector1)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_grid_points_vector1), 1
      if (output_split%my_grid_points_vector1(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_grid_points_vector1) - 1) > size(output_split%my_grid_points_vector1)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_grid_points_vector1(ivar:ivar + size(split%my_grid_points_vector1) - 1) = &
      & split%my_grid_points_vector1
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_grid_points_vector1 = &
      & (/ (len, len = ivar, ivar + size(split%my_grid_points_vector1) - 1, 1) /)
  end if
  if (associated(output_split%my_grid_points_vector2)) then
    if (.not. associated(split%my_grid_points_vector2)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_grid_points_vector2), 1
      if (output_split%my_grid_points_vector2(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_grid_points_vector2) - 1) > size(output_split%my_grid_points_vector2)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_grid_points_vector2(ivar:ivar + size(split%my_grid_points_vector2) - 1) = &
      & split%my_grid_points_vector2
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_grid_points_vector2 = &
      & (/ (len, len = ivar, ivar + size(split%my_grid_points_vector2) - 1, 1) /)
  end if
  if (associated(output_split%my_coefficients)) then
    if (.not. associated(split%my_coefficients)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_coefficients), 1
      if (output_split%my_coefficients(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_coefficients) - 1) > size(output_split%my_coefficients)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_coefficients(ivar:ivar + size(split%my_coefficients) - 1) = &
      & split%my_coefficients
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_coefficients = &
      & (/ (len, len = ivar, ivar + size(split%my_coefficients) - 1, 1) /)
  end if
  if (associated(output_split%my_components)) then
    if (.not. associated(split%my_components)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_components), 1
      if (output_split%my_components(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_components) - 1) > size(output_split%my_components)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_components(ivar:ivar + size(split%my_components) - 1) = &
      & split%my_components
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_components = &
      & (/ (len, len = ivar, ivar + size(split%my_components) - 1, 1) /)
  end if
  if (associated(output_split%my_states)) then
    if (.not. associated(split%my_states)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (not allocated).")
      return
    end if
    do ivar = 1, size(output_split%my_states), 1
      if (output_split%my_states(ivar) < 0) then
        exit
      end if
    end do
    if ((ivar + size(split%my_states) - 1) > size(output_split%my_states)) then
      call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
        & ERROR_TYPE_DIM, my_name, &
        & errmess = "incompatible split for merge (wrong length).")
      return
    end if
    output_split%my_states(ivar:ivar + size(split%my_states) - 1) = &
      & split%my_states
    ! We modify the split value to be used in accordance with
    ! the new output_split
    split%my_states = &
      & (/ (len, len = ivar, ivar + size(split%my_states) - 1, 1) /)
  end if
  lstat = .true.


!DEBUG
!write (*,*) 'etsf_io_split_merge : exit'
!ENDDEBUG

end subroutine etsf_io_split_merge
!!***
