/* $Id: WaveFormElem.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __WAVE_FORM_ELEM_HPP_INCLUDED
#define __WAVE_FORM_ELEM_HPP_INCLUDED

#include "frontend/ast/AstNode.hpp"
#include "frontend/ast/Expression.hpp"

namespace ast {

//! a VHDL waveform element.
/** This class represents a VHDL WaveForm Element.
 */
class WaveFormElem : public AstNode {
public:
	//! c'tor
	/** @param val value of the WaveFormElem.
          * @param tdelay delay of the value.
	  * @param loc Location of the WaveFormElement.
          */
	WaveFormElem(
		Expression *val,
		Expression *tdelay,
		Location loc
		) : 	AstNode(loc),
			value(val), 
			delay(tdelay) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
        *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->value;
		if (this->delay) {
			stream << " AFTER " << this->delay;
		}
	}

	/** value of the WaveFormElem */
	Expression *value;
	/** delay of the WaveFormElem */
	Expression *delay;

protected:
	/** Destructor */
	virtual ~WaveFormElem() {
		util::MiscUtil::terminate(value);
		util::MiscUtil::terminate(delay);
	}
};

}; /* namespace ast */

#endif /* __WAVE_FORM_ELEM_HPP_INCLUDED */
