-- $Id: iassoc.vhdl 4329 2009-01-27 14:48:04Z potyra $ 

-- small test case for individual associations

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library typedefs;
use typedefs.standard.all;
ENTITY dummy is
	type iarray12 is array(1 to 2) of integer;
	type iarray123 is array(1 to 3) of integer;

	FUNCTION foo(
			bofu : iarray12; 
			tofu : iarray123
		) return integer is
	begin
		return bofu(1) + tofu(2);
	end foo;
end ENTITY dummy;

ARCHITECTURE impl of dummy is
begin
	p1 : process
		variable result : integer;
	begin
		-- individual association
		result := foo(
				bofu(1) => 1,
				bofu(2) => 2,
				tofu(1) => 1,
				tofu(2) => 2,
				tofu(3) => 3
			);
	end process;

end;
