/*
 * $Id: sig_std_logic.h,v 1.10 2012-03-06 14:46:50 siflkres Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_STD_LOGIC_H_INCLUDED
#define __SIG_STD_LOGIC_H_INCLUDED

#include "sig_gen.h"

enum {
	SIG_STD_LOGIC_U,
	SIG_STD_LOGIC_X,
	SIG_STD_LOGIC_0,
	SIG_STD_LOGIC_1,
	SIG_STD_LOGIC_Z,
	SIG_STD_LOGIC_W,
	SIG_STD_LOGIC_L,
	SIG_STD_LOGIC_H,
	/* FIXME don't care '-' */
};

struct sig_std_logic_funcs {
	void (*set)(void *_cpssp, unsigned int val);
	void (*set_ext)(void *_cpssp, unsigned int val);
};

struct sig_std_logic {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_std_logic_funcs *f;
		unsigned int in;
	} in[16];
	unsigned int in_count;

	struct {
		void *s;
		unsigned int out;
	} out[16];
	unsigned int out_count;
};

struct sig_std_logic_merge {
	struct sig_std_logic *s0;
	struct sig_std_logic *s1;
};

extern void
sig_std_logic_set(struct sig_std_logic *b, void *s, unsigned int val);

extern void
sig_std_logic_connect_in(struct sig_std_logic *b,
		void *s, const struct sig_std_logic_funcs *f);
extern void
sig_std_logic_connect_out(struct sig_std_logic *b,
		void *s, unsigned int val);

extern struct sig_std_logic_merge *
sig_std_logic_merge(struct sig_std_logic *s0, struct sig_std_logic *s1);
extern void
sig_std_logic_split(struct sig_std_logic_merge *m);

extern struct sig_std_logic *
sig_std_logic_create(const char *name);
extern void
sig_std_logic_destroy(struct sig_std_logic *sig);

extern void
sig_std_logic_suspend(struct sig_std_logic *b, FILE *fSig);
extern void
sig_std_logic_resume(struct sig_std_logic *b, FILE *fSig);

#endif /* __SIG_STD_LOGIC_H_INCLUDED */
