#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("set Window Mode, needs 2 marks ")

    def run(self):
        if self.env["runtime"]["CursorManager"].set_window_for_application():
            curr_app = self.env["runtime"][
                "ApplicationManager"
            ].get_current_application()
            self.env["runtime"]["OutputManager"].present_text(
                _("Window Mode on for application {0}").format(curr_app),
                interrupt=True,
            )
            self.env["runtime"]["CursorManager"].clear_marks()
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("Set window begin and end marks"), interrupt=True
            )

    def set_callback(self, callback):
        pass
