/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.VisADException;
import visad.browser.Convert;

public class RangeWidget
extends JPanel
implements ActionListener,
ScalarMapListener {
    private JTextField dataLow;
    private JTextField dataHi;
    private ScalarMap map;

    public RangeWidget(ScalarMap smap) throws VisADException {
        this.map = smap;
        if (this.map == null) {
            throw new VisADException("RangeWidget: ScalarMap cannot be null");
        }
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        boolean scale = this.map.getScale(so, data, display);
        if (!scale) {
            throw new VisADException("RangeWidget: ScalarMap must have linearly scalable range");
        }
        this.dataLow = new JTextField();
        this.dataHi = new JTextField();
        this.updateTextFields(data);
        Dimension msize = this.dataLow.getMaximumSize();
        Dimension psize = this.dataLow.getPreferredSize();
        msize.height = psize.height;
        this.dataLow.setMaximumSize(msize);
        this.dataHi.setMaximumSize(msize);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel("low: "));
        p.add(this.dataLow);
        p.add(new JLabel(" hi: "));
        p.add(this.dataHi);
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel("Range of " + this.map.getScalarName() + " mapped to " + this.map.getDisplayScalar().getName().substring(7)));
        this.add(p);
        this.map.addScalarMapListener(this);
        this.dataLow.addActionListener(this);
        this.dataHi.addActionListener(this);
    }

    private void updateTextFields(double[] data) {
        this.dataLow.removeActionListener(this);
        this.dataHi.removeActionListener(this);
        if (data[0] < data[1]) {
            this.dataLow.setText(Convert.shortString(data[0], 2));
            this.dataHi.setText(Convert.shortString(data[1], 3));
        } else {
            this.dataLow.setText(Convert.shortString(data[0], 3));
            this.dataHi.setText(Convert.shortString(data[1], 2));
        }
        this.dataLow.addActionListener(this);
        this.dataHi.addActionListener(this);
    }

    private void updateScalarMap(double[] data) {
        try {
            this.map.setRange(data[0], data[1]);
        }
        catch (VisADException exc) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        double[] data = new double[]{Double.parseDouble(this.dataLow.getText()), Double.parseDouble(this.dataHi.getText())};
        this.updateScalarMap(data);
    }

    public void mapChanged(ScalarMapEvent e) {
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        this.map.getScale(so, data, display);
        this.updateTextFields(data);
    }

    public void controlChanged(ScalarMapControlEvent evt) {
    }
}

