# Autogenerated do not modify manually!
# This is a type-hinting python stub file, used by python IDEs to provide type hints. For more information
# about stub files, see https://www.python.org/dev/peps/pep-0484/#stub-files
# During execution, the actual module is made available via
# a C++ Boost-python process as part of the launch.
from collections.abc import Mapping, Sequence, Set
from enum import IntEnum
from typing import overload

from common.fo_typing import (
    BuildingId,
    BuildingName,
    EmpireId,
    FleetId,
    ObjectId,
    PartName,
    PlanetId,
    PlayerId,
    ShipId,
    SpeciesName,
    SystemId,
    Turn,
)

class AccountingInfo:
    @property
    def causeType(self): ...
    @property
    def customLabel(self): ...
    @property
    def meterChange(self): ...
    @property
    def meterRunningTotal(self): ...
    @property
    def sourceID(self): ...
    @property
    def specificCause(self): ...

class GalaxySetupData:
    @property
    def age(self) -> galaxySetupOptionGeneric: ...
    @property
    def gameUID(self) -> str: ...
    @property
    def maxAIAggression(self) -> aggression: ...
    @property
    def monsterFrequency(self) -> galaxySetupOptionMonsterFreq: ...
    @property
    def nativeFrequency(self) -> galaxySetupOptionGeneric: ...
    @property
    def planetDensity(self) -> galaxySetupOptionGeneric: ...
    @property
    def seed(self) -> str: ...
    @property
    def shape(self) -> galaxyShape: ...
    @property
    def size(self) -> int: ...
    @property
    def specialsFrequency(self) -> galaxySetupOptionGeneric: ...
    @property
    def starlaneFrequency(self) -> galaxySetupOptionGeneric: ...

class GameRules:
    @property
    def empty(self) -> bool: ...
    def getDescription(self, string: str) -> str: ...
    def getDouble(self, string: str) -> float: ...
    def getInt(self, string: str) -> int: ...
    def getRulesAsStrings(self) -> Mapping[str, str]: ...
    def getString(self, string: str) -> str: ...
    def getToggle(self, string: str) -> bool: ...
    def ruleExists(self, string: str) -> bool: ...
    def ruleExistsWithType(self, string: str, rule_type: ruleType) -> bool: ...

class UnlockableItem:
    @property
    def name(self) -> str: ...
    @property
    def type(self) -> unlockableItemType: ...

class buildingType:
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    def canBeEnqueued(self, number1: int, number2: int) -> bool: ...
    def canBeProduced(self, number1: int, number2: int) -> bool: ...
    def captureResult(self, number1: int, number2: int, number3: int, boolean: bool) -> captureResult: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def perTurnCost(self, number1: int, number2: int) -> float: ...
    def productionCost(self, number1: int, number2: int) -> float: ...
    def productionTime(self, number1: int, number2: int) -> int: ...

class diplomaticMessage:
    @property
    def recipient(self) -> PlayerId: ...
    @property
    def sender(self) -> PlayerId: ...
    @property
    def type(self) -> diplomaticMessageType: ...

class diplomaticStatusUpdate:
    @property
    def empire1(self) -> EmpireId: ...
    @property
    def empire2(self) -> EmpireId: ...
    @property
    def status(self) -> diplomaticStatus: ...

class empire:
    @property
    def adoptedPolicies(self) -> Sequence[str]: ...
    @property
    def allShipDesigns(self) -> Set[int]: ...
    @property
    def availableBuildingTypes(self) -> Sequence[str]: ...
    @property
    def availablePolicies(self) -> Set[str]: ...
    @property
    def availableShipDesigns(self) -> Set[int]: ...
    @property
    def availableShipHulls(self) -> Sequence[str]: ...
    @property
    def availableShipParts(self) -> Sequence[str]: ...
    @property
    def availableTechs(self) -> Set[str]: ...
    @property
    def capitalID(self) -> PlanetId: ...
    @property
    def categoriesSlotPolicies(self) -> Mapping[str, Mapping[int, str]]: ...
    @property
    def colour(self) -> tuple: ...
    @property
    def eliminated(self) -> bool: ...
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def emptyPolicySlots(self) -> Mapping[str, int]: ...
    @property
    def exploredSystemIDs(self) -> Set[int]: ...
    @property
    def fleetSupplyableSystemIDs(self) -> Set[int]: ...
    @property
    def lastTurnReceived(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def planetsWithAllocatedPP(self) -> Mapping[Set[int], float]: ...
    @property
    def planetsWithAvailablePP(self) -> Mapping[Set[int], float]: ...
    @property
    def planetsWithWastedPP(self) -> Set[Set[int]]: ...
    @property
    def playerName(self) -> str: ...
    @property
    def productionPoints(self) -> float: ...
    @property
    def productionQueue(self) -> productionQueue: ...
    @property
    def researchQueue(self) -> researchQueue: ...
    @property
    def resourceSupplyGroups(self) -> Set[Set[int]]: ...
    @property
    def supplyUnobstructedSystems(self) -> Set[int]: ...
    @property
    def systemSupplyRanges(self) -> Mapping[int, float]: ...
    @property
    def totalPolicySlots(self) -> Mapping[str, int]: ...
    @property
    def totalShipsOwned(self) -> int: ...
    @property
    def turnsPoliciesAdopted(self) -> Mapping[str, int]: ...
    @property
    def won(self) -> bool: ...
    def buildingTypeAvailable(self, string: str) -> bool: ...
    @overload
    def canBuild(self, build_type: buildType, string: str, number: int) -> bool: ...
    @overload
    def canBuild(self, build_type: buildType, number1: int, number2: int) -> bool: ...
    def canBuild(*args) -> bool: ...
    def getMeter(self, string: str) -> meter:
        """
        Returns the empire meter with the indicated name (string).
        """
    def getTechStatus(self, string: str) -> techStatus: ...
    def hasExploredSystem(self, number: int) -> bool: ...
    def obstructedStarlanes(self) -> Sequence[tuple[int, int]]: ...
    def policyAdopted(self, string: str) -> bool: ...
    def policyAvailable(self, string: str) -> bool: ...
    def policyPrereqsAndExclusionsOK(self, string: str) -> bool: ...
    def population(self) -> float: ...
    def preservedLaneTravel(self, number1: int, number2: int) -> bool: ...
    def productionCostAndTime(self, production_queue_element: productionQueueElement) -> object: ...
    def researchProgress(self, string: str) -> float: ...
    def resourceAvailable(self, resource_type: resourceType) -> float: ...
    def resourceProduction(self, resource_type: resourceType) -> float: ...
    def resourceStockpile(self, resource_type: resourceType) -> float: ...
    def shipDesignAvailable(self, number: int) -> bool: ...
    def slotPolicyAdoptedIn(self, string: str) -> int: ...
    def supplyProjections(self) -> Mapping[SystemId, int]:
        """
        Returns the (negative) number of jumps (int) away each known system ID (int) is from this empire's supply network. 0 in dicates systems that are fleet supplied. -1 indicates a system that is 1 jump away from a supplied system. -4 indicates a system that is 4 jumps from a supply connection.
        """
    def techResearched(self, string: str) -> bool: ...
    def turnPolicyAdopted(self, string: str) -> Turn: ...

class fieldType:
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """

class meter:
    @property
    def current(self) -> float: ...
    @property
    def initial(self) -> float: ...
    def dump(self) -> str:
        """
        Returns string with debug information.
        """

class policy:
    @property
    def category(self) -> str: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def shortDescription(self) -> str: ...
    @overload
    def adoptionCost(self) -> float: ...
    @overload
    def adoptionCost(self, empire_object: empire) -> float: ...
    @overload
    def adoptionCost(self, number: int) -> float: ...
    def adoptionCost(*args) -> float: ...

class productionQueue:
    @property
    def allocatedPP(self) -> Mapping[Set[int], float]: ...
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def empty(self) -> bool: ...
    @property
    def size(self) -> int: ...
    @property
    def totalSpent(self) -> float: ...
    def __getitem__(self, number: int) -> productionQueueElement: ...
    def __iter__(self) -> object: ...
    def __len__(self) -> int: ...

class productionQueueElement:
    @property
    def allocation(self) -> float: ...
    @property
    def allowedStockpile(self) -> bool: ...
    @property
    def blocksize(self) -> int: ...
    @property
    def buildType(self) -> buildType: ...
    @property
    def designID(self) -> int: ...
    @property
    def locationID(self) -> PlanetId: ...
    @property
    def name(self) -> str: ...
    @property
    def paused(self) -> bool: ...
    @property
    def progress(self) -> float: ...
    @property
    def remaining(self) -> int: ...
    @property
    def removed(self) -> bool: ...
    @property
    def turnsLeft(self) -> int: ...

class researchQueue:
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def empty(self) -> bool: ...
    @property
    def size(self) -> int: ...
    @property
    def totalSpent(self) -> float: ...
    def __contains__(self, research_queue_element: researchQueueElement) -> bool: ...
    def __getitem__(self, number: int) -> researchQueueElement: ...
    def __iter__(self) -> object: ...
    def __len__(self) -> int: ...
    def inQueue(self, string: str) -> bool: ...

class researchQueueElement:
    @property
    def allocation(self) -> float: ...
    @property
    def tech(self) -> str: ...
    @property
    def turnsLeft(self) -> int: ...

class shipDesign:
    @property
    def attack(self) -> float: ...
    @property
    def attackStats(self) -> Sequence[int]: ...
    @property
    def canColonize(self) -> bool: ...
    @property
    def canInvade(self) -> bool: ...
    @property
    def colonyCapacity(self) -> float: ...
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def defense(self) -> float: ...
    @property
    def description(self) -> str: ...
    @property
    def designedOnTurn(self) -> Turn: ...
    @property
    def detection(self) -> float: ...
    @property
    def fuel(self) -> float: ...
    @property
    def hasDirectWeapons(self) -> bool: ...
    @property
    def hasFighters(self) -> bool: ...
    @property
    def hull(self) -> str: ...
    @property
    def id(self) -> int: ...
    @property
    def industryGeneration(self) -> float: ...
    @property
    def influenceGeneration(self) -> float: ...
    @property
    def isArmed(self) -> bool: ...
    @property
    def isMonster(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def parts(self) -> Sequence[PartName]: ...
    @property
    def researchGeneration(self) -> float: ...
    @property
    def shields(self) -> float: ...
    @property
    def ship_hull(self) -> shipHull: ...
    @property
    def speed(self) -> float: ...
    @property
    def stealth(self) -> float: ...
    @property
    def structure(self) -> float: ...
    @property
    def troopCapacity(self) -> float: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def perTurnCost(self, number1: int, number2: int) -> float: ...
    def productionCost(self, number1: int, number2: int) -> float: ...
    def productionLocationForEmpire(self, number1: int, number2: int) -> bool: ...
    def productionTime(self, number1: int, number2: int) -> int: ...

class shipHull:
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def fuel(self) -> float: ...
    @property
    def name(self) -> str: ...
    @property
    def numSlots(self) -> int: ...
    @property
    def slots(self) -> Sequence[shipSlotType]: ...
    @property
    def speed(self) -> float: ...
    @property
    def stealth(self) -> float: ...
    @property
    def structure(self) -> float: ...
    def hasTag(self, string: str) -> bool: ...
    def numSlotsOfSlotType(self, ship_slot_type: shipSlotType) -> int: ...
    def productionCost(self, number1: int, number2: int, number3: int) -> float: ...
    def productionLocation(self, number: int) -> bool:
        """
        Returns the result of Location condition (bool) in passed location_id (int)
        """
    def productionTime(self, number1: int, number2: int, number3: int) -> int: ...

class shipPart:
    @property
    def capacity(self) -> float: ...
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def mountableSlotTypes(self) -> Sequence[shipSlotType]: ...
    @property
    def name(self) -> str: ...
    @property
    def partClass(self) -> shipPartClass: ...
    @property
    def secondaryStat(self) -> float: ...
    def canMountInSlotType(self, ship_slot_type: shipSlotType) -> bool: ...
    def hasTag(self, string: str) -> bool: ...
    def productionCost(self, number1: int, number2: int, number3: int) -> float: ...
    def productionLocation(self, number: int) -> bool:
        """
        Returns the result of Location condition (bool) in passed location_id (int)
        """
    def productionTime(self, number1: int, number2: int, number3: int) -> int: ...

class special:
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def spawnlimit(self) -> int: ...
    @property
    def spawnrate(self) -> float: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def initialCapacity(self, number: int) -> float: ...

class species:
    @property
    def canColonize(self) -> bool: ...
    @property
    def canProduceShips(self) -> bool: ...
    @property
    def description(self) -> str: ...
    @property
    def dislikes(self) -> Sequence[str]: ...
    @property
    def foci(self) -> Sequence[str]: ...
    @property
    def homeworlds(self) -> Set[int]: ...
    @property
    def likes(self) -> Sequence[str]: ...
    @property
    def name(self) -> str: ...
    @property
    def native(self) -> bool: ...
    @property
    def preferredFocus(self) -> str: ...
    @property
    def spawnlimit(self) -> int: ...
    @property
    def spawnrate(self) -> float: ...
    @property
    def tags(self) -> Sequence[str]: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def getPlanetEnvironment(self, planet_type: planetType) -> planetEnvironment: ...

class tech:
    @property
    def category(self) -> str: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def prerequisites(self) -> Sequence[str]: ...
    @property
    def shortDescription(self) -> str: ...
    @property
    def unlockedItems(self) -> Sequence[UnlockableItem]: ...
    @property
    def unlockedTechs(self) -> Sequence[str]: ...
    def perTurnCost(self, number: int) -> float: ...
    def recursivePrerequisites(self, number: int) -> Sequence[str]: ...
    def researchCost(self, number: int) -> float: ...
    def researchTime(self, number: int) -> int: ...

class universe:
    @property
    def buildingIDs(self) -> Sequence[BuildingId]: ...
    @property
    def effectAccounting(self) -> Mapping[int, Mapping[meterType, Sequence[AccountingInfo]]]: ...
    @property
    def fieldIDs(self) -> Sequence[int]: ...
    @property
    def fleetIDs(self) -> Sequence[FleetId]: ...
    @property
    def planetIDs(self) -> Sequence[PlanetId]: ...
    @property
    def shipIDs(self) -> Sequence[ShipId]: ...
    @property
    def systemIDs(self) -> Sequence[SystemId]: ...
    def destroyedObjectIDs(self, number: int) -> Set[int]: ...
    def dump(self) -> None: ...
    def getBuilding(self, number: int) -> building: ...
    def getField(self, number: int) -> field: ...
    def getFleet(self, number: int) -> fleet: ...
    def getGenericShipDesign(self, string: str) -> shipDesign:
        """
        Returns the ship design (ShipDesign) with the indicated name (string).
        """
    def getImmediateNeighbors(self, number1: int, number2: int) -> Sequence[int]: ...
    def getObject(self, number: int) -> universeObject: ...
    def getPlanet(self, number: int) -> planet: ...
    def getShip(self, number: int) -> ship: ...
    def getSystem(self, number: int) -> system: ...
    def getSystemNeighborsMap(self, number1: int, number2: int) -> Mapping[int, float]: ...
    def getVisibility(self, number1: int, number2: int) -> visibility: ...
    def getVisibilityTurnsMap(self, number1: int, number2: int) -> Mapping[visibility, int]: ...
    def jumpDistance(self, number1: int, number2: int) -> int:
        """
        If two system ids are passed or both objects are within a system, return the jump distance between the two systems. If one object (e.g. a fleet) is on a starlane, then calculate the jump distance from both ends of the starlane to the target system and return the smaller one.
        """
    def leastJumpsPath(self, number1: int, number2: int, number3: int) -> Sequence[int]: ...
    def linearDistance(self, number1: int, number2: int) -> float: ...
    def shortestNonHostilePath(self, number1: int, number2: int, number3: int) -> Sequence[int]:
        """
        Shortest sequence of System ids and distance from System (number1) to System (number2) with no hostile Fleets as determined by visibility of Empire (number3).  (number3) must be a valid empire.
        """
    def shortestPath(self, number1: int, number2: int, number3: int) -> Sequence[int]: ...
    def shortestPathDistance(self, number1: int, number2: int) -> float: ...
    def statRecords(self) -> Mapping[str, Mapping[int, Mapping[int, float]]]:
        """
        Empire statistics recorded by the server each turn. Indexed first by staistic name (string), then by empire id (int), then by turn number (int), pointing to the statisic value (double).
        """
    def systemHasStarlane(self, number1: int, number2: int) -> bool: ...
    def systemsConnected(self, number1: int, number2: int, number3: int) -> bool: ...
    def updateMeterEstimates(self, obj: object) -> None: ...

class universeObject:
    @property
    def ageInTurns(self): ...
    @property
    def containedObjects(self): ...
    @property
    def containerObject(self): ...
    @property
    def creationTurn(self): ...
    @property
    def id(self) -> ObjectId: ...
    @property
    def meters(self): ...
    @property
    def name(self) -> str: ...
    @property
    def owner(self) -> EmpireId: ...
    @property
    def specials(self) -> SpeciesName: ...
    @property
    def systemID(self) -> SystemId: ...
    @property
    def tags(self): ...
    @property
    def unowned(self): ...
    @property
    def x(self): ...
    @property
    def y(self): ...
    def containedBy(self, number: int) -> bool: ...
    def contains(self, number: int) -> bool: ...
    def currentMeterValue(self, meter_type: meterType) -> float: ...
    def dump(self) -> str:
        """
        Returns string with debug information.
        """
    def getMeter(self, meter_type: meterType) -> meter: ...
    def hasSpecial(self, obj: object) -> bool: ...
    def hasTag(self, string: str) -> bool: ...
    def initialMeterValue(self, meter_type: meterType) -> float: ...
    def ownedBy(self, number: int) -> bool: ...
    def specialAddedOnTurn(self, obj: object) -> int: ...

class building(universeObject):
    @property
    def buildingTypeName(self) -> BuildingName: ...
    @property
    def orderedScrapped(self) -> bool: ...
    @property
    def planetID(self) -> PlanetId: ...
    @property
    def producedByEmpireID(self) -> EmpireId: ...

class field(universeObject):
    @property
    def fieldTypeName(self) -> str: ...
    @overload
    def inField(self, base_object: universeObject) -> bool: ...
    @overload
    def inField(self, floating_number1: float, floating_number2: float) -> bool: ...
    def inField(*args) -> bool: ...

class fleet(universeObject):
    @property
    def aggression(self) -> fleetAggression: ...
    @property
    def aggressive(self) -> bool: ...
    @property
    def canChangeDirectionEnRoute(self) -> bool: ...
    @property
    def empty(self) -> bool: ...
    @property
    def finalDestinationID(self) -> int: ...
    @property
    def fuel(self) -> float: ...
    @property
    def hasArmedShips(self) -> bool: ...
    @property
    def hasColonyShips(self) -> bool: ...
    @property
    def hasFighterShips(self) -> bool: ...
    @property
    def hasMonsters(self) -> bool: ...
    @property
    def hasOutpostShips(self) -> bool: ...
    @property
    def hasTroopShips(self) -> bool: ...
    @property
    def maxFuel(self) -> float: ...
    @property
    def nextSystemID(self) -> int: ...
    @property
    def numShips(self) -> int: ...
    @property
    def obstructive(self) -> bool: ...
    @property
    def previousSystemID(self) -> int: ...
    @property
    def route(self) -> Sequence[int]: ...
    @property
    def shipIDs(self) -> Sequence[ShipId]: ...
    @property
    def speed(self) -> float: ...

class planet(universeObject):
    @property
    def availableFoci(self) -> Sequence[str]: ...
    @property
    def buildingIDs(self) -> Sequence[BuildingId]: ...
    @property
    def clockwiseNextPlanetType(self) -> planetType: ...
    @property
    def counterClockwiseNextPlanetType(self) -> planetType: ...
    @property
    def distanceFromOriginalType(self) -> int: ...
    @property
    def focus(self) -> str: ...
    @property
    def habitableSize(self) -> int: ...
    @property
    def lastColonizedByEmpire(self) -> int: ...
    @property
    def lastInvadedByEmpire(self) -> int: ...
    @property
    def lastTurnAttackedByShip(self) -> int: ...
    @property
    def lastTurnColonized(self) -> int: ...
    @property
    def lastTurnConquered(self) -> int: ...
    @property
    def nextLargerPlanetSize(self) -> planetSize: ...
    @property
    def nextSmallerPlanetSize(self) -> planetSize: ...
    @property
    def originalType(self) -> planetType: ...
    @property
    def ownerBeforeLastConquered(self) -> int: ...
    @property
    def size(self) -> planetSize: ...
    @property
    def speciesName(self) -> SpeciesName: ...
    @property
    def turnsSinceFocusChange(self) -> int: ...
    @property
    def type(self) -> planetType: ...
    def OrbitalPositionOnTurn(self, number: int) -> float: ...
    def environmentForSpecies(self, string: str) -> planetEnvironment: ...
    def nextBetterPlanetTypeForSpecies(self, obj: object, string: str) -> planetType: ...

class ship(universeObject):
    @property
    def arrivedOnTurn(self) -> int: ...
    @property
    def canBombard(self) -> bool: ...
    @property
    def canColonize(self) -> bool: ...
    @property
    def canInvade(self) -> bool: ...
    @property
    def colonyCapacity(self) -> float: ...
    @property
    def design(self) -> shipDesign: ...
    @property
    def designID(self) -> int: ...
    @property
    def fleetID(self) -> int: ...
    @property
    def hasFighters(self) -> bool: ...
    @property
    def isArmed(self) -> bool: ...
    @property
    def isMonster(self) -> bool: ...
    @property
    def lastResuppliedOnTurn(self) -> int: ...
    @property
    def lastTurnActiveInCombat(self) -> int: ...
    @property
    def orderedColonizePlanet(self) -> int: ...
    @property
    def orderedInvadePlanet(self) -> int: ...
    @property
    def orderedScrapped(self) -> bool: ...
    @property
    def partMeters(self) -> Mapping[tuple[meterType, meterType], meter]: ...
    @property
    def producedByEmpireID(self) -> EmpireId: ...
    @property
    def speciesName(self) -> SpeciesName: ...
    @property
    def speed(self) -> float: ...
    @property
    def troopCapacity(self) -> float: ...
    def currentPartMeterValue(self, meter_type: meterType, string: str) -> float: ...
    def initialPartMeterValue(self, meter_type: meterType, string: str) -> float: ...

class system(universeObject):
    @property
    def buildingIDs(self) -> Sequence[BuildingId]: ...
    @property
    def fieldIDs(self) -> Sequence[int]: ...
    @property
    def fleetIDs(self) -> Sequence[FleetId]: ...
    @property
    def lastTurnBattleHere(self) -> int: ...
    @property
    def numStarlanes(self) -> int: ...
    @property
    def numWormholes(self) -> int: ...
    @property
    def planetIDs(self) -> Sequence[PlanetId]: ...
    @property
    def shipIDs(self) -> Sequence[ShipId]: ...
    @property
    def starType(self) -> starType: ...
    @property
    def starlanesWormholes(self) -> Mapping[int, bool]: ...
    def HasStarlaneToSystemID(self, number: int) -> bool: ...
    def HasWormholeToSystemID(self, number: int) -> bool:
        """
        Currently unused.
        """

class aggression(IntEnum):
    invalid = -1
    beginner = 0
    turtle = 1
    cautious = 2
    typical = 3
    aggressive = 4
    maniacal = 5

class buildType(IntEnum):
    INVALID_BUILD_TYPE = -1
    BT_NOT_BUILDING = 0
    BT_BUILDING = 1
    BT_SHIP = 2
    BT_PROJECT = 3
    BT_STOCKPILE = 4
    NUM_BUILD_TYPES = 5

class captureResult(IntEnum):
    capture = 0
    destroy = 1
    retain = 2

class diplomaticMessageType(IntEnum):
    noMessage = -1
    warDeclaration = 0
    peaceProposal = 1
    acceptPeaceProposal = 2
    alliesProposal = 3
    acceptAlliesProposal = 4
    endAllies = 5
    cancelProposal = 6
    rejectProposal = 7

class diplomaticStatus(IntEnum):
    war = 0
    peace = 1
    allied = 2

class effectsCauseType(IntEnum):
    invalid = -1
    unknown = 0
    inherent = 1
    tech = 2
    building = 3
    field = 4
    special = 5
    species = 6
    shipPart = 7
    shipHull = 8
    policy = 9

class fleetAggression(IntEnum):
    passive = 0
    defensive = 1
    obstructive = 2
    aggressive = 3

class galaxySetupOptionGeneric(IntEnum):
    invalid = -1
    none = 0
    low = 1
    medium = 2
    high = 3
    random = 4

class galaxySetupOptionMonsterFreq(IntEnum):
    invalid = -1
    none = 0
    extremelyLow = 1
    veryLow = 2
    low = 3
    medium = 4
    high = 5
    veryHigh = 6
    extremelyHigh = 7
    random = 8

class galaxyShape(IntEnum):
    invalid = -1
    spiral2 = 0
    spiral3 = 1
    spiral4 = 2
    cluster = 3
    elliptical = 4
    disc = 5
    box = 6
    irregular = 7
    ring = 8
    random = 9

class meterType(IntEnum):
    targetPopulation = 0
    targetIndustry = 1
    targetResearch = 2
    targetInfluence = 3
    targetConstruction = 4
    targetHappiness = 5
    maxCapacity = 6
    maxSecondaryStat = 7
    maxFuel = 8
    maxShield = 9
    maxStructure = 10
    maxDefense = 11
    maxSupply = 12
    maxStockpile = 13
    maxTroops = 14
    population = 15
    industry = 16
    research = 17
    influence = 18
    construction = 19
    happiness = 20
    capacity = 21
    secondaryStat = 22
    fuel = 23
    shield = 24
    structure = 25
    defense = 26
    supply = 27
    stockpile = 28
    troops = 29
    rebels = 30
    size = 31
    stealth = 32
    detection = 33
    speed = 34

class planetEnvironment(IntEnum):
    uninhabitable = 0
    hostile = 1
    poor = 2
    adequate = 3
    good = 4

class planetSize(IntEnum):
    unknown = -1
    noWorld = 0
    tiny = 1
    small = 2
    medium = 3
    large = 4
    huge = 5
    asteroids = 6
    gasGiant = 7

class planetType(IntEnum):
    unknown = -1
    swamp = 0
    toxic = 1
    inferno = 2
    radiated = 3
    barren = 4
    tundra = 5
    desert = 6
    terran = 7
    ocean = 8
    asteroids = 9
    gasGiant = 10

class resourceType(IntEnum):
    industry = 0
    influence = 1
    research = 2
    stockpile = 3

class roleType(IntEnum):
    host = 0
    clientTypeModerator = 1
    clientTypePlayer = 2
    clientTypeObserver = 3
    galaxySetup = 4

class ruleType(IntEnum):
    invalid = -1
    toggle = 0
    int = 1
    double = 2
    string = 3

class shipPartClass(IntEnum):
    shortRange = 0
    fighterBay = 1
    fighterHangar = 2
    shields = 3
    armour = 4
    troops = 5
    detection = 6
    stealth = 7
    fuel = 8
    colony = 9
    speed = 10
    general = 11
    bombard = 12
    industry = 13
    research = 14
    influence = 15
    productionLocation = 16

class shipSlotType(IntEnum):
    external = 0
    internal = 1
    core = 2

class starType(IntEnum):
    unknown = -1
    blue = 0
    white = 1
    yellow = 2
    orange = 3
    red = 4
    neutron = 5
    blackHole = 6
    noStar = 7

class techStatus(IntEnum):
    unresearchable = 0
    partiallyUnlocked = 1
    researchable = 2
    complete = 3

class unlockableItemType(IntEnum):
    invalid = -1
    building = 0
    shipPart = 1
    shipHull = 2
    shipDesign = 3
    tech = 4
    policy = 5

class visibility(IntEnum):
    invalid = -1
    none = 0
    basic = 1
    partial = 2
    full = 3

def allEmpireIDs() -> Sequence[EmpireId]:
    """
    Returns an object (intVec) that contains the empire IDs of all empires in the game.
    """

def allPlayerIDs() -> Sequence[int]:
    """
    Returns an object (intVec) that contains the player IDs of all players in the game.
    """

def appendFleetMoveOrder(number1: int, number2: int) -> int:
    """
    Orders the fleet with indicated fleetID (int) to append the system with the indicated destinationID (int) to its possibly already enqueued route. Returns 1 (int) on success or 0 (int) on failure due to not finding the indicated fleet or system.
    """

def currentTurn() -> Turn:
    """
    Returns the current game turn (int).
    """

def empireID() -> EmpireId:
    """
    Returns the empire ID (int) of this AI player's empire.
    """

def empirePlayerID(number: int) -> PlayerId:
    """
    Returns the player ID (int) of the player who is controlling the empire with the indicated empireID (int).
    """

def getAIDir() -> str: ...
def getBuildingType(string: str) -> buildingType:
    """
    Returns the building type (BuildingType) with the indicated name (string).
    """

def getDiplomaticStatus(number1: int, number2: int) -> diplomaticStatus:
    """
    Returns the diplomatic status between two empires
    """

@overload
def getEmpire() -> empire: ...
@overload
def getEmpire(number: int) -> empire: ...
def getEmpire(*args) -> empire:
    """
    Returns the empire object (Empire) of this AI player
    Returns the empire object (Empire) with the specified empire ID (int)
    """

def getFieldType(string: str) -> fieldType: ...
def getGalaxySetupData() -> GalaxySetupData: ...
def getGameRules() -> GameRules:
    """
    Returns the game rules manager, which can be used to look up the names (string) of rules are defined with what type (boolean / toggle, int, double, string), and what values the rules have in the current game.
    """

def getNamedInt(string: str) -> int:
    """
    Returns the named integer value of the scripted constant with name (string). If no such named constant exists, returns 0.
    """

def getNamedReal(string: str) -> float:
    """
    Returns the named real value of the scripted constant with name (string). If no such named constant exists, returns 0.0.
    """

def getOptionsDBOptionBool(string: str) -> bool:
    """
    Returns the bool value of option in OptionsDB or None if the option does not exist.
    """

def getOptionsDBOptionDouble(string: str) -> float:
    """
    Returns the double value of option in OptionsDB or None if the option does not exist.
    """

def getOptionsDBOptionInt(string: str) -> int:
    """
    Returns the integer value of option in OptionsDB or None if the option does not exist.
    """

def getOptionsDBOptionStr(string: str) -> str:
    """
    Returns the string value of option in OptionsDB or None if the option does not exist.
    """

def getPolicy(string: str) -> policy:
    """
    Returns the policy (Policy) with the indicated name (string).
    """

def getPredefinedShipDesign(string: str) -> shipDesign:
    """
    Returns the ship design (ShipDesign) with the indicated name (string).
    """

def getSaveStateString() -> str:
    """
    Returns the previously-saved state string (string). Can be used to retrieve the last-set save state string at any time, although this string is also passed to the resumeLoadedGame(savedStateString) Python function when a game is loaded, so this function isn't necessary to use if resumeLoadedGame stores the passed string.
    """

def getShipDesign(number: int) -> shipDesign:
    """
    Returns the ship design (ShipDesign) with the indicated id number (int).
    """

def getShipHull(string: str) -> shipHull:
    """
    Returns the ship hull with the indicated name (string).
    """

def getShipPart(string: str) -> shipPart:
    """
    Returns the ShipPart with the indicated name (string).
    """

def getSpecial(string: str) -> special:
    """
    Returns the special (Special) with the indicated name (string).
    """

def getSpecies(string: str) -> species:
    """
    Returns the species (Species) with the indicated name (string).
    """

def getTech(string: str) -> tech:
    """
    Returns the tech (Tech) with the indicated name (string).
    """

def getTechCategories() -> Sequence[str]:
    """
    Returns the names of all tech categories (StringVec).
    """

def getUniverse() -> universe:
    """
    Returns the universe object (Universe)
    """

def getUserConfigDir() -> str:
    """
    Returns path to directory where FreeOrion stores user specific configuration.
    """

def getUserDataDir() -> str:
    """
    Returns path to directory where FreeOrion stores user specific data (saves, etc.).
    """

def initMeterEstimatesDiscrepancies() -> None:
    """
    For all objects and max / target meters, determines discrepancies between actual meters and what the known universe should produce. This is used later when updating meter estimates to incorporate those discrepancies.
    """

def isEnqueuableBuilding(string: str, number: int) -> bool:
    """
    Returns true if the specified building type (string) can be enqueued by this client's empire at the specified production location (int). Being enqueuable means that the item can be added to the queue, but does not mean that the item will be allocated production points once  it is added
    """

def isEnqueuableShip(number1: int, number2: int) -> bool:
    """
    Returns true if the specified ship design (int) can be enqueued by this client's empire at the specified production location (int). Enqueued ships should always also be producible, and thus able to be allocated production points once enqueued, if any are available at the production location.
    """

def isProducibleBuilding(string: str, number: int) -> bool:
    """
    Returns true if the specified building type (string) can be produced by this client's empire at the specified production location (int). Being producible means that if the item is on the production queue, it can be allocated production points that are available at its location. Being producible does not mean that the building type can be added to the queue.
    """

def issueAdoptPolicyOrder(string1: str, string2: str, number: int) -> int:
    """
    Orders the policy with name policyName (string) to be adopted by the empire in the category categoryName (string) and slot slot (int). Returns 1 (int) on success or 0 (int) on failure if the indicated policy can't be found. Will return 1 (int) but do nothing if the indicated policy can't be enqueued by this player's empire in the requested category and slot.
    """

def issueAggressionOrder(number: int, boolean: bool) -> int: ...
def issueAllowStockpileProductionOrder(number: int, boolean: bool) -> int:
    """
    Orders the item on the production queue at index queueIndex (int) to be enabled (or disabled) to use the imperial stockpile. Returns 1 (int) on success or 0 (int) on failure if the queue index is less than 0 or greater than the largest indexed item on the queue.
    """

def issueBombardOrder(number1: int, number2: int) -> int: ...
def issueChangeFocusOrder(number: int, string: str) -> int:
    """
    Orders the planet with ID planetID (int) to use focus setting focus (string). Returns 1 (int) on success or 0 (int) on failure if the planet can't be found or isn't owned by this player, or if the specified focus is not valid on the planet.
    """

def issueChangeProductionQuantityOrder(number1: int, number2: int, number3: int) -> int: ...
def issueColonizeOrder(number1: int, number2: int) -> int:
    """
    Orders the ship with ID shipID (int) to colonize the planet with ID planetID (int). Returns 1 (int) on success or 0 (int) on failure due to not finding the indicated ship or planet, this client's player not owning the indicated ship, the planet already being colonized, or the planet and ship not being in the same system.
    """

def issueCreateShipDesignOrder(
    string1: str,
    string2: str,
    string3: str,
    item_list: list,
    string4: str,
    string5: str,
    boolean: bool,
) -> int:
    """
    Orders the creation of a new ship design with the name (string), description (string), hull (string), parts vector partsVec (StringVec), graphic (string) and model (string). model should be left as an empty string as of this writing. There is currently no easy way to find the id of the new design, though the client's empire should have the new design after this order is issued successfully. Returns 1 (int) on success or 0 (int) on failure if any of the name, description, hull or graphic are empty strings, if the design is invalid (due to not following number and type of slot requirements for the hull) or if creating the design fails for some reason.
    """

def issueDeadoptPolicyOrder(string: str) -> int:
    """
    Orders the policy with name policyName (string) to be de-adopted by the empire. Returns 1 (int) on success or 0 (int) on failure if the indicated policy was not already adopted.
    """

def issueDequeueProductionOrder(number: int) -> int:
    """
    Orders the item on the production queue at index queueIndex (int) to be removed form the production queue. Returns 1 (int) on success or 0 (int) on failure if the queue index is less than 0 or greater than the largest indexed item on the queue.
    """

def issueDequeueTechOrder(string: str) -> int:
    """
    Orders the tech with name techName (string) to be removed from the queue. Returns 1 (int) on success or 0 (int) on failure if the indicated tech can't be found. Will return 1 (int) but do nothing if the indicated tech isn't on this player's empire's tech queue.
    """

def issueEnqueueBuildingProductionOrder(string: str, number: int) -> int:
    """
    Orders the building with name (string) to be added to the production queue at the location of the planet with id locationID. Returns 1 (int) on success or 0 (int) on failure if there is no such building or it is not available to this player's empire, or if the building can't be produced at the specified location.
    """

def issueEnqueueShipProductionOrder(number1: int, number2: int) -> int:
    """
    Orders the ship design with ID designID (int) to be added to the production queue at the location of the planet with id locationID (int). Returns 1 (int) on success or 0 (int) on failure there is no such ship design or it not available to this player's empire, or if the design can't be produced at the specified location.
    """

def issueEnqueueTechOrder(string: str, number: int) -> int:
    """
    Orders the tech with name techName (string) to be added to the tech queue at position (int) on the queue. Returns 1 (int) on success or 0 (int) on failure if the indicated tech can't be found. Will return 1 (int) but do nothing if the indicated tech can't be enqueued by this player's empire.
    """

def issueFleetMoveOrder(number1: int, number2: int) -> int:
    """
    Orders the fleet with indicated fleetID (int) to move to the system with the indicated destinationID (int). Returns 1 (int) on success or 0 (int) on failure due to not finding the indicated fleet or system.
    """

def issueFleetTransferOrder(number1: int, number2: int) -> int:
    """
    Orders the ship with ID shipID (int) to be transferred to the fleet with ID newFleetID. Returns 1 (int) on success, or 0 (int) on failure due to not finding the fleet or ship, or the client's empire not owning either, or the two not being in the same system (or either not being in a system) or the ship already being in the fleet.
    """

def issueGiveObjectToEmpireOrder(number1: int, number2: int) -> int: ...
def issueInvadeOrder(number1: int, number2: int) -> int: ...
def issueNewFleetOrder(string: str, number: int) -> int:
    """
    Orders a new fleet to be created with the indicated name (string) and containing the indicated shipIDs (IntVec). The ships must be located in the same system and must all be owned by this player. Returns the new fleets id (int) on success or 0 (int) on failure due to one of the noted conditions not being met.
    """

def issuePauseProductionOrder(number: int, boolean: bool) -> int:
    """
    Orders the item on the production queue at index queueIndex (int) to be paused (or unpaused). Returns 1 (int) on success or 0 (int) on failure if the queue index is less than 0 or greater than the largest indexed item on the queue.
    """

def issueRenameOrder(number: int, string: str) -> int:
    """
    Orders the renaming of the object with indicated objectID (int) to the new indicated name (string). Returns 1 (int) on success or 0 (int) on failure due to this AI player not being able to rename the indicated object (which this player must fully own, and which must be a fleet, ship or planet).
    """

def issueRequeueProductionOrder(number1: int, number2: int) -> int:
    """
    Orders the item on the production queue at index oldQueueIndex (int) to be moved to index newQueueIndex (int). Returns 1 (int) on success or 0 (int) on failure if the old and new queue indices are equal, if either queue index is less than 0 or greater than the largest indexed item on the queue.
    """

def issueScrapOrder(number: int) -> int:
    """
    Orders the ship or building with the indicated objectID (int) to be scrapped. Returns 1 (int) on success or 0 (int) on failure due to not finding a ship or building with the indicated ID, or if the indicated ship or building is not owned by this AI client's empire.
    """

def namedIntDefined(string: str) -> bool:
    """
    Returns true/false (boolean) whether there is a defined int-valued scripted constant with name (string).
    """

def namedRealDefined(string: str) -> bool:
    """
    Returns true/false (boolean) whether there is a defined double-valued scripted constant with name (string).
    """

def playerEmpireID(number: int) -> int:
    """
    Returns the empire ID (int) of the player with the specified player ID (int).
    """

def playerID() -> int:
    """
    Returns the integer id of this AI player.
    """

def playerIsAI(number: int) -> bool:
    """
    Returns True (boolean) if the player with the indicated playerID (int) is controlled by an AI and false (boolean) otherwise.
    """

def playerIsHost(number: int) -> bool:
    """
    Returns True (boolean) if the player with the indicated playerID (int) is the host player for the game and false (boolean) otherwise.
    """

@overload
def playerName() -> str: ...
@overload
def playerName(number: int) -> str: ...
def playerName(*args) -> str:
    """
    Returns the name (string) of this AI player.
    Returns the name (string) of the player with the indicated playerID (int).
    """

def policies() -> Sequence[str]:
    """
    Returns the names of all policies (StringVec).
    """

def policiesInCategory(string: str) -> Sequence[str]:
    """
    Returns the names of all policies (StringVec) in the indicated policy category name (string).
    """

def policyCategories() -> Sequence[str]:
    """
    Returns the names of all policy categories (StringVec).
    """

def sendChatMessage(number: int, string: str) -> None:
    """
    Sends the indicated message (string) to the player with the indicated recipientID (int) or to all players if recipientID is -1.
    """

def sendDiplomaticMessage(diplomatic_message: diplomaticMessage) -> None: ...
def setSaveStateString(string: str) -> None:
    """
    Sets the save state string (string). This is a persistant storage space for the AI script to retain state information when the game is saved and reloaded. Any AI state information to be saved should be stored in a single string (likely using Python's pickle module) and stored using this function when the prepareForSave() Python function is called.
    """

def techs() -> Sequence[str]:
    """
    Returns the names of all techs (StringVec).
    """

def techsInCategory(string: str) -> Sequence[str]:
    """
    Returns the names of all techs (StringVec) in the indicated tech category name (string).
    """

def updateMeterEstimates(boolean: bool) -> None: ...
def updateProductionQueue() -> None: ...
def updateResearchQueue() -> None: ...
def updateResourcePools() -> None: ...
def userString(string: str) -> str: ...
def userStringExists(string: str) -> bool: ...
def userStringList(string: str) -> list: ...
def validShipDesign(string: str, item_list: list) -> bool:
    """
    Returns true (boolean) if the passed hull (string) and parts (list of string) make up a valid ship design, and false (boolean) otherwise. Valid ship designs don't have any parts in slots that can't accept that type of part, and contain only hulls and parts that exist (and may also need to contain the correct number of parts - this needs to be verified).
    """
