/* File: "main.c", Time-stamp: <2010-11-30 17:33:36 feeley> */

/* Copyright (c) 2010 by Marc Feeley, All Rights Reserved. */

#include <stdio.h>
#include <stdlib.h>

/*
 * ___VERSION must match the version number of the Gambit header file.
 */

#define ___VERSION 406000
#include "gambit.h"

/*
 * When the link file is generated by the command
 *
 *   gsc -link -o prog_.c mod3.c mod4.c
 *
 * the link file "prog_.c" is generated.  It contains various tables
 * (symbols, global variables, list of modules, etc) describing the
 * set of Scheme modules that are linked.  The link file is needed to
 * initialize the Scheme runtime system.
 *
 * The symbol SCHEME_LINKER must be defined as the name of the Scheme
 * link file stripped of the extension, prefixed with "____20_" and
 * the character "_" transformed to "__".  This is the name of the
 * function in the link file that initializes the Scheme modules.
 */

#define SCHEME_LINKER ____20_prog__

___BEGIN_C_LINKAGE
extern ___mod_or_lnk SCHEME_LINKER(___global_state_struct*);
___END_C_LINKAGE

/*
 * [This is optional] Include mod3.h which contains the prototype of
 * the function "print_info" which we call in the main program.
 */

#include "mod3.h"

int main(int argc, char *argv[])
{
  /*
   * Setup the Scheme library by calling "___setup" with appropriate
   * parameters.  The call to "___setup_params_reset" sets all
   * parameters to their default setting.  The call to "___setup" also
   * runs the Scheme code at toplevel.  After the call to "___setup"
   * and before the call to "___cleanup" it is possible to call Scheme
   * functions from C if required.
   */

  ___setup_params_struct setup_params;

  ___setup_params_reset(&setup_params);

  setup_params.version = ___VERSION;
  setup_params.linker  = SCHEME_LINKER;

  ___setup(&setup_params);

  /*
   * [This is optional] We call a Scheme function, defined in mod3.scm,
   * just to show how it is done.  A string is passed to the Scheme
   * function "print-info" and that function returns a string.
   */

  {
    char *temp = print_info("Sussman and Steele");
    if (temp != NULL)
      {
        printf("Gambit was created by %s\n", temp);
        fflush(stdout);
        ___release_string(temp); /* don't forget to reclaim string */
      }
  }

  /*
   * Cleanup the Scheme runtime.
   */

  ___cleanup();

  return 0;
}
