/* 
GeoGebra - Dynamic Mathematics for Everyone
http://www.geogebra.org

This file is part of GeoGebra.

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by 
the Free Software Foundation.

*/
package geogebra.kernel;

/**
 * Represents geos with endpoints (segment, ray, arc, etc.)
 *
 */
public interface LimitedPath extends Path {
	
	/**
	 * Returns whether intersection points with this
	 * path are allowed
	 * that lie on the extension of this path.
	 * @return true iff outlying intersection should be allowed
	 */
	public boolean allowOutlyingIntersections();
	
	/**
	 * Sets whether intersection points with this
	 * path are allowed
	 * that lie on the extension of this path.
	 * @param flag true iff outlying intersection should be allowed
	 */
	public void setAllowOutlyingIntersections(boolean flag);
	
	/**
	 * Returns true iff the intersection point P lies on 
	 * this limited path.
	 * @param P
	 * @param eps epsilon precision for testing
	 * @return true iff the intersection point P lies on 
	 * this limited path.

	 */
	public boolean isIntersectionPointIncident(GeoPoint P, double eps);
	
	/**
	 * Returns whether a geometric transform of this
	 * path should yield an object of the same kind
	 * (i.e. segment becomes segment).
	 * @return true iff the geo keeps type on transform
	 */
	public boolean keepsTypeOnGeometricTransform();
			
	/**
	 * Sets whether a geometric transform of this
	 * path should yield an object of the same kind
	 * (i.e. segment becomes segment).
	 * @param flag true when a geometric transform of this
	 * path should yield an object of the same kind
	 */
	public void setKeepTypeOnGeometricTransform(boolean flag);
	
	/**
	 * Creates a new object using the geometrical transform of the given type.
	 * @param t transform
	 * @return array of elements generated by transform
	 */
	public GeoElement [] createTransformedObject(Transform t,String label);
	
	/**
	 * Returns true iff all endpoints are labeled
	 * @return true iff all endpoints are labeled
	 */
	public boolean isAllEndpointsLabelsSet() ;
	
}
