------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                       Copyright (C) 2011, AdaCore                        --
--                                                                          --
-- GPS is free software;  you can  redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT; see file COPYING3.  If not, go to --
-- http://www.gnu.org/licenses for a complete copy of the license.          --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines several helper subprograms to easily extract the
--  result of the MI parser in order to test MI.Utils routines.

with MI.Ast;                   use MI.Ast;

with Ada.Text_IO.Text_Streams; use Ada.Text_IO.Text_Streams;

package Read_File_Helper is

   Helper_Error : exception;
   --  The default exception raise by this compilation unit.

   function MI_Open (File_Name : String) return Stream_Access;
   --  This function opens the MI output file referred by File_Name and returns
   --  a Stream_Access to the content.

   procedure MI_Parse
     (Stream : Stream_Access;
      Result : out Record_List);
   --  This subprogram parse the stream containing MI output and build the
   --  Record_List from it.

   procedure MI_Extract_First_Record
     (Result : Record_List;
      Rec    : out MI_Record_Access);
   --  This subprogram extracts the first MI_Record from the given Record_List
   --  or raise a Helper_Error on error.

   function MI_Get_First_Record (File_Name : String) return MI_Record_Access;
   --  This function calls the three above subprogram to extract the first
   --  record of a MI output expression stored in the file pointed to by
   --  File_Name.

end Read_File_Helper;
