/*
-----------------------------------------------------------------------------
 hex_strings.h - Definitions for strings used in the gogoc application.
-----------------------------------------------------------------------------
 $Id: hex_strings.h,v 1.4 2010/03/07 19:53:19 carl Exp $
-----------------------------------------------------------------------------
  Copyright (c) 2007 gogo6 Inc. All rights reserved.

  For license information refer to CLIENT-LICENSE.TXT.
-----------------------------------------------------------------------------
*/

#ifndef _GOGO_STRINGS_H_
#define _GOGO_STRINGS_H_


#define TARGET_NAME "gogoc"


#define GOGO_STR_ENV_PRINT_VALUE                           "%-30.30s   %s"
#define GOGO_STR_NOT_DEF_AS_CLIENT_ERROR                   "%i is not defined as a client error. Might be a TSP error?"
#define GOGO_STR_UNKNOWN_HOST_ADD_KEY                      "%s is an unknown host, do you want to add its key?"
#define GOGO_STR_WARN_SERVER_KEY_AUTO_ADDED                "Server key has been automatically added."
#define GOGO_STR_WARN_STORED_LOCAL_KEY_NO_MATCH            "Local key stored in %s for host %s doesn't match host key. *NOT CONNECTING*"
#define GOGO_STR_API_EQUALS                                "API = %s, "
#define GOGO_STR_BN_BN2BIN_FAILED                          "oi %d != bin_size %d."
#define GOGO_STR_BAD_CLIENT_IPV4_RECVD                     "Bad value received from server for client_address_ipv4."
#define GOGO_STR_BAD_CLIENT_IPV6_RECVD                     "Bad value received from server for client_address_ipv6."
#define GOGO_STR_BAD_CLIENT_DNS_IPV6_RECVD                 "Bad value received from server for client_dns_server_address_ipv6."
#define GOGO_STR_BAD_SERVER_PREFIX_RECVD                   "Bad value received from server for prefix."
#define GOGO_STR_BAD_PREFIX_LEN_RECVD                      "Bad value received from server for prefix_length."
#define GOGO_STR_BAD_SERVER_IPV4_RECVD                     "Bad value received from server for server_address_ipv4."
#define GOGO_STR_BAD_SERVER_IPV6_RECVD                     "Bad value received from server for server_address_ipv6."
#define GOGO_STR_CANT_OPEN_TMP_FILE                        "Failed to open temporary file."
#define GOGO_STR_GOGOTUN_V4V6_NOT_INSTALLED                "gogo6 Multi-Tunnel Virtual Adapter is missing and is required for V4V6 tunneling."
#define GOGO_STR_GOGOTUN_V6UDPV4_NOT_INSTALLED             "gogo6 Multi-Tunnel Virtual Adapter is missing and is required for V6UDPV4 tunneling."
#define GOGO_STR_CANNOT_OPEN_LOG_FILE                      "Failed to open log file %s."
#define GOGO_STR_CHECKING_LINUX_IPV6_SUPPORT               "Checking for Linux IPv6 support..."
#define GOGO_STR_SETUP_PROXY                               "Client proxying is %s."
#define GOGO_STR_CANT_DELETE_SERVICE                       "Failed to delete service %s: %i."
#define GOGO_STR_CANT_OPEN_SCM                             "Failed to open the SCM."
#define GOGO_STR_DH_GEN_ERROR                              "DH generation error."
#define GOGO_STR_DH_SHARED_COMPUTE_ERROR                   "DH shared key computation error."
#define GOGO_STR_DH_SHARED_KEY                             "DH shared key: %s."
#define GOGO_STR_INITIALIZATION_ERROR                      "DH initialization error."
#define GOGO_STR_DSA_SIGN_R                                "DSA sign r:%s."
#define GOGO_STR_DSA_SIGN_S                                "DSA sign s:%s."
#define GOGO_STR_KEY_VERIF_ERROR                           "Key verification error."
#define GOGO_STR_START_SRVS_CTRL_DISP_ERR_CODE             "Error code for StartServiceCtrlDispatcher: %u."
#define GOGO_STR_ERR_CONFIG_TUN_DEV_REASON                 "Failed to configure tun device %s : %s."
#define GOGO_STR_ERR_CONFIG_TUN_DEV                        "Failed to configure tun device: %s."
#define GOGO_STR_ERR_FROM_CFG_FILE                         "Error from config file: %s."
#define GOGO_STR_ERR_IN_KEY_VERIF                          "Failed key verification."
#define GOGO_STR_ERR_OPEN_DEV                              "Failed to open device: %s."
#define GOGO_STR_ERR_OPEN_TUN_DEV                          "Failed to open tun device: %s."
#define GOGO_STR_ERR_ROTATING_LOG_FILE                     "Failed to rotate the log file."
#define GOGO_STR_ERR_FIND_DST_IP                           "Failed to find destination IP address."
#define GOGO_STR_ERR_FIND_SRC_IP                           "Failed to find source IP address."
#define GOGO_STR_ERR_FIND_SRC_IP_PORT                      "Failed to find source IP port."
#define GOGO_STR_ERR_WAITING_SCRIPT                        "Failed to wait for the script to complete."
#define GOGO_STR_ERR_SETENV                                "Failed to set environment variable %s: %s"
#define GOGO_STR_FATAL_NOT_ROOT_FOR_TUN                    "You must be root to setup a tunnel."
#define GOGO_STR_CANT_FIND_LOCALHOST_IP                    "Failed to get localhost IP address."
#define GOGO_STR_GOING_DAEMON                              "Going daemon."
#define GOGO_STR_IPV6_SUPPORT_FOUND                        "IPv6 support found."
#define GOGO_STR_NO_IPV6_SUPPORT_FOUND                     "No IPv6 support found."
#define GOGO_STR_BAD_SIG_FROM_SERVER                       "Incorrect signature from server."
#define GOGO_STR_INVALID_PAYLOAD_SIZE                      "Invalid payload size."
#define GOGO_STR_INVALID_RESPONSE_RECEIVED                 "Invalid response received."
#define GOGO_STR_INVALID_VAL_FOR_LOG                       "Config: Invalid value for log: %s."
#define GOGO_STR_LOG_FILE_CLOSED                           "Log file %s closed while it should be open."
#define GOGO_STR_MATCHING_KEY_FOUND_USED                   "Matching server key found and used."
#define GOGO_STR_NO_RUDP_REPLY                             "No RUDP reply."
#define GOGO_STR_NO_CONFIG_CANNOT_LOG_TO_FILE              "Failed to log to file: No configuration."
#define GOGO_STR_NO_LOG_FILENAME_IN_CONFIG                 "Failed to log to file: No log file name in configuration."
#define GOGO_STR_PASSDS_ENC_KEY                            "PASSDSS: encryption key: %s."
#define GOGO_STR_PASSDS_INTEG_KEY                          "PASSDSS: integrity key: %s."
#define GOGO_STR_PASSDS_IV                                 "PASSDSS: iv: %s."
#define GOGO_STR_PAYLOAD_BIGGER_PROTOFRMSIZE               "Payload size is bigger than PROTOCOLFRAMESIZE."
#define GOGO_STR_RCVD_DATA_INVALID                         "Received data is invalid."
#define GOGO_STR_LOG_CFG_RECEIVED_NULL_CFG                 "Received NULL configuration."
#define GOGO_STR_MESSAGE_ROTATING                          "** ROTATING LOG FILE **"
#define GOGO_STR_SERVER_NOT_IPV4                           "Failed to resolve server IPv4 address."
#define GOGO_STR_SERVER_NOT_IPV6                           "Failed to resolve server IPv6 address."
#define GOGO_STR_SERVER_KEY_ACCEPTED_ADDED                 "Server key accepted and added."
#define GOGO_STR_SERVER_KEY_REJECTED                       "Server key rejected."
#define GOGO_STR_SERVER_KEY_REJECTED_USER                  "Server key rejected by the user."
#define GOGO_STR_SERVICE                                   "Service"
#define GOGO_STR_SERVICE_PORT_INVALID                      "Service port not valid: %s."
#define GOGO_STR_CANT_REGISTER_TSP                         "Failed to register "TARGET_NAME" service."
#define GOGO_STR_CANT_UNREGISTER_TSP                       "Failed to unregister "TARGET_NAME" service."
#define GOGO_STR_TSP_REGISTERED                            "Registration of "TARGET_NAME" service successful."
#define GOGO_STR_TSP_UNREGISTERED                          "Unregistration of "TARGET_NAME" service successful."
#define GOGO_STR_SIG_VERIF_ERROR                           "Signature verification error."
#define GOGO_STR_SIGNED_HASH                               "Signed hash: %s."
#define GOGO_STR_TEMPLATE_NOT_FOUND                        "Failed to find \"%s\" template."
#define GOGO_STR_SETUP_HOST_TYPE                           "The host type is '%s'."
#define GOGO_STR_SETUP_TUNNEL_TYPE                         "The tunnel type is %s."
#define GOGO_STR_TRY_MODPROBE_IPV6                         "Try \"modprobe ipv6\"."
#define GOGO_STR_TRY_MODPROBE_TUN                          "Try \"modprobe tun\"."
#define GOGO_STR_CANT_FORK                                 "Failed to fork."
#define GOGO_STR_CANT_READ_TEMPLATE_FROM_CFG               "Failed to read the template name from the config file. Is it specified? Do you have %s in the current directory?"
#define GOGO_STR_CANT_ROTATE_LOG_NO_FILENAME               "Failed to rotate the log file: No file name specified."
#define GOGO_STR_CANT_ROTATE_LOG_CANT_FLUSH                "Failed to rotate the log file: Could not flush contents."
#define GOGO_STR_CANT_ROTATE_LOG_BACKUP_NAME               "Failed to rotate the log file: Could not generate a backup file name."
#define GOGO_STR_CANT_ROTATE_LOG_CANT_COPY                 "Failed to rotate the log file: Could not backup the file."
#define GOGO_STR_CANT_ROTATE_LOG_CANT_OPEN_NEW             "Failed to rotate the log file: Could not open new empty log file."
#define GOGO_STR_CANT_WRITE_LOG_BUFFER_TO_FILE             "Failed to write the log buffer to file. Some logs may be lost."
#define GOGO_STR_CANT_FPRINTF_TO_LOG                       "Failed to write to the log file."
#define GOGO_STR_USING_AUTH_ANONYMOUS                      "Using AUTH-ANONYMOUS authentication mechanism."
#define GOGO_STR_USING_AUTH_PLAIN                          "Using AUTH-PLAIN authentication mechanism."
#define GOGO_STR_USING_AUTH_DIGEST_MD5                     "Using DIGEST-MD5 authentication mechanism."
#define GOGO_STR_USING_AUTH_PASSDSS_3DES_1                 "Using PASSDSS-3DES-1 authentication mechanism."
#define GOGO_STR_VERIF_AND_FIX_CFG_FILE                    "Verifying and fixing the config file..."
#define GOGO_STR_WAITING_FOR_SETUP_SCRIPT                  "Waiting for setup script to complete."
#define GOGO_STR_EXPECTED_CONTENT_LENGTH                   "Was expecting 'Content-length:'. Received %s."
#define GOGO_STR_WRONG_TEMPLATE_NAME                       "Wrong template name in %s. Updating %s -> %s."
#define GOGO_STR_YOUR_IPV4_IP_IS                           "Your IPv4 address is %s."
#define GOGO_STR_YOUR_IPV6_IP_IS                           "Your IPv6 address is %s."
#define GOGO_STR_YOUR_IPV6_DNS_IS                          "Your IPv6 DNS address is %s."
#define GOGO_STR_YOUR_IPV4_PREFIX_IS                       "Your IPv4 prefix is %s/%s."
#define GOGO_STR_YOUR_IPV6_PREFIX_IS                       "Your IPv6 prefix is %s/%s."
#define GOGO_STR_ALLOC_NOT_SUPPORTED                       "alloc %u not supported."
#define GOGO_STR_BAD_STRING_LENGTH                         "Invalid string length %u."
#define GOGO_STR_CANT_HANDLE_BN_SIZE                       "Failed to handle BN of size %d."
#define GOGO_STR_ERROR_CODE_EQUALS                         "Error code = %d, "
#define GOGO_STR_GETNAMEINFO_FAILED                        "getnameinfo() failed: %ld."
#define GOGO_STR_INPUT_BUF_TOO_SMALL                       "Input buffer too small."
#define GOGO_STR_LEN_NOT_SUPPORTED                         "len %u not supported."
#define GOGO_STR_MESSAGE_EQUALS                            "Message = %s"
#define GOGO_STR_RECV_INVALID_TSP_DATA                     "Received invalid TSP data."
#define GOGO_STR_REPLY_RUDP_PACKET                         "Reply: RUDP packet %i, RTO %f, sequence 0x%x timestamp %i."
#define GOGO_STR_RUDP_PACKET                               "RUDP packet %i, RTO %f, sequence 0x%x timestamp %i."
#define GOGO_STR_NO_V4V6_ON_PLATFORM                       "v4v6 is not supported on this platform."
#define GOGO_STR_V4V6_TUNNEL_SETUP_FAILED                  "Failed to setup v4v6 tunnel interface properly."
#define GOGO_STR_V6UDPV4_TUNNEL_SETUP_FAILED               "Failed to setup v6udpv4 tunnel interface properly."
#define GOGO_STR_NO_V6UDPV4_ON_PLATFORM                    "v6udpv4 (NAT traversal) is not supported on this platform."

// Redirection strings.
#define GOGO_STR_RECEIVED_REDIRECTION                      "Received a TSP redirection message from server %s (%s)."
#define GOGO_STR_RDR_ADD_BROKER_INTERNAL_ERR               "Internal error trying to add a server address to the server redirection list."
#define GOGO_STR_RDR_ADD_BROKER_NO_MEM                     "Failed to allocate memory for a new server address in the server redirection list."
#define GOGO_STR_RDR_ADD_BROKER_ADDRESS_TRUNC              "Failed to set server Address in server redirection list: address too long."
#define GOGO_STR_RDR_CREATE_LIST_CANT_ADD                  "Failed to add a new server address while creating the server redirection list."
#define GOGO_STR_RDR_SORTING_BROKER_LIST                   "Sorting the server redirection list."
#define GOGO_STR_RDR_SORT_LIST_CANT_GET_DIST               "Failed to get server timing information while sorting the server redirection list."
#define GOGO_STR_RDR_SORT_LIST_CANT_ALLOC                  "Failed to allocate memory for a new server address while sorting the server redirection list."
#define GOGO_STR_RDR_SORT_LIST_CANT_INSERT                 "Failed to insert a new server address while sorting the server redirection list."
#define GOGO_STR_RDR_CANT_EXTRACT_PAYLOAD                  "Failed to parse the XML payload while handling server redirection."
#define GOGO_STR_RDR_CANT_CREATE_LIST                      "Failed to create the server redirection list."
#define GOGO_STR_RDR_CANT_SORT_LIST                        "Failed to sort the server redirection list."
#define GOGO_STR_RDR_CANT_SAVE_LIST                        "Failed to write the server redirection list to file."
#define GOGO_STR_RDR_CANT_LOG                              "Failed to log server redirection details."
#define GOGO_STR_RDR_NULL_LIST                             "Received an empty server address list while handling server redirection."
#define GOGO_STR_RDR_READ_LAST_SERVER_INT_ERR              "Internal error trying to read the last server address from the last_server file."
#define GOGO_STR_RDR_WRITE_LAST_SERVER_INT_ERR             "Internal error trying to write the last server address to the last_server file."
#define GOGO_STR_RDR_WRITE_LAST_SERVER_CANT_OPEN           "Failed to open %s to save the last server address."
#define GOGO_STR_RDR_WRITE_LAST_SERVER_CANT_WRITE          "Failed to write last server address %s to %s."
#define GOGO_STR_RDR_WRITE_BROKER_LIST_INT_ERR             "Internal error trying to write the server redirection list to the broker_list file."
#define GOGO_STR_RDR_WRITE_BROKER_LIST_CANT_OPEN           "Failed to open %s to save the server redirection list."
#define GOGO_STR_RDR_WRITE_BROKER_LIST_CANT_WRITE          "Failed to write the server redirection list to %s."
#define GOGO_STR_RDR_READ_BROKER_LIST_CANT_ADD             "Failed to add a new server address while creating the server redirection list from file %s."
#define GOGO_STR_RDR_TRYING_LAST_SERVER                    "Trying last server address %s."
#define GOGO_STR_RDR_NO_LAST_SERVER_FOUND                  "Failed to find last server in last_server file %s. Trying server address %s instead."
#define GOGO_STR_RDR_CANT_OPEN_LAST_SERVER                 "Failed to open last_server file %s. Trying server %s instead."
#define GOGO_STR_RDR_ERROR_READING_LAST_SERVER             "Failed to read the last_server file %s."
#define GOGO_STR_RDR_READING_BROKER_LIST                   "Trying to read the server redirection list from broker_list file %s."
#define GOGO_STR_RDR_READ_BROKER_LIST_EMPTY                "The server redirection list is empty."
#define GOGO_STR_RDR_READ_BROKER_LIST_CREATED              "The server redirection list was created successfully."
#define GOGO_STR_RDR_CANT_OPEN_BROKER_LIST                 "Failed to open broker_list file %s."
#define GOGO_STR_RDR_ERROR_READING_BROKER_LIST             "Failed to create the server redirection list from broker_list file %s."
#define GOGO_STR_RDR_BROKER_LIST_END                       "Reached the end of the server redirection list."
#define GOGO_STR_RDR_NEXT_IN_BROKER_LIST                   "Moving to the next server address in the server redirection list (%s)."
#define GOGO_STR_RDR_BROKER_LIST_INTERNAL_ERROR            "Internal error processing the server redirection list."
#define GOGO_STR_RDR_ERROR_PROCESSING_REDIRECTION          "Failed to process a TSP redirection message from %s."
#define GOGO_STR_RDR_BROKER_LIST_IS                        "The server redirection list is %s."
#define GOGO_STR_RDR_SORTED_BROKER_LIST_IS                 "The optimized server redirection list is %s."
#define GOGO_STR_RDR_TOO_MANY_BROKERS                      "Too many entries in the server redirection list than the allowed limit (%u). Discarding."
#define GOGO_STR_RDR_CREATING_DISTANCE_THREAD              "Creating server timing thread for %s."
#define GOGO_STR_RDR_CANT_CREATE_DISTANCE_THREAD           "Failed to create timing thread for %s."
#define GOGO_STR_RDR_WAITING_FOR_THREAD                    "Waiting for %s timing thread to complete."
#define GOGO_STR_RDR_ERR_WAITING_FOR_THREAD                "Failed to wait for %s timing thread to complete."
#define GOGO_STR_RDR_DISTANCE_CALCULATION_TIMEOUT          "A timeout occurred during server timing for %s."
#define GOGO_STR_RDR_DISTANCE_CALCULATION_OK               "server timing for %s completed successfully (%u ms)."
#define GOGO_STR_RDR_DISTANCE_CALCULATION_ERR              "An error occurred during server timing for %s."
#define GOGO_STR_RDR_ERROR_CREATE_STAT_ENGINE              "Failed to allocate a stat engine to send an echo request to %s."
#define GOGO_STR_RDR_ERROR_INIT_STAT_ENGINE                "Failed to initialize a stat engine to send an echo request to %s."
#define GOGO_STR_RDR_ERROR_GET_SOCKADDRESS                 "Failed to create an address structure to send an echo request to %s."
#define GOGO_STR_RDR_ERROR_RESOLVING_DN                    "Failed to resolve %s to an IP address."
#define GOGO_STR_RDR_ERROR_CONNECT_SOCKET                  "Failed to create a connected socket to send an echo request to %s."
#define GOGO_STR_RDR_ERROR_PREPARING_RUDP_MSG              "Failed to create an RUDP message to send an echo request to %s."
#define GOGO_STR_RDR_MAX_ECHO_REPLY_ATTEMPTS               "Maximal number of echo request attempts (%u) reached for %s."
#define GOGO_STR_RDR_SENDING_ECHO_REQUEST                  "Sending echo request message #%u to %s."
#define GOGO_STR_RDR_SEND_ECHO_REQUEST_FAILED              "Failed to send an echo request message to %s."
#define GOGO_STR_RDR_WAITING_ECHO_REPLY                    "Waiting for an echo reply from %s."
#define GOGO_STR_RDR_WAITING_ECHO_REPLY_TIMEOUT            "Timed out waiting for an echo reply from %s."
#define GOGO_STR_RDR_RECEIVING_RUDP_MESSAGE                "Receiving an RUDP message from %s."
#define GOGO_STR_RDR_ERR_RECEIVING_RUDP_FROM               "Failed to receive an RUDP message from %s."
#define GOGO_STR_RDR_RECEIVED_RUDP_OK                      "Received RUDP message from %s correctly."
#define GOGO_STR_RDR_RECV_RUDP_SEQ_DIFFERS                 "Sequence number of RUDP message from %s differs."
#define GOGO_STR_RDR_ERR_WAITING_ECHO_REPLY                "Failed to wait for an echo reply from %s."
#define GOGO_STR_RDR_RCV_EXPECTED_ECHO_REPLY               "Received expected echo reply from %s: %s."
#define GOGO_STR_RDR_RCV_UNEXPECTED_ECHO_REPLY             "Received unexpected echo reply from %s: %s."
#define GOGO_STR_RDR_CANT_MALLOC_THREAD_ARRAY              "Failed to allocate memory for the server timing threads."
#define GOGO_STR_RDR_CANT_MALLOC_THREAD_ARGS               "Failed to allocate memory for the server timing thread arguments."
#define GOGO_STR_RDR_WRONG_ADDRESS_FAMILY                  "Server address %s is not compatible with the configured tunnel mode."
#define GOGO_STR_INIT_MESSAGING_FAILED                     "Failed to initialize the messaging subsystem. Communication with GUI unavailable."
#define GOGO_STR_UNINIT_MESSAGING_FAILED                   "Failed to uninitialize the messaging subsystem."

// Home access and home web strings.
#define GOGO_STR_HACCESS_MAKING_DEVICES_ACCESSIBLE            "About to make the requested devices accessible."
#define GOGO_STR_HACCESS_ABOUT_TO_PERFORM_SETUP               "About to perform HomeAcces setup."
#define GOGO_STR_HACCESS_ABOUT_TO_PERFORM_TEARDOWN            "About to perform HomeAcces teardown."
#define GOGO_STR_HACCESS_ATTEMPTING_DDNS_DELETE               "Attempting to perform a DDNS deletion for %s.%s."
#define GOGO_STR_HACCESS_ATTEMPTING_DDNS_UPDATE               "Attempting to perform a DDNS update for %s.%s/%s."
#define GOGO_STR_HACCESS_CONNECTING_TO_DDNS_PROXY             "Connecting to the DDNS proxy (%s)."
#define GOGO_STR_HACCESS_CREATING_DDNS_REQUEST                "Creating a DDNS request for %s."
#define GOGO_STR_HACCESS_DISCONNECTING_FROM_DDNS_PROXY        "Disconnecting from the DDNS proxy."
#define GOGO_STR_HACCESS_EXECUTING_EXTERNAL_COMMAND           "Executing an external command: %s."
#define GOGO_STR_HACCESS_EXECUTING_PROXY_CONFIG_SCRIPT        "Executing the HomeAcces HTTP proxy configuration script."
#define GOGO_STR_HACCESS_EXECUTING_SETUP_SCRIPT               "Executing the HomeAcces setup script."
#define GOGO_STR_HACCESS_EXECUTING_TEARDOWN_SCRIPT            "Executing the HomeAcces teardown script."
#define GOGO_STR_HACCESS_GENERATING_PROXY_CONFIG_FILE         "Generating the HTTP proxy configuration file."
#define GOGO_STR_HACCESS_ERR_PROCESSING_DDNS_REQUEST          "Errors occurred while processing the DDNS request for %s.%s."
#define GOGO_STR_HACCESS_ERR_ADDRESS_NOT_V4_OR_V6             "Host address for the DDNS request is not an IPv4 or IPv6 address."
#define GOGO_STR_HACCESS_ERR_CANT_CONNECT_TO_DDNS_PROXY       "Failed to connect to the DDNS proxy."
#define GOGO_STR_HACCESS_ERR_CANT_DISCONNECT_FROM_DDNS_PROXY  "Failed to disconnect from the DDNS proxy correctly."
#define GOGO_STR_HACCESS_ERR_READING_DEVICE_MAPPING_CONFIG    "Failed to read the device mapping information from the configuration file."
#define GOGO_STR_HACCESS_ERR_EXECUTING_SCRIPT                 "Failed to execute the requested script."
#define GOGO_STR_HACCESS_ERR_QUEUEING_DDNS_REQUEST            "Failed to queue the required DDNS requests."
#define GOGO_STR_HACCESS_ERR_SETTING_ENV_VARS                 "Failed to set the required environment variables."
#define GOGO_STR_HACCESS_ERR_WRITING_SCRIPT_CALL_LINE         "Failed to write the script invocation command to the buffer."
#define GOGO_STR_HACCESS_ERR_INVALID_ARGS_FOR_DDNS_THREAD     "Invalid arguments for the DDNS processing thread."
#define GOGO_STR_HACCESS_ERR_INVALID_FUNCTION_ARGS            "Invalid function arguments."
#define GOGO_STR_HACCESS_ERR_NO_SPACE_IN_BUFFER_FOR_CALL_LINE "Not enough space in the buffer to generate the script invocation command."
#define GOGO_STR_HACCESS_ERR_DDNS_ACTION_INVALID              "The DDNS request action is invalid."
#define GOGO_STR_HACCESS_ERR_ENV_VAR_UNKNOWN                  "The environment variable to be set is unknown."
#define GOGO_STR_HACCESS_ERR_SCRIPT_EXIT_ERROR                "Failed to execute script successfully."
#define GOGO_STR_HACCESS_ERR_ADDRESS_TOO_LONG_FOR_REQ         "The host address is too long to create a DDNS request."
#define GOGO_STR_HACCESS_ERR_NAME_TOO_LONG_FOR_REQ            "The host name is too long to create a DDNS request."
#define GOGO_STR_HACCESS_ERR_UNKNOWN_SCRIPT                   "The script to be executed is unknown."
#define GOGO_STR_HACCESS_ERR_CANT_CREATE_REQ                  "Failed to create the requested DDNS request."
#define GOGO_STR_HACCESS_ERR_NO_MEM_FOR_STATUS_COPY           "Failed to allocate memory for a copy of the device status."
#define GOGO_STR_HACCESS_ERR_NO_MEM_FOR_DDNS_REQ              "Failed to allocate memory for the DDNS request."
#define GOGO_STR_HACCESS_ERR_NO_MEM_FOR_STATUS_NAME           "Failed to allocate memory for the device name in the device status."
#define GOGO_STR_HACCESS_ERR_NO_MEM_FOR_STATUS                "Failed to allocate memory for the device status."
#define GOGO_STR_HACCESS_ERR_CANT_CLEAR_STATUS                "Failed to clear the status information."
#define GOGO_STR_HACCESS_ERR_CANT_COPY_HOST_NAME              "Failed to copy the host name from the device status."
#define GOGO_STR_HACCESS_ERR_CANT_CREATE_PREP_MAPPING_FILE    "Failed to create the prepared device mapping configuration file."
#define GOGO_STR_HACCESS_ERR_CANT_GET_TIME                    "Failed to determine the current time."
#define GOGO_STR_HACCESS_ERR_CANT_FREE_DDNS_REQ_QUEUE         "Failed to free the DDNS request processing queue."
#define GOGO_STR_HACCESS_ERR_CANT_FREE_DDNS_REQ               "Failed to free the DDNS request."
#define GOGO_STR_HACCESS_ERR_CANT_GEN_PROXY_CONFIG_FILE       "Failed to generate the proxy configuration file."
#define GOGO_STR_HACCESS_ERR_CANT_INIT_STATUS                 "Failed to initialize status information."
#define GOGO_STR_HACCESS_ERR_CANT_INIT_DDNS_REQ_QUEUE         "Failed to initialize the DDNS request processing queue."
#define GOGO_STR_HACCESS_ERR_CANT_INIT_MAPPING_CONF_MODULE    "Failed to initialize the device mapping configuration module."
#define GOGO_STR_HACCESS_ERR_CANT_LOAD_MAPPING_CONF_FILE      "Failed to load the device mapping configuration file."
#define GOGO_STR_HACCESS_ERR_CANT_OPEN_PREP_MAPPING_FILE      "Failed to open the prepared device mapping configuration file for writing."
#define GOGO_STR_HACCESS_ERR_CANT_INIT_PLATFORM               "Failed to perform the platform-specific initialization."
#define GOGO_STR_HACCESS_ERR_CANT_SHUTDOWN_PLATFORM           "Failed to perform the platform-specific shutdown operations."
#define GOGO_STR_HACCESS_ERR_CANT_PREP_SCRIPT_CALL            "Failed to prepare the script invocation command."
#define GOGO_STR_HACCESS_ERR_CANT_PUSH_DDNS_REQ_BACK          "Failed to push the DDNS request back on the DDNS request processing queue."
#define GOGO_STR_HACCESS_ERR_CANT_PUSH_NEW_DDNS_REQ           "Failed to push the new DDNS request on the DDNS request processing queue."
#define GOGO_STR_HACCESS_ERR_CANT_REMOVE_PREP_MAPPING_FILE    "Failed to remove the prepared device mapping configuration file."
#define GOGO_STR_HACCESS_ERR_CANT_SEND_STATUS_TO_GUI          "Failed to send the DDNS request status to the GUI."
#define GOGO_STR_HACCESS_ERR_CANT_SET_ENV_VAR                 "Failed to set the requested environment variable."
#define GOGO_STR_HACCESS_ERR_CANT_SIGNAL_SHUTDOWN             "Failed to signal that the module is shutting down."
#define GOGO_STR_HACCESS_ERR_CANT_START_DDNS_THREAD           "Failed to start the DDNS request processing thread."
#define GOGO_STR_HACCESS_ERR_CANT_UPDATE_DDNS_REQ_STATUS      "Failed to update the DDNS request status."
#define GOGO_STR_HACCESS_ERR_CANT_WRITE_TO_PREP_MAPPING_FILE  "Failed to write an entry to the prepared device mapping configuration file."
#define GOGO_STR_HACCESS_ERR_SET_STATUS_UNEXPECTED_STATE      "Unexpected situation while trying to set the device status."
#define GOGO_STR_HACCESS_SETUP_COMPLETED                      "HomeAcces setup completed."
#define GOGO_STR_HACCESS_SHUTDOWN_COMPLETED                   "HomeAcces shutdown completed."
#define GOGO_STR_HACCESS_TEARDOWN_COMPLETED                   "HomeAcces teardown completed."
#define GOGO_STR_HACCESS_ADDRESS_IS_IPV4                      "Host address is an IPv4 address; IPv6 address will be %s."
#define GOGO_STR_HACCESS_ADDRESS_IS_IPV6                      "Host address is an IPv6 address; IPv6 address will be %s."
#define GOGO_STR_HACCESS_NOT_TIME_FOR_REQ                     "It is still not time to process this DDNS request. Pushing it back on the queue."
#define GOGO_STR_HACCESS_TIME_FOR_REQ                         "It is time to process this DDNS request."
#define GOGO_STR_HACCESS_POPPED_DDNS_REQ                      "Popped a DDNS request for %s.%s from the DDNS request processing queue."
#define GOGO_STR_HACCESS_PREPARING_TO_QUEUE                   "Preparing to queue the required DDNS requests."
#define GOGO_STR_HACCESS_REACHED_MAX_ATTEMPTS                 "Reached the maximum number of DDNS request attempts (%u) for %s.%s. Giving up."
#define GOGO_STR_HACCESS_READING_MAPPING_CONFIG               "Reading the device mapping configuration."
#define GOGO_STR_HACCESS_RECEIVED_DDNS_SERVAIL                "Received a SERVFAIL reply from the DDNS proxy."
#define GOGO_STR_HACCESS_RECEIVED_DDNS_ERROR                  "Received an error reply from the DDNS proxy. The request for %s.%s was not processed successfully."
#define GOGO_STR_HACCESS_RESTARTING_HTTP                      "Restarting the HTTP server."
#define GOGO_STR_HACCESS_SHUTTING_DOWN                        "Shutting down HACCESS."
#define GOGO_STR_HACCESS_STARTING_DDNS_THREAD                 "Starting the DDNS processing thread."
#define GOGO_STR_HACCESS_DDNS_REQ_PROCESSED_SUCCESS           "The DDNS request was processed successfully."
#define GOGO_STR_HACCESS_PROXY_READY                          "The HTTP proxy configuration has been adjusted, and the required DDNS requests have been queued for processing."
#define GOGO_STR_HACCESS_DDNS_REQ_ELIGIBLE_IN                 "This DDNS request will be eligible for processing in %u seconds."
#define GOGO_STR_HACCESS_VERIFYING_IF_PROCESS_NOW             "Verifying if the DDNS request for %s.%s should be processed now."
#define GOGO_STR_HACCESS_ERR_PROCESSING_DDNS_REQS             "An error occurred during the processing of the DDNS requests."
#define GOGO_STR_HACCESS_ERR_CANT_START_PLATFORM_THREAD       "Failed to start a platform-specific thread."
#define GOGO_STR_HACCESS_ERR_CANT_SIGNAL_MODULE_SHUTDOWN      "Failed to signal the module shutdown event."
#define GOGO_STR_HACCESS_ERR_CANT_CREATE_PLATFORM_WAIT_EVENT  "Failed to create a platform-specific wait event."
#define GOGO_STR_HACCESS_ERR_CANT_CLOSE_SHUTDOWN_EVENT        "Failed to close the module shutdown event."
#define GOGO_STR_HACCESS_ERR_CANT_CLOSE_THREAD_HANDLE         "Failed to close the DDNS request processing thread handle."
#define GOGO_STR_HACCESS_ERR_CANT_INIT_MODULE                 "Failed to perform module initialization."
#define GOGO_STR_HACCESS_ERR_CANT_DO_TEARDOWN                 "Failed to perform teardown."
#define GOGO_STR_HACCESS_ERR_CANT_DO_SHUTDOWN                 "Failed to perform module shutdown."
#define GOGO_STR_HACCESS_ERR_FAILED_TO_SETUP_HACCESS_FEATURES "Failed to setup the HACCESS features."
#define GOGO_STR_HACCESS_ERR_FAILED_TO_EXPOSE_DEVICES         "Failed to make the HomeAccess devices accessible."
#define GOGO_STR_HACCESS_WARN_DEVICE_ADDRESS_NOT_IN_PREFIX    "Device %s mapping refused: Device address '%s' is not within your delegated prefix '%s'."
#define GOGO_STR_HACCESS_HIDING_DEVICES                       "About to remove the devices from the DNS server."
#define GOGO_STR_HACCESS_ERR_CANT_SIGNAL_EMPTY_QUEUE          "Failed to signal that the DDNS request queue is empty."
#define GOGO_STR_HACCESS_ERR_CANT_SIGNAL_HIDING_EVENT         "Failed to signal the device hiding completion event."
#define GOGO_STR_HACCESS_ERR_CANT_WAIT_HIDING_EVENT           "Failed to wait for the device hiding completion event to be signaled."
#define GOGO_STR_HACCESS_ERR_CANT_WAIT_HIDING_DONE            "Failed to wait for the completion of the DDNS deletion requests."
#define GOGO_STR_HACCESS_ERR_CANT_DO_HIDE_DEVICES             "Failed to remove the DNS entries."
#define GOGO_STR_HACCESS_ERR_HIDING_TIMEOUT                   "Timed out waiting for the completion of the DDNS deletion requests."
#define GOGO_STR_INVALID_IPHLPAPI_DLL                         "Failed to find required IPHLPAPI.DLL file, or invalid version."
#define GOGO_STR_CANT_GET_LOCAL_DNSSERVERS                    "Failed to retrieve local system DNS servers"


// Keepalive strings.
#define STR_KA_INIT_FAIL_CAUSE                        "Keepalive initialisation failed: "
#define STR_KA_START_FAIL_CAUSE                       "Keepalive start failed: "
#define STR_KA_QRYSTATUS_FAIL_CAUSE                   "Keepalive status query failed: "
#define STR_KA_STOP_FAIL_CAUSE                        "Keepalive stop failed: "
#define STR_KA_DESTR_FAIL_CAUSE                       "Keepalive destruction failed: "

#define STR_KA_INIT_INFO                              "Keepalive initialized with peer %s. Interval=%dms. Timeout=%dms. General timeout at %d consecutive timeouts."
#define STR_KA_SEND_INFO                              "Keepalive request sent."
#define STR_KA_RECV_INFO                              "Keepalive reply received. Roundtrip time: %.3fms"
#define STR_KA_STOP_INFO_CAUSE                        "Keepalive processing stopped: "

#define STR_KA_ERR_ALREADY_INIT                       "Already initialized."
#define STR_KA_GENERAL_TIMEOUT                        "General timeout detected."
#define STR_KA_EXPLICIT_STOP                          "Keepalive engine was explicitly stopped."
#define STR_KA_ERR_DESTR_IEE                          "Failed to destroy ICMP echo engine."
#define STR_KA_ERR_STOP_IEE                           "Failed to stop ICMP echo engine."
#define STR_KA_ERR_THREAD_START                       "Thread start error: "
#define STR_KA_ERR_THREAD_JOIN                        "Thread join error: "

// General strings.
#define STR_GEN_UNKNOWN_ERROR                         "Unknown or unhandled error."
#define STR_GEN_NETWORK_ERROR                         "Networking error."
#define STR_GEN_INVALID_POINTER                       "Invalid pointer."
#define STR_GEN_MALLOC_ERROR                          "Failed memory allocation."
#define STR_GEN_USING_TSP_PROTO_VER                   "Using TSP protocol version %s."
#define STR_GEN_CONNECT_FAIL_SERVER                   "Failed to connect to server %s. Verify server name/address."
#define STR_GEN_CONNECTED_SERVER                      "Connection to server %s successful."
#define STR_GEN_EXEC_CFG_SCRIPT                       "Executing interface configuration script: %s."
#define STR_GEN_SCRIPT_EXEC_SUCCESS                   "Interface configuration script completed successfully."
#define STR_GEN_SCRIPT_EXEC_FAILED                    "Interface configuration script completed with errors."
#define STR_GEN_DISCONNECTED_RETRY_NOW                "Disconnected. Retrying."
#define STR_GEN_DISCONNECTED_RETRY_SEC                "Disconnected. Retrying in %d seconds."
#define STR_GEN_LAST_STATUS_CONTEXT                   "Last status context is: %s."
#define STR_GEN_FINISHED                              "Finished."

// TSP strings.
#define STR_TSP_GEN_ERROR                             "A TSP error occurred. Status: %d. Info: %s"
#define STR_TSP_NO_LISTENER                           "Failed to contact TSP listener at %s."
#define STR_TSP_INVALID_VERSION                       "TSP version not supported by server: %s."
#define STR_TSP_SERVER_TOO_BUSY                       "The server is too busy to process your TSP request."
#define STR_TSP_GETCAPABILITIES_FROM_SERVER           "Retrieving TSP capabilities from Server."
#define STR_TSP_GETCAPABILITIES_ERROR                 "Failed to retrieve TSP capabilities."
#define STR_TSP_TUNMODE_NOT_AVAILABLE                 "Requested tunnel mode not available on server %s."
#define STR_TSP_AUTHENTICATING                        "Authenticating..."
#define STR_TSP_NO_COMMON_AUTHENTICATION              "Failed to find common authentication method with server."
#define STR_TSP_AUTH_FAILED_USER                      "The server failed to authenticate user %s."
#define STR_TSP_UNKNOWN_ERR_AUTH_FAILED               "Unknown TSP error during authentication. (%s)"
#define STR_TSP_AUTH_SUCCESSFUL                       "Authentication successful."
#define STR_TSP_NEGOTIATING_TUNNEL                    "Negotiating tunnel parameters with server"
#define STR_TSP_TUNNEL_NEGO_FAILED                    "Tunnel negotiation failed. Status: %d"
#define STR_TSP_TUNNEL_NEGO_SUCCESSFUL                "Tunnel negotiation successful. Accepted offer."
#define STR_TSP_ERRS_TUN_PARAM_FROM_SERVER            "Errors in tunnel parameters in server response."
#define STR_TSP_TUNNEL_LEASE_EXPIRED                  "Tunnel allocation lease expired. Sending back TSP request."

// Network strings.
#define STR_NET_USING_SOURCE_IPV4                     "Using [%s] as source IPv4 address."
#define STR_NET_USING_SOURCE_IPV6                     "Using [%s] as source IPv6 address."
#define STR_NET_FAILED_FIND_LOCALHOST_IPV4            "Failed to find localhost IPv4 address. (because client_v4=auto)"
#define STR_NET_FAILED_FIND_LOCALHOST_IPV6            "Failed to find localhost IPv6 address. (because client_v6=auto)"
#define STR_NET_CANT_GET_SRC_ADDRESS                  "Failed to get source address to communicate with server."
#define STR_NET_CANT_GET_DST_ADDRESS                  "Failed to get destination address to communicate with the server."
#define STR_NET_CONNECT_RUDP                          "Establishing connection to server %s using reliable UDP."
#define STR_NET_CONNECT_RUDPV6                        "Establishing connection to server %s using reliable UDPv6."
#define STR_NET_CONNECT_TCP                           "Establishing connection to server %s using TCP."
#define STR_NET_CONNECT_TCPV6                         "Establishing connection to server %s using TCPv6."
#define STR_NET_SENDING                               "Sending: '%s'"
#define STR_NET_RECEIVED                              "Received: '%s'"
#define STR_NET_FAIL_CONNECT_SERVER                   "Failed to connect to server %s on port %d."
#define STR_NET_FAIL_RW_SOCKET                        "Failed to write/read on network socket."
#define STR_NET_FAIL_W_SOCKET                         "Failed to write on network socket."
#define STR_NET_FAIL_R_SOCKET                         "Failed to read from network socket."
#define STR_NET_FAIL_R_TUN_DEV                        "Failed to read from tunnel device."
#define STR_NET_FAIL_W_TUN_DEV                        "Failed to write to tunnel device."
#define STR_NET_FAIL_TUN_DEV_BUFSMALL                 "Buffer size too small to attempt reading from tunnel device."

// Miscellaneous error strings.
#define STR_MISC_FAIL_TUN_INIT                        "Failed to initialize TUN device."
#define STR_MISC_INVALID_MD5_RESPONSE                 "Invalid MD5 response from server."
#define STR_MISC_FAIL_WRITE_LAST_SERVER               "Failed to write the last server address (%s) to the last server file %s."
#define STR_MISC_LOG_CONFIGURE_FAILED                 "Failed to configure the logging system."
#define STR_MISC_PROCESS_SERVER_REPLY                 "Processing server reply."

// String litterals
#define STR_LIT_DISABLED                              "disabled"
#define STR_LIT_ENABLED                               "enabled"

// server status context.
#define STR_CTX_UNSPECIFIED                           "Unspecified"
#define STR_CTX_CFGVALIDATION                         "Configuration validation"
#define STR_CTX_NETWORKINIT                           "Network initialisation"
#define STR_CTX_NETWORKCONNECT                        "Network connection"
#define STR_CTX_TSPCAPABILITIES                       "Retrieve TSP capabilities"
#define STR_CTX_TSPAUTHENTICATION                     "TSP authentication"
#define STR_CTX_TSPTUNNEGOTIATION                     "TSP tunnel negotiation"
#define STR_CTX_TUNINTERFACESETUP                     "Tunnel interface setup"
#define STR_CTX_TUNNELLOOP                            "Tunnel life loop"
#define STR_CTX_GOGOCTEARDOWN                         "Application/tunnel teardown"

// server TSP ptotocol strings
#define STR_TSP_PROTO_SUCCESS                         "Operation successful."
#define STR_TSP_PROTO_AUTH_FAILED                     "Authentication failed."
#define STR_TSP_PROTO_NO_TUNNELS                      "The server has reached its tunnel capacity limit."
#define STR_TSP_PROTO_UNSUP_TSP_VER                   "Unsupported TSP version."
#define STR_TSP_PROTO_UNSUP_TUN_MODE                  "Unsupported tunnel type."
#define STR_TSP_PROTO_UNDEFINED                       "Server-side error."
#define STR_TSP_PROTO_INVALID_REQUEST                 "Invalid TSP request."
#define STR_TSP_PROTO_INVALID_IPV4                    "Invalid IPv4 address."
#define STR_TSP_PROTO_INVALID_IPV6                    "Invalid IPv6 address."
#define STR_TSP_PROTO_IPV4_PREFIX_ALREADY_USED        "IPv4 prefix already in use."
#define STR_TSP_PROTO_REQ_PREFIX_LEN_UNAVAILABLE      "Prefix length unavailable."
#define STR_TSP_PROTO_DNS_DELEGATION_ERROR            "DNS delegation error."
#define STR_TSP_PROTO_UNSUPP_PREFIX_LEN               "Unsupported prefix length."
#define STR_TSP_PROTO_MISSING_PREFIX_LEN              "Missing prefix length."
#define STR_TSP_PROTO_REQ_IN_PROGRESS                 "Request already in progress."
#define STR_TSP_PROTO_PREFIX_REQ_FOR_ANONYMOUS        "Prefix requested for anonymous."
#define STR_TSP_PROTO_SERVER_TOO_BUSY                 "Server too busy."
#define STR_TSP_PROTO_REDIRECT                        "Redirection."

#endif
