package securityinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SourceControlClient is the API spec for Microsoft.SecurityInsights (Azure Security Insights) resource provider
type SourceControlClient struct {
	BaseClient
}

// NewSourceControlClient creates an instance of the SourceControlClient client.
func NewSourceControlClient(subscriptionID string) SourceControlClient {
	return NewSourceControlClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSourceControlClientWithBaseURI creates an instance of the SourceControlClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSourceControlClientWithBaseURI(baseURI string, subscriptionID string) SourceControlClient {
	return SourceControlClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListRepositories gets a list of repositories metadata.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// workspaceName - the name of the workspace.
// repoType - the repo type.
func (client SourceControlClient) ListRepositories(ctx context.Context, resourceGroupName string, workspaceName string, repoType RepoType) (result RepoListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlClient.ListRepositories")
		defer func() {
			sc := -1
			if result.rl.Response.Response != nil {
				sc = result.rl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("securityinsight.SourceControlClient", "ListRepositories", err.Error())
	}

	result.fn = client.listRepositoriesNextResults
	req, err := client.ListRepositoriesPreparer(ctx, resourceGroupName, workspaceName, repoType)
	if err != nil {
		err = autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "ListRepositories", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRepositoriesSender(req)
	if err != nil {
		result.rl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "ListRepositories", resp, "Failure sending request")
		return
	}

	result.rl, err = client.ListRepositoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "ListRepositories", resp, "Failure responding to request")
		return
	}
	if result.rl.hasNextLink() && result.rl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListRepositoriesPreparer prepares the ListRepositories request.
func (client SourceControlClient) ListRepositoriesPreparer(ctx context.Context, resourceGroupName string, workspaceName string, repoType RepoType) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/listRepositories", pathParameters),
		autorest.WithJSON(repoType),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRepositoriesSender sends the ListRepositories request. The method will close the
// http.Response Body if it receives an error.
func (client SourceControlClient) ListRepositoriesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListRepositoriesResponder handles the response to the ListRepositories request. The method always
// closes the http.Response Body.
func (client SourceControlClient) ListRepositoriesResponder(resp *http.Response) (result RepoList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRepositoriesNextResults retrieves the next set of results, if any.
func (client SourceControlClient) listRepositoriesNextResults(ctx context.Context, lastResults RepoList) (result RepoList, err error) {
	req, err := lastResults.repoListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "listRepositoriesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRepositoriesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "listRepositoriesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRepositoriesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "securityinsight.SourceControlClient", "listRepositoriesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRepositoriesComplete enumerates all values, automatically crossing page boundaries as required.
func (client SourceControlClient) ListRepositoriesComplete(ctx context.Context, resourceGroupName string, workspaceName string, repoType RepoType) (result RepoListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlClient.ListRepositories")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListRepositories(ctx, resourceGroupName, workspaceName, repoType)
	return
}
