# Buildah version 1.5 Release Announcement

![buildah logo](https://buildah.io/images/buildah.png)

We're pleased to announce the release of Buildah version 1.5 which is now available from GitHub for any Linux distro.  We are shipping this release on Fedora, RHEL 7, CentOS, openSUSE and Ubuntu in the near future.

The Buildah project has continued to grow over the past several weeks, welcoming several new contributors to the mix.  Updates were made to rootless user handling, added support for a few Dockerfile commands that were missing, a number of performance changes for the underlying pull commands and bug fixes.

## The major highlights for this release are:

* A variety of updates were made in rootless user handling:
  - Let runc auto-detect rootless capability.  This will allow for different runtimes to run in rootless mode.
  - If slirp4netns is available, it is now used to configure the network for the rootless isolation mode.
  - Support for fuse-overlayfs has been added.
  -  Usernamespaces are now created only when they are needed.

* Dockerfile handling improvements.
  - If the ARG command was the first line in the Dockerfile, Buildah did not process it.  This has been corrected.
  - The “FROM {image} AS {reference}” command in a Dockerfile is now supported.

* A number of performance changes have been made to the underlying pull functionality.

* If a directory was passed the ‘bud’ commands --file parameter a panic would occur even if a Dockerfile was in the directory.  This has been corrected.

## Release Changes

* rootless: do not specify --rootless to the OCI runtime.
* rootless: use slirp4netns to setup the network namespace.
* rootless: only discard network configuration names.
* run: only set up /etc/hosts or /etc/resolv.conf with network.
* run: bind mount /etc/hosts and /etc/resolv.conf if not in a volume.
* Handle directories better in ‘bud --file’.
* common: support a per-user registries conf file.
* unshare: do not override the configuration.
* common: honor the rootless configuration file.
* unshare: create a new mount namespace.
* unshare: support libpod rootless pkg.
* Use libpod GetDefaultStorage to report proper storage config.
* Allow container storage to manage the SELinux labels.
* When the value of isolation is provided to the run command, use the value provided instead of the default value.
* Fix ‘buildah version’ error when build time could not be determined on some systems.
* Walk symlinks when checking cached images for copied/added files.
* ReserveSELinuxLabels(): handle wrapped errors from OpenBuilder.
* Set WorkingDir to empty, not ‘/’ for conformance to Docker.
* Allow setting --no-pivot default with an env var.
* Add the --no-pivot flag to the run command.
* Improve reporting about individual pull failures.
* Return a "search registries were needed but empty" indication in util.ResolveName.
* Simplify handling of the "tried to pull an image but found nothing" case.
* Don't even invoke the pull loop if options.FromImage == "".
* Eliminate the long-running ref and img variables in resolveImage.
* In resolveImage, return immediately on success.
* Fix From As in Dockerfile.
* Sort CLI flags of buildah bud.
* unshare: detect when unprivileged userns are disabled.
* chroot: fix the args check.
* buildah: use the same logic for XDG_RUNTIME_DIR as podman.
* Podman  --privileged selinux is broken.
* parse: Modify the return value.
* parse: modify the verification of the isolation value.
* Make sure we log or return every error.
* pullImage(): when completing an image name, try docker://.
* Enforce "blocked" for registries for the "docker" transport.
* Correctly set DockerInsecureSkipTLSVerify when pulling images.
* chroot: set up seccomp and capabilities after supplemental groups.
* chroot: fix capabilities list setup and application.
* namespaces.bats: fix handling of uidmap/gidmap options in pairs.
* chroot: only create user namespaces when we know we need them.
* Check /proc/sys/user/max_user_namespaces on unshare(NEWUSERNS).
* bash/buildah: add isolation option to the from command for bash completions.
* Updated the following packages to newer versions:  containers/image, containers/storage, libpod, and opencontainers/selinux.
* Plus a number of smaller fixes.

## Try it Out.

If you haven’t yet, install Buildah from one of the Linux repos or GitHub and give it a spin.  We’re betting you'll find it’s an easy and quick way to build containers in your environment without a daemon being involved!

For those of you who contributed to this release, thank you very much for your contributions!  If you haven't joined our community yet, don't wait any longer!  Come join us in GitHub, where Open Source communities live.

## Buildah == Simplicity

