/* SPDX-License-Identifier: MIT */
/*
 * List of real DP EDIDs from popular monitors.
 * The current list (at the time of writing this comment) is based on the top
 * monitors used on ChromeOS.
 *
 * Copyright 2022 Google LLC.
 *
 * Authors: Mark Yacoub <markyacoub@chromium.org>
 */

#ifndef TESTS_CHAMELIUM_MONITOR_EDIDS_DP_EDIDS_H_
#define TESTS_CHAMELIUM_MONITOR_EDIDS_DP_EDIDS_H_

#include "monitor_edids_helper.h"

monitor_edid DP_EDIDS_4K[] = {
	{ .name = "4K_DELL_UP3216Q_DP",
	  .edid = "00ffffffffffff0010acf84050383230"
		  "051a0104a5431c783aca95a6554ea126"
		  "0f5054a54b808100b300714f8180d1c0"
		  "0101010101017e4800e0a0381f404040"
		  "3a00a11c2100001a000000ff00393143"
		  "5937333538303238500a000000fc0044"
		  "454c4c205532393137570a20000000fd"
		  "00314c1d5e13010a2020202020200117"
		  "02031df1501005040302071601061112"
		  "1513141f2023091f0783010000023a80"
		  "1871382d40582c2500a11c2100001e01"
		  "1d8018711c1620582c2500a11c210000"
		  "9e011d007251d01e206e285500a11c21"
		  "00001e8c0ad08a20e02d10103e9600a1"
		  "1c210000180000000000000000000000"
		  "000000000000000000000000000000dd" },
	{ .name = "4K_HP_Spectre32_DP",
	  .edid = "00FFFFFFFFFFFF0022F01A3200000000"
		  "2E180104B54728783A87D5A8554D9F25"
		  "0E5054210800D1C0A9C081C0D100B300"
		  "9500A94081804DD000A0F0703E803020"
		  "3500C48F2100001A000000FD00183C1E"
		  "873C000A202020202020000000FC0048"
		  "502053706563747265203332000000FF"
		  "00434E43393430303030310A2020018F"
		  "020318F14B101F041303120211010514"
		  "2309070783010000A36600A0F0701F80"
		  "30203500C48F2100001A565E00A0A0A0"
		  "295030203500C48F2100001AEF5100A0"
		  "F070198030203500C48F2100001AB339"
		  "00A080381F4030203A00C48F2100001A"
		  "283C80A070B0234030203600C48F2100"
		  "001A00000000000000000000000000C4" },

};

monitor_edid DP_EDIDS_NON_4K[] = {
	 { .name = "DEL_16543_DELL_P2314T_DP",
	   .edid = "00ffffffffffff0010ac9f404c4c3645"
		   "10180104a5331d783ae595a656529d27"
		   "105054a54b00714f8180a9c0d1c00101"
		   "010101010101023a801871382d40582c"
		   "4500fd1e1100001e000000ff00445746"
		   "325834344645364c4c0a000000fc0044"
		   "454c4c205032333134540a20000000fd"
		   "00384c1e5311010a20202020202001bb"
		   "02031cf14f9005040302071601061112"
		   "1513141f2309070783010000023a8018"
		   "71382d40582c4500fd1e1100001e011d"
		   "8018711c1620582c2500fd1e1100009e"
		   "011d007251d01e206e285500fd1e1100"
		   "001e8c0ad08a20e02d10103e9600fd1e"
		   "11000018000000000000000000000000"
		   "0000000000000000000000000000003f" },
	 { .name = "ACI_9713_ASUS_VE258_DP",
	   .edid = "00ffffffffffff000469f125f3c60100"
		   "1d150104a5371f783a7695a5544ba226"
		   "115054bfef00714f81c0814081809500"
		   "950fb300d1c0023a801871382d40582c"
		   "450029372100001e000000ff0042374c"
		   "4d54463131363436370a000000fd0032"
		   "4b185311041100f0f838f03c000000fc"
		   "00415355532056453235380a202001b7"
		   "020322714f0102031112130414051f90"
		   "0e0f1d1e2309170783010000656e0c00"
		   "10008c0ad08a20e02d10103e96002937"
		   "21000018011d007251d01e206e285500"
		   "29372100001e011d00bc52d01e20b828"
		   "554029372100001e8c0ad09020403120"
		   "0c405500293721000018000000000000"
		   "000000000000000000000000000000aa" },
	 { .name = "DEL_16443_DELL_2208WFP_DP",
	   .edid = "00ffffffffffff0010ac3b4053343034"
		   "18120103682f1e78ea3af5aa5037ab24"
		   "135054a54b00714f8180b30001010101"
		   "01010101010121399030621a274068b0"
		   "3600d9281100001c000000ff00463533"
		   "3248383643343034530a000000fc0044"
		   "454c4c20323230385746500a000000fd"
		   "00384c1e5310000a2020202020200039" },
	 { .name = "DEL_16543_DELL_P2314T_DP",
	   .edid = "00ffffffffffff0010ac9f404c4c3645"
		   "10180104a5331d783ae595a656529d27"
		   "105054a54b00714f8180a9c0d1c00101"
		   "010101010101023a801871382d40582c"
		   "4500fd1e1100001e000000ff00445746"
		   "325834344645364c4c0a000000fc0044"
		   "454c4c205032333134540a20000000fd"
		   "00384c1e5311010a20202020202001bb"
		   "02031cf14f9005040302071601061112"
		   "1513141f2309070783010000023a8018"
		   "71382d40582c4500fd1e1100001e011d"
		   "8018711c1620582c2500fd1e1100009e"
		   "011d007251d01e206e285500fd1e1100"
		   "001e8c0ad08a20e02d10103e9600fd1e"
		   "11000018000000000000000000000000"
		   "0000000000000000000000000000003f" },
	 { .name = "DEL_61463_DELL_U2410_DP",
	   .edid = "00ffffffffffff0010ac17f04c334a31"
		   "08150104b53420783a1ec5ae4f34b126"
		   "0e5054a54b008180a940d100714f0101"
		   "010101010101283c80a070b023403020"
		   "360006442100001a000000ff00463532"
		   "354d313247314a334c0a000000fc0044"
		   "454c4c2055323431300a2020000000fd"
		   "00384c1e5111000a20202020202001ff"
		   "02031df15090050403020716011f1213"
		   "14201511062309070783010000023a80"
		   "1871382d40582c450006442100001e01"
		   "1d8018711c1620582c25000644210000"
		   "9e011d007251d01e206e285500064421"
		   "00001e8c0ad08a20e02d10103e960006"
		   "44210000180000000000000000000000"
		   "00000000000000000000000000000021" },
	 { .name = "HWP_10345_HP_ZR24w_DP",
	   .edid = "00ffffffffffff0022f0692801010101"
		   "0d150104a53623782efc81a4554d9d25"
		   "125054210800814081809500a940b300"
		   "d1c001010101283c80a070b023403020"
		   "360022602100001a000000fd003b3d18"
		   "5011000a202020202020000000fc0048"
		   "50205a523234770a20202020000000ff"
		   "00434e54313133373034500a20200031" },
	 { .name = "HWP_10348_HP_ZR30w_DP",
	   .edid = "00ffffffffffff0022f06c2801010101"
		   "0c170104b5402878e28d85ad4f35b125"
		   "0e505400000001010101010101010101"
		   "010101010101e26800a0a0402e603020"
		   "360081902100001abc1b00a050201730"
		   "3020360081902100001a000000fc0048"
		   "50205a523330770a20202020000000ff"
		   "00434e34333132303344420a20200067" },
	 { .name = "HWP_10580_HP_ZR2440w_DP",
	   .edid = "00ffffffffffff0022f0542900000000"
		   "14170104a534207823fc81a4554d9d25"
		   "125054210800d1c081c0814081809500"
		   "a940b3000101283c80a070b023403020"
		   "360006442100001a000000fd00183c18"
		   "5011000a202020202020000000fc0048"
		   "50205a5232343430770a2020000000ff"
		   "00434e3433323030314c500a20200156"
		   "020319c14c901f051404130302070612"
		   "012309070783010000023a801871382d"
		   "40582c450006442100001e023a80d072"
		   "382d40102c458006442100001e011d00"
		   "7251d01e206e28550006442100001e01"
		   "1d00bc52d01e20b82855400644210000"
		   "1e8c0ad08a20e02d10103e9600064421"
		   "0000180000000000000000000000007b" },
	 { .name = "HWP_12441_HP_Z30i_DP",
	   .edid = "00ffffffffffff0022f0993000000000"
		   "06180104a54028783a1df5ae4f35b325"
		   "0d5054a10800d100b30095008100a940"
		   "8180d1c081c0e26800a0a0402e603020"
		   "360081902100001a000000fd00324618"
		   "621b000a202020202020000000fc0048"
		   "50205a3330690a2020202020000000ff"
		   "00434e34343036304743560a20200142"
		   "020316f149900403021f131211012309"
		   "070783010000023a801871382d40582c"
		   "450081902100001e023a80d072382d40"
		   "102c458081902100001e011d007251d0"
		   "1e206e28550081902100001e011d00bc"
		   "52d01e20b828554081902100001e8c0a"
		   "d08a20e02d10103e9600819021000018"
		   "00000000000000000000000000000083" },
	 { .name = "HWP_12446_HP_Z24i_DP",
	   .edid = "00ffffffffffff0022f09e3000000000"
		   "15180104a5342078264ca5a7554da226"
		   "105054a10800b30095008100a9408180"
		   "d1c081c00101283c80a070b023403020"
		   "360006442100001a000000fd00324c18"
		   "5e11000a202020202020000000fc0048"
		   "50205a3234690a2020202020000000ff"
		   "00434e343432313050334b0a2020006f" },

 };

#endif /* TESTS_CHAMELIUM_MONITOR_EDIDS_DP_EDIDS_H_ */
