/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.MessageHelper;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public abstract class AbstractRemoteTestRunnerClient {
    protected IRemoteSuiteListener[] m_suiteListeners;
    protected IRemoteTestListener[] m_testListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private PrintWriter m_outputWriter;
    private BufferedReader m_inputReader;

    public synchronized void startListening(IRemoteSuiteListener[] suiteListeners, IRemoteTestListener[] testListeners, ServerConnection serverConnection) {
        this.m_suiteListeners = suiteListeners;
        this.m_testListeners = testListeners;
        serverConnection.start();
    }

    public IRemoteSuiteListener[] getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public IRemoteTestListener[] getTestListeners() {
        return this.m_testListeners;
    }

    private synchronized void shutdown() {
        if (this.m_outputWriter != null) {
            this.m_outputWriter.close();
            this.m_outputWriter = null;
        }
        try {
            if (this.m_inputReader != null) {
                this.m_inputReader.close();
                this.m_inputReader = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            if (null != this.m_outputWriter) {
                this.m_outputWriter.println(">STOP");
                this.m_outputWriter.flush();
            }
            this.shutdown();
        }
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(String message) {
        int messageType = MessageHelper.getMessageType(message);
        try {
            if (messageType < 10) {
                GenericMessage gm = MessageHelper.unmarshallGenericMessage(message);
                this.notifyStart(gm);
            } else if (messageType < 100) {
                SuiteMessage sm = MessageHelper.createSuiteMessage(message);
                this.notifySuiteEvents(sm);
            } else if (messageType < 1000) {
                TestMessage tm = MessageHelper.createTestMessage(message);
                this.notifyTestEvents(tm);
            } else {
                TestResultMessage trm = MessageHelper.unmarshallTestResultMessage(message);
                this.notifyResultEvents(trm);
            }
        }
        finally {
            if (this.isRunning() && null != this.m_outputWriter) {
                this.m_outputWriter.println(">ACK");
                this.m_outputWriter.flush();
            }
        }
    }

    protected abstract void notifyStart(GenericMessage var1);

    protected abstract void notifySuiteEvents(SuiteMessage var1);

    protected abstract void notifyTestEvents(TestMessage var1);

    protected abstract void notifyResultEvents(TestResultMessage var1);

    public abstract class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fServerPort = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String message;
                AbstractRemoteTestRunnerClient.this.fServerSocket = new ServerSocket(this.fServerPort);
                AbstractRemoteTestRunnerClient.this.fSocket = AbstractRemoteTestRunnerClient.this.fServerSocket.accept();
                try {
                    AbstractRemoteTestRunnerClient.this.m_inputReader = new BufferedReader(new InputStreamReader(AbstractRemoteTestRunnerClient.this.fSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    AbstractRemoteTestRunnerClient.this.m_inputReader = new BufferedReader(new InputStreamReader(AbstractRemoteTestRunnerClient.this.fSocket.getInputStream()));
                }
                try {
                    AbstractRemoteTestRunnerClient.this.m_outputWriter = new PrintWriter((Writer)new OutputStreamWriter(AbstractRemoteTestRunnerClient.this.fSocket.getOutputStream(), "UTF-8"), true);
                }
                catch (UnsupportedEncodingException e1) {
                    AbstractRemoteTestRunnerClient.this.m_outputWriter = new PrintWriter((Writer)new OutputStreamWriter(AbstractRemoteTestRunnerClient.this.fSocket.getOutputStream()), true);
                }
                while (AbstractRemoteTestRunnerClient.this.m_inputReader != null && (message = AbstractRemoteTestRunnerClient.this.readMessage(AbstractRemoteTestRunnerClient.this.m_inputReader)) != null) {
                    AbstractRemoteTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException e) {
                this.handleThrowable(e);
            }
            catch (IOException e) {
                this.handleThrowable(e);
            }
            finally {
                AbstractRemoteTestRunnerClient.this.shutdown();
            }
        }

        protected abstract void handleThrowable(Throwable var1);
    }
}

