/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "configuration.h"
#include "ledhandler.h"

#include <KProcess>

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

LEDHandler::LEDHandler()
{
    updateConfiguration();

    if (m_ledEnabled)
    {
        KProcess ledProc;
        ledProc << m_ledOffCommand;
        ledProc.startDetached();
    }

    m_isOn = false;
}

// ------------------------------------------------------------------------------------------------------------------- //

LEDHandler::~LEDHandler()
{
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods                                                                                                   //
// ------------------------------------------------------------------------------------------------------------------- //

void LEDHandler::updateConfiguration()
{
    m_ledEnabled = Configuration::config()->ledEnabled();
    m_ledOnCommand = Configuration::config()->ledOnCommand();
    m_ledOffCommand = Configuration::config()->ledOffCommand();
}

// ------------------------------------------------------------------------------------------------------------------- //

void LEDHandler::setLedOn(bool on)
{
    if (m_ledEnabled)
    {
        if (on && !m_isOn)
        {
            KProcess ledProc;
            ledProc << m_ledOnCommand;
            ledProc.startDetached();
            m_isOn = true;
        }

        else if (!on && m_isOn)
        {
            KProcess ledProc;
            ledProc << m_ledOffCommand;
            ledProc.startDetached();
            m_isOn = false;
        }
    }
}

// ------------------------------------------------------------------------------------------------------------------- //
