#include <stdio.h>
#include <errno.h>
#include <interface.h>
#include <fnld.h>

struct _fontent {
    unsigned short code;
    unsigned char bitmap[32];
} fent[65535];

int
main(int argc, char *argv[])
{
    bool all=FALSE;
    unsigned short code, max=0;
    unsigned int fnt, i, num=0;
    unsigned char line[10], *path, *font, bytes, high;
    struct fontRegs *freg=&fDRegs[1];
    extern struct fontInfo fi;

    path = NULL;
    for (i = 1; i < argc; i ++) {
  	if (*argv[i] == '-') {
	    if (*(argv[i] + 1) == 'a') all = TRUE;
	} else path = argv[i];
    }
    if (!path) {
	printf("usage: %s [minix font file]\n");
	exit(1);
    }
    if ((font = LoadFontFile(path, "minix", 0)) == NULL) {
	perror(argv[1]);
	exit(1);
    }
    high = fi.high;
    bytes = sizeof(fent[0].code) + high * 2;
    if (all) for (num = 0x2121; num < 0x7474; num ++) {
        code = num & 0x7F7F;
	if (code > max) max = code;
	fnt = freg->addr((code >> 8) & 0x7F, code & 0x7F);
	fent[code].code = code;
	memcpy(fent[code].bitmap, font + fnt, 32);
    } else while (fgets(line, sizeof(line), stdin)) {
	code = ((line[0] << 8) & 0x7F00) | (line[1] & 0x7F);
	if (code > max) max = code;
	fnt = freg->addr(line[0] & 0x7F, line[1] & 0x7F);
	fent[num].code = code;
	memcpy(fent[num].bitmap, font + fnt, 32);
	num ++;
    }
    fwrite(&high, sizeof(high), 1, stdout);
    fwrite(&max, sizeof(max), 1, stdout);
    for (i = 0; i < num; i ++) if (fent[i].code)
	fwrite(&fent[i], bytes, 1, stdout);
    return(0);
}
