/*
 * Decompiled with CFR 0.152.
 */
package net.noha.tools.ant.yuicompressor.tasks;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.UnsupportedCharsetException;
import net.noha.tools.ant.yuicompressor.tasks.CompressionStatistics;
import net.noha.tools.ant.yuicompressor.tasks.FileType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YuiCompressorTask
extends MatchingTask {
    protected File fromDir;
    protected File toDir;
    protected String charset = "ISO-8859-1";
    protected int lineBreakPosition = -1;
    protected boolean munge = false;
    protected boolean warn = true;
    private boolean enabled = true;
    protected boolean preserveAllSemiColons = true;
    protected boolean optimize = true;
    protected String jsSuffix = "-min.js";
    protected String cssSuffix = "-min.css";
    private CompressionStatistics stats = new CompressionStatistics();

    public void execute() {
        this.validateDirs();
        DirectoryScanner ds = this.getDirectoryScanner(this.fromDir);
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File inFile = new File(this.fromDir.getAbsolutePath(), files[i]);
            FileType fileType = FileType.getFileType(files[i]);
            if (fileType == null) continue;
            String newSuffix = fileType.equals((Object)FileType.JS_FILE) ? this.jsSuffix : this.cssSuffix;
            File outFile = new File(this.toDir.getAbsolutePath(), files[i].replaceFirst(fileType.getSuffix() + "$", newSuffix));
            if (this.isEnabled()) {
                this.compressFile(inFile, outFile, fileType);
                continue;
            }
            try {
                YuiCompressorTask.copyFile(inFile, outFile);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.log(this.stats.getJsStats());
        this.log(this.stats.getCssStats());
        this.log(this.stats.getTotalStats());
    }

    public static void copyFile(File srcFile, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        targetFile.createNewFile();
        FileChannel srcChannel = new FileInputStream(srcFile).getChannel();
        FileChannel dstChannel = new FileOutputStream(targetFile).getChannel();
        dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
        srcChannel.close();
        dstChannel.close();
    }

    private void compressFile(File inFile, File outFile, FileType fileType) throws EvaluatorException, BuildException {
        if (outFile.isFile() && !inFile.getAbsolutePath().equals(outFile.getAbsolutePath()) && outFile.lastModified() >= inFile.lastModified()) {
            return;
        }
        try {
            Reader in = this.openFile(inFile);
            outFile.getParentFile().mkdirs();
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), this.charset);
            if (fileType.equals((Object)FileType.JS_FILE)) {
                JavaScriptCompressor compressor = this.createJavaScriptCompressor(in);
                compressor.compress((Writer)out, this.lineBreakPosition, this.munge, this.warn, this.preserveAllSemiColons, !this.optimize);
            } else if (fileType.equals((Object)FileType.CSS_FILE)) {
                CssCompressor compressor = new CssCompressor(in);
                compressor.compress((Writer)out, this.lineBreakPosition);
            }
            in.close();
            in = null;
            ((Writer)out).close();
            out = null;
            this.log(this.stats.getFileStats(inFile, outFile, fileType));
        }
        catch (IOException ioe) {
            throw new BuildException("I/O Error when compressing file", (Throwable)ioe);
        }
    }

    private JavaScriptCompressor createJavaScriptCompressor(Reader in) throws IOException {
        JavaScriptCompressor compressor = new JavaScriptCompressor(in, new ErrorReporter(){

            private String getMessage(String source, String message, int line, int lineOffset) {
                String logMessage = line < 0 ? (source != null ? source + ":" : "" + message) : (source != null ? source + ":" : "" + line + ":" + lineOffset + ":" + message);
                return logMessage;
            }

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                YuiCompressorTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 1);
            }

            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                YuiCompressorTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 0);
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                YuiCompressorTask.this.log(this.getMessage(sourceName, message, line, lineOffset), 0);
                return new EvaluatorException(message);
            }
        });
        return compressor;
    }

    private Reader openFile(File file) throws BuildException {
        InputStreamReader in;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        }
        catch (UnsupportedCharsetException uche) {
            throw new BuildException("Unsupported charset name: " + this.charset, (Throwable)uche);
        }
        catch (IOException ioe) {
            throw new BuildException("I/O Error when reading input file", (Throwable)ioe);
        }
        return in;
    }

    private void validateDirs() throws BuildException {
        if (!this.fromDir.isDirectory()) {
            throw new BuildException(this.fromDir + " is not a valid directory");
        }
        if (!this.toDir.isDirectory()) {
            throw new BuildException(this.toDir + " is not a valid directory");
        }
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setFromDir(File fromDir) {
        this.fromDir = fromDir;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLineBreakPosition(int lineBreakPosition) {
        this.lineBreakPosition = lineBreakPosition;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setJsSuffix(String jsSuffix) {
        this.jsSuffix = jsSuffix;
    }

    public void setCssSuffix(String cssSuffix) {
        this.cssSuffix = cssSuffix;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

