# Overview of the Kopano code structure


The codebase has a lot of libraries, components and, for example, scripts.

Each top level directory is listed below with a description of what it does.


| folder              | content |
|---------------------|---------|
| autoconf/           | m4 code for autoconf to detect php and swig
| caldav/             | iCal server implementation which uses kopano-server as backend
| common/             | Unorganized shared code that is used more or less everywhere
| doc/                | Kopano manpages
| ECtools/            | Individual administrative and user tools
| gateway/            | POP3/IMAP gateway for Kopano
| inetmapi/           | Library converting between RFC 2822 mail and MAPI mail objects
| libfreebusy/        | Freebusy library from windows and from Linux
| libicalmapi/        | Library converting between iCal and MAPI calendar objects
| libsync/            | Shared library that is used by the synchronisation agent in Windows for offline synchronisation
| mapi4linux/         | MAPI library (source-compatible with Windows MAPI32)
| php-ext/            | PHP5 module for libmapi, and PHP-MAPI library
| php7-ext/           | PHP7 module for libmapi
| po/                 | Translations
| provider/           | 
| provider/client/    | The Kopano client, a plugin ("provider") for MAPI. Provides Global Addressbook (GAB), all your stores, private and delegate.
| provider/common/    | Unorganized shared code used all over provider/
| provider/contact/   | Address book plugin for MAPI, displays one or multiple address books, for example in WebApp, as contacts.
| provider/include/   | Unorganized headers and gSOAP template
| provider/libserver/ | The unmanaged Kopano Storage Server implementation
| provider/plugins/   | Plugins for KSS
| provider/server/    | The managed Kopano Server (thread pool and network socket manager atop libserver)
| provider/soap/      | Autogenerated code from gSOAP; HTTP server and client
| spooler/            | Delivery Agent (an LMTP daemon for Postfix that stores mail into KSS) and Spooler (SMTP client that reads mail from KSS and sends to e.g. Postfix)
| swig/               | Python bindings for MAPI
| tools/              | Collection of miscellaneous tools

# MAPI Properties

All initial MAPI properties can be found in ```mapi4linux/include/mapi.h```, later added property definitions are found in ```common/mapiext.h```.

Kopano defined properties (all properties which start with PR_EC_*) can be found in ```common/ECTags.h```.
