package junit.test.svg;

import latexDraw.parsers.svg.*;
import latexDraw.parsers.svg.elements.SVGCircleElement;
import latexDraw.parsers.svg.elements.SVGElement;
import latexDraw.parsers.svg.parsers.UnitProcessor;

import org.junit.Before;
import org.junit.Test;

/** 
 * This class contains tests for the SVGCircleElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 02/02/08<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestSVGCircleElement extends AbstractTestSVGElement
{
	@Override
	@Before
	public void setUp()
	{
		doc = new SVGDocument();
        node = (SVGElement)doc.createElement(SVGElements.SVG_CIRCLE);
	}
	
	
	
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGCircleElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try
		{ 
			new SVGCircleElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}

		try
		{ 
			node.setAttribute(SVGAttributes.SVG_R, "dsd"); //$NON-NLS-1$
			new SVGCircleElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_R, "-1"); //$NON-NLS-1$
			new SVGCircleElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_R, "10"); //$NON-NLS-1$
			new SVGCircleElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetCy()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_R, "10"); //$NON-NLS-1$
			SVGCircleElement e = new SVGCircleElement(node, null);
			assertEquals(e.getCy(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_CY, "40"); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCy(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CY, "40px "); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCy(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CY, " 40 cm "); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCy(), UnitProcessor.toUserUnit(40, SVGLength.LengthType.CM));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetCx()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_R, "10"); //$NON-NLS-1$
			SVGCircleElement e = new SVGCircleElement(node, null);
			assertEquals(e.getCx(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_CX, "76.987"); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCx(), 76.987);
			
			node.setAttribute(SVGAttributes.SVG_CX, "40px "); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCx(), 40.);
			
			node.setAttribute(SVGAttributes.SVG_CX, " 30.5 mm "); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getCx(), UnitProcessor.toUserUnit(30.5, SVGLength.LengthType.MM));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_R, "0"); //$NON-NLS-1$
			SVGCircleElement e = new SVGCircleElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_R, "10"); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertTrue(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetR()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_R, "20"); //$NON-NLS-1$
			SVGCircleElement e = new SVGCircleElement(node, null);
			assertEquals(e.getR(), 20.);
			node.setAttribute(SVGAttributes.SVG_R, "20 pt"); //$NON-NLS-1$
			e = new SVGCircleElement(node, null);
			assertEquals(e.getR(), UnitProcessor.toUserUnit(20, SVGLength.LengthType.PT));
		}
		catch(MalformedSVGDocument e) { fail(); }
	}


	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_CIRCLE;
	}
}
