package latexDraw.parsers.svg;

import java.util.HashMap;

import latexDraw.parsers.svg.parsers.CSSStyleHandler;

/**
 * Defines a list of CSS styles.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/24/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 */
public class CSSStyleList extends HashMap<String, String> implements CSSStyleHandler
{
	private static final long serialVersionUID = 1L;


	/**
	 * Adds a CSS style to the list.
	 * @param name The name of the style.
	 * @param value The value of the style.
	 * @since 0.1
	 */
	public void addCSSStyle(String name, String value)
	{
		if(name!=null && value!=null)
			put(name, value);
	}
	
	
	
	/**
	 * @param styleName The name of the style.
	 * @return The value of the given CSS style name or null.
	 */
	public String getCSSValue(String styleName)
	{
		return get(styleName);
	}
	
	
	
	public void onCSSStyle(String name, String value)
	{
		if(name!=null && value!=null)
			addCSSStyle(name, value);
	}
}
