; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7m-arm-none-eabi | FileCheck %s

define internal i32 @table_switch(i32 %x) {
; CHECK-LABEL: table_switch:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bti
; CHECK-NEXT:    subs r1, r0, #1
; CHECK-NEXT:    cmp r1, #3
; CHECK-NEXT:    bhi .LBB0_4
; CHECK-NEXT:  @ %bb.1: @ %entry
; CHECK-NEXT:  .LCPI0_0:
; CHECK-NEXT:    tbb [pc, r1]
; CHECK-NEXT:  @ %bb.2:
; CHECK-NEXT:  .LJTI0_0:
; CHECK-NEXT:    .byte (.LBB0_5-(.LCPI0_0+4))/2
; CHECK-NEXT:    .byte (.LBB0_3-(.LCPI0_0+4))/2
; CHECK-NEXT:    .byte (.LBB0_6-(.LCPI0_0+4))/2
; CHECK-NEXT:    .byte (.LBB0_7-(.LCPI0_0+4))/2
; CHECK-NEXT:    .p2align 1
; CHECK-NEXT:  .LBB0_3: @ %bb2
; CHECK-NEXT:    bti
; CHECK-NEXT:    movs r0, #2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .LBB0_4: @ %sw.epilog
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:  .LBB0_5: @ %return
; CHECK-NEXT:    bti
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .LBB0_6: @ %bb3
; CHECK-NEXT:    bti
; CHECK-NEXT:    movs r0, #3
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .LBB0_7: @ %bb4
; CHECK-NEXT:    bti
; CHECK-NEXT:    movs r0, #4
; CHECK-NEXT:    bx lr
entry:
  switch i32 %x, label %sw.epilog [
    i32 1, label %bb1
    i32 2, label %bb2
    i32 3, label %bb3
    i32 4, label %bb4
  ]

bb1:
  br label %return
bb2:
  br label %return
bb3:
  br label %return
bb4:
  br label %return
sw.epilog:
  br label %return

return:
  %ret = phi i32 [ 0, %sw.epilog ], [ 1, %bb1 ], [ 2, %bb2 ], [ 3, %bb3 ], [ 4, %bb4 ]
  ret i32 %ret
}

@computed_goto_cases = private unnamed_addr constant [2 x ptr] [ptr blockaddress(@computed_goto, %return), ptr blockaddress(@computed_goto, %case_1)], align 4

define internal i32 @computed_goto(i32 %x) {
; CHECK-LABEL: computed_goto:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bti
; CHECK-NEXT:    movw r1, :lower16:.Lcomputed_goto_cases
; CHECK-NEXT:    movt r1, :upper16:.Lcomputed_goto_cases
; CHECK-NEXT:    ldr.w r0, [r1, r0, lsl #2]
; CHECK-NEXT:    mov pc, r0
; CHECK-NEXT:  .Ltmp3: @ Block address taken
; CHECK-NEXT:  .LBB1_1: @ %return
; CHECK-NEXT:    bti
; CHECK-NEXT:    movs r0, #2
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .Ltmp4: @ Block address taken
; CHECK-NEXT:  .LBB1_2: @ %case_1
; CHECK-NEXT:    bti
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    bx lr
entry:
  %arrayidx = getelementptr inbounds [2 x ptr], ptr @computed_goto_cases, i32 0, i32 %x
  %0 = load ptr, ptr %arrayidx, align 4
  indirectbr ptr %0, [label %return, label %case_1]

case_1:
  br label %return

return:
  %ret = phi i32 [ 1, %case_1 ], [ 2, %entry ]
  ret i32 %ret
}

declare void @may_throw()
declare void @consume_exception(ptr)
declare i32 @__gxx_personality_v0(...)

define internal i32 @exception_handling(i32 %0) personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: exception_handling:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    bti
; CHECK-NEXT:    .save  {r7, lr}
; CHECK-NEXT:    push   {r7, lr}
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    bl     may_throw
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:    movs   r0, #0
; CHECK-NEXT:    pop    {r7, pc}
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    bti
; CHECK-NEXT:    bl     consume_exception
; CHECK-NEXT:    movs   r0, #1
; CHECK-NEXT:    pop    {r7, pc}
entry:
  invoke void @may_throw()
          to label %return unwind label %lpad

lpad:
  %1 = landingpad { ptr, i32 }
          catch ptr null
  %2 = extractvalue { ptr, i32 } %1, 0
  call void @consume_exception(ptr %2)
  br label %return

return:
  %retval.0 = phi i32 [ 1, %lpad ], [ 0, %entry ]
  ret i32 %retval.0
}

!llvm.module.flags = !{!1}
!1 = !{i32 8, !"branch-target-enforcement", i32 1}
