; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals
; RUN: opt < %s -passes=simplifycfg -simplifycfg-require-and-preserve-domtree=1  -S | FileCheck %s

define void @test1(i1 %C, ptr %BP) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[C:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %C, label %T, label %F
T:
  store i1 %C, ptr %BP
  unreachable
F:
  ret void
}

define void @test2() personality ptr @__gxx_personality_v0 {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @test2() #[[ATTR3:[0-9]+]]
; CHECK-NEXT:    ret void
;
entry:
  invoke void @test2( )
  to label %N unwind label %U
U:
  %res = landingpad { ptr }
  cleanup
  unreachable
N:
  ret void
}

declare i32 @__gxx_personality_v0(...)

define i32 @test3(i32 %v) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[V:%.*]], 2
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND]], i32 2, i32 1
; CHECK-NEXT:    ret i32 [[SPEC_SELECT]]
;
entry:
  switch i32 %v, label %default [
  i32 1, label %U
  i32 2, label %T
  ]
default:
  ret i32 1
U:
  unreachable
T:
  ret i32 2
}


;; We can either convert the following control-flow to a select or remove the
;; unreachable control flow because of the undef store of null. Make sure we do
;; the latter.

define void @test5(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[COND:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    store i8 2, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %bb1, label %bb3

bb3:
  br label %bb2

bb1:
  br label %bb2

bb2:
  %ptr.2 = phi ptr [ %ptr, %bb3 ], [ null, %bb1 ]
  store i8 2, ptr %ptr.2, align 8
  ret void
}

declare void @llvm.assume(i1)
declare i1 @llvm.type.test(ptr, metadata) nounwind readnone

;; Same as the above test but make sure the unreachable control flow is still
;; removed in the presence of a type test / assume sequence.

define void @test5_type_test_assume(i1 %cond, ptr %ptr, ptr %vtable) {
; CHECK-LABEL: @test5_type_test_assume(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[COND:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[P:%.*]] = call i1 @llvm.type.test(ptr [[VTABLE:%.*]], metadata !"foo")
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[P]])
; CHECK-NEXT:    store i8 2, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %bb1, label %bb3

bb3:
  br label %bb2

bb1:
  br label %bb2

bb2:
  %ptr.2 = phi ptr [ %ptr, %bb3 ], [ null, %bb1 ]
  %p = call i1 @llvm.type.test(ptr %vtable, metadata !"foo")
  tail call void @llvm.assume(i1 %p)
  store i8 2, ptr %ptr.2, align 8
  ret void
}

define void @test5_no_null_opt(i1 %cond, ptr %ptr) #0 {
; CHECK-LABEL: @test5_no_null_opt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[DOTPTR:%.*]] = select i1 [[COND:%.*]], ptr null, ptr [[PTR:%.*]]
; CHECK-NEXT:    store i8 2, ptr [[DOTPTR]], align 8
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %bb1, label %bb3

bb3:
  br label %bb2

bb1:
  br label %bb2

bb2:
  %ptr.2 = phi ptr [ %ptr, %bb3 ], [ null, %bb1 ]
  store i8 2, ptr %ptr.2, align 8
  ret void
}

define void @test6(i1 %cond, ptr %ptr) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[COND:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    store i8 2, ptr [[PTR:%.*]], align 8
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %bb1, label %bb2

bb1:
  br label %bb2

bb2:
  %ptr.2 = phi ptr [ %ptr, %entry ], [ null, %bb1 ]
  store i8 2, ptr %ptr.2, align 8
  ret void
}

define void @test6_no_null_opt(i1 %cond, ptr %ptr) #0 {
; CHECK-LABEL: @test6_no_null_opt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[COND:%.*]], ptr null, ptr [[PTR:%.*]]
; CHECK-NEXT:    store i8 2, ptr [[SPEC_SELECT]], align 8
; CHECK-NEXT:    ret void
;
entry:
  br i1 %cond, label %bb1, label %bb2

bb1:
  br label %bb2

bb2:
  %ptr.2 = phi ptr [ %ptr, %entry ], [ null, %bb1 ]
  store i8 2, ptr %ptr.2, align 8
  ret void
}


define i32 @test7(i1 %X) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    ret i32 0
;
entry:
  br i1 %X, label %if, label %else

if:
  call void undef()
  br label %else

else:
  %phi = phi i32 [ 0, %entry ], [ 1, %if ]
  ret i32 %phi
}

define void @test8(i1 %X, ptr %Y) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    call void [[Y:%.*]]()
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call void %phi()
  ret void
}

define void @test8_no_null_opt(i1 %X, ptr %Y) #0 {
; CHECK-LABEL: @test8_no_null_opt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    call void [[SPEC_SELECT]]()
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call void %phi()
  ret void
}

declare ptr @fn_nonnull_noundef_arg(ptr nonnull noundef %p)
declare ptr @fn_nonnull_deref_arg(ptr nonnull dereferenceable(4) %p)
declare ptr @fn_nonnull_deref_or_null_arg(ptr nonnull dereferenceable_or_null(4) %p)
declare ptr @fn_nonnull_arg(ptr nonnull %p)
declare ptr @fn_noundef_arg(ptr noundef %p)

define void @test9(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_noundef_arg(ptr %phi)
  ret void
}

; Optimizing this code should produce assume.
define void @test9_deref(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_deref(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_deref_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_deref_arg(ptr %phi)
  ret void
}

; Optimizing this code should produce assume.
define void @test9_deref_or_null(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_deref_or_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_deref_or_null_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_deref_or_null_arg(ptr %phi)
  ret void
}

define void @test9_undef(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_undef(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_noundef_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ undef, %if ]
  call ptr @fn_noundef_arg(ptr %phi)
  ret void
}

define void @test9_undef_null_defined(i1 %X, ptr %Y) #0 {
; CHECK-LABEL: @test9_undef_null_defined(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_noundef_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ undef, %if ]
  call ptr @fn_noundef_arg(ptr %phi)
  ret void
}

define void @test9_null_callsite(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_null_callsite(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_arg(ptr noundef nonnull [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_arg(ptr nonnull noundef %phi)
  ret void
}

define void @test9_gep_mismatch(i1 %X, ptr %Y,  ptr %P) {
; CHECK-LABEL: @test9_gep_mismatch(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[P:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_noundef_arg(ptr %P)
  ret void
}

define void @test9_gep_zero(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_gep_zero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_noundef_arg(ptr %phi)
  ret void
}

define void @test9_gep_bitcast(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_gep_bitcast(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = xor i1 [[X:%.*]], true
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP0]])
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[Y:%.*]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_noundef_arg(ptr %phi)
  ret void
}

define void @test9_gep_nonzero(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_gep_nonzero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[SPEC_SELECT]], i64 12
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[GEP]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  %gep = getelementptr i8, ptr %phi, i64 12
  call ptr @fn_nonnull_noundef_arg(ptr %gep)
  ret void
}

define void @test9_gep_inbounds_nonzero(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_gep_inbounds_nonzero(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[SPEC_SELECT]], i64 12
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[GEP]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  %gep = getelementptr inbounds i8, ptr %phi, i64 12
  call ptr @fn_nonnull_noundef_arg(ptr %gep)
  ret void
}


define void @test9_gep_inbouds_unknown_null(i1 %X, ptr %Y, i64 %I) {
; CHECK-LABEL: @test9_gep_inbouds_unknown_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, ptr [[SPEC_SELECT]], i64 [[I:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[GEP]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  %gep = getelementptr inbounds i8, ptr %phi, i64 %I
  call ptr @fn_nonnull_noundef_arg(ptr %gep)
  ret void
}

define void @test9_gep_unknown_null(i1 %X, ptr %Y, i64 %I) {
; CHECK-LABEL: @test9_gep_unknown_null(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[SPEC_SELECT]], i64 [[I:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[GEP]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  %gep = getelementptr i8, ptr %phi, i64 %I
  call ptr @fn_nonnull_noundef_arg(ptr %gep)
  ret void
}

define void @test9_gep_unknown_undef(i1 %X, ptr %Y, i64 %I) {
; CHECK-LABEL: @test9_gep_unknown_undef(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[Y:%.*]], i64 [[I:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_noundef_arg(ptr [[GEP]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ undef, %if ]
  %gep = getelementptr i8, ptr %phi, i64 %I
  call ptr @fn_noundef_arg(ptr %gep)
  ret void
}

define void @test9_missing_noundef(i1 %X, ptr %Y) {
; CHECK-LABEL: @test9_missing_noundef(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_arg(ptr [[SPEC_SELECT]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_arg(ptr %phi)
  ret void
}

define void @test9_null_defined(i1 %X, ptr %Y) #0 {
; CHECK-LABEL: @test9_null_defined(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[X:%.*]], ptr null, ptr [[Y:%.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = call ptr @fn_nonnull_noundef_arg(ptr [[SPEC_SELECT]])
; CHECK-NEXT:    ret void
;
entry:
  br i1 %X, label %if, label %else

if:
  br label %else

else:
  %phi = phi ptr [ %Y, %entry ], [ null, %if ]
  call ptr @fn_nonnull_noundef_arg(ptr %phi)
  ret void
}



attributes #0 = { null_pointer_is_valid }
;.
; CHECK: attributes #[[ATTR0:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: readwrite) }
; CHECK: attributes #[[ATTR1:[0-9]+]] = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
; CHECK: attributes #[[ATTR2:[0-9]+]] = { null_pointer_is_valid }
; CHECK: attributes #[[ATTR3]] = { nounwind }
;.
