; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=loop-vectorize -force-vector-interleave=1 -force-vector-width=2 %s -S | FileCheck --check-prefix=VF2 %s
; RUN: opt -passes=loop-vectorize -force-vector-interleave=1 -force-vector-width=4 %s -S | FileCheck --check-prefix=VF4 %s

; for (iv = 0, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step1_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step1_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[TMP1]], [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[TMP13]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP12]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP15]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step1_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP3:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
; A[iv/2 + iv2/2] is uniform for VF=2 but not for VF=4.
define void @ld_div2_step1_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step1_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = udiv i64 [[TMP0]], 2
; VF2-NEXT:    [[TMP3:%.*]] = udiv i64 [[TMP1]], 2
; VF2-NEXT:    [[TMP4:%.*]] = add i64 [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <2 x i64> poison, i64 [[TMP6]], i64 0
; VF2-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <2 x i64> [[BROADCAST_SPLATINSERT]], <2 x i64> poison, <2 x i32> zeroinitializer
; VF2-NEXT:    [[TMP7:%.*]] = add nsw <2 x i64> [[BROADCAST_SPLAT]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[TMP8]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP7]], ptr [[TMP9]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP10]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step1_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP5:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step1_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step1_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[TMP1]], [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[TMP13]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP12]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP15]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP7:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step1_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP7:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step2_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step2_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP9:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step2_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 2, i64 4, i64 6>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP9:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
define void @ld_div2_step2_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step2_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP11:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step2_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 2, i64 4, i64 6>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP11:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step2_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step2_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP13:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step2_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 2, i64 4, i64 6>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 1000, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 500, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP13:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step3_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step3_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP15:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step3_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 3, i64 6, i64 9>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP15:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
define void @ld_div2_step3_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step3_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP17:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step3_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 3, i64 6, i64 9>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP17:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step3_start0_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step3_start0_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP4:%.*]] = add <2 x i64> [[TMP2]], [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP4]], i32 0
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = extractelement <2 x i64> [[TMP4]], i32 1
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP8]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> poison, i64 [[TMP9]], i32 0
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> [[TMP11]], i64 [[TMP10]], i32 1
; VF2-NEXT:    [[TMP13:%.*]] = add nsw <2 x i64> [[TMP12]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP13]], i32 0
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP13]], i32 1
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP18:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP18]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP18:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP19:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step3_start0_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 3, i64 6, i64 9>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP4:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP6:%.*]] = add <4 x i64> [[TMP4]], [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP6]], i32 0
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP6]], i32 1
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP6]], i32 2
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP6]], i32 3
; VF4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP13]]
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP14]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> poison, i64 [[TMP15]], i32 0
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 1
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 2
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 3
; VF4-NEXT:    [[TMP23:%.*]] = add nsw <4 x i64> [[TMP22]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP23]], i32 0
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP23]], i32 1
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP23]], i32 2
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP23]], i32 3
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP32:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP32]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP18:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP19:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step1_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step1_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[TMP1]], [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[TMP13]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP12]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], 998
; VF2-NEXT:    br i1 [[TMP15]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP20:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 999, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 998, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP21:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step1_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 996
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP20:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP21:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
define void @ld_div2_step1_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step1_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[TMP1]], [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[TMP13]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP12]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], 998
; VF2-NEXT:    br i1 [[TMP15]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP22:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 999, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 998, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP23:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step1_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 996
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP22:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP23:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 1, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step1_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step1_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP2:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[TMP1]], [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[TMP13]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP12]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], 998
; VF2-NEXT:    br i1 [[TMP15]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP24:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 999, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 998, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP25:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step1_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP2:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[TMP1]], [[TMP2]]
; VF4-NEXT:    [[TMP4:%.*]] = extractelement <4 x i64> [[TMP3]], i32 0
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP3]], i32 1
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP3]], i32 2
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP3]], i32 3
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP5]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> poison, i64 [[TMP12]], i32 0
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> [[TMP16]], i64 [[TMP13]], i32 1
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 2
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 3
; VF4-NEXT:    [[TMP20:%.*]] = add nsw <4 x i64> [[TMP19]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[TMP21]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP20]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP23:%.*]] = icmp eq i64 [[INDEX_NEXT]], 996
; VF4-NEXT:    br i1 [[TMP23]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP24:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 996, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 1
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP25:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step2_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step2_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 498
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP26:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 498, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP27:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step2_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 3, i64 5, i64 7>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 496
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP26:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 993, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 496, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP27:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
define void @ld_div2_step2_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step2_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 498
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP28:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 498, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP29:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step2_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 3, i64 5, i64 7>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 496
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP28:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 993, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 496, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP29:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 2, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step2_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step2_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 4, i64 4>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 498
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP30:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 498, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP31:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step2_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 3, i64 5, i64 7>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 8, i64 8, i64 8, i64 8>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 496
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP30:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 993, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 496, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 2
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP31:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/1 + iv2/1] + 42;
define void @ld_div1_step3_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div1_step3_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 1, i64 1>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP32:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP33:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div1_step3_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 4, i64 7, i64 10>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 1, i64 1, i64 1, i64 1>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP32:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 1
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 1
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP33:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 1
  %div2 = udiv i64 %iv2, 1
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/2 + iv2/2] + 42;
define void @ld_div2_step3_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div2_step3_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP34:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP35:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div2_step3_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 4, i64 7, i64 10>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 2, i64 2, i64 2, i64 2>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP34:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 2
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 2
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP35:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 2
  %div2 = udiv i64 %iv2, 2
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1, iv2 = 0 ; ; iv += 3, iv2 += 1) B[iv] = A[iv/3 + iv2/3] + 42;
define void @ld_div3_step3_start1_ind2(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_div3_step3_start1_ind2
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND2:%.*]] = phi <2 x i64> [ <i64 0, i64 1>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP3:%.*]] = udiv <2 x i64> [[VEC_IND]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP4:%.*]] = udiv <2 x i64> [[VEC_IND2]], <i64 3, i64 3>
; VF2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[TMP3]], [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
; VF2-NEXT:    [[TMP12:%.*]] = insertelement <2 x i64> poison, i64 [[TMP10]], i32 0
; VF2-NEXT:    [[TMP13:%.*]] = insertelement <2 x i64> [[TMP12]], i64 [[TMP11]], i32 1
; VF2-NEXT:    [[TMP14:%.*]] = add nsw <2 x i64> [[TMP13]], <i64 42, i64 42>
; VF2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP17:%.*]] = extractelement <2 x i64> [[TMP14]], i32 0
; VF2-NEXT:    store i64 [[TMP17]], ptr [[TMP15]], align 8
; VF2-NEXT:    [[TMP18:%.*]] = extractelement <2 x i64> [[TMP14]], i32 1
; VF2-NEXT:    store i64 [[TMP18]], ptr [[TMP16]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], <i64 6, i64 6>
; VF2-NEXT:    [[VEC_IND_NEXT3]] = add <2 x i64> [[VEC_IND2]], <i64 2, i64 2>
; VF2-NEXT:    [[TMP19:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP19]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP36:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
; VF2-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF2-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF2-NEXT:    br label [[LOOP:%.*]]
; VF2:       loop:
; VF2-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF2-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF2-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF2-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF2-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF2-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF2-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF2-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF2-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF2-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF2-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF2-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF2-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP37:![0-9]+]]
; VF2:       exit:
; VF2-NEXT:    ret void
;
; VF4-LABEL: define void @ld_div3_step3_start1_ind2
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 4, i64 7, i64 10>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND2:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT3:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP5:%.*]] = udiv <4 x i64> [[VEC_IND]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP6:%.*]] = udiv <4 x i64> [[VEC_IND2]], <i64 3, i64 3, i64 3, i64 3>
; VF4-NEXT:    [[TMP7:%.*]] = add <4 x i64> [[TMP5]], [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP14]]
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP19:%.*]] = load i64, ptr [[TMP15]], align 8
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> poison, i64 [[TMP16]], i32 0
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 1
; VF4-NEXT:    [[TMP22:%.*]] = insertelement <4 x i64> [[TMP21]], i64 [[TMP18]], i32 2
; VF4-NEXT:    [[TMP23:%.*]] = insertelement <4 x i64> [[TMP22]], i64 [[TMP19]], i32 3
; VF4-NEXT:    [[TMP24:%.*]] = add nsw <4 x i64> [[TMP23]], <i64 42, i64 42, i64 42, i64 42>
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP27:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP28:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP24]], i32 0
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP24]], i32 1
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[TMP31:%.*]] = extractelement <4 x i64> [[TMP24]], i32 2
; VF4-NEXT:    store i64 [[TMP31]], ptr [[TMP27]], align 8
; VF4-NEXT:    [[TMP32:%.*]] = extractelement <4 x i64> [[TMP24]], i32 3
; VF4-NEXT:    store i64 [[TMP32]], ptr [[TMP28]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], <i64 12, i64 12, i64 12, i64 12>
; VF4-NEXT:    [[VEC_IND_NEXT3]] = add <4 x i64> [[VEC_IND2]], <i64 4, i64 4, i64 4, i64 4>
; VF4-NEXT:    [[TMP33:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP33]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP36:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
; VF4-NEXT:    [[BC_RESUME_VAL:%.*]] = phi i64 [ 997, [[MIDDLE_BLOCK]] ], [ 1, [[ENTRY:%.*]] ]
; VF4-NEXT:    [[BC_RESUME_VAL1:%.*]] = phi i64 [ 332, [[MIDDLE_BLOCK]] ], [ 0, [[ENTRY]] ]
; VF4-NEXT:    br label [[LOOP:%.*]]
; VF4:       loop:
; VF4-NEXT:    [[IV:%.*]] = phi i64 [ [[BC_RESUME_VAL]], [[SCALAR_PH]] ], [ [[IV_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[IV2:%.*]] = phi i64 [ [[BC_RESUME_VAL1]], [[SCALAR_PH]] ], [ [[IV2_NEXT:%.*]], [[LOOP]] ]
; VF4-NEXT:    [[DIV1:%.*]] = udiv i64 [[IV]], 3
; VF4-NEXT:    [[DIV2:%.*]] = udiv i64 [[IV2]], 3
; VF4-NEXT:    [[ADD:%.*]] = add i64 [[DIV1]], [[DIV2]]
; VF4-NEXT:    [[GEP_LD:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[ADD]]
; VF4-NEXT:    [[LD:%.*]] = load i64, ptr [[GEP_LD]], align 8
; VF4-NEXT:    [[CALC:%.*]] = add nsw i64 [[LD]], 42
; VF4-NEXT:    [[GEP_ST:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[IV]]
; VF4-NEXT:    store i64 [[CALC]], ptr [[GEP_ST]], align 8
; VF4-NEXT:    [[IV2_NEXT]] = add nsw i64 [[IV2]], 1
; VF4-NEXT:    [[IV_NEXT]] = add nsw i64 [[IV]], 3
; VF4-NEXT:    [[COND:%.*]] = icmp eq i64 [[IV_NEXT]], 1000
; VF4-NEXT:    br i1 [[COND]], label [[EXIT]], label [[LOOP]], !llvm.loop [[LOOP37:![0-9]+]]
; VF4:       exit:
; VF4-NEXT:    ret void
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %iv2 = phi i64 [ 0, %entry ], [ %iv2_next, %loop ]
  %div1 = udiv i64 %iv, 3
  %div2 = udiv i64 %iv2, 3
  %add = add i64 %div1, %div2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %add
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv2_next = add nsw i64 %iv2, 1
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}
