; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes="separate-const-offset-from-gep<lower-gep>" < %s | FileCheck %s

; Check that GEP with an index 'A - B + [ConstantInt]' will be split into two
; GEPs. eg.
;     %A = ...
;     %B = ...
;     %sub = %A - %B
;     %idx = %sub + 10
;     %gep = getelementptr int, ptr %p, %idx
;  will be transformed into:
;     %A = ...
;     %B = ...
;     %sub = %A - %B
;     %gep_base = getelementptr int, ptr %p, %sub
;     %gep = getelementptr int, ptr %gep_base, 10

define void @test_A_sub_B_add_ConstantInt(ptr %p) {
; CHECK-LABEL: @test_A_sub_B_add_ConstantInt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call i32 @foo()
; CHECK-NEXT:    [[REM:%.*]] = srem i32 [[TMP0]], 5
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[K:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[COND_END:%.*]] ]
; CHECK-NEXT:    [[MUL:%.*]] = mul nuw nsw i32 [[K]], 5
; CHECK-NEXT:    [[SUB1:%.*]] = sub nsw i32 [[MUL]], [[REM]]
; CHECK-NEXT:    [[CMP26:%.*]] = icmp ult i32 [[SUB1]], 512
; CHECK-NEXT:    br i1 [[CMP26]], label [[COND_TRUE:%.*]], label [[COND_END]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[TMP1:%.*]] = sext i32 [[MUL]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = sext i32 [[REM]] to i64
; CHECK-NEXT:    [[SUB22:%.*]] = sub i64 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP3:%.*]] = ptrtoint ptr [[P:%.*]] to i64
; CHECK-NEXT:    [[TMP4:%.*]] = shl i64 [[SUB22]], 2
; CHECK-NEXT:    [[TMP5:%.*]] = add i64 [[TMP3]], [[TMP4]]
; CHECK-NEXT:    [[TMP6:%.*]] = add i64 [[TMP5]], 2044
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    store float 1.000000e+00, ptr [[TMP7]], align 4
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[K]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i32 [[INC]], 100
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %0 = tail call i32 @foo()
  %rem = srem i32 %0, 5
  %add = add nsw i32 %rem , 511
  br label %for.body

for.body:
  %k = phi i32 [ 0, %entry ], [ %inc, %cond.end ]
  %mul = mul nuw nsw i32 %k, 5
  %sub1 = sub nsw i32 %mul, %rem
  %cmp26 = icmp ult i32 %sub1, 512
  br i1 %cmp26, label %cond.true, label %cond.end

cond.true:
  %sub2 = sub nsw i32 %add, %mul
  %idxprom = sext i32 %sub2 to i64
  %arryidx = getelementptr inbounds float, ptr %p, i64 %idxprom
  store float 1.0, ptr %arryidx, align 4
  br label %cond.end

cond.end:
  %inc = add nuw nsw i32 %k, 1
  %exitcond = icmp ne i32 %inc, 100
  br i1 %exitcond, label %for.body, label %for.end

for.end:
  ret void
}

declare i32 @foo()
