/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Christian Dywan <christian.dywan@canonical.com>
 */

#include <QtCore/QCoreApplication>
#include <QtGui/QMatrix4x4>
#include <QtGui/QQuaternion>
#include <QtGui/QVector3D>
#include <QtGui/QVector4D>
#include <QtQml/QQmlEngine>
#include <QtQml/QQmlProperty>
#include <QtQuick/QQuickItem>
#include <QtQuick/QQuickView>
#include <QtTest/QtTest>
#include <QtTest/QSignalSpy>

#include "uctestcase.h"

class tst_OrientationTest : public QObject
{
    Q_OBJECT
public:
    tst_OrientationTest() {}

private Q_SLOTS:

    void test_defaults()
    {
        QScopedPointer<LomiriTestCase> testCase(new LomiriTestCase("Defaults.qml"));
        QQuickItem *helper = testCase->findItem<QQuickItem*>("helper");
        QCOMPARE(helper->property("automaticOrientation").toBool(), true);
        // No warnings expected
        QCOMPARE(testCase->warnings(), 0);
    }

    void test_manualAngle()
    {
        QScopedPointer<LomiriTestCase> testCase(new LomiriTestCase("ManualAngle.qml"));
        QQuickItem *helper = testCase->findItem<QQuickItem*>("helper");
        // No warning about "window" being undefined must appear
        QSKIP("FIXME: We have no valid effectiveness tests for OrientationHelper. See bug #1626063.");
        QCOMPARE(testCase->warnings(), 0);
        QCOMPARE(helper->property("orientationAngle").toInt(), 90);
        // Verify expected values
        QQuickItem *checkpoint = testCase->findItem<QQuickItem*>("checkpoint");
        // window.contentOrientation
        QCOMPARE(checkpoint->property("contentOrientation").toInt(), helper->property("orientationAngle").toInt());
    }
};

QTEST_MAIN(tst_OrientationTest)

#include "tst_orientation.moc"



