;;;; -*-coding: iso-8859-1;-*-
;;;;;
;;;;; Copyright (C) 1991-2002  Lysator Academic Computer Association.
;;;;;
;;;;; This file is part of the LysKOM Emacs LISP client.
;;;;; 
;;;;; LysKOM is free software; you can redistribute it and/or modify it
;;;;; under the terms of the GNU General Public License as published by 
;;;;; the Free Software Foundation; either version 2, or (at your option) 
;;;;; any later version.
;;;;; 
;;;;; LysKOM is distributed in the hope that it will be useful, but WITHOUT
;;;;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;;;;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;;;;; for more details.
;;;;; 
;;;;; You should have received a copy of the GNU General Public License
;;;;; along with LysKOM; see the file COPYING.  If not, write to
;;;;; Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
;;;;; or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
;;;;; MA 02139, USA.
;;;;;
;;;;; Please mail bug reports to bug-lyskom@lysator.liu.se. 
;;;;;
;;;; ================================================================
;;;; ================================================================
;;;;
;;;; File: swedish-strings.el
;;;;
;;;; This file contains all strings in the LysKOM elisp client.
;;;; Language: Swedish.
;;;;
;;;; ================================================================
;;;;

(require 'lyskom-vars "vars")
(require 'lyskom-language "language")


;;; ================================================================
;;; The language definition

(lyskom-define-language 'sv
                        'iso-8859-1
                        "Svenska"
                        )


;;; ================================================================
;;; lyskom-edit-mode-map

(defvar lyskom-sv-edit-mode-map nil)
(lyskom-language-keymap lyskom-edit-mode-map sv lyskom-sv-edit-mode-map)

;;; Set the keymap for lyskom-edit-mode

(defvar lyskom-sv-edit-prefix)
(defvar lyskom-sv-edit-review-prefix)
(defvar lyskom-sv-edit-insert-prefix)
(defvar lyskom-sv-edit-aux-prefix)
(defvar lyskom-sv-edit-add-prefix)

(if lyskom-sv-edit-mode-map
    nil
  (setq lyskom-sv-edit-mode-map (make-sparse-keymap))
  (define-prefix-command 'lyskom-sv-edit-prefix)
  (define-prefix-command 'lyskom-sv-edit-review-prefix)
  (define-prefix-command 'lyskom-sv-edit-insert-prefix)
  (define-prefix-command 'lyskom-sv-edit-aux-prefix)
  (define-prefix-command 'lyskom-sv-edit-add-prefix)
  (define-key lyskom-sv-edit-mode-map (kbd "*")     'kom-button-press-or-self-insert-command)
  (define-key lyskom-sv-edit-mode-map (kbd "=")     'kom-menu-button-press-or-self-insert-command)
  (define-key lyskom-sv-edit-mode-map (kbd "TAB")   'kom-edit-next-button-or-self-insert)
  (define-key lyskom-sv-edit-mode-map (kbd "M-TAB") 'kom-edit-prev-button)
  (define-key lyskom-sv-edit-mode-map (kbd "<S-tab>") 'kom-edit-prev-button)
  (define-key lyskom-sv-edit-mode-map (kbd "C-c")   'lyskom-sv-edit-prefix)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2 'button2up))) 'kom-button-click-or-yank)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys (lyskom-xemacs-or-gnu 'button2up 'button2))) 'kom-mouse-null)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-sv-edit-mode-map (kbd (lyskom-keys 'button3up))     'kom-mouse-null)

  (define-key lyskom-sv-edit-prefix (kbd "C-x")     'lyskom-sv-edit-aux-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-a")     'lyskom-sv-edit-add-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "C-i")     'lyskom-sv-edit-insert-prefix)
  (define-key lyskom-sv-edit-prefix (kbd "TAB")     'lyskom-sv-edit-insert-prefix)

  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "C-]")       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "C-}")       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "C-")       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "C-")       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [(control aring)] 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [(control Aring)] 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix "\205"            'lyskom-sv-edit-review-prefix) ; For windows and Emacs 19

  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "") 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "}") 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix (kbd "]") 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [aring]   'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [Aring]   'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix []       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix []       'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [229]     'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [197]     'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [2277]    'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [2245]    'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [3909]    'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [3941]    'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [195 165] 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [195 165] 'lyskom-sv-edit-review-prefix)
  (lyskom-try-define-key lyskom-sv-edit-prefix [()]     (let ((k (make-sparse-keymap)))
							   (define-key k (vector (intern "\205")) 'lyskom-sv-edit-review-prefix)
							   (define-key k [] 'lyskom-sv-edit-review-prefix)
							   k))

  (define-key lyskom-sv-edit-prefix (kbd "?")       'lyskom-help)
  (define-key lyskom-sv-edit-prefix (kbd "*")       'kom-button-press)
  (define-key lyskom-sv-edit-prefix (kbd "=")       'kom-menu-button-press)
  (define-key lyskom-sv-edit-prefix (kbd "C-c")     'kom-edit-send)
  (define-key lyskom-sv-edit-prefix (kbd "C-s")     'kom-edit-ispell-message)
  (define-key lyskom-sv-edit-prefix (kbd "C-k")     'kom-edit-quit)
  (define-key lyskom-sv-edit-prefix (kbd "C-y")     'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-prefix (kbd "C-b")     'kom-edit-insert-buglist)

  (define-key lyskom-sv-edit-insert-prefix (kbd "?")   'lyskom-help)
  (define-key lyskom-sv-edit-insert-prefix (kbd "C-k") 'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-insert-prefix (kbd "C-y")     'kom-edit-insert-commented)
  (define-key lyskom-sv-edit-insert-prefix (kbd "1")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "2")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "3")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "4")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "5")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "6")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "7")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "8")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "9")   'kom-edit-insert-digit-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "SPC") 'kom-edit-insert-text)
  (define-key lyskom-sv-edit-insert-prefix (kbd "C-l") 'kom-edit-insert-link)
  (define-key lyskom-sv-edit-insert-prefix (kbd "C-i") 'kom-edit-insert-last-info-nodename)

  (define-key lyskom-sv-edit-add-prefix (kbd "C-m") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-add-prefix (kbd "<RET>") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-e") 'kom-edit-add-copy)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-b") 'kom-edit-add-bcc)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-f") 'kom-edit-move-text)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-j") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-add-prefix (kbd "<LFD>") 'kom-edit-add-recipient)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-k") 'kom-edit-add-comment)
  (define-key lyskom-sv-edit-add-prefix (kbd "C-x") 'kom-edit-add-cross-reference)
  (define-key lyskom-sv-edit-add-prefix (kbd "?")   'lyskom-help))

  (define-key lyskom-sv-edit-aux-prefix (kbd "C-p") 'kom-edit-add-personal-comments)
  (define-key lyskom-sv-edit-aux-prefix (kbd "C-n") 'kom-edit-add-no-comments)
  (define-key lyskom-sv-edit-aux-prefix (kbd "C-l") 'kom-edit-add-world-readable)
  (define-key lyskom-sv-edit-aux-prefix (kbd "C-b") 'kom-edit-add-read-confirm-request)

  (define-key lyskom-sv-edit-review-prefix (kbd "?")     'lyskom-help)
  (define-key lyskom-sv-edit-review-prefix (kbd "C-k")   'kom-edit-show-commented)
  (define-key lyskom-sv-edit-review-prefix (kbd "k")     'kom-edit-show-commented)



(defconst lyskom-strings-missing '())



;;; The alist formely known as lyskom-strings
(lyskom-language-strings local lyskom-message sv
  '(
    ;; From vars.el: 
    ;; From komtypes.el: nil
    ;; From clienttypes.el: nil
    ;; From startup.el:
    (server-q . "LysKOM-server? ")
    (try-connect . "LysKOM elisp-klient version %#1s.\nFrsker koppla upp mot %#2s.\n")
    (too-old-server . "Servern r fr gammal fr den hr versionen av klienten.")
    (connection-done . "Uppkopplingen klar. Serverns versionsnummer r %#1s.\n\n")
    (what-is-your-name . "Vad heter du? ")
    (password . "Lsenord? ")
    (wrong-password . "Fel lsen.\n")
    (wrong-password-help . "
Du kan skicka e-mail till ngon av nedanstende adresser fr att f
ett nytt lsenord eller fr att f din gamla person raderad s att du
kan skapa en ny:\n")
    (wrong-password-email . "* %#1t\n")
    (are-logged-in . "Du r nu inloggad. Vnta ett tag.\n")
    (you-have-motd . "\nDu har en lapp p drren:\n\n")
    (server-has-motd . "Servern har ett loginmeddelande:\n")
    (lyskom-motd-was-garbed . "\nLoginmeddelandet finns inte!
Det meddelande som ska visas efter inloggning har frsvunnit.
Kontakta LysKOM-administratren.\n")
    (first-greeting . "%#1s
Det tycks vara frsta gngen du anvnder LysKOM. Vlkommen!
Kontrollera att du stavat ditt namn rtt. Anvnd grna ditt fullstndiga
namn och organisation, t ex \"Eskil Block, FOA\". Om du stavat ditt namn
fel, eller vill ndra ditt namn, svara nej p frgan nedan.

Observera att all information n s lnge sparas s att vem som helst
kan lsa den. Dock r lsenordet krypterat.

Om du r osker p hur man anvnder LysKOM kan du hmta en manual via
anonym ftp frn ftp.lysator.liu.se. Frga din systemadministratr om
du r osker. Du kan ven skriva \"?\" fr kommandot \"Hjlp\".
")

    (is-name-correct . "r namnet %#1s korrekt? ")
    (personal-password . "Ange ett personligt lsen: ")
    (repeat-password . "Repetera fr kontroll: ")
    (repeat-failure . "Du angav inte samma lsenord bgge gngerna.\n")

    (could-not-create-you .  "Det gick inte att skapa personen.\n")
    (presentation-subject . "%#1s")
    (presentation-form . "\
Namn:    
Adress:  
Stad:    
Telefon: 
E-post:  
WWW:     

Annat:   ")
    (presentation-help . "Du skriver just  nu din presentation.\n")
    (not-present-anywhere . "Ej nrvarande i ngot mte.")
    (in-secret-conference . "Hemligt mte (%#1d).")
    (start-new-session-same-server
     . "Du kr redan mot den servern. Vill du starta en ny session? ")
    (new-session-in-buffer . "\n\n---- Ny session startad %s ----\n\n")
    (warning-about-uncompiled-client . "
OBS: LysKOM-klienten r inte kompilerad. Fr att ka prestanda br du kra en
kompilerad version av klienten. Ls i den medfljande README-filen hur man
gr det.
")

    ;; From internal.el:
    (shaky-tcp . "Nu nr jag inte servern. TCP/IP-frbindelsen r skakig%#1s")
    (retrying-tcp . "Jag frsker igen.")

    ;; From parse.el:
    (protocol-error . "protokollfel: %s")

    ;; From services.el:
    (interrupted . "Kommandot avbrutet\n")

    ;; From cache.el:
    ;; No entries.

    ;; From commands1.el:
    (appreciation . "Du r mycket vacker och mycket klok. Mnga lskar dig bde till kropp
och till sjl. Du kommer att versas med rikedom och f stor lycka i ditt
liv. Var glad att just du r du. Det har du all anledning att vara.
Fantomen nskar dig en bra dag.\n\n")
    (abuse . "Du r mycket ful och mycket dum. Mnga hatar dig bde till kropp
och till sjl. Du kommer att versas med sjukdomar och inte f ngon som
helst lycka i ditt liv. Du borde verkligen ta dig samman och gra ngot av
ditt liv ven om det inte r mycket att starta med.
Guran vill helst stta en giftpil i dig.\n\n")

    (what-conf-to-delete . "Vilket mte/person vill du utplna: ")
    (what-conf-to-change . "Vilket mte vill du ndra: ")
    (confirm-delete-pers-or-conf . "Ta bort %#1s %#2s? ")
    (the-pers . "personen")
    (the-conf . "mtet")
    (deletion-not-confirmed . "Utplningen avbruten\n")
    (somebody-else-deleted-that-conf . "Ngon annan tog precis bort mtet.\n")
    (conf-is-deleted . "Ok, nu r %#1s utplnad.\n")
    (you-could-not-delete . "%#1M kunde inte utplnas av dig.\n")
    (you-have-deleted-yourself . "Du har utplnat dig sjlv.\n")

    (what-text-to-delete . "Vilket inlgg skall tas bort? ")
    (delete-marked-text . "Inlgget r %#1s. Ta bort nd? ")
    (delete-marked-by-you . "markerat av dig")
    (delete-marked-by-you-and-others . "markerad av dig och %#1?d%[ngon annan%]%[%#1d andra%]")
    (delete-marked-by-several . "markerat av %#1d person%#1?d%[%]%[er%]")
    (delete-commented-text-help . "\
Inlgget du hller p att radera har kommentarer. Om du tar bort inlgget
s kommer dessa kommentarer att frlora sitt sammanhang. Detta irriterar
mnga lsare. vervg att flytta inlgget till ett annat mte istllet
fr att radera det.")
    (delete-commented-text . "Inlgget har kommentarer. Radera nd? ")
    (really-delete-commented-text . "Att radera kommenterade inlgg irriterar mnga lsare. Radera nd?")
    (deleting-text . "Radering av text %#1:n...")

    (presentation-for-whom . "Se presentation fr vilket mte/person? ")
    (unread-presentation-for-whom . "Olsmarkera presentation fr vilket mte/person? ")
    (text-to-see-author-of . "Se presentation fr vilket inlggs frfattare? ")
    (text-to-unread-author-of . "Olsmarkera presentation fr vilket inlggs frfattare? ")
    (somebody-deleted-that-conf . "Ngon tog precis bort mtet.\n")
    (review-presentation-of . "terse presentation av %#1M.\n")
    (has-no-presentation . "%#1:M har ingen presentation.\n")

    (have-to-read . "Du mste lsa ett inlgg frst.\n")

    (no-comment-to . "Det finns inget kommenterat inlgg att titta p.\n")
    (no-text-at-point . "Det finns inget inlgg vid markren.\n")
    (what-ancestor . "Vilken av de kommenterade texterna nskas? ")

    (who-letter-to . "Vem vill du skicka brev till? ")
    (who-send-text-to . "Vart vill du skicka inlgget? ")
    (has-motd . "%#1P har en lapp p drren:\n\n")
    (motd-persist-q . "Vill du fortfarande skriva texten? ")

    (who-to-add . "Vem vill du addera? ")
    (where-to-add . "Vilket mte skall han/hon adderas till? ")
    (where-to-add-self . "Vilket mte vill du bli medlem i? ")
    (priority-q . "Prioritet p ditt medlemskap i mtet? (0 (lg) - 255 (hg)) ")
    (other-priority-q . "Prioritet p den adderades medlemskap i mtet? (0 (lg) - 255 (hg)) ")
    (done . "klart.\n")
    (cancelled . "avbrutet.\n")
    (nope . "det gick inte.\n")
    (add-already-member . "%#2P r redan medlem i %#1M.\n")
    (you-already-member . "Du r redan medlem i %#1M.\n")

    (cant-find-supervisor . "Hittar inte organisatren fr %#1M.\n")
    (is-read-protected-contact-supervisor . "%#1M r slutet.
Skicka ett brev till %#2P fr medlemskap.\n")

    (conf-does-not-exist . "\nMtet finns inte.\n")

    (who-to-exclude . "Vem vill du utesluta? ")
    (where-from-exclude . "Vilket mte skall han/hon uteslutas ifrn? ")

    (leave-what-conf . "Vilket mte vill du g ur? ")

    (error-fetching-person . "Fel i personhmtningen.\n")
    (error-fetching-conf . "Fel i mteshmtningen.\n")

    (name-of-conf . "Vad ska mtet heta? ")
    (anyone-member . "Fr vem som helst bli medlem? ")
    (secret-conf . "Hemligt mte? ")
    (comments-allowed . "Fr man skriva kommentarer? ")
    (anonymous-allowed . "Fr man skriva anonyma texter? ")
    (secret-members-allowed . "Fr man g med som hemlig medlem? ")
    (what-comment-no . "Kommentera text nummer: ")
    (what-footnote-no . "Fotnotera text nummer: ")
    (what-private-no . "Personligt svar till text nummer: ")
    (quit-in-spite-of-unsent . "Vill du avsluta sessionen trots oinskickat inlgg? ")
    (really-quit . "Vill du verkligen avsluta sessionen? ")
    (session-ended . "
*****************************
LysKOM-sessionen r avslutad.
*****************************\n")
    (session-auto-ended . "
===========================================================
Kopplar ned frn LysKOM eftersom LysKOM r fullt och
du har lst klart allting. Kom tillbaks senare.
===========================================================\n\n")
    (session-ended-long . "
*******************************************************************************
LysKOM-sessionen r avslutad.
*******************************************************************************
")
    (session-auto-ended-long . "
===============================================================================
Kopplar ned frn LysKOM eftersom LysKOM r fullt och
du har lst klart allting. Kom tillbaks senare.
===============================================================================
\n")
    (what-to-change-pres-you . "Vilket mte/person vill du ndra presentationen fr: ")
    (what-to-change-faq-you . "Vilket mte vill du ndra FAQ fr: ")
    (who-to-put-motd-for . "Vilket mte/person vill du stta lapp p drr fr: ")

    (what-to-set-pres-you . "Vilket mte/person vill du stta presentationen fr: ")
    (what-text-to-set-as-pres-no . "Vilket inlgg vill du ska vara den nya presentationen: ")
    (what-to-set-motd-you . "Vilket mte/person vill du stta lapp p drr fr: ")
    (what-text-to-set-as-motd-no . "Vilket inlgg vill du ska vara den nya lappen: ")
    (conf-already-has-pres . "Mtet/personen har redan en presentation. Fortstt nd? ")
    (conf-already-has-motd . "Mtet/personen har redan en lapp p drren. Fortstt nd? ")
    (setting-conf-pres . "Stter presentation fr %#1M till text %#2n...")
    (setting-conf-motd . "Stter lapp p drren fr %#1M till text %#2n...")

    (who-to-remove-pres-for . "Vilket mte/person vill du ta bort presentationen frn: ")
    (removing-pres-for-conf . "Tar bort presentation (text %#2n) frn %#1M...")

    (cant-get-conf-stat . "Kan ej hmta mtesstatus fr mtet.\n")
    (go-to-conf-p . "G till mte: ")
    (want-become-member . "Vill du bli medlem? ")
    (no-ok . "Nehej.\n")

    (who-to-remove-motd-for . "Vilket mte/person vill du ta bort lapp p drr fr: ")

    (conf-all-read . "inga olsta")
    (no-in-conf . "Du r inte nrvarande i ngot mte.\n")

    (search-for-pers . "Ange skvillkor (RETURN fr alla personer): ")
    (search-for-conf . "Ange skvillkor (RETURN fr alla mten): ")
    (search-re . "Ange skuttryck (reguljrt uttryck): ")
    (search-re-for-what . "Vad vill du ska? ")
    (search-re-persons . "pSk personer")
    (search-re-confs . "mSk mten")
    (search-re-all . "bSk alla")

    (no-matching-confs . "Inga mten uppfyller skvillkoret \"%#1s\".\n")
    (no-matching-perss . "Inga personer uppfyller skvillkoret \"%#1s\".\n")
    (no-matching-anys . "Inga personer eller mten uppfyller uttrycket \"%#1s\".\n")
    (no-confs-exist . "Det finns inga mten i databasen.\n")
    (no-pers-confs-exist . "Det finns inga mten eller personer i databasen.\n")
    (list-confs-created-by . "Lista gda mten fr: ")
    (listing-confs-created-by . "gda mten fr %#1P\n\
    S=Skapat, O=Organisatr, M=Brevlda som supermte; S=Slutet, H=Hemligt\n")
    (list-pers-confs-created-by . "Lista gda mten (med brevldor) fr: ")
    (getting-all-confs . "Hmtar en lista av alla mten frn servern...")
    (getting-all-pers-confs . "Hmtar en lista av alla personer och mten frn servern...")
    (getting-all-confs-done . "Hmtar en lista av alla mten frn servern...klart")
    (getting-all-pers-confs-done . "Hmtar en lista av alla personer och mten frn servern...klart")
    (finding-created-confs . "Sker gda mten (%#1d av %#2d klart)")
    (finding-created-pers-confs . "Sker gda mten (med brevldor) (%#1d av %#2d klart)")
    (no-created-confs . "%#1P r inte skapare, organisatr eller supermte fr ngot mte.\n")

    (name-to-be-changed . "Ange det namn som skall ndras: ")
    (no-such-conf-or-pers . "Mtet eller personen finns ej.\n")
    (new-name . "Nytt namn: ")
    (new-paren . "Ny parentes: ")
    (too-many-parens-in-name . "Namnet innehller mer n en parentes. Anvnd \"ndra namn\" istllet.\n")
    (no-paren-in-name . "Namnet innehller ingen parentes.\n")
    (who-to-change-supervisor-for . "Vem vill du ndra organisatr fr? ")
    (new-supervisor . "Ny organisatr: ")
    (text-to-mark . "Vilket inlgg vill du markera? ")
    (text-to-unmark . "Vilket inlgg vill du avmarkera? ")
    (what-mark . "Vilken typ av markering vill du stta (namn eller 0-255)? ")
    (erroneous-mark . "Felaktig markeringstyp.\n")
    (want-to-create-symbolic-mark . "Markeringstypen \"%#1s\" finns inte. Vill du skapa den? ")
    (creating-symbolic-mark-type . "Skapar markeringstypen \"%#1s\" (%#2d).\n")
    (no-mark-types-left . "Ledsen, det finns inga lediga markeringstyper. Rensa bland de gamla frst.")
    (unmarking-textno . "Avmarkering av text %#1n...")
    (marking-textno . "Markering av text %#1n med markering %#2?b%[\"%#2s\" (%#3d)%]%[%#3d%]...")
    (list-which-mark . "Lista vilken markeringstyp (namn eller 0-255, RET fr alla)? ")

    (new-passwd-again . "Mata in det nya lsenordet igen fr kontroll: ")
    (what-mark-to-unread . "Olsmarkera vilken markeringstyp (namn eller 0-255, RET fr alla)? ")
    (what-mark-to-view . "terse vilken markeringstyp (namn eller 0-255, RET fr alla)? ")
    (whos-passwd . "Vem vill du ndra lsenord fr? ")
    (old-passwd . "Mata in ditt nuvarande lsenord: ")
    (new-passwd . "Mata in det nya lsenordet: ")
    (changing-passwd . "ndrar lsenordet...")
    (retype-dont-match . "Lsenorden r inte samma. Gr om.\n")
    (palindrome . " (en palindrom!)")
    (lyskom-name . "Anvndare")
    (is-in-conf . "Nrvarande i mte")
    (from-machine . "Kr frn")
    (is-doing . "Gr")
    (connection-time . "Loggade in")
    (active-last . "Aktiv senast")
    (active . "Aktiv")
    (lyskom-client . "Klient")
    (move-roots-q . "Inlgg %#1n r en fotnot/bilaga. Flytta %#2n%#3?b%[ mfl.%]%[%] istllet? ")
    (add-roots-q . "Inlgg %#1n r en fotnot/bilaga. Addera till %#2n%#3?b%[ mfl.%]%[%] istllet? ")
    (sub-roots-q . "Inlgg %#1n r en fotnot/bilaga. Subtrahera frn %#2n%#3?b%[ mfl.%]%[%] istllet? ")
    (text-to-add-recipient . "Vilket inlgg vill du addera mottagare till:")
    (text-to-add-copy . "Vilket inlgg vill du addera en extra kopia till:")
    (text-to-add-bcc . "Vilket inlgg vill du skicka som dold kopia:")
    (text-to-delete-recipient . "Vilket inlgg vill du subtrahera mottagare frn:")
    (text-to-move . "Vilket inlgg vill du flytta:")
    (text-tree-to-move . "Vilket inlgg r rot till trdet du vill flytta:")
    (text-to-add-comment-to . "Vilket inlgg vill du addera en kommentar till:")
    (text-to-delete-comment-from . "Vilket inlgg vill du subtrahera en kommentar frn:")
    (text-to-add-footnote-to . "Vilket inlgg vill du addera en fotnot till:")
    (text-to-delete-footnote-from . "Vilket inlgg vill du subtrahera en fotnot frn:")
    (comment-to-move-q . "Vilken kommentar vill du flytta:")
    (comment-move-from-q . "Frn vilken text vill du flytta %#1n:")
    (comment-move-to-q . "Till vilken text vill du flytta %#1n:")
    (text-is-not-a-comment . "Inlgg %#1n r inte en kommentar till ngot inlgg\n")
    (cant-move-footnotes . "Kan inte flytta fotnoter.\n")
    (moving-comment . "Flyttar %#1n frn %#2n till %#3n...\n")

    (text-to-add-cross-reference-to . "Vilket inlgg vill du addera en referens till:")
    (text-has-no-recipients-r . "Inlgg %#1n har inga mottagare\n")
    (cant-move-from-to-same . "Mtet du flyttar till kan inte vara samma som du flyttar frn.\n")

    (where-on-list-q . "Placering p listan? (0-%#1d) ")
    (accepting-invitation . "Accepterar inbjudan till %#2M%#3?b%[ %#3s%]%[%]...")
    (member-in-conf . "Bli medlem i %#2M%#3?b%[ %#3s%]%[%]...")
    (member-in-conf-with-low-priority . "%#1M har lgre prioritet n din lsniv och kommer drfr inte att visas.\n")
    (member-in-conf-with-unread-date . "med olsta frn %#3d %#2s %#1d")
    (member-in-conf-with-unread . "med %#1d olsta")
    (add-member-in . "Addera %#1P som medlem i %#2M...")
    (change-priority-for-q . "ndra prioritet fr mte: ")
    (cant-change-priority-of-passive . "Kan inte ndra prioritet p passiva medlemskap.\n")
    (change-priority-for . "ndra prioritet p %#2M...")
    (unsubscribe-to . "Uttrda ur %#1M...")
    (unsubscribe-to-2 . "Uttrda ur %#1M%#2s...")
    (confirm-each-join . "Vill du bekrfta medlemskap i enskila mten? ")
    (confirm-each-msg . "Vill du bekrfta mottagande av gruppmeddelande i enskila mten? ")
    (receive-each-msg . "Vill du ta emot gruppmeddelande i alla mten? ")
    (no-confirm-each-sure . "r du helt sker p att du vill g med i %#1d mten automatiskt? ")
    (confirm-join . "G med i %#1M? ")
    (getting-all-confs . "Hmtar en lista med alla mten...")
    (getting-all-confs-progress . "Hmtar en lista med alla mten (%#1d/%#2d)...")
    (getting-all-confs-done . "Hmtar en lista med alla mten...klart")
    (unsub-all-skipping-letterbox . "nix\nMtet r din brevlda.\n")
    (unsub-all-skipping-supervised . "nix\nDu r organisatr fr mtet.\n")
    (unsub-secret-conf-q . "%#1M r hemligt. Vill du g ur mtet nd? ")
    (unsub-all-secret . "aG ur alla hemliga mten")
    (unsub-closed-conf-q . "%#1M r slutet. Vill du g ur mtet nd? ")
    (unsub-all-closed . "aG ur alla slutna mten")
    (unsub-open-conf-q . "Vill du g ur %#1M? ")
    (unsub-all-open . "aG ur alla ppna mten")
    (abc-yes . "jJa")
    (abc-no . "nNej")
    (abc-yes-all . "aJa till alla")
    (abc-no-all . "xNej till alla")

    (move-tree-move . "fFlytta")
    (move-tree-sub  . "sSubtrahera")
    (move-tree-add  . "aAddera")
    (move-tree-ign  . "iIngenting")
    (move-tree-jump . "hHoppa")
    (move-tree-quit . "qAvbryt")

    (move-tree-add-rcpt-type . "Addera som: ")
    (move-tree-rcpt . "mMottagare")
    (move-tree-cc . "eExtra kopia")
    (move-tree-bcc . "dDold kopia")

    (move-tree-leave-cc-q . "Lmna ursprungsmottagare som extrakopiemottagare? ")

    (exclude-from . "Utesluta %#1P frn %#2M...")

    (unsubscribe-failed . "\nDet gick inte. %#1P var kanske aldrig medlem i %#2M?\n")
    (activate-mship . "Bli aktiv medlem i %#1M...")
    (activate-mship-done . "Du r nu ter aktiv medlem i %#1M.\n")
    (passivate-done . "Du r nu passiv medlem i %#1M.
Uttrd ur mtet en gng till fr g ur helt.\n")

    (You . "Du")
    (could-not-create-conf . "Mtet \"%#1s\" kunde ej skapas.\n")
    (created-conf-no-name . "Mte nummer %[%#3@%#1:m %#2:M%], skapat.\n")
    (cant-read-textno . "Du fr inte lsa text %#1:n.\n")

    (not-supervisor-for . "Du r inte organisatr fr %#1M.\n")
    (not-supervisor-for-server . "Du r inte administratr fr LysKOM-servern.\n")
    (go-to-conf . "G till %#1M.\n")
    (cant-go-to-his-mailbox . "Du fr inte g till %#1Ms brevlda.\n")
    (not-member-of-conf . "Du r inte medlem i %#1M.\n")
    (about-to-change-name-from . "%#1M\n")
    (change-name-done . "Klart. Nytt namn: %[%#2@%#1:M%].\n")
    (change-name-nope . "Det gick inte bra att ndra till %#1s.\nFelkod %#3d. %#2s.\n")
    (change-supervisor-from-to . "ndra organisatr fr %#1M till %#2P...")
    (change-supervisor-nope . 
			    "\nDet gick inte. Kanske du inte fr ndra organisatr fr %#1M?\n")
    
    (no-marked-texts . "Du har inga markerade inlgg.\n")
    (no-marked-texts-mark . 
			  "Du har inga markerade inlgg med markeringstypen \"%#1s\".\n")

;;; For later
;    (northward . "norrut")
;    (southward . "sderut")
;    (permanent-sundown . "Solen kommer inte att g upp. Flytta %#1s!")
;    (permanent-sunup . "Solen kommer inte att g ned. Flytta %#1s!")
;    (sunup-soon . "Solen gr snart upp")
;    (sundown-recently . "Solen gick nyligen ned")
;    (after-sunset . "Solen har gtt ned")
;    (before-sunup . "Solen har inte gtt upp nnu")
;    (sun-is-up . "Solen r uppe")
;;;
    (weekdays . ["sndag" "mndag" "tisdag" "onsdag" "torsdag"
		 "fredag" "lrdag" "sndag"])
    (weekdays-short . ["sn" "mn" "tis" "ons" "tor" "fre" "lr" "sn"])
    (time-is . "Det r %#1s%#2s (enligt servern).")
    (time-is-week . "Det r %#1s%#2s, vecka %#3d (enligt servern).")

    (xmaseve . "\nJulafton! Har du ppnat dina julklappar n?")
    (xmasday . "Juldagen.\nDu har vl varit i julottan?")
    (newyearday . "Nyrsdagen. Gott nytt %#1d!")
    (newyearevelate . "Mindre n en timme kvar av %#1d...")
    (newyeareve . "Nyrsafton.")
    (cgdag . "Valborgsmssoafton.\nKonungens fdelsedag.")
    (sixjune . "Sveriges nationaldag och svenska flaggans dag.")
    (holdnose . "Hll fr nsan...")
    (lysbday . "
P denna dag, r 1973, grundades Lysator, och det var en stor dag
i svensk datorhistoria. Ls mer p http://www.lysator.liu.se/history/")
    (13dayxmas . "Trettondedag jul (\"Trettondagen\").")
    (20dayxmas . "Tjugondedag jul (\"Tjugondag Knut\").")
    (kyndeldag . "Kyndelsmssodagen.")
    (skottdag . "Skottdagen.")
    (intwomday . "Internationella kvinnodagen.")
    (mariebdag . "Marie bebdelsedag.\nFram med vffeljrnet!")
    (johannesddag . "Johannes Dparens dag.")
    (fnday . "FN-dagen.")
    (allhelgonadag . "Allhelgonadagen.")
    (varnlosdag . "Vrnlsa barns dag.")
    (luciaday . "\nLuciadagen! Glm inte att lussa fr dina kollegor.")

    (total-users . "    Sammanlagt %#1d anvndare (%#2s).\n")
    (total-users-sans-date . "    Sammanlagt %#1d anvndare\n")
    (total-visible-users . "    Sammanlagt %#1d synlig%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (total-active-users . "    Sammanlagt %#1d aktiv%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (total-visible-active-users
     . "    Sammanlagt %#1d synlig%#1?d%[%]%[a%] aktiv%#1?d%[%]%[a%] anvndare (%#2s).\n")
    (client-statistics . "    Klienternas frdelning:\n")
    (client-statistics-line . "    %4#2d %#1s%#3?d%[%]%[ [%#3d varianter]%]")
    (who-to-add-q . "Vilket mte/person vill du addera som mottagare till text %#1n? ")
    (who-to-add-copy-q . "Vilket mte/person vill du addera som kopiemottagare till text %#1n? ")
    (who-to-add-bcc-q . "Vilket mte/person vill du addera som mottagare av en dold kopia till text %#1n? ")
    (add-footnotes-too-q . "Frsk addera mottagare till fotnoter ocks? ")
    (add-attachments-too-q . "Frsk addera mottagare till bilagor ocks? ")

    (really-add-as-recpt-q . "Skall framtida kommentarer till inlgget ocks skickas till %#1M? ") 
    (who-to-sub-q . "Vilket mte/person vill du subtrahera som mottagare till text %#1n? ")
    (sub-footnotes-too-q . "Frsk subtrahera mottagare frn fotnoter ocks? ")
    (sub-attachments-too-q . "Frsk subtrahera mottagare frn bilagor ocks? ")

    (who-to-move-from-q . "Frn vilket mte vill du flytta text %#1n? ")
    (who-to-move-to-q . "Vart vill du flytta text %#1n? ")
    (edit-who-to-move-to-q . "Vart vill du flytta texten? ")
    (who-to-move-to-or-sub-q . "Vart vill du flytta texten (tomt fr att bara subtrahera)? ")
    (move-footnotes-too-q . "Frsk flytta fotnoter ocks? ")
    (move-attachments-too-q . "Frsk flytta bilagor ocks? ")
    (move-text-not-recipient . "har ej rtt mottagare.\n")

    (adding-name-as-recipient . "Adderar %#1M som mottagare till text %#2n...")
    (adding-name-as-copy . "Adderar %#1M som kopiemottagare till text %#2n...")
    (adding-name-as-bcc . "Adderar %#1M som dold kopiemottagare till text %#2n...")
    (remove-name-as-recipient . "Subtraherar %#1M som mottagare frn text %#2n...")


    (unknown-recpt-text . "oknd mottagare")
    (cc-recpt-text . "kopiemottagare")
    (bcc-recpt-text . "dold kopiemottagare")
    (recpt-text . "mottagare")
    (add-conf-as-rcpt-q . "Vill du gra %#1M %#2s till text %#3n? ")
    (del-conf-as-rcpt-q . "Vill ta bort %#1M som %#2s till text %#3n? ")
    (change-conf-as-rcpt-q . "Vill du ndra %#2s %#1M till en %#3s till text %#4n? ")
    (move-conf-as-rcpt-q . "Vill du flytta %#1n frn %#2M till %#3M? ")

    (adding-cross-reference . "Adderar referens...")

    (error-recipient-limit . "Text %#1n har fr mnga mottagare.\n")
    (error-already-recipient . "%#2M r redan mottagare till inlgg %#1n.\n")
    (error-permission-denied-add-recpt . "Bara frfattaren till %#1n eller organisatren fr %#2M kan ndra mottagartyp.\n")
    (error-permission-denied-sub-recpt . "Bara frfattaren till %#1n eller organisatren fr %#2M kan subtrahera mottagare.\n")
    (error-access-denied-add-recpt . "Du fr inte addera inlgg till %#2M.\n")
    (error-not-recipient . "%#2M r inte mottagare till inlgg %#1n.\n")

    (moving-tree-what-action-q . "Vad vill du gra? ")
    (moving-cant-read . "Det gick inte att inte flytta text %#1n (kan inte lsa texten).\n")
    (moving-name . "Flyttar text %#3n frn %#1M till %#2M...")
    (moving-already-moved . "Inlgg %#1n har inte %#2M som mottagare.\nFlyttar inte inlgget eller dess kommentarstrd.\n")
    (text-to-add-q . "Vilket inlgg vill du addera som kommentar till %#1n? ")
    (text-to-remove-q . "Vilket inlgg vill du subtrahera som kommentar frn %#1n? ")
    (text-to-add-footn-q . "Vilket inlgg vill du addera som fotnot till %#1n? ")
    (text-to-remove-footn-q . "Vilket inlgg vill du subtrahera som fotnot frn %#1n? ")
    (add-comment-to . "Adderar text %#1n som kommentar till text %#2n...") ;
    (sub-comment-to . "Subtraherar text %#1n som kommentar till text %#2n...")
    (add-footnote-to . "Adderar text %#1n som fotnot till text %#2n...") ;
    (sub-footnote-to . "Subtraherar text %#1n som fotnot till text %#2n...")
    (comment-keep-recpt-p ."Ska %#1s vara mottagare? ")
    (comment-all-relevant-p . "Inlgget har flera mottagare. r alla relevanta? ")
    (please-edit-recipients . "ndra mottagarlistan och skicka in inlgget igen.")
    (checking-rcpt . "Kontrollerar mottagare...")
    (checking-rcpt-done . "Kontrollerar mottagare...klart")
    (checking-comments . "Kontrollerar kommenterade texter...")
    (checking-comments-done . "Kontrollerar kommenterade texter...klart")
    (please-check-commented-texts . "terse de kommenterade texterna och deras kommentarer.")
    (have-unread-comment . "Skicka in trots olsta kommentarer till text %#1n? ")
    (duplicate-recipients . "Kan inte skicka in texten. En mottagare frekommer flera gnger (%#1M)")
    (no-recipients . "Kan inte skicka in texten. Inga mottagare har angivits.")

    (add-recipient-p . "Addera mottagare %#2?b%[ %#2M fr att n%]%[%] %#1P? ")
    (matching-regexp . "Mten/personer som matchar '%#1s'\n")
    (matching-regexp-perss . "Personer som matchar '%#1s'\n")
    (matching-regexp-confs . "Mten som matchar '%#1s'\n")

    (who-is-active-all . "Visar alla sessioner.\n")
    (who-is-active-last-minutes . "Visar alla sessioner som har varit aktiva de senaste %#1d minuterna.\n")
    (showing-invisibles . "Visar osynliga sessioner.\n")
    (null-who-info . "Det finns inga (aktiva) inloggade.\n")

    (no-other-lyskom-r . "Det finns inga fler aktiva LysKOM-sessioner.\n")
    (no-lyskom-session . "Det finns ingen aktiv LysKOM-session.")
    (no-other-unread-lyskom-r . "Hittar ingen annan LysKOM-session med olsta.\n")
    (no-unread-lyskom-r . "Hittar ingen aktiv LysKOM-session med olsta.\n")
    (no-unread-lyskom . "Hittar ingen aktiv LysKOM-session med olsta.")

    (who-is-on-in-what-conference . "Vilka i vilket mte: ")
    (who-is-present-in-what-conference . "Vilka nrvarande i vilket mte: ")
    (who-is-friend . "Visar endast vnner.\n")
    (who-is-active-and-member . "Visar endast medlemmar i %#1M.\n")
    (who-is-active-and-present . "Visar endast medlemmar nrvarande i %#1M.\n")

    (personal-comment-to-anonymous . "Det gr inte att skriva ett personligt svar p ett anonymt inlgg.\n")

    ;; From commands2.el:

    (your-memberships . "Ditt medlemskap i olika KOM-mten:\n")
    (memberships-header . "Senast inne	   Prio	Olsta	Mtesnamn\n")
    (memberships-line . "%16#1s  %#2d\t%#3d\t%#4M\n")
    (conf-for-status . "Vilket mte vill du se statusen fr? ")
    (no-such-conf . "Mtet finns ej.\n")
    (status-record . "Status fr mte %#1M (%#1m)%#2s\n\n")
    (change-type-prompt . "ndra mtestyp fr mte %#1M (%#1m) (%#2s)...")
    (Mailbox . "Brevlda")
    (Protected . "Hemligt")
    (no-comments . "original")
    (closed . "slutet")
    (allow-anon . "anonymt ok")
    (allow-secret . "hemliga medl")

    (created-by . "Skapat av person %25#1p %#3s(%#2P)\n")
    (created-at . "Skapad:%35#1s\n")
    (members .    "Antal medlemmar: %25#1d\n")
    (conf-allows-secret-members . "Hemliga medlemmar:                       %#1s\n")
    (conf-allows-anon-texts .     "Anonyma inlgg:                          %#1s\n")
    (anon-texts-permitted . "Anonyma inlgg r tilltna")
    (anon-texts-not-permitted . "Anonyma inlgg r inte tilltna")
    (secret-members-permitted . "Hemliga medlemmar r tilltna")
    (secret-members-not-permitted . "Hemliga medlemmar r inte tilltna")
    (garb-nice .      "Livslngd p inlgg:        %14#1d dag%#1?d%[%]%[ar%]\n")
    (keep-commented . "Minsta livslngd fr kommenterade inlgg: %#1d dag%#1?d%[%]%[ar%]\n")
    (lowest-local-no ."Lgsta existerande lokala nummer: %8#1d\n")
    (highest-local-no . "Hgsta existerande lokala nummer: %8#1d\n")
    (last-text-time . "Tid fr senaste inlgg: %18#1s (str det i din cache)\n")
    (no-of-motd . "Lapp p drren i text nummer: %12#1n\n")
    (pers-has-privileges .  "Rttigheter: %#1s\n")
    (pers-has-privileges-2 .  "%28#1s")
    (superconf-is-no-name . "Supermte:       %25#1m %#3s(%#2M)\n")
    (permitted-submitters-no-name . "Tilltna frfattare:%22#1m %#3s(%#2M)\n")
    (supervisor-is-no-name . "Organisatr:     %25#1p %#3s(%#2P)\n")
    (presentation-no . "Presentation:    %25#1n\n")
    (conf-mship-priority . "Prioritet:       %25#1n%#2?b%[ %#2s%]%[%]\n")
    (conf-has-motd . "\n%#1M har en lapp p drren:\n")
    (status-conf-generic . "%-40#1s %#2s\n")
    (status-aux-item .   "Oknd tillggsinformation: %15#1s%#3s (skapad av %#2M)\n")
    (conf-mx-allow-envelope-sender-regexp . "Tillten avsndare vid import:           %#1s %#2s\n")
    (conf-mx-list-name . "Importerad mailinglista:                 %#1s %#2s\n")
    (conf-mx-refuse-import . "Vgra import av:                         %#1s %#2s\n")
    (recommended-conf-aux . "Rekommenderat mte:                      %#1M <%#1m> %#2s\n")
    (bad-recommended-conf-aux . "Rekommenderat mte:                     \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s\n")
    (status-read-faq-aux-item . "Lst FAQ:                 %15#2n fr %#1?z%[%#1M <%#1m>%]%[servern%] %#3s\n")
    (bad-status-read-faq-aux-item . "Lst FAQ:                              \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s\n")
    (status-rejected-recommendation-aux-item . "Avvisad mtesrekommendation:            %#1M %#2s\n")
    (bad-status-rejected-recommendation-aux-item . "Avvisad mtesrekommendation:           \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s\n")
    (status-send-comments-to . "Dirigera om kommentarer till:           %#1M <%#1m> %#2s\n")
    (bad-status-send-comments-to . "Dirigera om kommentarer till:          \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s\n")

    (Everybody . "Alla")
    (show-members-list-also-q . "Vill du se medlemslistan ocks? ")
    (show-membership-info-q . "Visa medlemskapsinformation och antalet olsta? ")
    (conf-has-these-members . "\n%#1M har fljande medlemmar:\n")
    (conf-has-no-members . "\n%#1M har inga medlemmar.\n")
    (member-list-header . "\nSenast inne         Osett   Namn\n")
    (secret-membership . "*** Hemlig rad ***\n")
    (conf-membership-line . "%#4@%#1s%#2M %#3s\n")
    (conf-membership-line-2 . "                            Adderad %#1s av %#2P\n")
    (pers-for-status . "Vem vill du se statusen fr? ")
    (text-to-see-author-status-of . "Vilken texts frfattare vill du statusen fr? ")
    (no-such-pers . "Det finns ingen sdan person.\n")
    (pers-status-record . "Status fr person %#1P (%#1p)\n")
    (created-time .  "Skapad:%34#1s\n\n")
    (created-confs . "Skapade mten:%27#1d\n")
    (created-persons . "Skapade personer:%24#1d\n")
    (created-texts . "Skapade texter:%26#1d\n")
    (created-lines . "Skapade rader:%27#1d\n")
    (created-chars . "Antal skapade tecken:%20#1d\n")
    (no-of-sessions . "Antal sessioner:%25#1d\n")
    (present-time-d-h-m-s . "Nrvarotid:%19#1d d %02#2d:%02#3d:%02#4d\n")
    (last-log-in . "Senaste in-/utloggning:%18#1s\n")
    (user-name . "Anvndare: %30#1s\n")

    (read-texts . "Lsta texter:%28#1d\n")
    (marked-texts . "Markerade texter:%24#1d\n")
    (time-for-last-letter . "Tid fr senaste brev:%20#1s (str det i din cache)\n")
    (superconf . "Supermte:%31#1m %#3s(%#2M)\n")
    (supervisor . "Organisatr:%29#1p %#3s(%#2P)\n")
    (member-of-confs . "Medlem i (antal mten):%18#1d\n")
    (presentation . "Presentation:    %24#1n\n")
    (show-membership-list-also-q . "Vill du se vilka mten personen r medlem i ocks? ")
    (not-allowed-see-confs . "%#1P r inte medlem i ngra mten.\n")
    (is-member-of . "\n%#1P r medlem i fljande mten:\n")
    (membership-list-header . "\nSenast inne           Osett  Namn\n")
    (pers-membership-line . "%#5@%#1s%#2s%#3M %#4s\n")
    (pers-membership-line-2 . "                             Adderad %#1s av %#2P\n")
    (is-supervisor-mark . "O ")
    (moronify-saving . "Sparar ndringen...")
    (moronify-saving-done . "Sparar ndringen...klart")
    (moronify-saving-error . "Kunde inte spara ndringen!")
    (befriend-saving . "Sparar ndringen...")
    (befriend-saving-done . "Sparar ndringen...klart")
    (befriend-saving-error . "Kunde inte spara ndringen!")
    (moronify-whom . "Lgg vem p minuslistan? ")
    (befriend-whom . "Lgg vem p pluslistan? ")
    (who-to-send-message-to . "Vem vill du skicka meddelandet till? (%#1s) ")
    (send-empty-message-p . "Meddelandet r tomt. Vill du nd skicka det? ")
    (his-total-unread . "\n%#1M har totalt %#2d olsta (plus %#3d i passiva medlemskap).\n")
    (message-prompt . "Meddelande%#1?z%[%]%[ (till alla inloggade)%]: ")
    (message-sent-to-user . "\
%[%#3$\
================================================================
%]%[%#4$\
Ditt meddelande till %#2M (%#5s):

%#1t
%]%[%#3$\
----------------------------------------------------------------
%]")
    (message-sent-to-all . "\
%[%#3$\
================================================================
%]%[%#4$\
Ditt alarmmeddelande ld (%#5s):

%#1t
%]%[%#3$\
----------------------------------------------------------------
%]")
    (message-sent-to-user-long . "\
%[%#3$\
===============================================================================
%]%[%#4$\
Ditt meddelande till %#2M (%#5s):

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-sent-to-all-long . "\
%[%#3$\
===============================================================================
%]%[%#4$\
Ditt alarmmeddelande ld (%#5s):

%#1t
%]%[%#3$\
-------------------------------------------------------------------------------
%]")
    (message-use-alarm-instead . "Anvnd kommandot %#1s fr att skicka alarmmeddelanden.\n")
    (message-all-info . "\
%#1@Snd alarmmeddelande till alla inloggade.

%[%#3Fvervg att anvnda \"%#2C\" fr att skicka meddelandet till ett
specifikt mte eller en enskild anvndare.%]
")
    (message-recipient-info . "Snd meddelande till %#1M\n")
    (message-nope
     . "Det gick inte. %#3s\
Meddelandet du frskte snda till %#1M var:
%#2t\n")
    (only-last . "Endast lsa senaste i %#1s: ")
    (initial-unread . "Initialt antal olsta (tomt fr alla): ")
    (only-error . "Ngot gick galet. Ledsen.\n")

    (lp--only-last . "Antal texter att lsa: ")

    (session-list-unreads-in-confs . 
			      "Du har %#2?z%[%#2d olst%#2?d%[%]%[a%] brev och totalt %]%[%]%#3d olst%#3?d%[%]%[a%] i %#4d mte%#4?d%[%]%[n%] i %#1s.\n")
    (session-list-no-unread-in . "Du har lst ut %#1s.\n")

    (you-have-unreads . "Du har %#1d olst%#1?d%[%]%[a%] inlgg i %#2M\n")
    (you-have-unreads-special . "Du har %#1d okommentera%#1?d%[t%]%[de%] inlgg i %#2M\n")
    (you-have-no-unreads . "Du har inget olst i %#1M\n")
    (you-have-read-everything . "Du har sett alla nyheter.\n")
    (no-unreads-shown . "Hittade inga mten som matchade det kriteriet.\n")
    (total-unreads . "Du har totalt %#1d olst%#1?d%[%]%[a%] inlgg i %#2d mte%#2?d%[%]%[n%].\n")
    (shown-unreads . "Visade %#1d olst%#1?d%[%]%[a%] inlgg i %#2d mte%#2?d%[%]%[n%].\n")
    (list-unread-with-n-unread . "Visar endast mten med minst %#1d olsta.\n")
    (list-unread-with-at-most-n-unread . "Visar endast mten med som mest %#1d olsta.\n")
    (waiting-for-anything .
			  "Du vntar p ett inlgg i vilket mte som helst.\n")
    (waiting-higher-than . 
			 "Du vntar p ett inlgg i ett mte med hgre prioritet n %#1d.\n")

    (have-to-be-in-conf-with-unread . "Du mste g till ett icketomt mte frst.\n")
    (Texts . "Inlgg")
    (Written . "Skrivet")
    (Lines . "Rader")
    (Author . "Frfattare")
    (Subject . "rende")
    (Comments . "Ko")
    (Num-marks . "Mk")
    (mark-type . "Markering")
    (mark-no . "Mrk")
    (could-not-read . "Du fick inte lsa denna text (%#1n).\n")
    (multiple-choice . "Flera alternativ finns.")
    (does-not-exist . "Detta kommando finns inte.")
    (summary-line . "%=-8#1n%#2s%4#3d  %[%#4@%#5:P%]  %[%#6@%#7r%]\n")
    (diff-what-text-old . "Gammal text att jmfra: ")
    (diff-what-text-new . "Ny text att jmfra: ")


    ;; Only people fixing bugs or receiving bug reports should
    ;; change these:
    (buggreport-compilestart . "Skapar buggrapporten...")
    (buggreport-compileend . "Skapar buggrapporten...klart")
    (buggreport-description . "Detta gjorde jag:
\(Fyll i dina kommentarer nedan\)\n================\n\n
================
Bland informationen nedan finns ocks en lista p de 100 sist tryckta
tangenterna i din emacs. Om du nyligen loggat in kan den innehlla ditt
lyskomlsenord. Titta igenom den och ndra det som r ditt lsenord
till * * * eller m i t t l  s e n eller ngot annat lmpligt.

Nr du skrivit klart skall du skicka in din buggrapport till LysKOMs
elispklientutvecklare. Det sker antingen:
* med email till bug-lyskom@lysator.liu.se
* med vanligt brev till:
\tLysator
\tc/o ISY
\tLinkping University
\tS-581 83 Linkoping
\tSWEDEN.

Mrk kuvertet \"LysKOM buggrapport fr elispklienten\".\n\n")
    
    (buggreport-internals . "LysKOMs interna information:\n\n")
    (buggreport-version . "lyskom-version:")
    (buggreport-emacs-version . "emacs-version:")
    (buggreport-system-id . "system-id:")
    (buggreport-ctl-arrow-doc . "ctrl-doc:")
    (buggreport-unparsed . "\nlyskom-unparsed-buffer:")
    (buggreport-command-keys . "Nyss tryckta tangenter:")
    (buggreport-backtrace . "\n*Backtrace*:\n%#1s\n")
    (buggreport-communications . "\nlyskom-debug-communications-to-buffer-buffer:")
    (buggreport-all-kom-variables . "\n\nAndra variabler:\n***** *********")
    (buggreport-instead-of-byte-comp . "byte-code(\"byte-string\"")
    (buggreport-subject . "Bugg-rapport elisp-klienten version %#1s")


    (not-logged-in . "Du r inte inloggad.  ")

    ;; Used for kom-is-person-member-of-conference:
    (pers-to-check-mship-for . "Vems medlemskap vill du underska? ") ;-)
    (conf-to-check-mship-of . "...i vilket mte? ")
    (conf-is-empty . "Mtet %#1M r tomt.\n")
    (pers-is-member-of-conf . "Ja, %#1P r medlem i mtet %#2M.\n")
    (pers-is-passive-member-of-conf . "Nja, %#1P r bara passiv medlem i mtet %#2M.\n")
    (pers-is-not-member-of-conf . "Nej, %#1P r inte medlem i mtet %#2M.\n")
    (pers-is-member-of-conf-2 . "Antal olsta: %#2D (senast inne %#1s)\n")
    (pers-will-receive-async . "Tar %#1?b%[%]%[inte %]emot gruppmeddelanden till mtet\n")
    (pers-mship-priority . "Medlemskapets prioritet: %#1d\n")
    (Unknown-number . "Oknt antal")
    (text-to-check-will-read-for . "...fr medlemskap i mottagare till inlgg: ")
    (pers-to-check-will-read-for . "Vilken person vill du kontrollera: ")
    (pers-is-member-of-rcpt . "Ja, %#1P r medlem i minst en mottagare till inlgg %#2n.\n")
    (pers-is-passive-member-of-rcpt . "Nja, %#1P r bara passiv medlem ngon mottagare till %#2n.\n")
    (pers-is-not-member-of-rcpt . "Nej, %#1P r inte medlem i ngon mottagare till %#2n.\n")

    ;; +++ cant seem to find where these are used:
    (name-is-not-in-conf . "%#1s r inte nrvarande i ngot mte.\n")
    (name-is-in-conf . "%#1s r nrvarande i\n%#2s\n")
    (connected-during . "Uppkopplingstid: %#1d sekunder.\n")
    ;; +++


    (conf-to-set-permitted-submitters-q . "Vilket mte vill du stta tilltna frfattare fr? ")
    (conf-to-set-super-conf-q . "Vilket mte vill du stta supermte fr? ")
    (new-super-conf-q . "Vilket mte vill du ha som supermte? ")
    (new-permitted-submitters-q . "Mte med tilltna frfattare till %#1s? (alla) ")
    (super-conf-for-is . "ndra supermte fr %#1M till %#2M...")
    (permitted-submitters-removed-for-conf . "Tillt alla frfattare i mte %#1M...")
    (submitters-conf-for-is . "ndra tilltna frfattare fr mte %#1M till\nmedlemmarna i %#2M...")

    (conf-to-set-garb-nice-q . "Vilket mte vill du stta livslngd fr? ")
    (new-garb-nice-q . "Efter hur mnga dagar ska inlgg utplnas? ")
    (new-keep-commented-q . "Hur mnga dagar ska nya kommentarer skydda det kommenterade? ")
    (garb-nice-for-is . "ndrar livslngden fr %#1M till %#2d dag%#2?d%[%]%[ar%]...")
    (keep-commented-for-is . "ndrar s kommentarer skyddar frn utplning i %#2d dag%#2?d%[%]%[ar%] fr %#1M...")

    (really-shutdown . "r du sker p att du vill stnga av servern? ")
    (closing-server . "Stnga av servern...")
    (really-sync . "r du sker p att du vill spara databasen? ")
    (syncing-server . "Spara databasen...")
    (administrator . "administratr")
    (no-longer-administrator . "en normal anvndare igen")
    (you-are-now . "Ok, du kr nu som %#1s.\n")
    (setting-motd . "Stter loginmeddelandet till text %#1n.\n")
    (set-motd-success . "Du har satt ett nytt loginmeddelande.\n")
    (set-motd-failed . "Det gick inte. Du var kanske inte administratr.\n")
    (removing-motd . "Tar bort loginmeddelandet.\n")
    (removed-motd . "Du har tagit bort loginmeddelandet.\n")
    (who-to-throw-out . "Vems session vill du kasta ut? ")
    (throwing-out . "Kastar nu ut session %#1d... ")
    (postpone-prompt . "Hur lite vill du lsa nu? ")
    (set-session-priority . "Stt lsniv: ")

    ;; From review.el:
    (no-unread-done . "Du mste markera inlgg olsta innan du kan markera fler olsta.\n")
    (no-review-done . "Du mste terse innan du kan terse mer.\n")
    (not-reviewing . "Du hller inte p att terse ngot nu.\n")
    (unread-how-many . "Olsmarkera hur mnga?")
    (unread-how-many-roots . "Olsmarkera hur mnga urinlgg?")
    (review-how-many . "terse hur mnga?")
    (review-how-many-roots . "terse hur mnga urinlgg?")
    (unread-how-many-more . "Olsmarkera ytterligare hur mnga?")
    (review-how-many-more . "terse ytterligare hur mnga?")
    (latest-n . "senaste %#1d")
    (first-n . "frsta %#1d")

    (review-by-whom . "terse %#1s %#2?b%[%#2s %]%[%]av vem: ")
    (review-to-conf . "terse %#1s %#2?b%[%#2s %]%[%]till mte: ")
    (unread-by-whom . "Olsmarkera %#1s %#2?b%[%#2s %]%[%]av vem: ")
    (unread-to-conf . "Olsmarkera %#1s %#2?b%[%#2s %]%[%]till mte: ")
    (all-confs . "alla mten")

    (unread-info-by-to . "Olsmarkera %#1s %#4?b%[%#4s %]%[%]av %#2P till %#3M.\n")
    (unread-more-info-by-to . "Olsmarkera %#1s %#4?b%[%#4s %]%[%]av %#2P till %#3M.\n")
    (unread-rest . "resten")
    (unread-more . "nsta %#1d")

    (review-info-by-to . "terse %#1s  %#4?b%[%#4s %]%[%]av %#2P till %#3M.\n")
    (review-more-info-by-to . "terse %#1s %#4?b%[%#4s %]%[%]av %#2P till %#3M.\n")
    (review-filter-roots . "urinlgg")

    (review-rest . "resten")
    (review-more . "nsta %#1d")
    (you-review . "Du terser nu %#1s.\n")
    (read-text-first . "Du mste lsa en text frst.\n")
    (cannot-read-last-text . "Du kan inte lsa den senast lsta texten.\n")
    (review-n-texts . "terse %#1d inlgg.\n")
    (review-marked . "terse %#1d markerade.\n")
    (review-text-no . "terse text nummer %#1n\n")
    (review-many-comments . "terse %#2?d%[en%]%[%#2d%] kommentar%#2?d%[%]%[er%] till inlgg %#1n.\n")
    (view-many-comments . "Ls %#2?d%[en%]%[%#2d%] kommentar%#2?d%[%]%[er%] till %#1n.\n")
    (view-texts-in-conf . "Totalt %#1d inlgg att lsa i %#2M.\n")
    (not-reading-anywhere . "Du lser inte i ngot mte.\n")
    (read-normally-read . "Hur mnga vill du se igen? ")

    (review-conf-gone . "Mtet finns inte.\n")
    (review-pers-gone . "Personen finns inte.\n")
    (review-cant-read-conf . "Du kan inte terse inlgg till ett slutet mte du inte r med i.\n")
    (review-cant-read-letterbox . "Du kan inte terse inlgg till ngon annans brevlda.\n")
    (review-cant-read-empty . "Mtet r tomt.\n")
    (cant-review-everything . "Du kan inte terse alla texter i LysKOM.\n")
    (cant-unread-everything . "Du kan inte olsmarkera alla texter i LysKOM.\n")

    (more-than-one-root . "Inlgg %#1n har mer n ett urinlgg.\n")
    (more-than-one-root-review . 
"Inlgg %#1n har mer n ett urinlgg, men endast ett trd kommer att visas.\n")

    ;; From edit-text.el:
    (press-C-c-C-c . "Tryck C-c C-c fr att skicka in texten.")
    (recipient . "Mottagare")
    (carbon-copy . "Extra kopia")
    (blank-carbon-copy . "Dold kopia")
    (recipient-prefix . "\\([Mm]\\)")
    (carbon-copy-prefix . "\\([Ee]\\)")
    (blank-carbon-copy-prefix . "\\([Dd]\\)")
    (add-recipient . "Addera mottagare")
    (add-recipient-or-xref . "Addera...")

    (secret-aux-flag . "hemlig")
    (anonymous-aux-flag . "anonym")
    (inherit-aux-flag  . "rvd")
    (aux-item-prefix . "[*]")
    (aux-item-prefix-regexp . "\\[\\*\\]\\s-*")
    (comment-item-prefix . "#\\s-*")
    (text-no-comment . "%#1d %#2s /%#3d rad%#3?d%[%]%[er%]/ %#4P %#5?b%[ [anonymt]%]%[%]\n")
    (cant-fcc-text-file-error . "Kan inte spara inlgg %#1n till \"%#2s\" (%#3s: %#4s).\n")
    (cant-fcc-text . "Kan inte spara inlgg %#1n till \"%#2s\" (%#3s).\n")

    (header-subject . "rende: ")
    (header-separator . "\\<lyskom-edit-mode-map>\
--- Skriv nedan. \
Skicka in=\\[kom-edit-send], \
Avbryt=\\[kom-edit-quit], \
Annat se \\[describe-mode] ---")
    (text-mass . "%#4s%#1s%[%#6@\n%]%[%#5@%#2s%]%[%#7@\n%]%#3s")
    (comment-to-by . "%#1s till text %#2n%#3s.\n")
    (already-sent . "Du har redan skickat denna text en gng. Snd nd? ")
    (subject . "rende: ")
    (subject-prefix . "[\\{\\[]")
    (enter-subject-idi . "Skriv ett rende.")
    (which-text-include . "Vilken text skall vi inkludera? ")
    (added-recipient . "Mottagare som skall adderas: ")
    (added-carbon-copy . "Extra kopia till mte: ")
    (added-blank-carbon-copy . "Dold kopia till: ")
    (text-to-comment-q . "Vilket inlgg vill du kommentera? ")
    (conf-has-motd-no . "Mtet har en lapp p drren. (%#1d)\n\n%#2s")
    (still-want-to-add . "Vill du fortfarande addera mtet? ")
    (could-not-create-text . "\nTexten kunde ej skapas. %#2s.\n")
    (no-get-text . "Du fick inte hmta texten.")
    (unknown-header . "Oknd information p raden")
    (transform-error . "Skicka in oformatterat (%#1s)? ")
    (cant-find-info-node . "Hittar inte info-bufferten")

    (link-type . "Vad vill du lnka till? ")
    (which-text-to-link . "Lgg in lnk till text nummer: ")
    (which-text-to-link-err . "Hittar inte texten. Lgg in lnk till text nummer: ")
    (which-pers-to-link . "Lgg in lnk till person: ")
    (which-conf-to-link . "Lgg in lnk till mte: ")

    ;; From view-text.el:
    (view-text-first-line . "%#7$%#2@%#1n %#3s /%#4d rad%#4?d%[%]%[er%]/ %#5P%#6?b%[%#6s%]%[%]\n")

    (marked-by-you . "Markerad av dig (typ: %#1s).\n")
    (marked-by-you-and-others . "Markerad av dig (typ: %#2s) och %#1?d%[ngon annan%]%[%#1d andra%].\n")
    (marked-by-several . "Markerad av %#1d person%#1?d%[%]%[er%].\n")

    (timeformat-day-yyyy-mm-dd-hh-mm-ss . "%#7s %4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm-ss . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d:%02#6d")
    (timeformat-yyyy-mm-dd-hh-mm . "%4#1d-%02#2d-%02#3d %02#4d:%02#5d")
    (timeformat-yyyy-mm-dd . "%4#1d-%02#2d-%02#3d")
    (timeformat-hh-mm-ss . "%02#4d:%02#5d:%02#6d")
    (timeformat-hh-mm . "%02#4d:%02#5d")

    (format-time-date-and-time . "%#1s %#2s")
    (format-time-just-date . "%#1s")
    (format-time-just-time . "%#2s")
    (today . "idag")
    (yesterday . "igr")

    (no-such-text-no . "Det finns inget sdant inlgg. (%#1:n)\n")
    (text-created-at . "Skapad: %#1s\n")
    (text-imported-at . "Importerad: %#1s\n")
    (text-imported-at-by . "Importerad: %#1s av %#2P\n")

    (head-Subject . "rende: ")
    (Recipient . "Mottagare")
    (Extra-recipient . "Extra kopia")
    (Hidden-recipient . "Dold kopia")
    (mx-Recipient . "Extern mottagare")
    (mx-Extra-recipient . "Extern kopiemottagare")
    (mx-Extern-reply-to . "Externa svar till")
    (Strange-recipient . "Underlig mottagare")
    (send-at . "    Snt:     %#1s\n")
    (sent-by . "    Snt av %#1P\n")
    (received-at . "    Mottaget: %#1s\n")

    (comment-to-text . "Kommentar till text %#1n")
    (footnote-to-text . "Fotnot till text %#1n")
    (comment-in-text . "Kommentar i text %#1n")
    (footnote-in-text . "Fotnot i text %#1n")

    (comment-to-text-by . "Kommentar till text %#1n av %#2P")
    (footnote-to-text-by . "Fotnot till text %#1n av %#2P")
    (comment-in-text-by . "Kommentar i text %#1n av %#2P")
    (footnote-in-text-by . "Fotnot i text %#1n av %#2P")

    (attachment-to-text . "Bilaga %#3still text %#1n")
    (attachment-in-text . "Bilaga %#3si text %#1n")
    
    (envelope-sender . "Snt av: %#1s\n")
    (attachment-filename . "Bilagans filnamn: \"%#1s\"\n")
    (message-id . "Meddelande-ID: %#1s\n")

    (written-by . " av %#1P\n")

    ;; From async.el:

    (name-has-changed-to-name . "%#1:P har nu bytt namn till %#2:P")
    (name-has-changed-to-name-r . "%#4@%[%#3@%#1:P%] har nu bytt namn till %[%#3@%#2:P%]\n")
    (you-changed-name-to . "Nu har du bytt namn till %[%#2@%#1:P%].\n")
    (database-sync . "Databasen synkas.")

    (lyskom-is-full . "\
===========================================================
Meddelande frn LysKOM-systemet: Ngon frskte koppla upp,
men misslyckades eftersom alla tillgngliga frbindelser r
upptagna. Logga ut och kom tillbaks senare om du vntar nu.
===========================================================\n")
    (lyskom-is-full-long . "\
===============================================================================
Meddelande frn LysKOM-systemet: Ngon frskte koppla upp,
men misslyckades eftersom alla tillgngliga frbindelser r
upptagna. Logga ut och kom tillbaks senare om du vntar nu.
===============================================================================
")
    (has-entered . "Nu har %#1:P gtt in i %#2s.")
    (has-entered-r . "%#2@Nu har %#1P gtt in i %#3s%#6?b%[ frn %#6s%]%[%]%#4?b%[ (%#4s %#5s)%]%[%].\n")
    (has-left . "Nu har %#1:P gtt ur %#2s.")
    (has-left-r . "%#2@Nu har %#1P gtt ur %#3s (%#4s %#5s).\n")
    (Unknown . "Oknd")
    (unknown . "oknd")
    (Unknown2 . "Oknt")
    (unknown-person . "Oknd person")

    (no-longer-member . "Du r inte lngre medlem i %#1M.\n")
    (no-longer-member-n . "Du r inte lngre medlem i mte %#1m (finns inte).\n")

    (have-become-member . "Du har blivit medlem i %#1M.\n")
    (have-become-invited-member . "Du har bjudits in till %#1M.
G till mtet fr att acceptera eller tacka nej till inbjudan. Du kan ven
anvnda kommandot 'Bli medlem i mte' fr att acceptera inbjudan.\n")
    (have-become-passive-member . "Du har blivit passiv medlem i %#1M.\n")

    (message-broadcast . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarmmeddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-broadcast-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Alarmmeddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from . "\
%[%#4$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Personligt meddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
----------------------------------------------------------------
%]")
    (message-from-long . "\
%[%#4$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#5$\
Personligt meddelande frn %#1P (%#3s):

%#2t
%]%[%#4$\
-------------------------------------------------------------------------------
%]")
    (message-from-to . "\
%[%#5$\
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$\
Gruppmeddelande till %#3M\nfrn %#2P (%#4s):

%#1t
%]%[%#5$\
----------------------------------------------------------------
%]")
    (message-from-to-long . "\
%[%#5$\
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%]%[%#6$\
Gruppmeddelande till %#3M\nfrn %#2P (%#4s):

%#1t
%]%[%#5$\
-------------------------------------------------------------------------------
%]")
    (text-is-created . "Text %#1n r skapad!")

    ;; Used in mode-line-process
    (mode-line-waiting . ": vntar")
    (mode-line-working . ": arbetar")
    (mode-line-saving . ": sparar")
    (mode-line-down . ": nerkopplad")

    ;; From completing-read.el:
	   
    (person-or-conf-no-regexp . "\\`[ \t]*[mpMP]\\w*[ \t]+\\([0-9]+\\)\\'")
    (session-no-regexp . "\\`[ \t]*[sS]\\w*[ \t]+\\([0-9]+\\)\\'")
    (conf-prompt . "Vilket mte/person? ")

    ;; From flags.el:
    (saving-settings . "Sparar instllningarna...")
    (saving-settings-done . "Sparar instllningarna...klart")
    (save-options-failed-internal . "\
Det gick inte att spara instllningarna p grund av ett internt fel.

Globala instllningar:         %#1?b%[Kodningen misslyckades%]%[OK%]
Elispklientens instllningar:  %#2?b%[Kodningen misslyckades%]%[OK%]
Andra klienters instllningar: %#3?b%[Kodningen misslyckades%]%[OK%]

Rapportera grna detta fel till elispklientens utvecklare.
")
    (hang-on . "Vnta ett tag...\n")
    (no-changes . "Ingenting behvde sparas eftersom inga variabler hade ndrats.\n")
    (could-not-save-options . "Kunde ej spara instllningarna.\n")
    (could-not-create-area . "Kunde ej skapa texten.\n")
    (could-not-set-user-area . "Kunde ej stlla om user-arean. Servern sger felmeddelande: %#1d\n")
    (you-dont-exist . "Du finns inte.\n")
    (error-in-options . "Det fanns ett fel i en av dina variabler (%#1s)
Det stod \"%#2s\" i user-arean. Den stts till nil istllet.
Skicka en bugrapport.\n")
    (error-in-options-short . "Det fanns ett fel i dina instllningar. Vissa instllningar har inte lsts in.")
    (reading-settings-from-server . "Dina sparade instllningar har ndrats p servern. Lser om instllningarna.\n")

    ;; From elib-string.el:
    ;; No entries.
		
    ;; From lyskom-rest.el:
		
    (mode-line-unread . " Olsta ")
    (mode-line-letters . "brev ")
    (frame-title-unread . "Olsta")
    (frame-title-letters . " brev")
    (sessions-with-unreads . "Sessioner med olsta")
    (unread-letters . "olsta brev")

    (bad-text-no-prefix . "Kan inte verstta prefix `%s' till inlggsnummer")
    (prefix-arg-try-again . "Ange en annan text eller tryck control-g fr att avbryta.\n")
    (error-code . "%#2?+%[Felkod %#2d/%#3S: %]%[%]%#1s.\n")
    (error-in-kom-do-when-done . "Variabeln kom-do-when-done har ett felaktigt vrde.
Du br stta den till ett bttre vrde.\n")
    (extended-command . "LysKOM: ")
    (wait-for-server . "LysKOM vntar p svar frn servern. Vnta tills du fr en prompt.\n")
    (review-text-q . "terse text nummer: ")

    (completely-read-conf . "Du har sett alla texter i detta mte.\n")
    (not-in-any-conf . "Du lser inte ngot mte just nu.\n")

    (all-conf-unread-r . "Du har lst ut alla mten.\n")
    (all-conf-unread-s . "Du har lst ut alla mten. ")
    (enter-conf-unread . "%#1d olst%#1?d%[%]%[a%]")
    (enter-conf-unread-faq . "%#1d olst%#1?d%[%]%[a%] FAQ")

    (save-one-on-file-q . "Arkivera inlgg %#1n till fil: ")
    (save-many-on-file-q . "Arkivera %#1d inlgg till fil: ")
    (saving-one-on-file . "Arkiverar inlgg %#1n i %#2s.\n")
    (saving-many-on-file . "Arkivera %#1d inlgg i %#2s.\n")
    (save-text-to-file-q . "Spara inlggstext %#1n p fil: ")
    (save-text-confirm . "Filen %#1s finns redan. Vill du skriva ver den? ")
    (saving-text . "Sparar inlgg %#1n som %#2s...")
    (what-save-no . "Vilket inlgg vill du spara? ")
    (wait-for-prompt . "Vnta p prompten.")

    (conference-no . "<mte %#1d>")
    (person-no . "<person %#1d>")
    (prompt-several-messages . "(%d meddelanden)")
    (prompt-single-message   . "(%d meddelande)")

    (text-buffer-missing . "Inlggsbufferten existerar inte lngre.\n")

    (re-edit-text-prompt . "Redigera texten som inte kunde skapas")
    (go-to-pri-conf-prompt . "G till nsta prioriterade mte")
    (go-to-pri-mailbox-prompt . "G till din brevlda (prioriterad)")
    (read-pri-text-conf . "Lsa nsta prioriterade text")
    (read-pri-letter-prompt . "Lsa nsta brev (prioriterat)")
    (review-next-text-prompt . "terse nsta text")
    (review-next-comment-prompt . "terse nsta kommentar")
    (review-next-marked-prompt . "terse nsta markerade")
    (review-next-faq-prompt . "terse nsta FAQ")
    (read-next-letter-prompt . "Lsa nsta brev")
    (read-next-footnote-prompt . "Lsa nsta fotnot")
    (read-next-comment-prompt . "Lsa nsta kommentar")
    (read-next-text-prompt . "Lsa nsta text")
    (read-next-attachment-prompt . "Lsa nsta bilaga")
    (go-to-conf-of-marked-prompt . "teruppta terse markerade")
    (go-to-conf-of-review-tree-prompt . "teruppta terse kommentarer")
    (go-to-conf-of-review-prompt . "teruppta terse")
    (go-to-conf-of-review-faq-prompt . "teruppta terse FAQ")
    (go-to-next-conf-prompt . "G till nsta mte")
    (go-to-your-mailbox-prompt . "G till din brevlda")
    (next-pri-session-prompt . "G till prioriterat LysKOM \"%#1s\"")
    (next-unread-session-prompt . "G till LysKOM \"%#1s\"")

    (no-such-kom-session . "Det finns ingen sdan session med olsta.\n")
    (the-command . "Kommandot: %#1C")
    (error-in-login-hook . "Det fanns ett fel i din kom-login-hook: %#1s\n")

    (give-a-number . "Mata in ett tal: ")

    (yes-regexp . "\\`[jJ][aA]\\'")
    (no-regexp . "\\`[nN][eE][jJ]\\'")
    (yes-string . "Ja")
    (no-string . "Nej")
    (yes-or-no-nag . "Svara bara ja eller nej.")
    (yes-or-no . "(ja eller nej) ")

    (y-or-n-instring . "jJnN ")
    (j-or-n-nag . "Svara bara j eller n. ")
    (j-or-n . "(j eller n) ")
    (y-instring . "jJ ")

    (a-or-b-or-c-nag . "Ge ett giltigt alternativ. ")

    (person-does-not-exist . "Person %#1d (finns inte).")
    (conference-does-not-exist . "Mte %#1d (finns inte).")
    (conf-no-does-not-exist-r . "Mte %#1d finns inte.")
    (person-is-anonymous . "Anonym person")

    (process-signal . "Signal frn processen.")
    (closed-connection . "
**************************************************
%#2s
LysKOM-sessionen onormalt stngd.
Felmeddelande: %#1s**************************************************")
    (closed-connection-other-buf . "\
**************************************************
LysKOM-sessionen %#1s stngdes onormalt.
**************************************************
")
    (dead-session . "LysKOM-sessionen r inte aktiv.")
    (resurrect-session . "LysKOM-sessionen har kopplats ner, vill du ansluta igen? ")
    (not-lyskom-buffer . "Detta r inte en aktiv LysKOM-session.")
    (error-not-found . "Fel nummer %#1d. Ingen klartextfrklaring finns.")

    ;; Useful in more place than one:
    (illegal-command . "Otilltet kommando.\n")
    (no-such-text . "Det finns inget sdant inlgg.\n")
    (no-such-text-m . "Det finns inget sdant inlgg.")
    (nobody . "ingen")
    (everybody . "alla")
    (everything . "allt")
    (anybody . "vem som helst")
    (forward . "framt")
    (backward . "bakt")
    (wait . "Vnta ett tag...\n")
    (comment . "Kommentar")
    (comment-prefix . "\\([Kk]\\)")
    (footnote . "Fotnot")
    (footnote-prefix . "\\([Ff]\\)")

    (by . " av %#1P")
    (text-created .  "Text nummer %#1n r skapad.\n")
    (text-created-anonymous .  "\
Text nummer %#1n r skapad (anonymt). Fr att gra det svrare fr 
andra att ta reda p att du skapade inlgget br du vnta ett tag med
att lsa det.\n")

    (resolve-session . "Ange vilken session: ")

    (starting-program . "Startar %#1s...")
    (super-jump . "Filtrerar rende \"%#1r\" i mte \"%#2M\"\n")
    (no-recipient . "Inlgget har ingen mottagare.\n")
    (filtered . "[Filtrerad]")
    (filter-error-specification . "Fel i filterspecifikationen")
    (filter-error-bad-not . "Fel i filterspecifikation efter 'not'")
    (filter-error-unknown-key . "Filternyckeln '%S' r oknd.")
    (filter-error-key-arg . "Fel filterdata (%S %S)")
    (filter-tree . "Hoppar ver text %#1n \"%#2r\" av %#3P och dess kommentarstrd.\n")
    (filter-text . "Hoppar ver text %#1n \"%#2r\" av %#3P.\n")
    (filter-permanent . "Permanent? ")
    (filter-action . "Hur vill du filtrera? ")
    (filter-in-conf . "I vilket mte? (alla) ")
    (filter-subject . "Filtrera vilket rende? ")
    (filter-which-text . "Filtrera inlgg som innehller: ")
    (filter-author . "Filtrera vilken frfattare? ")
    (filter-recipient . "Vilken mottagare vill du filtrera? ")
    (permanent . "(permanent)")
    (temporary . "(tillfllig)")
    (filter-edit-buffer-name . "*LysKOM Filter Edit*")
    (filter-edit-empty-list . "Listan r tom")
    (filter-edit-start-of-list . "Listans brjan")
    (filter-edit-end-of-list . "Listans slut")
    (filter-edit-filter-how . "Hur vill du filtrera? ")
    (filter-edit-filter-what . "Vad vill du filtrera? ")
    (filter-edit-bad-argument . "Felaktig inmatning: %s")
    (filter-edit-outside-entry . "Kan inte utfra kommandot utanfr ett filter")
    (filter-edit-outside-list . "Kan inte utfra operationen utanfr listan")
    (filter-edit-end-of-pattern . "Filtrets slut")
    (filter-edit-save-p . "Spara frndringar? ")
    (filter-edit-remove-empty . "Tomma filter gr att alla texter filtreras. Vill du ta bort dessa? ")
    (filter-edit-restart-p . "Du har gjort ndringar. Vill du verkligen brja om? ")
    (filter-edit-help . 
		      "p,n Upp/ned, i/M-i Ny rad/filter, d/M-d Radera rad/filter, C-h m Mer hjlp")
    (filter-edit-header . "ndra filter fr \"%s\"\n")
    (filter-edit-footer . "
 Upp rad:    p  Ny rad:          i    Ta bort rad:     d
 Upp filter: P  Nytt filter:     M-i  Ta bort filter:  M-d
 Ned rad:    n  Spara ndringar: s    ndra handling:  a
 Ned filter: N  ngra ndringar: g    ndra permanens: t
 Avsluta:    q                        Mer hjlp:       C-h m
")
    (filter-edit-saving . "Sparar ndringarna...")
    (filter-edit-saving-done . "Sparar ndringarna...klart")
    (filter-edit-saving-error . "Kunde inte spara ndringarna!")
    (filter-edit-insert-pred . "%#1s (=,!=): ")
    (filter-edit-insert-arg . "%#1s %#2s (vad): ")
    (no-filters . "Inga filter har definierats.\n")
    (view-filters-header . "\nAktiva filter:\n\n")
    (view-filters-footer . "")

    (ansaphone-new-message . "Nytt automatsvar: ")
    (ansaphone-message . "Svarsmeddelande:
----------------------------------------------------------------------
%#1t
----------------------------------------------------------------------
")
    (ansaphone-message-long . "Svarsmeddelande:
-------------------------------------------------------------------------------
%#1t
-------------------------------------------------------------------------------
")
    (ansaphone-state . "Automatsvar r nu %#1s.")
    (ansaphone-state-r . "Automatsvar r nu %#1s.\n")
    (ansaphone-messages-gone . "Sparade meddelanden raderade.")
    (ansaphone-no-messages . "Inga meddelanden.\n")
    (ansaphone-message-list-start . "Sparade meddelanden:\n\n")
    (ansaphone-message-list-end . "\n\n")
    (ansaphone-message-header . "Automatiskt svar (satt %#1s):\n")

    (remote-erase-messages . "Fjrrstyrning (%#1P %#2s): Sparade meddelanden raderade\n")
    (remote-set-message . "Fjrrstyrning (%#1P %#2s): Svarsmeddelande:
----------------------------------------------------------------------
%#3t
----------------------------------------------------------------------
")
    (remote-set-message-long . "Fjrrstyrning (%#1P %#2s): Svarsmeddelande:
-------------------------------------------------------------------------------
%#3t
-------------------------------------------------------------------------------
")    (remote-set-ansaphone . "Fjrrstyrning (%#1P %#2s): Automatsvar r nu %#3s\n")
    (remote-list-messages . "Fjrrstyrning (%#1P %#2s): Meddelanden listade\n")
    (remote-quit . "Fjrrstyrning(%#1P %#2s): Avsluta\n")

    (illegal-remote . 
		    "Otillten fjrrstyrning:
Tid: %#1s
Frn: %#2P <%#2p>
Till: %#3P <%#3p>
Text: 
%#4t")
    (illegal-remote-reply . "Fjrrstyrning inte accepterad: %#1s") 
    (remote-not-in-list . "Otillten person")
    (remote-bad-command . "Felaktigt kommando")
    (remote-unknown-error . "Oknt fel")

    (remote-control-who . "Kontrollera vilken session? ")
    (remote-control-autoreply . "Automatsvar p eller av? ")

    (state-on . "pslaget")
    (state-off . "avslaget")

    (text-popup-title . "Inlgg %#1s")
    (conf-popup-title . "Mte %#1s")
    (pers-popup-title . "Person %#1s")
    (url-popup-title  . "URL %#1s")
    (aux-popup-title  . "Tillggsinformation")
    (timestamp-popup-title . "Tidsstmpel %#1s")
    (recpt-type-popup-title . "Mottagartyp: %#1s")
    (add-recpt-button-text . "[Addera...]")
    (add-recpt-button-text-regex . "\\[Addera\\.\\.\\.\\]")
    (generic-popup-title . "%#1s")

    (who-i-am-not-present . "%#1P r inte nrvarande i ngot mte\n")
    (who-i-am-present . "%#1P r nrvarande i %#2M\n")
    (who-i-am-client . "Programmet heter lyskom.el, version %#1s%#2?b%[ (MULE)%]%[%].\n")
    (who-i-am-server . "Detta r %#1s, version %#2s.\n")
    (who-i-am-emacs . "Det krs under %#1s%#2?b%[ (MULE)%]%[%].\n")

    (no-such-session-r . "Det finns ingen sdan session. Personen kanske inte r inloggad.\n")
    (person-not-logged-in-r . "%#1P %#2?b%[har inte varit inloggad sedan %#2s%]%[r inte inloggad%].\n")
    (session-status . "Session %#1d r %#2P <%#2p>
%#5s %#7s %#4M
Kr %#6D frn %#3s\n")
    (session-status-9 . "Session %#1d r %#2P <%#2p>
%#5s %#7s %#4M
Kr %#6D frn %#3s
Uppkopplad sedan %#8s%#9s")
    (session-status-inactive . "\nHar inte varit aktiv p %#1s\n")
    (one-day . "en dag")
    (one-hour . "en timme")
    (one-minute . "en minut")
    (years . "r")
    (year . "r")
    (months . "mnader")
    (month . "mnad")
    (days . "dagar")
    (day . "dag")
    (hours . "timmar")
    (minutes . "minuter")
    (and . "och")
    (session-is-active . " och r aktiv.\n")
    (session-is-invisible . "Denna session r osynlig.\n")
    (status-for-session . "Sessionsstatus fr vilken person? ")
    (unknown-doing-what . "Existerar")
    (doing-where-conn . "i")
    (doing-nowhere-conn . "men r")
    (waiting-for-membership . "Vntar p att medlemskapslistan ska lsas in...%d/%d")

    ;; From slow.el
    (no-such-command . "Det finns inget sdant kommando.\n")
    (command-completions . "Du kan mena ngon av fljande:\n %#1s\n")
    (which-language . "ndra sprk till (change language to): ")
    (send-formatted . "Skicka in som formatterad text? ")
    (changing-language-to . "Byter till %#1_s.\n")
    (language-set-to . "Sprket r %#1_s%#2?b%[ %#3@[%#2s]%]%[%].\n")
    (language-not-loaded . "%#1s finns inte tillgngligt.\n")

    (reformat-html . "HTML")
    (reformat-enriched . "enriched")
    (reformat-filled . "ombruten")
    (reformat-image . "bild")
    (image-no-show . "< Bilden (%#1s) kan inte visas. >")
    (reformat-video . "video")
    (video-no-show . "< Video (%#1s) stds inte. >")
    (reformat-audio . "ljud")
    (audio-no-show . "< Ljud (%#1s) stds inte. >")
    (reformat-multipart . "flerdelat")
    (multipart-no-show . "< Flerdelade inlgg (%#1s) stds inte. >")
    (reformat-message . "meddelande")
    (message-no-show . "< Meddelandetyp (%#1s) stds inte. >")
    (reformat-model . "modell")
    (model-no-show . "< Modeller (%#1s) stds inte. >")
    (reformat-application . "tillmpningsdata")
    (application-no-show . "< Tillmpningsdata (%#1s) stds inte. >")
    (reformat-unknown . "oknd typ")
    (unknown-no-show . "< Oknd typ (%#1s) stds inte. >")

    (reformat-truncated . "nedkortad")

    (reformat-signature . "avsignerad")

    (reformat-deswascii . "var swascii")

    (reformat-rot13 . "rot13")

    (reformat-utf-8 . "var UTF-8")

    (pdf-no-show . "< PDF-filer stds inte. Emacs doc-view krvs fr att visa i ny buffert. >")
    (view-pdf . "%#1@< PDF-filer stds inte. > [Visa i ny buffert]")
    (reformat-pdf . "pdf")
    (doc-view-buffer-name . "Inlgg %#1n: %#2s")

    (need-library . "Paketet \"%#1s\" behvs fr att utfra detta kommando.\n")
    (calc-expression . "Uttryck: ")

    (do-send-anonymous . "Skicka in texten anonymt? ")
    (remove-self-sending-anonymous . "Vill du ta bort dig sjlv som mottagare frn inlgget? ")
    (anonymous . "anonym")
    (Anonymous . "Anonym")

    (secret-conf-letter . "H")
    (protected-conf-letter . "S")
    (created-conf-letter . "S")
    (superconf-conf-letter . "M")
    (supervisor-conf-letter . "O")

    ;; Some Help

    (where-is-doesnt-exist . "Kommandot %#1s finns inte")
    (where-is-on-no-key . "%#1s finns inte p ngon tangent")
    (where-is-on-key . "%#1s finns p %#2s")

    ;; From aux-items.el

    (content-type-aux . "Innehllstyp: %#1s")
    (content-type-regexp . "Innehllstyp: \\(\\S-+\\)")
    
    (agreeing . "Hller med om inlgg %#1n...")
    (fast-replying . "Anmrkning till inlgg %#1n...")
    (author-fast-replies . "Anmrkningar av frfattaren:")
    (author-fast-reply-aux . "  \"%#1t\"")
    (other-fast-replies . "Anmrkningar:")
    (other-fast-reply-aux . "  \"%#1t\" /%#2P/")
    (fast-reply-too-long . "Kan inte skapa anmrkningar som bestr av mer n en rad.\n")
    
    (conf-to-list-faqs . "Lista FAQ fr vilket mte: ")
    (faq-for-conf-aux . "Texten r FAQ fr %#1M <%#1m>")
    (bad-faq-for-conf-aux . "Texten r FAQ: \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s")
    (faq-for-server-aux . "Texten r FAQ fr LysKOM-servern") 
    (faq-in-text-aux . "FAQ i inlgg:                   %10#1n %#2D")
    (bad-faq-in-text-aux . "FAQ i inlgg:                            \"%<20...#1s\" %[%#2@[ogiltigt]%] %#3s")
    (conf-to-add-faq . "Vilket mte vill du lgga till en FAQ fr? ")
    (text-to-add-as-faq . "Vilken text vill du lgga till som FAQ? ")
    (text-to-change-as-faq . "Vilken FAQ vill du ndra? ")
    (adding-faq . "Lgger till inlgg %#1n som FAQ fr %#2?b%[%#2M%]%[servern%]...")
    (conf-to-del-faq . "Vilket mte vill du ta bort en FAQ frn? ")
    (text-to-del-as-faq . "Vilken text vill du ta bort som FAQ? ")
    (deleting-faq . "Tar bort inlgg %#1n som FAQ fr %#2?b%[%#2M%]%[servern%]...")
    (conf-has-no-faq . "%#1?b%[%#1M%]%[Servern%] har ingen FAQ\n")
    (unread-which-faq . "Olsmarkera FAQ fr vilket mte? ")
    (view-which-faq . "terse FAQ fr vilket mte? ")
    (review-faq-for-r . "terse FAQ fr %#1?b%[%#1M%]%[servern%].\n")
    (set-faq-for-conf-done . "Text %#3n r nu FAQ fr %#1?b%[%#1M%]%[servern%].\n")
    (set-faq-for-conf-failed . "Kunde inte stta FAQ fr %#1?b%[%#1M%]%[servern%] till text %#3n.\n")
    (changed-faq-for-conf-done . "FAQ i text %#2n fr %#1?b%[%#1M%]%[servern%] ndrad till text %#3n.\n")
    (changed-faq-for-conf-failed . "Kunde inte ndra FAQ fr %#1?b%[%#1M%]%[servern%] till text %#3n.
%#2?b%[Text %#2n r fortfarande FAQ.
%]%[%]%#4s")
    (faq-in-text . "FAQ i text %#1n %#3s%#4s")
    (faq-in-text-by . "FAQ i text %#1n %#5s %#3sav %#2P %#4s")
    (server-has-new-faq . "\nDet finns %#1d ny%#1?d%[%]%[a%] FAQ till servern.\n")
    (unread-faqs-header . "\nOlst%#1?d%[%]%[a%] FAQ till %#2?b%[%#2M%]%[servern%]:\n")
    (all-faqs-header . "Alla FAQ till %#1?b%[%#1M%]%[servern%]:\n")

    (too-many-languages . "Fr mnga teckenuppsttningar fr att koda. Skicka in okodat? ")
    (too-many-languages-error . "Fr mnga teckenuppsttningar fr att koda. Kan inte skicka in inlgget.")
    (too-many-content-types . "Kan inte avgra innehllstyp. Frenkla inlgget.")

    (cross-reference-text-status-aux . "Se ven inlgg:                 %10#1n /%#2P/")
    (cross-reference-conf-status-aux . "Se ven mte:                           <%#1m> %#1M /%#2P/")
    (cross-reference-pers-status-aux . "Se ven person:                         <%#1p> %#1P /%#2P/")
    (strange-cross-reference-status .  "Se ven:                                 %#1s (vad nu det betyder)")
    (cross-reference-text-aux . "Se ven inlgg %#1n /%#2P/")
    (cross-reference-conf-aux . "Se ven mte <%#1m> %#1M /%#2P/")
    (cross-reference-pers-aux . "Se ven person <%#1p> %#1P /%#2P/")
    (cross-reference-text-regexp . "Se ven inlgg \\([0-9]+\\)")
    (cross-reference-conf-regexp . "Se ven mte <\\([0-9]+\\)>")
    (cross-reference-pers-regexp . "Se ven person <\\([0-9]+\\)>")
    (strange-cross-reference . "Se ven %#1s, vad nu det betyder")
    
    (no-comments-aux . "Frfattaren har begrt att inte f kommentarer")
    (no-comments-edit-aux . "Begr att inte f kommentarer")
    (no-comments-regexp . "Begr att inte f kommentarer")
    
    (personal-comment-aux . "Frfattaren har begrt endast personliga svar")
    (personal-comment-edit-aux . "Begr endast personliga svar")
    (personal-comment-regexp . "Begr endast personliga svar")
    
    (request-confirmation-aux . "%#1P har begrt lsbekrftelse")
    (request-confirmation-edit-aux . "Begr bekrftelse om lsning")
    (request-confirmation-regexp . "Begr bekrftelse om lsning")
    (confirm-read-q . "Bekrfta lsning av inlgg %#1n? ")
    
    (read-confirm-aux . "Lst: %#1P %#2s")

    (redirect-email-aux . "Skicka sladdpost till %#1s")
    (redirect-lyskom-aux . "Skicka inlgg till mte %#1M")

    (label-what-kind . "Stt personligt namn p vad (inlgg, mte, person)? ")
    (label-what-text . "Stt personligt namn p inlgg nummer: ")
    (label-what-conf . "Stt personligt namn p vilket mte? ")
    (label-what-pers . "Stt personligt namn p vilken person? ")
    (label-what-label . "Personligt namn: ")
    (label-secret    . "Skall andra kunna se namnet? ")

    (creating-software-aux . "Skapad med %#1s")
    (world-readable-text-aux . "Inlgget kan lsas utan inloggning")
    (world-readable-text-edit-aux . "Gr inlgget lsbart utan inloggning")

    (cant-get-aux-item . "Hittar inte tillggsinformationen\n")
    (aux-item-no-info . "Ingen information tillgnglig\n")
    (aux-item-info . "\
Nummer:       %#1d %#6s
Typ:          %#2d (%#3s)
Skapad av:    %#4P <%#4p>
Skapad:       %#5s
Flaggor:      %#7s
Arvsgrns:    %#8s
Innehll:    \"%#9s\"
")
    (secret . "Hemlig")
    (deleted . "Raderad")
    (hide-creator . "Dold skapare")
    (inherit . "rvs")
    (unlimited-inherit . "Obegrnsat arv")
    (no-inheritance . "Arv r avslaget")
    (no-more-inheritance . "Grnsen uppndd; inget mer arv")
    (inherit-steps . "%#1d steg")

    (aux-item-for . "Tillggsinformation fr ")
    (aux-item-for-conference-no . "mte <%#1m> %#1M")
    (aux-item-for-text-no . "inlgg %#1n")
    (aux-item-for-server . "servern")

    (what-fast-reply-no . "Anmrkning till vilket inlgg? ")
    (fast-reply-prompt . "Anmrkning: ")
    (agree-prompt . "Text: ")
    (default-agree-string . "Hller med")
    (what-agree-no . "Hll med vilket inlgg? ")

    (what-kind-to-add-aux-to . "Koppla tillggsinformation till vad? ")
    (which-conf-to-add-aux-to . "Vilket mte vill du koppla till? ")
    (which-text-to-add-aux-to . "Vilket inlgg vill du koppla till? ")
    (which-aux-item-tag . "Aux-item tag: ")
    (which-aux-item-inherit . "Stt inherit-flaggan? ")
    (which-aux-item-secret . "Stt secret-flaggan? ")
    (which-aux-item-anonymous . "Stt anonymous-flaggan? ")
    (which-aux-item-rsv1 . "Stt dont-garb-flaggan? ")
    (which-aux-item-rsv2 . "Stt reserved2-flaggan? ")
    (which-aux-item-rsv3 . "Stt reserved3-flaggan? ")
    (which-aux-item-rsv4 . "Stt reserved4-flaggan? ")
    (which-aux-item-inherit-limit . "Arvsgrns: ")
    (which-aux-item-data . "Data: ")

    ;; Cross-reference stuff

    (Person . "Person")
    (person . "person")
    (persons . "personer")
    (Conference . "Mte")
    (conference . "mte")
    (conferences . "mten")
    (Text . "Inlgg")
    (text . "inlgg")
    (texts . "inlgg")
    (Server . "Server")
    (server . "server")
    (servers . "servrar")
    (abc-conference . "mMte")
    (abc-person . "pPerson")
    (abc-text . "iInlgg")

    (xref-type . "Vad vill du referera till? ")
    (which-text-to-xref . "Lgg till referens till text nummer: ")
    (which-text-to-xref-err . "Hittar inte texten. Lgg till referens till text nummer: ")
    (which-pers-to-xref . "Lgg till referens till person: ")
    (which-conf-to-xref . "Lgg till referens till mte: ")

    ;; Aux-item stuff from edit-text

    (no-comments-q . "Frfattaren vill inte ha kommentarer. Kommentera nd? ")
    (private-answer-q . "Frfattaren har bett om personliga svar. Skriv personligt svar? ")

    (your-invited . "%#2P har bjudit in dig till %#1M.
Genom att acceptera inbjudan fortstter du vara medlem i %#1M.
Du kan ven tacka nej, och d kommer du automatiskt att g ur mtet.
")

    (accept-invitation . "Vill du acceptera inbjudan och fortstta vara medlem? ")
    (enter-passive . "Du r passiv medlem i %#1M.
Du mste bli aktiv medlem fr att g till mtet.\n")
    (convert-passive . "Vill du bli aktiv medlem i %#1M? ")
    (bug-secret-mship . "Du r hemlig medlem i %#1M\n")

    (invitation-mt-type . "inbjuden")
    (passive-mt-type . "passiv")
    (secret-mt-type . "hemlig")
    (message-flag-off-mt-type . "ej gruppmeddelanden")
    (message-flag-on-mt-type . "gruppmeddelanden")

    (Invitation-mt-type . "Inbjuden")
    (Passive-mt-type . "Passiv")
    (Secret-mt-type . "Hemlig")
    (Message-flag-mt-type . "Gruppmeddelanden")

    (not-author . "Du r inte frfattare till text %#1n.")
    (not-author-try-anyway-p . "Du r inte frfattare till inlgget. Vill du frska nd? ")
    (what-no-comments-no . "Vilken text vill du inte ha kommentarer till: ")
    (adding-no-comments . "Begr att inte f kommentarer till inlgg %#1n...")
    (already-no-comments . "Inlgg %#1n har redan begran om inga kommentarer.\n")

    (what-private-answer-no . "Vilken text vill du ha personligt svar till: ")
    (adding-private-answer . "Begr att endast f personligt svar till inlgg %#1n...")
    (already-private-answer . "Inlgg %#1n har redan begran om enbart personliga svar.\n")

    (what-request-confirm-no . "Vilken text vill du ha lsbekrftelse till: ")
    (adding-request-confirm . "Begr lsbekrftelse till inlgg %#1n...")
    (already-request-confirm . "Inlgg %#1n har redan begran om lsbekrftelse.\n")

    (review-mail-headers-to-what . "Vilken texts brevhuvud vill du se? ")
    (no-mail-headers . "Inlgg %#1n har inget brevhuvud\n")
    (mail-headers-for . "Brevhuvud fr inlgg %#1n:\n")
    (email-name-prefix . "")
    (email-name-suffix . "")

    (you-are-anonymous . "Du r nu ngorlunda anonym.\n")
    (you-are-nonanonymous . "Du r inte lngre anonym.\n")
    (you-are-already-anonymous . "Du r redan ngorlunda anonym.\n")
    (you-are-already-nonanonymous . "Du r redan icke-anonym.\n")

    (start-keep-alive . "Snder data med %#1d sekunders mellanrum fr att hlla frbindelsen aktiv.")
    (stop-keep-alive . "Data snds inte lngre fr att hlla frbindelsen aktiv.")

    (review-converted-q . "terse vilket inlgg konverterat?")
    (review-noconversion-q . "terse vilket inlgg omodifierat?")
    (review-rot13-q . "terse vilket inlgg i rot13?")
    (unread-commented-q . "Olsmarkera vilket inlggs kommenterade?")
    (review-commented-q . "terse vilket inlgg kommenterade?")
    (unread-tree-q . "Olsmarkera alla kommentarer rekursivt fr vilket inlgg?")
    (review-tree-q . "terse alla kommentarer rekursivt fr vilket inlgg?")
    (unread-root-q . "Olsmarkera urinlgget fr vilken text?")
    (find-root-q . "terse urinlgget fr vilken text?")
    (unread-root-review-q . "Olsmarkera trd fr vilket inlgg?")
    (find-root-review-q . "terse trd fr vilket inlgg?")
    (unread-comments-q . "Olsmarkera alla kommentarer till vilket inlgg?")
    (review-comments-q . "terse alla kommentarer till vilket inlgg?")
    (review-xrefs-q . "terse alla korsreferenser frn vilket inlgg?")

    (confusion-who-to-reply-to . "Jag frstr inte vems inlgg du vill skriva ett privat svar till.\n")
    (confusion-what-to-answer-to . "Jag frstr inte vilken text du vill besvara.\n")
    (confusion-what-to-view . "Jag frstr inte vilken text du vill terse.\n")

    (confusion-what-to-reply-to . "Jag frstr inte vilken text du vill skriva en anmrkning till.\n")
    (confusion-what-to-agree-to . "Jag frstr inte vilken text du vill hlla med om.\n")
    (confusion-what-to-request-confirmation . "Jag frstr inte vilken text du vill ha lsbekrftelser p.\n")
    (confusion-what-to-comment . "Jag frstr inte vilken text du vill kommentera.\n")
    (confusion-what-to-footnote . "Jag frstr inte vilken text du vill skriva en fotnot till.\n")

    (confusion-what-to-delete . "Jag frstr inte vilken text du vill radera.\n")
    (confusion-what-to-add-sub-recipient . "Jag frstr inte vilken text du vill %#1s.\n")
    (add-rcpt-action-name . "addera mottagare till")
    (add-copy-action-name . "addera extra-kopiemottagare till")
    (add-bcc-action-name . "addera dold kopia till")
    (sub-action-name . "subtrahera mottagare frn")
    (move-action-name . "flytta")

    (confusion-what-to-add-comment-to . "Jag frstr inte vilken text du vill addera en kommentar till.\n")
    (confusion-what-to-sub-comment-from . "Jag frstr inte vilken text du vill subtrahera en kommentar frn.\n")
    (confusion-what-to-add-footnote-to . "Jag frstr inte vilken text du vill addera en fotnot till.\n")
    (confusion-what-to-sub-footnote-from . "Jag frstr inte vilken text du vill subtrahera en fotnot frn.\n")
    
    (confusion-what-to-mark . "Jag frstr inte vilket inlgg du vill markera.\n")
    (confusion-what-to-unmark . "Jag frstr inte vilket inlgg du vill avmarkera.\n")
    (confusion-what-to-save . "Jag frstr inte vilket inlgg du vill spara.\n")

    (confusion-what-to-review-mail-headers . "Jag frstr inte vilket inlggs brevhuvud du vill se.\n")
    (confusion-what-to-unread-root . "Jag frstr inte vilket inlggs urinlgg du vill markera olst.\n")
    (confusion-what-to-find-root . "Jag frstr inte vilket inlggs urinlgg du vill terse.\n")
    (could-not-find-root . "Kan inte identifiera urinlgget. Kommentarsstrukturen kanske r cirkulr.\n")
    (confusion-what-to-unread-root-review . "Jag frstr inte vilket inlggstrd du vill markera olst.\n")
    (confusion-what-to-find-root-review . "Jag frstr inte vilket inlggstrd du vill terse.\n")


    ;; Help

    (help-with-what . "Vad vill du ha hjlp med? ")
    (help-for . "Hjlp fr \"%#1s\"\n")

    ;; Button actions

    (lyskom-button-view-text-action . "terse texten")
    (lyskom-button-unread-text-action . "Olsmarkera texten")
    (lyskom-button-copy-text-no-action . "Kopiera inlggsnumret")
    (lyskom-button-review-converted-action . "terse konverterat")
    (lyskom-button-review-noconversion-action . "terse omodifierat")
    (lyskom-button-review-rot13-action . "terse rot13")
    (lyskom-button-find-root-review-action . "terse trd")
    (lyskom-button-find-root-action . "terse urinlgget")
    (lyskom-button-comment-text-action . "Kommentera texten")
    (lyskom-button-private-comment-text-action . "Personligt svar")
    (lyskom-button-mark-text-action . "Markera texten")
    (lyskom-button-unmark-text-action . "Avmarkera texten")
    (lyskom-button-save-text-action . "Arkivera inlgg")
    (lyskom-button-save-text-body-action . "Spara inlggstext")
    (lyskom-button-review-comments-action . "terse alla kommentarer")
    (lyskom-button-review-tree-action . "terse alla kommentarer rekursivt")
    (lyskom-button-write-footnote-action . "Fotnotera")
    (lyskom-button-fast-reply-action . "Anmrk")
    (lyskom-button-view-conf-presentation-action . "Visa presentation")
    (lyskom-button-view-conf-status-action . "Visa mtesstatus")
    (lyskom-button-goto-conf-action . "G till mtet")
    (lyskom-button-send-message-action . "Skicka gruppmeddelande")
    (lyskom-button-add-self-action . "Bli medlem i mtet")
    (lyskom-button-sub-self-action . "Uttrd ur mtet")
    (lyskom-button-view-pers-presentation-action . "Visa presentation")
    (lyskom-button-view-pers-status-action . "Visa personstatus")
    (lyskom-button-view-session-status-action . "Visa sessionsstatus")
    (lyskom-button-mail-action . "Skicka brev")
    (lyskom-button-send-message-action . "Snd meddelande")
    (lyskom-button-moronify-action . "Lgg p idiot/knppskalle-listan")
    (lyskom-button-befriend-action . "Lgg p vnner/bekanta-listan")
    (lyskom-button-open-url-action . "ppna")
    (lyskom-button-copy-url-action . "Kopiera")
    (lyskom-button-goto-info-node-action . "ppna")
    (lyskom-button-open-email-action . "Skicka mail")
    (lyskom-button-copy-email-action . "Kopiera")
    (lyskom-button-info-aux-action . "Information")
    (lyskom-button-delete-aux-action . "Radera")
    (lyskom-button-copy-timestamp-action . "Kopiera")
    (lyskom-button-recpt-type-recipient . "Mottagare")
    (lyskom-button-recpt-type-copy . "Extra kopia")
    (lyskom-button-recpt-type-bcc . "Dold kopia")
    (lyskom-button-recpt-type-sub . "Subtrahera")
    (lyskom-button-recpt-add-recipient . "Mottagare")
    (lyskom-button-recpt-add-copy . "Extra-kopiemottagare")
    (lyskom-button-recpt-add-bcc . "Dold-kopiamottagare")
    (lyskom-button-aux-type-xref . "Referens till mte/person/inlgg")
    (lyskom-button-aux-type-no-comments . "Begran om inga kommentarer")
    (lyskom-button-aux-type-personal-comments . "Begran om personligt svar")

    (lyskom-edit-toggle-secret-aux-action . "Vxla \"hemlig\"")
    (lyskom-edit-toggle-anonymous-aux-action . "Vxla \"anonym\"")
    (lyskom-edit-toggle-inherit-aux-action   . "Vxla \"rvd\"")
    (lyskom-edit-delete-aux-action          . "Ta bort")
    (lyskom-prioritize-flag-toggle-action . "Vxla")
    (lyskom-prioritize-flag-set-action . "Stt p")
    (lyskom-prioritize-flag-clear-action . "Stng av")

    (server-status-header   . "Status fr LysKOM-server %#1s%#2?b%[ (%#2s:%#3d)%]%[%]\n\n")
    (server-status-server   . "Kanonisk server:                         %#1s%#2?b%[:%#2s%]%[%]\n")
    (server-status-version  . "Programversion:                          %#1s %#2s\n")
    (server-status-protocol . "Protokollversion:          %15#1d\n")
    (server-status-sessions . "\
Antal sessioner:     %21#1d (totalt)
                     %21#2d aktiva under de senaste %#7d minuterna
                     %21#3d inaktiva sessioner
                     %21#4d oknd aktivitet
                     %21#5d osynliga sessioner
                     %21#6d ej inloggade/hemliga/zombies\n")
    (server-status-first-text . "ldsta befintliga text:     %14#1n\n")
    (server-status-last-text  . "Yngsta befintliga text:     %14#1n%#2?b%[ (%#2n vid start)%]%[%]\n")
    (server-status-texts .      "Antal existerande inlgg:   %14#1d (%#2s just nu, %#3d vid start)\n")
    (server-status-confs .      "Antal existerande mten:    %14#1d (%#2s just nu, %#3d vid start)\n")
    (server-status-pers .       "Antal existerande personer: %14#1d (%#2s just nu, %#3d vid start)\n")
    (server-status-has-motd . "\nServern har en lapp p drren:\n")
    (server-status-time . "Serverns tid:                   %#1s\n")
    (server-status-boot-time . "Servern startades:              %#1s\n")
    (server-status-save-time . "Initial databas sparades:       %#1s%#2?b%[ (%#2s)%]%[%]\n")

    (mship-type-invitation-q . "Inbjudan till medlemskap? ")
    (mship-type-passive-q . "Passivt medlemskap? ")
    (mship-type-secret-q . "Hemligt medlemskap? ")
    (recommend-which-conf . "Vilket mte vill du rekommendera? ")
    (recommend-set-priority-q . "Rekommendera prioritet? ")
    (recommend-set-mship-type-q . "Rekommendera mtestyp? ")
    (recommending-conf . "Rekommenderar %#1M%#2?b%[ (prioritet %#2d)%]%[%]%#3?b%[ %#3s%]%[%]...")
    (has-recommended-conf . "%#1P har rekommenderat mte %#2M. Vill du bli medlem?\n")
    (accept-recommendation . "G med i %#1M? ")
    (accepting-recommendation . "G med i rekommenderat mte %#2M...")

    (redirect-for-whom . "Dirigera om kommentarer fr: ")
    (redirect-to-which-conf . "Dirigera om kommentarer till: ")
    (redirecting-comments-to . "Dirigerar om kommentarer fr %#1P till %#2M%#3?b%[ (frr %#1M)%]%[%]...")

    (kom-redirect-comments-e49 . "Du har inte rtt att ndra denna omdirigering")
    (kom-redirect-comments-e48 . "Omdirigering av kommentarer stds inte av servern")

    (external-program-missing . "Hittar inte det externa programmet \"%#1s\" som krvs fr att genomfra kommandot.")
    (ignored-user-area-var . "\

Ignorerar fljande variabler i dina instllningar:

    %#1s

Variablerna r inte registrerade LysKOM-variabler och kan drfr inte
lsas frn servern. Du kan ta bort variablerna frn servern genom att
ge kommandot \"Spara instllningar\" med prefixargument.

%#2?b%[%#5F\
Oknda variabler kan bero p att dina instllningar sparades med
version %#3s av elispklienten, medan detta r version %#4s.

%]%[%]")

    (unknown-aux-item . "Oknd tillggsinformation")
    (text-header-aux-item . "%#1s: <%#2d> \"%#3s\" %#4s")

    (aux-content-type-name . "Innehllstyp")
    (aux-fast-reply-name . "Anmrkning")
    (aux-cross-reference-name . "Referens")
    (aux-no-comments-name . "Begran om inga kommentarer")
    (aux-personal-comment-name . "Begran om personliga svar")
    (aux-request-confirmation-name . "Begran om lsbekrftelse")
    (aux-read-confirm-name . "Lsbekrftelse")
    (aux-redirect-name . "Omdirigering")
    (aux-x-face-name . "Bild")
    (aux-alternate-name-name . "Alternativt namn")
    (aux-pgp-signature-name . "PGP-signatur")
    (aux-pgp-public-key-name . "Publik PGP-nyckel")
    (aux-e-mail-address-name . "E-postadress")
    (aux-faq-text-name . "FAQ i text")
    (aux-creating-software-name . "Skapande klient")
    (aux-mx-author-name . "E-mailfrfattare")
    (aux-mx-from-name . "E-mail frn")
    (aux-mx-reply-to-name . "E-mail svar snds till")
    (aux-mx-to-name . "E-mail till")
    (aux-mx-cc-name . "E-mail CC")
    (aux-mx-date-name . "E-maildatum")
    (aux-mx-message-id-name . "E-mail-meddelande-ID")
    (aux-mx-in-reply-to-name . "E-mail svar till")
    (aux-mx-misc-name . "E-mailheader")
    (aux-mx-allow-filter-name . "E-mail allow-filter")
    (aux-mx-reject-forward-name . "E-mail reject-forward")
    (aux-mx-allow-envelope-sender-regexp . "Tillten avsndare vid import")
    (aux-notify-comments-name . "Meddela kommentarer")
    (aux-faq-for-conf-name . "FAQ fr mte")
    (aux-recommended-conf-name . "Mtesrekommendation")
    (aux-allowed-content-type-name . "Tillten innehllstyp")
    (aux-canonical-name-name . "Kanoniskt namn")
    (aux-mx-list-name-name . "E-maillistnamn")
    (aux-send-comments-to-name . "Snd kommentarer till")
    (aux-world-readable-name . "Lsbart utan inloggning")
    (aux-mx-refuse-import . "Vgra inlggsimport")
    (aux-elisp-client-read-faq-name . "Lst FAQ")
    (aux-elisp-client-rejected-invitation-name . "Avvisad inbjudan")

    (review-marking-as-read . "terse lsmarkerar")
    (review-not-marking-as-read . "terse lsmarkerar inte")

    (review-using-cache . "terse anvnder cache")
    (review-not-using-cache . "terse anvnder inte cache")

    (using-ssh-connection . "Anvnder ssh-uppkoppling till %#1s...")
    (opening-ssh-connection . "ppnar ssh-uppkoppling till %#1s...")
    (ssh-cant-connect . "Kan inte gra ssh-uppkopplingen: %s")
    (ssh-closing . "Stnger ssh-uppkopplingen till %#1s")
    (ssh-unknown-host . "oknd vrd")

    (keyboard-cancel . "Avbryt")
    (keyboard-menu-help . "(vlj: C-n, C-p; bekrfta: RET)")
    (customize-help . "Se brjan av bufferten fr mer information")

    (no-mule-warning . "\

%#1@Du har stdet fr multibytetecken (MULE) avslaget i emacs. Detta beror
antagligen p att du har ett anrop till standard-display-european
eller motsvarande i din .emacs, eller i ngon av systemets startfiler.

Elispklienten r gjord fr att kras med stdet fr multibytetecken
pslaget. Utan detta std kan inlgg visas fel, och du kan f problem
med att skapa inlgg. Du br drfr sl p stdet fr multibytetecken
i emacs.

")
    (coding-system-mismatch-warning . "\

%#3@Din emacs r instlld p att i frsta hand koda tecken enligt
\"%#1s\", men den LysKOM-server du kr mot rekommenderar
\"%#2s\". Det innebr att kommentarer du skriver till
andras inlgg, och kommentarer till dina inlgg kan f en blandning av
tecken som inte gr att visa ordentligt. Du br byta sprkomgivning i
emacs till en som anvnder \"%#2s\" som frstahandsval fr
teckenkodning (se Emacs-manualen och kommandot set-language-environment
fr mer information).

")

    (has-nameday-1 . "%#1s har namnsdag i dag%#2?b%[ (%#2s)%]%[%].")
    (has-nameday-2 . "%#1s och %#2s har namnsdag i dag%#3?b%[ (%#3s)%]%[%].")
    (no-nameday . "Ingen namnsdag i dag%#2?b%[ (%#2s)%]%[%]")

    (invalid-date-entry . "Ogiltigt datum")
    (number-out-of-range . "Otilltet tal")
    (or-date . "eller datum")

    (set-unread-n . "Endast lsa %#1?d%[det senaste inlgget%]%[de senaste %#1d inlggen%].\n")
    (set-unread-date . "Endast lsa inlgg sedan %#3d %#2s %#1d.\n")

    (jump-from-text . "Hoppa ver kommentarer till vilken text? ")
    (jumping-from-text . "Hoppar ver kommentarer till inlgg %#1n.\n")
    (jumping-from-text-review . "Hoppar ver tersedda kommentarer.\n")
    
    (session-to-copy-options-from . "Kopiera instllningar frn session: ")
    (reading-settings-from . "Lser instllningar frn %s...")
    (reading-settings-from-done . "Lser instllningar frn %s...klart")

    (super-jump-q . "Superhoppa vilket inlgg? ")
    (conf-list-legend . "* Ej medlem; - Passiv medlem\n")

    (unread-text-q . "Gr vilket inlgg olst? ")
    (marking-text-unread . "Markerar inlgg %#1n olst...")
    (cant-mark-text-unread . "Kunde inte markera inlgg %#1n som olst (%#2s)\n")
    (confusion-what-to-mark-unread . "Jag frstr inte vilken text du vill markera olst.\n")
    (no-comment-to-to-unread . "Det finns inget kommenterat inlgg att markera som olst.\n")

    (mx-refuse-import-html . "HTML")
    (mx-refuse-import-spam . "Spam")
    (mx-refuse-import-all . "Alla texter")
    (abc-html . "hHTML")
    (abc-spam . "sSpam")
    (abc-everything . "aAlla texter")
    (abc-regexp . "tTillt avsndare")
    (limit-import-regexp-q . "Tillt endast vilken avsndare (regexp)? ")
    (limit-import-to-conf . "Begrnsa import till vilket mte? ")
    (limit-import-of-what . "Begrnsa import av vad? ")
    (limit-import-not-super . "Du verkar inte vara organisatr fr mtet. Frsk nd? ")
    (limiting-import . "Begrnsar import av %#1s i %#2M...")
    (limiting-import-regexp . "Begrnsar import till %#2M till avsnare %#1s...")

    (set-message-flag-for-conf . "ndra meddelandeflagga fr vilket mte? ")
    (set-message-flag-to-what . "Vill du ta emot gruppmeddelanden till %#1M? ")
    (setting-message-flag . "%#1?b%[Slr p%]%[Stnger av%] mottagning av gruppmeddelanden till %#2M...")

    (text-has-no-comments . "Inlgg %#1n har inga kommentarer\n")
    (text-has-no-footnotes . "Inlgg %#1n har inga fotnoter\n")
    (set-message-flag-q . "Ta emot gruppmeddelanden till %#1M? ")
    (why-you-got-no-presentation . "\

%#1@\
========================================================================
Du har ingen presentation%#2?z%[ men har skrivit %#2d inlgg%]%[%]

Anvnd kommandot \"ndra presentation\" fr att skriva eller ndra din
presentation.

%[%#4F\
Din presentation lter andra i %#3s veta lite om vem du r, och det
bidrar till knslan av samhrighet i %#3s. Det hr meddelandet kommer
att upprepas d och d tills du har skrivit en presentation.%]
========================================================================

")

    (delete-user-area-warning . "\
%#1@\
========================================================================
Om du raderar user-arean s kommer alla dina sparade instllningar att
frsvinna. Du kan naturligtvis spara dina aktuella instllningar, och 
d kommer en ny user-area att skapas med elispklientens (men inga andra
klienters) instllningar.

r du helt sker p att du vet var du hller p med och att du verkligen
vill radera din user-area?
========================================================================
")
    (delete-user-area-confirm . "Radera din user-area och alla sparade instllningar? ")
    (removing-user-area . "Tar bort hnvisningen till user-arean frn din personstatus...")
    (deleting-user-area . "Raderar din user-area...")

    (status-server-stats . "Statistik om servern:\n\n")
    (current-average . "nu")

    (unit-second . "sekund")
    (unit-minute . "minut")
    (unit-hour . "timme")
    (unit-day . "dag")
    (unit-mongth . "mnad")
    (unit-year . "r")

    (db-status-backup . "informationsfrlust kan ha frekommit")
    (no-support-in-server . "Servern saknar ndvndig funktionalitet fr detta kommando.\n")
    (mark-confs-as-known . "Markera dessa  %#2d %#1s som knda? ")
    (no-new-conferences . "Inga nya %#2s%#1?b%[ sedan %#1s%]%[%].\n")
    (new-conferences-since . "Nya %#2s%#1?b%[ sedan %#1s%]%[%]:\n")
    (list-confs-from-date . "Lista %#1s skapade sedan vilket datum (tomt fr alla)? ")

    (privs-wheel . "operatr")
    (privs-admin . "administratr")
    (privs-statistic . "statistik")
    (privs-create-conf . "skapa mten")
    (privs-create-pers . "skapa personer")
    (privs-change-name . "ndra namn")
    (privs-flg7 . "oknd (7)")
    (privs-flg8 . "oknd (8)")
    (privs-flg9 . "oknd (9)")
    (privs-flg10 . "oknd (10)")
    (privs-flg11 . "oknd (11)")
    (privs-flg12 . "oknd (12)")
    (privs-flg13 . "oknd (13)")
    (privs-flg14 . "oknd (14)")
    (privs-flg15 . "oknd (15)")
    (privs-flg16 . "oknd (16)")
    (lyskom-no-privileges . "inga rttigheter")

    (what-pers-privs-to-change . "Vems rttigheter vill du ndra? ")
    (change-pers-privs-prompt . "\
Nuvarande rttigheter fr %#1P (%#1p):
    %#2s
ndra rttigheter fr %#1P (%#1p)...")

    (set-wheel-priv-q . "Aktivera operatrsrttigheter? ")
    (set-admin-priv-q . "Aktivera administratrsrttigheter? ")
    (set-statistic-priv-q . "Aktivera statistikrttigheter? ")
    (set-create-conf-priv-q . "Aktivera rtt att skapa mten? ")
    (set-create-pers-priv-q . "Aktivera rtt att skapa personer? ")
    (set-change-name-priv-q . "Aktivera rtt att ndra namn? ")
    (set-flg7-priv-q . "Aktivera oknd rttighet 7? ")
    (set-flg8-priv-q . "Aktivera oknd rttighet 8? ")
    (set-flg9-priv-q . "Aktivera oknd rttighet 9? ")
    (set-flg10-priv-q . "Aktivera oknd rttighet 10? ")
    (set-flg11-priv-q . "Aktivera oknd rttighet 11? ")
    (set-flg12-priv-q . "Aktivera oknd rttighet 12? ")
    (set-flg13-priv-q . "Aktivera oknd rttighet 13? ")
    (set-flg14-priv-q . "Aktivera oknd rttighet 14? ")
    (set-flg15-priv-q . "Aktivera oknd rttighet 15? ")
    (set-flg16-priv-q . "Aktivera oknd rttighet 16? ")

    (canceling-command . "Abryter kommandot...")

    (no-selection . "Ingen markerad")
    (selection . "%#1d markerad%#1?d%[%]%[e%]")
    (lp-no-hidden . "")
    (lp-hidden . "(%#1d dold%#1?d%[%]%[a%])")
    (priority-prompt . "Ny prioritet fr %#1M: ")
    (priority-prompt-marked . "Ny prioritet p markerade mten: ")
    (lp-no-creation-info . "Ingen information om nr medlemskapet skapades")
    (lp-invited . "Inbjuden")
    (lp-added . "Adderad")
    (lp-nope . "Det gick inte: %#1s")
    (lp-no-entry . "Det finns inget medlemskap hr")
    (lp-no-active-filter . "(inga filter aktiva)")
    (lp-active-filters . "Aktiva filter: %#1s")
    (lp-mark-mship-with-prio . "Markera medlemskap med prioritet: ")
    (lp-unmark-mship-with-prio . "Avmarkera medlemskap med prioritet: ")
    (lp-no-selection . "Inga medlemskap r markerade")
    (lp-at-min-prio . "Medlemskapet har redan lgsta mjliga prioritet")
    (lp-at-max-prio . "Medlemskapet har redan hgsta mjliga prioritet")
    (lp-beginning-of-list . "Listans brjan")
    (lp-end-of-list . "Listans slut")
    (lp-goto-priority . "G till prioritet: ")
    (lp-mode-name . "Medlemskap")
    (lp-header-main . "Medlemskap fr %#1M p %#2s")
    (lp-list-header . " Prio   %#1s  Senast inne  Olst  IHPM\n")
    (lp-help-footer . "
 Markera medlemskap: SPC      Markera omrde: C-w      Flytta markerade:   C-y
 Stt prioritet:     p        ka prioritet:  +        Minska prioritet:   -
 Flytta upp:         M-p      Flytta ned:     M-n      ndra flaggor:  I,H,P,M
 Uppskjuta lsning:  u        Endast:         e
 Avsluta:            C-c C-c                           Mer hjlp:        C-h m
")
    (lp-hide-read-after . "Dlj medlemskap lsta efter: ")
    (lp-hide-read-since . "Dlj medlemskap ej lsta sedan: ")
    (lp-skipping-missing-meeting . "Mtet %#1M finns inte lngre, hoppar ver.")
    ))

(lyskom-language-var local lyskom-month-names sv
  '(("januari" . 1)   ("jan" . 1)
    ("februari" . 2)  ("feb" . 2)
    ("mars" . 3)      ("mar" . 3)
    ("april" . 4)     ("apr" . 4)
    ("maj" . 5)       ("maj" . 5)
    ("juni" . 6)      ("jun" . 6)
    ("juli" . 7)      ("jul" . 7)
    ("augusti" . 8)   ("aug" . 8)
    ("september" . 9) ("sep" . 9)
    ("oktober" . 10)  ("okt" . 10)
    ("november" . 11) ("nov" . 11)
    ("december" . 12) ("dec" . 12)))


;;; ================================================================
;;;              The commands and their associated functions



;;; The Alist formerly known as lyskom-commands
(lyskom-language-strings global lyskom-command sv
  '(
    (kom-help                 . "Hjlp")
    (kom-slow-mode            . "Lngsamma kommandon")
    (kom-quick-mode           . "Snabba kommandon")
    (kom-moronify             . "Lgg p idiot/knppskalle-listan")
    (kom-befriend             . "Lgg p vnner/bekanta-listan")
    (kom-send-message         . "Snda meddelande")
    (kom-send-alarm           . "Skicka alarmmeddelande")
    (kom-create-conf	      . "Skapa mte")
    (kom-delete-conf          . "Utplna (mte/person)")
    (kom-delete-text          . "Radera inlgg")
    (kom-display-time	      . "Se tiden")
    (kom-go-to-conf	      . "G till mte")
    (kom-go-to-next-conf      . "G till nsta mte")
    (kom-jump		      . "Hoppa ver alla kommentarer")
    (kom-list-created-conferences . "Lista gda mten")
    (kom-list-conferences     . "Lista mten") 
    (kom-list-persons	      . "Lista personer")
    (kom-list-news            . "Lista nyheter")
    (kom-list-sessions        . "Lista sessioner")
    (kom-list-re              . "Lista (med) regexpar")
    (kom-membership	      . "Lista medlemskap")
    (kom-postpone	      . "Uppskjuta lsning")
    (kom-set-session-priority . "Stt lsniv")
    (kom-prioritize	      . "Prioritera mten")
    (kom-status-person	      . "Status (fr) person")
    (kom-status-conf	      . "Status (fr) mte")
    (kom-add-self	      . "Bli medlem i mte")
    (kom-change-priority      . "ndra prioritet")
    (kom-list-summary	      . "Lista renden")
    (kom-sub-self             . "Uttrda ur mte")
    (kom-quit		      . "Sluta")
    (kom-recover	      . "Starta om klienten") 
    (kom-start-anew	      . "Brja med nytt namn")
    (kom-view		      . "terse inlgg")
    (kom-find-root-review     . "terse trd")
    (kom-review-comments      . "terse alla kommentarer")
    (kom-review-more-comments . "terse fler kommentarer")
    (kom-review-tree	      . "terse alla kommentarer rekursivt")
    (kom-review-clear         . "terse hoppa")
    (kom-review-last-normally-read
     			      . "terse igen")
    (kom-review-cross-references
     			      . "terse alla korsreferenser")
    (kom-review-converted     . "terse konverterat")
    (kom-review-noconversion  . "terse omodifierat")
    (kom-review-rot13         . "terse rot13")
    (kom-review-next          . "terse nsta")
    (kom-find-root	      . "terse urinlgget")
    (kom-review-by-to         . "terse senaste")
    (kom-review-roots-by-to   . "terse senaste urinlgg")
    (kom-review-more          . "terse fler inlgg")
    (kom-review-first         . "terse frsta")
    (kom-review-first-roots   . "terse frsta urinlgg")
    (kom-review-all           . "terse alla")
    (kom-review-all-roots     . "terse alla urinlgg")
    (kom-view-commented-text  . "terse det kommenterade")
    (kom-view-previous-commented-text
     			      . "terse det fregende kommenterade")
    (kom-review-stack         . "terse lista")
    (kom-review-presentation  . "terse presentation")
    (kom-review-backward      . "(terse) Baklnges")
    (kom-view-next-text	      . "Lsa nsta inlgg")
    (kom-who-is-on	      . "Vilka (r) inloggade") 
    (kom-who-is-on-in-conference
     			      . "Vilka (r inloggade i) mte") 
    (kom-who-is-present-in-conference
     			      . "Vilka (r) nrvarande (i mte)")
    (kom-who-is-on-and-friend . "Vilka vnner (r inloggade)")
    (kom-who-am-i             . "Var (r) jag")
    (kom-list-clients	      . "Lista klienter")
    (kom-busy-wait	      . "Vnta p ett inlgg")
    (kom-write-comment	      . "Kommentera inlgg")
    (kom-comment-previous     . "Kommentera fregende inlgg")
    (kom-write-footnote       . "Fotnot till inlgg")
    (kom-private-answer       . "Personligt svar")
    (kom-private-answer-previous
     . "Personligt svar p fregende inlgg")
    (kom-set-unread	      . "Endast lsa senaste")
    (kom-write-text	      . "Skriva ett inlgg")
    (kom-send-letter	      . "Skicka brev")
    (kom-change-name	      . "ndra namn")
    (kom-change-parenthesis   . "ndra parentes")
    (kom-change-password      . "ndra lsenord")
    (kom-change-supervisor    . "ndra organisatr")
    (kom-change-presentation  . "ndra presentation")
    (kom-get-appreciation     . "F uppmuntran")
    (kom-get-abuse            . "F skll")
    (kom-mark-text            . "Markera (inlgg)")
    (kom-unmark-text          . "Avmarkera (inlgg)")
    (kom-review-marked-texts  . "terse markerade")
    (kom-review-all-marked-texts . "terse alla markerade")
    (kom-add-recipient        . "Addera mottagare")
    (kom-add-copy	      . "Addera extra kopiemottagare")
    (kom-add-bcc	      . "Addera dold kopia")
    (kom-sub-recipient        . "Subtrahera mottagare")
    (kom-move-text            . "Flytta inlgg")
    (kom-add-comment	      . "Addera kommentar")
    (kom-sub-comment	      . "Subtrahera kommentar")
    (kom-move-comment	      . "Flytta kommentar")
    (kom-add-cross-reference  . "Addera referens")
    (kom-add-member	      . "Addera medlem")
    (kom-sub-member           . "Uteslut medlem")
    (kom-change-conf-motd     . "Stt lapp p drren")
    (kom-set-garb-nice        . "ndra livslngd")
    (kom-set-super-conf       . "ndra supermte")
    (kom-set-permitted-submitters . "ndra tilltna frfattare")
    (kom-unset-conf-motd      . "Ta bort lapp p drren")
    (kom-save-text	      . "Arkivera inlgg (till fil)")
    (kom-save-text-body	      . "Spara inlggstext (p fil)")
    (kom-save-options         . "Spara instllningar")
    (kom-shutdown-server      . "Stng av servern")
    (kom-sync-database        . "Spara databasen")
    (kom-enable-adm-caps      . "verg till administratrsmod")
    (kom-disable-adm-caps     . "verg till normalmod")
    (kom-set-motd             . "Stt loginmeddelande")
    (kom-remove-motd          . "Ta bort loginmeddelande")
    (kom-force-logout         . "Kasta ut en session")
    (kom-filter-author        . "Filtrera frfattare")
    (kom-filter-subject       . "Filtrera rende")
    (kom-filter-text          . "Filtrera innehll")
    (kom-filter-recipient     . "Filtrera mottagare")
    (kom-super-jump           . "Superhoppa")
    (kom-filter-edit          . "ndra filter")
    (kom-list-filters         . "Lista filter")
    (kom-show-user-area       . "Visa user-arean")
    (kom-delete-user-area     . "Ta bort user-arean")
    (kom-change-conf-type     . "ndra mtestyp")

    (kom-change-auto-reply    . "ndra svarsmeddelande")
    (kom-toggle-auto-reply    . "Automatsvar")
    (kom-list-messages        . "Lista meddelanden")
    (kom-erase-messages       . "Radera meddelanden")

    (kom-remote-autoreply     . "Fjrrkontrollera automatsvar")
    (kom-remote-set-message   . "Fjrrkontrollera ndra svarsmeddelande")
    (kom-remote-list-messages . "Fjrrkontrollera lista meddelanden")
    (kom-remote-erase-messages . "Fjrrkontrollera radera meddelanden")
    (kom-remote-quit          . "Fjrrkontrollera avsluta")

    (kom-status-session       . "Status (fr) session")
    (kom-customize            . "Instllningar (fr) LysKOM")
    (kom-next-kom             . "Nsta LysKOM")
    (kom-previous-kom         . "Fregende LysKOM")
    (kom-next-unread-kom      . "Nsta olsta LysKOM")
    (kom-change-language      . "ndra sprk")
    (kom-calculate            . "Berkna")
    (kom-list-marks           . "Lista markeringar")
    (kom-where-is             . "Var finns kommandot")
    (kom-fast-reply           . "Anmrkning (till inlgg)")
    (kom-agree                . "Hlla med")
    (kom-add-faq              . "Addera FAQ")
    (kom-del-faq              . "Ta bort FAQ")
    (kom-review-faq           . "terse FAQ")

    (kom-add-footnote	      . "Addera fotnot")
    (kom-sub-footnote	      . "Subtrahera fotnot")

    (kom-add-no-comments      . "Frhindra kommentarer")
    (kom-add-private-answer   . "Begr personligt svar")
    (kom-add-request-confirm  . "Begr lsbekrftelse")

    (kom-review-mail-headers  . "terse brevhuvud")
    
    (kom-compare-texts        . "Jmfr tv texter")
    (kom-diff-texts           . "Se diff")

    (kom-view-url-in-text     . "Visa URL")

    (kom-become-anonymous     . "Bli anonym")
    (kom-become-nonanonymous  . "Bli icke-anonym (trd fram ur skuggorna)")

    (kom-keep-alive           . "Hll frbindelsen aktiv")
    (kom-stop-keep-alive      . "Avbryt hll frbindelsen aktiv")

    (kom-is-person-member-of-conference . "Kontrollera (om person r) medlem (i mte)")
    (kom-will-person-read-text . "Kontrollera (om person kommer att) lsa (inlgg)")

    (kom-change-conf-faq      . "ndra FAQ")

    (kom-make-review-mark-as-read . "terse lsmarkerar")
    (kom-make-review-not-mark-as-read . "terse lsmarkerar inte")

    (kom-set-presentation     . "Addera presentation")
    (kom-remove-presentation  . "Ta bort presentation")
    (kom-set-motd-text        . "Addera lapp p drren")
    (kom-create-aux-item      . "Skapa tillggsinformation")
    (kom-status-server        . "Status (fr) servern")
    (kom-add-server-faq       . "Addera server-FAQ")
    (kom-del-server-faq       . "Ta bort server-FAQ")
    (kom-review-server-faq    . "terse server-FAQ")
    (kom-change-server-faq    . "ndra server-FAQ")
    (kom-recommend-conference . "Rekommendera mte")
    (kom-redirect-comments    . "Dirigera om kommentarer")
    (kom-move-text-tree       . "Flytta trd")

    (kom-copy-options         . "Kopiera instllningar")
    (kom-mark-unread          . "Olsmarkera inlgg")
    (kom-unread-by-to         . "Olsmarkera senaste")
    (kom-unread-roots-by-to   . "Olsmarkera senaste urinlgg")
    (kom-unread-more          . "Olsmarkera fler inlgg")
    (kom-unread-commented-text . "Olsmarkera det kommenterade")
    (kom-unread-previous-commented-text . "Olsmarkera det fregende kommenterade")
    (kom-unread-comments      . "Olsmarkera alla kommentarer")
    (kom-unread-tree          . "Olsmarkera alla kommentarer rekursivt")
    (kom-unread-root          . "Olsmarkera urinlgget")
    (kom-unread-root-review   . "Olsmarkera trd")
    (kom-unread-last-normally-read
     			      . "Olsmarkera igen")
    (kom-unread-all           . "Olsmarkera alla")
    (kom-unread-all-roots     . "Olsmarkera alla urinlgg")
    (kom-unread-first         . "Olsmarkera frsta")
    (kom-unread-first-roots   . "Olsmarkera frsta urinlgg")
    (kom-unread-presentation  . "Olsmarkera presentation")
    (kom-unread-server-faq    . "Olsmarkera server-FAQ")
    (kom-unread-faq           . "Olsmarkera FAQ")
    (kom-unread-marked-texts  . "Olsmarkera markerade")
    (kom-unread-all-marked-texts . "Olsmarkera alla markerade")

    (kom-join-all-conferences . "Bli medlem i alla mten")
    (kom-leave-all-conferences . "Uttrd ur (nstan) alla mten")
    (kom-limit-import         . "Begrnsa import av texter")
    (kom-change-message-flag  . "ndra mottagning (av) gruppmeddelanden")
    (kom-list-faqs            . "Lista FAQ")
    (kom-list-server-faqs     . "Lista server-FAQ")
    (kom-list-new-conferences . "Lista nya mten")
    (kom-list-new-persons     . "Lista nya personer")
    (kom-change-privileges    . "ndra rttigheter")
    ))

(lyskom-language-var local lyskom-language-codes sv
  '((aa . "Afar")
    (ab . "Abkhasianska")
    (af . "Afrikaans")
    (am . "Amhariska")
    (ar . "Arabiska")
    (as . "Assamesiska")
    (ay . "Aymara")
    (az . "Azerbajanska")
    (ba . "Bashkiriska")
    (be . "Vitryska")
    (bg . "Bulgariska")
    (bh . "Bihariska")
    (bi . "Bislamska")
    (bn . "Bengaliska")
    (bo . "Tibetanska")
    (br . "Bretangneska")
    (ca . "Katalanska")
    (co . "Korsikanska")
    (cs . "Tjeckiska")
    (cy . "Walesiska")
    (da . "Danska")
    (de . "Tyska")
    (dz . "Bhutanska")
    (el . "Grekiska")
    (en . "Engelska")
    (eo . "Esperanto")
    (es . "Spanska")
    (et . "Estniska")
    (eu . "Baskiska")
    (fa . "Persiska")
    (fi . "Finska")
    (fj . "Fiji")
    (fo . "Fariska")
    (fr . "Franska")
    (fy . "Frisiska")
    (ga . "Irlndska")
    (gd . "Skotsk Gliska")
    (gl . "Galiciska")
    (gn . "Guarani")
    (gu . "Gujaratiska")
    (ha . "Hausa")
    (he . "Hebreiska")
    (hi . "Hindi")
    (hr . "Kroatiska")
    (hu . "Ungerska")
    (hy . "Armeniska")
    (ia . "Interlingua")
    (id . "Indonesiska")
    (ie . "Interlingue")
    (ik . "Inupiak")
    (is . "Islndska")
    (it . "Italienska")
    (iu . "Inuktitut")
    (ja . "Japanska")
    (jw . "Javanesiska")
    (ka . "Georgiska")
    (kk . "Kazakhstanska")
    (kl . "Grnlndska")
    (km . "Kambodianska")
    (kn . "Kannada")
    (ko . "Koreanska")
    (ks . "Kashmiriska")
    (ku . "Kurdiska")
    (ky . "Kirghiz")
    (la . "Latinska")
    (ln . "Lingala")
    (lo . "Laotesiska")
    (lt . "Litauiska")
    (lv . "Lettiska")
    (mg . "Malagasiska")
    (mi . "Maori")
    (mk . "Makedonska")
    (ml . "Malayalam")
    (mn . "Mongolska")
    (mo . "Moldaviska")
    (mr . "Marathi")
    (ms . "Malaysiska")
    (mt . "Maltesiska")
    (my . "Burmesiska")
    (na . "Nauruiska")
    (ne . "Nepalska")
    (nl . "Hollndska")
    (no . "Norska")
    (oc . "Occitanska")
    (om . "Oromo")
    (or . "Oriya")
    (pa . "Pundjabiska")
    (pl . "Polska")
    (ps . "Pashtu")
    (pt . "Protugisiska")
    (qu . "Quechua")
    (rm . "Rhtoromanska")
    (rn . "Kirundiska")
    (ro . "Rumnska")
    (ru . "Ryska")
    (rw . "Kiyarwanda")
    (sa . "Sanskrit")
    (sd . "Sindhi")
    (sg . "Sangho")
    (sh . "Serbokroatiska")
    (si . "Singhalesiska")
    (sk . "Slovakiska")
    (sl . "Slovenska")
    (sm . "Samoanska")
    (sn . "Shoniska")
    (so . "Somaliska")
    (sq . "Albanska")
    (sr . "Serbiska")
    (ss . "Siswatiska")
    (st . "Sesothiska")
    (su . "Sudanesiska")
    (sv . "Svenska")
    (sw . "Swahili")
    (ta . "Tamilska")
    (te . "Telugu")
    (tg . "Tajikiska")
    (th . "Thailndska")
    (ti . "Tigrinya")
    (tk . "Turkmenistanska")
    (tl . "Tagalog")
    (tn . "Sichuanska")
    (to . "Tongiska")
    (tr . "Turkiska")
    (ts . "Tsongiska")
    (tt . "Tatariska")
    (tw . "Twi")
    (ug . "Uiguriska")
    (uk . "Ukrainska")
    (ur . "Urdu")
    (uz . "Uzbekistanska")
    (vi . "Vietnamesiska")
    (vo . "Volapk")
    (wo . "Wolof")
    (xh . "Xhosa")
    (yi . "Yiddish")
    (yo . "Yorouba")
    (za . "Zhuang")
    (zh . "Kinesiska")
    (zu . "Zulu")
    (-- . "Oknt sprk (%#1s)")))


(lyskom-language-ending-mismatch lyskom-menu language sv en)
(lyskom-language-ending-mismatch lyskom-menu kom-change-language sv en)
(lyskom-language-ending-mismatch lyskom-menu kom-change-global-language sv en)
(lyskom-language-ending-mismatch lyskom-menu kom-change-local-language sv en)

(lyskom-language-strings global lyskom-menu sv
  '((lyskom    . "LysKOM")
    (read      . "Ls")
    (dont-read . "Hoppa")
    (write     . "Skriv")
    (conference . "Mte")
    (person    . "Person")
    (server    . "Server")
    (other     . "Annat")
    (move      . "G")
    (info      . "Om")
    (send      . "Snd")
    (unread    . "Markera olst")
    (review    . "terse inlgg")
    (marks     . "Markerade inlgg")
    (filters   . "Filter")
    (receivers . "Mottagare")
    (commented . "Kommenterar")
    (aux-items . "Tillggsinformation")
    (conf-admin . "Mtesadministration")
    (server-admin . "Serveradministration")
    (membership . "Medlemskap")
    (pers-admin . "Personadministration")
    (autoreply . "Automatsvar")
    (remote-control . "Fjrrstyrning")
    (language . "ndra sprk (Change Language)")
    (kom-help . "Hjlp (Help)")
    (kom-change-language . "ndra sprk (Change language)")
    (kom-change-global-language . "Visning och kommandon (display and commands)")
    (kom-change-local-language . "Endast visning (display language only)")
    (kom-edit-send . "Skicka in")
    (kom-edit-send-anonymous . "Skicka anonymt")
    (kom-edit-quit . "Kasta bort") 
    (kom-ispell-message . "Stavningskontroll")
    (kom-edit-add-recipient . "Addera mottagare")
    (kom-edit-add-copy . "Addera extra kopiemottagare")
    (kom-edit-show-commented . "terse det kommenterade")
    (kom-edit-insert-commented . "Citera det kommenterade")
    (kom-edit-insert-buglist . "Klistra in kommenterad buglista")
    (kom-edit-add-bcc . "Addera dold kopia")
    (kom-edit-add-cross-reference . "Addera korsreferens")
    (kom-edit-add-no-comments . "Begr inga kommentarer")
    (kom-edit-add-personal-comments . "Begr personliga svar")
    (kom-edit-add-read-confirm-request . "Begr lsbekrftelse")
    (kom-edit-move-text . "Flytta till en ny mottagare")

    (lp--toggle-membership-selection . "Vxla markering p medlemskap")
    (lp--select-region . "Markera omrde")
    (lp--select-priority . "Markera prioritet")
    (lp--deselect-priority . "Avmarkera prioritet")
    (lp--deselect-all . "Avmarkera alla")
    (lp--membership-expansion . "Expandera medlemskap")
    (lp--toggle-entry-expansion . "Vxla expansion")
    (lp--expand-entry . "Expandera medlemskap")
    (lp--contract-entry . "Avexpandera medlemskap")
    (lp--membership-priority . "Prioritet")
    (lp--set-priority . "ndra prioritet")
    (lp--move-up . "Flytta uppt")
    (lp--move-down . "Flytta nedt")
    (lp--increase-priority . "ka prioritet")
    (lp--decrease-priority . "Minska prioritet")
    (lp--yank . "Flytta markerade")
    (lp--filter . "Urval")
    (lp--show-hide-memberships-read-before . "Vxla visning av medlemskap lsta fre...")
    (lp--show-hide-memberships-read-after . "Vxla visning av medlemskap lsta efter...")
    (lp--show-hide-read-memberships . "Vxla visning av medlemskap utan olsta")
    (lp--show-hide-passive-memberships . "Vxla visning av passiva medlemskap")
    (lp--show-all . "Visa alla medlemskap")
    (lp--membership-type . "Medlemskapstyp")
    (lp--toggle-invitation . "Vxla inbjudan")
    (lp--toggle-passive . "Vxla passiv")
    (lp--toggle-message-flag . "Vxla meddelanden")
    (lp--toggle-secret . "Vxla hemlig")
    (lp--set-unread . "Endast")
    (lp--quit . "Avsluta")
))

(lyskom-language-var local lyskom-onoff-table sv
  '(("p" . on) ("av" . off)))

(lyskom-language-var local lyskom-filter-predicate-list sv
      '(("=" . nil) ("!=" . t)))

(lyskom-language-var local lyskom-filter-what sv
      '((author . "Frfattare")
        (author-no . "Frfattare (nummer)")
        (author-re . "Frfattare (regexp)")
        (subject . "rende")
        (subject-re . "rende (regexp)")
        (recipient . "Mottagare")
        (recipient-no . "Mottagare (nummer)")
        (recipient-re . "Mottagare (regexp)")
        (text . "Innehll")
        (text-re . "Innehll (regexp)")))

(lyskom-language-var local lyskom-filter-actions sv
      '((skip-text . "Hoppa ver")
        (dontshow . "Visa inte")
        (read . "Undanta frn filtrering")
        (skip-tree . "Hoppa ver kommentarer")
	(obliterate . "Utplna")))

(defconst lyskom-keybindings-missing nil)

(defvar lyskom-sv-mode-map nil)
(lyskom-language-keymap lyskom-mode-map sv lyskom-sv-mode-map)

(defvar lyskom-sv-review-prefix)
(defvar lyskom-sv-change-prefix)
(defvar lyskom-sv-next-prefix)
(defvar lyskom-sv-list-prefix)
(defvar lyskom-sv-S-prefix)
(defvar lyskom-sv-fast-reply-prefix)
(defvar lyskom-sv-filter-get-prefix)
(defvar lyskom-sv-who-prefix)
(defvar lyskom-sv-A-prefix)
(defvar lyskom-sv-unread-prefix)

(if lyskom-sv-mode-map
    nil
  (setq lyskom-sv-mode-map (make-keymap))
  (suppress-keymap lyskom-sv-mode-map)
  (define-prefix-command 'lyskom-sv-review-prefix)
  (define-prefix-command 'lyskom-sv-change-prefix)
  (define-prefix-command 'lyskom-sv-next-prefix)
  (define-prefix-command 'lyskom-sv-list-prefix)
  (define-prefix-command 'lyskom-sv-S-prefix)
  (define-prefix-command 'lyskom-sv-fast-reply-prefix)
  (define-prefix-command 'lyskom-sv-filter-get-prefix)
  (define-prefix-command 'lyskom-sv-who-prefix)
  (define-prefix-command 'lyskom-sv-A-prefix)
  (define-prefix-command 'lyskom-sv-unread-prefix)

  (define-key lyskom-sv-mode-map (kbd "f") 'lyskom-sv-filter-get-prefix)
  (define-key lyskom-sv-mode-map (kbd "n") 'lyskom-sv-next-prefix)
  (define-key lyskom-sv-mode-map (kbd "l") 'lyskom-sv-list-prefix)
  (define-key lyskom-sv-mode-map (kbd "s") 'lyskom-sv-S-prefix)
  (define-key lyskom-sv-mode-map (kbd "r") 'lyskom-sv-fast-reply-prefix)
  (define-key lyskom-sv-mode-map (kbd "v") 'lyskom-sv-who-prefix)
  (define-key lyskom-sv-mode-map (kbd "a") 'lyskom-sv-A-prefix)
  (define-key lyskom-sv-mode-map (kbd "o") 'lyskom-sv-unread-prefix)

  (lyskom-try-define-key lyskom-sv-mode-map (kbd "")    'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map (kbd "{")    'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map (kbd "[")    'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [adiaeresis] 'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [Adiaeresis] 'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map []          'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map []          'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [228]        'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [196]        'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [2276]       'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [2244]       'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [3908]       'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [3940]       'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [195 164]    'lyskom-sv-change-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [195 132]    'lyskom-sv-change-prefix)

  (lyskom-try-define-key lyskom-sv-mode-map (kbd "") 'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map (kbd "}") 'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map (kbd "]") 'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [aring]     'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [Aring]     'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map []       'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map []       'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [229]     'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [197]     'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [2277]    'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [2245]    'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [3909]    'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [3941]    'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [195 165] 'lyskom-sv-review-prefix)
  (lyskom-try-define-key lyskom-sv-mode-map [195 133] 'lyskom-sv-review-prefix)

  ; XEmacs 21.4 UTF-8 on terminal compatibility
  (lyskom-try-define-key lyskom-sv-mode-map [()]      (let ((k (make-sparse-keymap)))
                                                           (define-key k (vector (intern "\205")) 'lyskom-sv-review-prefix)
                                                           (define-key k [] 'lyskom-sv-review-prefix)
                                                           (define-key k (vector (intern "\204")) 'lyskom-sv-change-prefix)
                                                           (define-key k [()] 'lyskom-sv-change-prefix)
							   k))

  (define-key lyskom-sv-mode-map (kbd "M-m") 'kom-toggle-mark-as-read-prefix)
  (define-key lyskom-sv-mode-map (kbd "M-c") 'kom-toggle-cache-prefix)
  (define-key lyskom-sv-mode-map (kbd "M-u") 'kom-toggle-topic-prefix)

  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button2)) 'kom-mouse-null)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button2up)) 'kom-button-click)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button3))   'kom-popup-menu)
  (define-key lyskom-sv-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-mode-map (kbd "*")     'kom-button-press)
  (define-key lyskom-sv-mode-map (kbd "=")     'kom-menu-button-press)
  (define-key lyskom-sv-mode-map (kbd "TAB")   'kom-next-link)
  (define-key lyskom-sv-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-sv-mode-map (kbd "<S-tab>") 'kom-previous-link)
  (define-key lyskom-sv-mode-map (kbd "C-i")   'kom-next-link)
  (define-key lyskom-sv-mode-map (kbd "M-C-i") 'kom-previous-link)

  ;; These should be first in order to be last in the menu of alternatives.
  (define-key lyskom-sv-change-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-review-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-unread-prefix     (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-filter-get-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-next-prefix       (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-list-prefix       (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-S-prefix          (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-who-prefix        (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-fast-reply-prefix (kbd "?") 'lyskom-help)
  (define-key lyskom-sv-A-prefix          (kbd "?") 'lyskom-help)
  

  (define-key lyskom-sv-mode-map (kbd "e")   'kom-set-unread)
;;  (define-key lyskom-sv-mode-map (kbd "a")   'kom-obsolete-extended-command-binding)
;;  (define-key lyskom-sv-mode-map (kbd "l v") 'kom-obsolete-who-is-on-in-conference)
  (define-key lyskom-sv-mode-map (kbd "x")   'kom-extended-command)
  (define-key lyskom-sv-mode-map (kbd "<SPC>") 'kom-next-command)
  (define-key lyskom-sv-mode-map (kbd "<RET>") 'kom-line-next-command)
  (define-key lyskom-sv-mode-map (kbd "<LFD>") 'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "C-j") 'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "j")   'kom-page-next-command)
  (define-key lyskom-sv-mode-map (kbd "C-m") 'kom-line-next-command)

  (define-key lyskom-sv-mode-map (kbd "?")   'kom-help)
  (define-key lyskom-sv-mode-map (kbd "b")   'kom-send-letter)
  (define-key lyskom-sv-mode-map (kbd "g")   'kom-go-to-conf)
  (define-key lyskom-sv-mode-map (kbd "i")   'kom-write-text)
  (define-key lyskom-sv-mode-map (kbd "k")   'kom-write-comment)
  (define-key lyskom-sv-mode-map (kbd "K")   'kom-comment-previous)
  (define-key lyskom-sv-mode-map (kbd "F")   'kom-write-footnote)
  (define-key lyskom-sv-mode-map (kbd "p")   'kom-private-answer)
  (define-key lyskom-sv-mode-map (kbd "P")   'kom-private-answer-previous)
  (define-key lyskom-sv-mode-map (kbd "h")   'kom-jump)
  (define-key lyskom-sv-mode-map (kbd "H")   'kom-super-jump)
  (define-key lyskom-sv-mode-map (kbd "m")   'kom-add-self)
  (define-key lyskom-sv-mode-map (kbd "M")   'kom-mark-text)
  (define-key lyskom-sv-mode-map (kbd "A")   'kom-unmark-text)
  (define-key lyskom-sv-mode-map (kbd "S")   'kom-quit)
  (define-key lyskom-sv-mode-map (kbd "q")   'kom-quit)
  (define-key lyskom-sv-mode-map (kbd "z")   'kom-bury)
  (define-key lyskom-sv-mode-map (kbd "R")   'kom-recover)
  (define-key lyskom-sv-mode-map (kbd "t")   'kom-display-time)
  (define-key lyskom-sv-mode-map (kbd "J")   'kom-who-am-i)
  (define-key lyskom-sv-mode-map (kbd "V")   'kom-busy-wait)

  (define-key lyskom-sv-next-prefix (kbd "i") 'kom-view-next-new-text)
  (define-key lyskom-sv-next-prefix (kbd "m") 'kom-go-to-next-conf)
  (define-key lyskom-sv-next-prefix (kbd "l") 'kom-next-kom)
  (define-key lyskom-sv-next-prefix (kbd "o") 'kom-next-unread-kom)

  (define-key lyskom-sv-list-prefix (kbd "k") 'kom-list-sessions)
  (define-key lyskom-sv-list-prefix (kbd "M") 'kom-list-marks)
  (define-key lyskom-sv-list-prefix (kbd "m") 'kom-list-conferences)
  (define-key lyskom-sv-list-prefix (kbd "n") 'kom-list-news)
  (define-key lyskom-sv-list-prefix (kbd "p") 'kom-list-persons)
  (define-key lyskom-sv-list-prefix (kbd "r") 'kom-list-re)
  (define-key lyskom-sv-list-prefix (kbd "s") 'kom-membership)
  (define-key lyskom-sv-list-prefix (kbd "f") 'kom-list-filters)
  (define-key lyskom-sv-list-prefix (kbd "q") 'kom-list-faqs)
  (define-key lyskom-sv-list-prefix (kbd "Q") 'kom-list-server-faqs)

  (lyskom-try-define-key lyskom-sv-list-prefix (kbd "") 'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix (kbd "{") 'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix (kbd "[") 'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [adiaeresis]     'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [Adiaeresis]     'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix []       'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix []       'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [228]     'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [196]     'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [2276]    'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [2244]    'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [3908]    'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [3940]    'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [195 164] 'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [195 132] 'kom-list-summary)
  (lyskom-try-define-key lyskom-sv-list-prefix [()]        (let ((k (make-sparse-keymap)))
                                                           (define-key k (vector (intern "\204")) 'kom-list-summary)
                                                           (define-key k [] 'kom-list-summary)
							   k))

  (define-key lyskom-sv-filter-get-prefix (kbd "u") 'kom-get-appreciation)
  (define-key lyskom-sv-filter-get-prefix (kbd "s") 'kom-get-abuse)
  (define-key lyskom-sv-filter-get-prefix (kbd "t") 'kom-move-text)
  (define-key lyskom-sv-filter-get-prefix (kbd "T") 'kom-move-text-tree)
  (define-key lyskom-sv-filter-get-prefix (kbd "f") 'kom-filter-author)
  (define-key lyskom-sv-filter-get-prefix (kbd "i") 'kom-filter-text)
  (define-key lyskom-sv-filter-get-prefix (kbd "m") 'kom-filter-recipient)
  (define-key lyskom-sv-filter-get-prefix (kbd "l") 'kom-previous-kom)
  (define-key lyskom-sv-filter-get-prefix (kbd "k") 'kom-move-comment)

  (lyskom-try-define-key lyskom-sv-filter-get-prefix (kbd "")    'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix (kbd "{")    'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix (kbd "[")    'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [adiaeresis] 'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [Adiaeresis] 'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix []          'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix []          'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [228]        'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [196]        'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [2276]       'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [2244]       'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [3908]       'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [3940]       'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [195 164]    'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [195 132]    'kom-filter-subject)
  (lyskom-try-define-key lyskom-sv-filter-get-prefix [()]        (let ((k (make-sparse-keymap)))
                                                           (define-key k (vector (intern "\204")) 'kom-filter-subject)
                                                           (define-key k [] 'kom-filter-subject)
							   k))

  (define-key lyskom-sv-who-prefix (kbd "i") 'kom-who-is-on)
  (define-key lyskom-sv-who-prefix (kbd "m") 'kom-who-is-on-in-conference)
  (define-key lyskom-sv-who-prefix (kbd "n") 'kom-who-is-present-in-conference)
  (define-key lyskom-sv-who-prefix (kbd "u") 'kom-view-url-in-text)
  (define-key lyskom-sv-who-prefix (kbd "v") 'kom-who-is-on-and-friend)

  (define-key lyskom-sv-change-prefix (kbd "p") 'kom-change-presentation)
  (define-key lyskom-sv-change-prefix (kbd "q") 'kom-change-conf-faq)
  (define-key lyskom-sv-change-prefix (kbd "f") 'kom-filter-edit)
  (define-key lyskom-sv-change-prefix (kbd "m") 'kom-change-auto-reply)

  (define-key lyskom-sv-unread-prefix (kbd "SPC") 'kom-mark-unread)
  (define-key lyskom-sv-unread-prefix (kbd "0") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "1") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "2") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "3") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "4") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "5") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "6") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "7") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "8") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "9") 'kom-initial-digit-unread)
  (define-key lyskom-sv-unread-prefix (kbd "k") 'kom-unread-commented-text)
  (define-key lyskom-sv-unread-prefix (kbd "K") 'kom-unread-previous-commented-text)
  (define-key lyskom-sv-unread-prefix (kbd "a ?") 'lyskom-help)
  (define-key lyskom-sv-unread-prefix (kbd "a k") 'kom-unread-comments)
  (define-key lyskom-sv-unread-prefix (kbd "a r") 'kom-unread-tree)
  (define-key lyskom-sv-unread-prefix (kbd "i") 'kom-unread-last-normally-read)
  (define-key lyskom-sv-unread-prefix (kbd "r") 'kom-unread-root)
  (define-key lyskom-sv-unread-prefix (kbd "u") 'kom-unread-root)
  (define-key lyskom-sv-unread-prefix (kbd "s") 'kom-unread-by-to)
  (define-key lyskom-sv-unread-prefix (kbd "S") 'kom-unread-roots-by-to)
  (define-key lyskom-sv-unread-prefix (kbd "y") 'kom-unread-more)
  (define-key lyskom-sv-unread-prefix (kbd "t") 'kom-unread-root-review)
  (define-key lyskom-sv-unread-prefix (kbd "A") 'kom-unread-all-roots)
  (define-key lyskom-sv-unread-prefix (kbd "f") 'kom-unread-first)
  (define-key lyskom-sv-unread-prefix (kbd "F") 'kom-unread-first-roots)
  (define-key lyskom-sv-unread-prefix (kbd "p") 'kom-unread-presentation)
  (define-key lyskom-sv-unread-prefix (kbd "q") 'kom-unread-faq)
  (define-key lyskom-sv-unread-prefix (kbd "Q") 'kom-unread-server-faq)
  (define-key lyskom-sv-unread-prefix (kbd "m") 'kom-unread-marked-texts)
  (define-key lyskom-sv-unread-prefix (kbd "a m") 'kom-unread-all-marked-texts)
  (define-key lyskom-sv-unread-prefix (kbd "a SPC") 'kom-unread-all)

  (define-key lyskom-sv-review-prefix (kbd "SPC") 'kom-view)
  (define-key lyskom-sv-review-prefix (kbd "0") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "1") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "2") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "3") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "4") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "5") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "6") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "7") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "8") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "9") 'kom-initial-digit-view)
  (define-key lyskom-sv-review-prefix (kbd "k") 'kom-view-commented-text)
  (define-key lyskom-sv-review-prefix (kbd "K") 'kom-view-previous-commented-text)
  (define-key lyskom-sv-review-prefix (kbd "a ?") 'lyskom-help)
  (define-key lyskom-sv-review-prefix (kbd "a k") 'kom-review-comments)
  (define-key lyskom-sv-review-prefix (kbd "a y") 'kom-review-more-comments)
  (define-key lyskom-sv-review-prefix (kbd "a r") 'kom-review-tree)
  (define-key lyskom-sv-review-prefix (kbd "a x") 'kom-review-cross-references)
  (define-key lyskom-sv-review-prefix (kbd "h") 'kom-review-clear)
  (define-key lyskom-sv-review-prefix (kbd "i") 'kom-review-last-normally-read)
  (define-key lyskom-sv-review-prefix (kbd "n") 'kom-review-next)
  (define-key lyskom-sv-review-prefix (kbd "o") 'kom-review-noconversion)
  (define-key lyskom-sv-review-prefix (kbd "v") 'kom-review-converted)
  (define-key lyskom-sv-review-prefix (kbd "3") 'kom-review-rot13)
  (define-key lyskom-sv-review-prefix (kbd "r") 'kom-find-root)
  (define-key lyskom-sv-review-prefix (kbd "u") 'kom-find-root)
  (define-key lyskom-sv-review-prefix (kbd "s") 'kom-review-by-to)
  (define-key lyskom-sv-review-prefix (kbd "S") 'kom-review-roots-by-to)
  (define-key lyskom-sv-review-prefix (kbd "y") 'kom-review-more)
  (define-key lyskom-sv-review-prefix (kbd "A") 'kom-review-all-roots)
  (define-key lyskom-sv-review-prefix (kbd "f") 'kom-review-first)
  (define-key lyskom-sv-review-prefix (kbd "F") 'kom-review-first-roots)
  (define-key lyskom-sv-review-prefix (kbd "l") 'kom-review-stack)
  (define-key lyskom-sv-review-prefix (kbd "p") 'kom-review-presentation)
  (define-key lyskom-sv-review-prefix (kbd "t") 'kom-find-root-review)
  (define-key lyskom-sv-review-prefix (kbd "m") 'kom-review-marked-texts)
  (define-key lyskom-sv-review-prefix (kbd "q") 'kom-review-faq)
  (define-key lyskom-sv-review-prefix (kbd "Q") 'kom-review-server-faq)
  (define-key lyskom-sv-review-prefix (kbd "a m") 'kom-review-all-marked-texts)
  (define-key lyskom-sv-review-prefix (kbd "a SPC") 'kom-review-all)
  (define-key lyskom-sv-review-prefix (kbd "b") 'kom-review-mail-headers)
  (define-key lyskom-sv-review-prefix (kbd "B")   'kom-review-backward)

  (define-key lyskom-sv-S-prefix (kbd "m") 'kom-status-conf)
  (define-key lyskom-sv-S-prefix (kbd "p") 'kom-status-person)
  (define-key lyskom-sv-S-prefix (kbd "s") 'kom-status-session)
  (define-key lyskom-sv-S-prefix (kbd "k") 'kom-status-server)
  (define-key lyskom-sv-S-prefix (kbd "u ?") 'lyskom-help)
  (define-key lyskom-sv-S-prefix (kbd "u m") 'kom-sub-recipient)
  (define-key lyskom-sv-S-prefix (kbd "u k") 'kom-sub-comment)
  (define-key lyskom-sv-S-prefix (kbd "u q") 'kom-del-faq)
  (define-key lyskom-sv-S-prefix (kbd "u f") 'kom-sub-footnote)
  (define-key lyskom-sv-S-prefix (kbd "t") 'kom-save-text)

  (lyskom-try-define-key lyskom-sv-S-prefix (kbd "")    'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix (kbd "{")    'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix (kbd "[")    'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [adiaeresis] 'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [Adiaeresis] 'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix []          'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix []          'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [228]        'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [196]        'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [2276]       'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [2244]       'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [3908]       'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [3940]       'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [195 164]    'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [195 132]    'kom-send-message)
  (lyskom-try-define-key lyskom-sv-S-prefix [()]        (let ((k (make-sparse-keymap)))
                                                           (define-key k (vector (intern "\204")) 'kom-send-message)
                                                           (define-key k [] 'kom-send-message)
							   k))

  (define-key lyskom-sv-A-prefix (kbd "m") 'kom-add-recipient)
  (define-key lyskom-sv-A-prefix (kbd "e") 'kom-add-copy)
  (define-key lyskom-sv-A-prefix (kbd "d") 'kom-add-bcc)
  (define-key lyskom-sv-A-prefix (kbd "k") 'kom-add-comment)
  (define-key lyskom-sv-A-prefix (kbd "r") 'kom-add-cross-reference)
  (define-key lyskom-sv-A-prefix (kbd "q") 'kom-add-faq)
  (define-key lyskom-sv-A-prefix (kbd "f") 'kom-add-footnote)
  (define-key lyskom-sv-A-prefix (kbd "Q") 'kom-add-server-faq)

  (define-key lyskom-sv-fast-reply-prefix (kbd "a") 'kom-fast-reply)
  (define-key lyskom-sv-fast-reply-prefix (kbd "r") 'kom-fast-reply)
  (define-key lyskom-sv-fast-reply-prefix (kbd "h") 'kom-agree)

  ;; Running in buffer

  (define-key lyskom-sv-mode-map (kbd "M-p") 'kom-backward-text)
  (define-key lyskom-sv-mode-map (kbd "M-n") 'kom-forward-text)
  (define-key lyskom-sv-mode-map (kbd "C-M-p") 'kom-prev-prompt)
  (define-key lyskom-sv-mode-map (kbd "C-M-n") 'kom-next-prompt)

  (define-key lyskom-sv-mode-map (kbd "C-?") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<DEL>") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<delete>") 'scroll-down)
  (define-key lyskom-sv-mode-map (kbd "<BS>") 'scroll-down)

  (define-key lyskom-sv-mode-map (kbd "<") 'beginning-of-buffer)
  (define-key lyskom-sv-mode-map (kbd ">") 'end-of-buffer)
  )


;;; ================================================================
;;; Prioritization

(defvar lyskom-sv-prioritize-mode-map nil "Keymap used in lyskom-prioritize-mode")
(lyskom-language-keymap lyskom-prioritize-mode-map sv lyskom-sv-prioritize-mode-map)

(if lyskom-sv-prioritize-mode-map
    nil
  (setq lyskom-sv-prioritize-mode-map (make-keymap))
  (suppress-keymap lyskom-sv-prioritize-mode-map)
  (define-key lyskom-sv-prioritize-mode-map (kbd "SPC") 'lp--toggle-membership-selection)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-k") 'lp--toggle-membership-selection)
  (define-key lyskom-sv-prioritize-mode-map (kbd "p")   'lp--set-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-w") 'lp--select-region)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-w") 'lp--select-region)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-y") 'lp--yank)
  (define-key lyskom-sv-prioritize-mode-map (kbd "#")   'lp--select-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-#")   'lp--deselect-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-DEL") 'lp--deselect-all)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-p") 'lp--previous-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<up>") 'lp--previous-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-n") 'lp--next-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<down>") 'lp--next-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<home>") 'lp--first-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "<end>") 'lp--last-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<") 'lp--first-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M->") 'lp--last-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd "g") 'lp--goto-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "RET") 'lp--toggle-entry-expansion)
  (define-key lyskom-sv-prioritize-mode-map (kbd "+") 'lp--increase-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "-") 'lp--decrease-priority)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-p") 'lp--move-up)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-n") 'lp--move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<up>") 'lp--move-up)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-<down>") 'lp--move-down)
  (define-key lyskom-sv-prioritize-mode-map (kbd "I") 'lp--toggle-invitation)
  (define-key lyskom-sv-prioritize-mode-map (kbd "H") 'lp--toggle-secret)
  (define-key lyskom-sv-prioritize-mode-map (kbd "P") 'lp--toggle-passive)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M") 'lp--toggle-message-flag)
  (define-key lyskom-sv-prioritize-mode-map (kbd "e") 'lp--set-unread)
  (define-key lyskom-sv-prioritize-mode-map (kbd "u") 'lp--postpone)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-c C-c") 'lp--quit)
  (define-key lyskom-sv-prioritize-mode-map (kbd "q") 'lp--quit)
  (define-key lyskom-sv-prioritize-mode-map (kbd "(") 'lp--expand-entry)
  (define-key lyskom-sv-prioritize-mode-map (kbd ")") 'lp--contract-entry)

  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button2up)) 'kom-button-click)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button2)) 'kom-mouse-null)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button3)) 'kom-popup-menu)
  (define-key lyskom-sv-prioritize-mode-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-prioritize-mode-map (kbd "*") 'kom-button-press)
  (define-key lyskom-sv-prioritize-mode-map (kbd "=") 'kom-menu-button-press)
  (define-key lyskom-sv-prioritize-mode-map (kbd "TAB") 'kom-next-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-TAB") 'kom-previous-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "C-i") 'kom-next-link)
  (define-key lyskom-sv-prioritize-mode-map (kbd "M-C-i") 'kom-previous-link)
  )



;;; ==============================================================
;;; Keymap for filter editing
;;;

(defvar lyskom-sv-filter-edit-map nil)
(lyskom-language-keymap lyskom-filter-edit-map sv lyskom-sv-filter-edit-map)

(if lyskom-sv-filter-edit-map ()
  (setq lyskom-sv-filter-edit-map (make-keymap))
  (suppress-keymap lyskom-sv-filter-edit-map)
  (define-prefix-command 'lyskom-sv-filter-edit-prefix)
  (define-key lyskom-sv-filter-edit-map (kbd "C-c") 'lyskom-sv-filter-edit-prefix)
  (define-key lyskom-sv-filter-edit-map (kbd "p")   'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "P")   'lyskom-filter-edit-prev-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "n")   'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "N")   'lyskom-filter-edit-next-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "C-p") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-n") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-b") 'lyskom-filter-edit-prev-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-f") 'lyskom-filter-edit-next-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-p") 'lyskom-filter-edit-prev-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "M-n") 'lyskom-filter-edit-next-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "d")   'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-d") 'lyskom-filter-edit-delete-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "D")   'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "C-d") 'lyskom-filter-edit-delete-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "i")   'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "I")   'lyskom-filter-edit-insert-pattern)
  (define-key lyskom-sv-filter-edit-map (kbd "M-i") 'lyskom-filter-edit-insert-entry)
  (define-key lyskom-sv-filter-edit-map (kbd "<")   'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd ">")   'lyskom-filter-edit-end-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "M-<") 'lyskom-filter-edit-beginning-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "M->") 'lyskom-filter-edit-end-of-list)
  (define-key lyskom-sv-filter-edit-map (kbd "q")   'lyskom-filter-edit-quit)
  (define-key lyskom-sv-filter-edit-map (kbd "C-c C-c")   'lyskom-filter-edit-quit)
  (define-key lyskom-sv-filter-edit-map (kbd "x")   'lyskom-filter-edit-expunge)
  (define-key lyskom-sv-filter-edit-map (kbd "s")   'lyskom-filter-edit-save)
  (define-key lyskom-sv-filter-edit-map (kbd "g")   'lyskom-filter-edit-revert)
  (define-key lyskom-sv-filter-edit-map (kbd "t")   'lyskom-filter-edit-toggle-permanent)
  (define-key lyskom-sv-filter-edit-map (kbd "a")   'lyskom-filter-edit-toggle-action)
  (define-key lyskom-sv-filter-edit-map (kbd "?")   'lyskom-filter-edit-brief-help)
  (define-key lyskom-sv-filter-edit-map (kbd "h")   'lyskom-filter-edit-brief-help)
  )


;;;; ============================================================
;;;; Strings and things for the customize mode
;;;;

(defvar lyskom-sv-customize-map nil)
(lyskom-language-keymap lyskom-customize-map sv lyskom-sv-customize-map)


(if lyskom-sv-customize-map
    nil
  (setq lyskom-sv-customize-map (make-sparse-keymap))
  (define-key lyskom-sv-customize-map (kbd "TAB") 'widget-forward)
  (define-key lyskom-sv-customize-map (kbd "M-TAB") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "<S-tab>") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "C-i") 'widget-forward)
  (define-key lyskom-sv-customize-map (kbd "M-C-i") 'widget-backward)
  (define-key lyskom-sv-customize-map (kbd "C-m") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "C-j") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "<RET>") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd "<LFD>") 'widget-button-press)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button1)) 'widget-button-click)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button2)) 'widget-button-click)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button3)) 'lyskom-widget-click)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button1up)) 'kom-mouse-null)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button2up)) 'kom-mouse-null)
  (define-key lyskom-sv-customize-map (kbd (lyskom-keys 'button3up)) 'kom-mouse-null)
  (define-key lyskom-sv-customize-map (kbd "C-c C-c") 'lyskom-customize-save-and-quit)
  (define-key lyskom-sv-customize-map (kbd "C-c C-k") 'lyskom-customize-quit)
  (define-key lyskom-sv-customize-map (kbd "C-c C-s") 'lyskom-customize-save)
  (define-key lyskom-sv-customize-map (kbd "C-c C-a") 'lyskom-customize-apply)
  (define-key lyskom-sv-customize-map (kbd "?") 'lyskom-customize-help)
)

(lyskom-language-strings local lyskom-custom-strings sv
  '(
    ;;
    ;; Widget strings
    ;;

    (which-person . "Ange en person: ")
    (which-conf . "Ange ett mte: ")
    (which-conf-or-person . "Ange en person eller ett mte: ")
    (which-name . "Ange ett namn: ")
    (some-person . "Person %#1d")
    (invalid-value . "Otilltet vrde (%#1S)")
    (unknown-command . "Oknt kommando (%#1s)")
    (ding . "Ljudsignal")

    ;;
    ;; Help messages
    ;;

    (variable-type-help . "Kryssa i fr att spara instllningen i servern.")
    (default-help-echo . "ndra vrdet p %#1s.")
    (change-this-name . "ndra namnet p denna rad.")
    (show-doc . "Visa hjlptexten.")
    (hide-doc . "Dlj hjlptexten.")
    (select-command . "Vlj kommando.")
    (select-what-to-execute . "Exekvera kommando eller tangentbordsmakro.")
    (select-url-viewer . "Vlj en WWW-lsare.")
    (select-number . "Ange hur mnga gnger.")
    (select-audio-file . "Ange en ljudfil.")
    (select-priority . "Ange prioritet.")
    (select-buffer . "Ange buffert.")
    (select-buffer-size . "Ange buffertstorlek.")

    ;;
    ;; Strings that are used in types and so forth
    ;;

    (buffer-name . "%#1s-instllningar")

    (other-window     . "Ngot annat fnster            ")
    (other-frame      . "I en annan frame               ")
    (new-frame        . "I en ny frame                  ")
    (lyskom-window    . "LysKOM-buffertens fnster      ")
    (window-on-buffer . "Ett fnster som visar bufferten")

    (on . "P")
    (off . "Av")
    (yes . "Ja ")
    (no . "Nej")
    (to-file . "Till fil:")
    (max-text-length . "Fr inlgg kortare n: ")
    (autowrap-timeout . "Antal sekunder: ")
    (no-timeout . "Ingen tidsbegrnsning")

    (session-lost-all-buffers . "Visa notifiering i alla aktiva LysKOM buffrar")
    (session-lost-beep . "Pip")

    (friends . "Vnner och bekanta")

    (turned-off      . "Avslaget            ")
    (number-of-times . "Ngra gnger")
    (specific-spec . "Per mottagare/avsndare")
    (sound-file . "Ljudfil")
    (other-persons . "Alla andra")
    (selected-mark . "Markering")
    (conf-or-person . "Person eller mte")
    (ask . "Frga varje gng")
    (before . "Fre texten")
    (after . "Efter texten")
    (first . "Frst")
    (last . "Sist ")
    (depth-first . "I kommentarsordning")
    (time-order . "I tidsordning")
    (ancestor . "Ls olsta kommenterade frst")
    (relative . "Ls olsta relaterade frst")
    (limited-number . "Ett begrnsat antal")
    (unlimited-number . "Obegrnsat")

    (ar-message-type . "Meddelandetyp")
    (ar-personal     . "Personligt meddelande")
    (ar-group        . "Gruppmeddelande")
    (ar-alarm        . "Alarmmeddelande")
    (ar-any-type     . "Alla meddelandetyper")
    (ar-sender       . "Avsndare")
    (ar-any-sender   . "Alla avsndare")
    (ar-specified-sender . "Specifika avsndare")
    (ar-pers-or-conf . "Person eller mte")
    (ar-recipient    . "Mottagare")
    (ar-any-recipient . "Alla mottagare")
    (ar-specified-recipient . "Specifika mottagare")
    (ar-person       . "Person")
    (ar-message-text . "Meddelandetext")
    (ar-any-message  . "Alla meddelanden")
    (ar-matching-regexp . "Meddelanden som matchar")
    (ar-reply        . "Automatsvar")
    (ar-no-reply     . "Inget svar")
    (ar-reply-text   . "Svarstext")

    (express-break . "Omedelbart efter de har skapats")
    (break         . "Efter aktuell kommentarskedja")
    (no-break      . "Efter aktuellt mte")

    (express-server-break . "Omedelbart")
    (express-server-letters-break . "Omedelbart om det kommer brev")
    (server-break . "Efter aktuell kommentarskedja")
    (letters-server-break . "Efter aktuell kommentarskedja om det kommer brev")
    (after-conf-server-break . "Efter aktuellt mte")
    (after-conf-letters-server-break . "Efter aktuellt mte nr det kommer brev")
    (when-done-server-break . "Nr allt r utlst")
    (no-server-break . "Aldrig")

    (command . "Kommando")
    (command-list . "Kommandolista")
    (some-persons . "Fr vissa personer:")
    (name . "Namn")

    (page-none . "Aldrig                 ")
    (page-all  . "Fre varje kommando    ")
    (page-some . "Fre fljande kommandon")

    (ask-every-time . "Frga varje gng      ")
    (fixed-priority . "Fast prioritet")

    (messages-in-lyskom-buffer . "I LysKOM-bufferten  ")
    (discard-messages .          "Ingenstans          ")
    (in-named-buffer .           "I namngiven buffert:")

    (automatic-session-name . "Automatiskt")
    (given-session-name . "Anvnd angivet:")

    (simple-unread-mode-line . "Enkel")
    (explicit-unread-mode-line . "Visa alla sessioner med olsta")

    (everybody-rcpt .       "Alla                              ")
    (group-rcpt .           "Senaste gruppmeddelandes mottagare")
    (sender-rcpt .          "Senaste meddelandes avsndare     ")
    (last-recipient-recpt . "Senaste mottagaren                ")

    (viewer-program . "WWW-lsare")
    (no-viewer            . "(ingenting valt)")
    (default-viewer       . "Browse-URL (alla)")
    (netscape-viewer      . "Firefox/Mozilla/Opera/Netscape (alla)")
    (windows-viewer       . "Windows standard eller Netscape-liknande (alla)")
    (emacs-w3-viewer      . "Emacs W3-mode (HTTP, Gopher, FTP)")
    (emacs-general-viewer . "Emacs (FTP, Telnet, Mail)")
    (emacs-dired-viewer   . "Emacs Dired (FTP)")
    (emacs-mail-viewer    . "Emacs Mail-mode (Mail)")
    (emacs-telnet-viewer  . "Emacs Telnet-mode (telnet)")
    (mosaic-viewer        . "NCSA Mosaic (alla)")
    (lynx-viewer          . "Lynx (alla)")
    (galeon-viewer        . "Galeon (alla)")

    (dont-check . "Ingen bekrftelse")
    (check-before-open . "Bekrfta innan inlgget skrivs")
    (check-before-send . "Bekrfta innan inlgget snds")
    (no-size-limit . "Ingen begrnsning")
    (max-size-in-bytes . "Begrnsning (i bytes)")
    (execute . "Utfr")
    (kbd-macro . "Tangentbordmakro")
    (command . "Kommando")
    (enter-kbd-macro . "Mata in tangentbordsmakro. Avsluta med %#1s")

    (long-format  . "Visa hjlptexter")
    (short-format . "Gm hjlptexter ")

    (truncate-threshold-lines . "Max rader")

    (first . "Frst")
    (last . "Sist")
    (specific-placement . "Specifik plats")
    (priority . "Prioritet")
    (same-as-conf . "Samma som aktuellt mte")
    (custom-format . "Eget format:")
    (default-format . "Standardformat")
    (a-string . "En text:")
    (some-string . "En slumpmssig text")
    (unspecified . "Ospecificerat")

    (symbolic-mark-association . "Associering")
    (symbolic-mark-name . "Symboliskt namn: ")
    (mark-type-to-assoc . "Markeringstyp att associera till: ")

    (prompt-for-text-no . "Frga efter textnummer")

    (all-others . "Alla andra")
    (some-person . "Person")
    (format-html . "Formattera HTML:")

    (url-transform-regexp . "Frn (regexp):")
    (url-transform-newtext . "Till:")

    (default-namedays . "Namnsdagar fr aktuellt sprk")
    (specific-namedays . "Specifik namnlngd")
    (several-name-lists . "Flera namnlngder")

    (link-pattern-for . "Mnster fr")
    (all-conferences . "Alla mottagare")
    (link-specific-rcpt . "Specifik mottagare")
    (link-pattern . "Lnkmnster")
    (link-replace . "Lnksubstitution")
    (link-highlight-match . "Visa grupp")
    (link-fold-case . "Versaler och gemener lika")

    (generated-face . "Automatgenererat teckensnitt")
    (predefined-fonts . "Teckensnitt avsedda fr specifika tillmpningar\n")
    (other-fonts . "Teckensnitt utan specifika tillmpningar\n")
    (other-face . "Annat")

    (ext-simple-command . "Enkelt kommando")
    (ext-complex-command . "Kommando med argument")
    (ext-complex-component . "Komanndo/argument")

    (lynx-xterm . "Lynx i xterm")
    (lynx-emacs . "Lynx i emacs terminal-mode")

    (morons . "Idioter och knppskallar")
    (friends . "Vnner och bekanta")
    (me . "Mig sjlv och ingen annan")
    (i-am-supervisor . "Mten jag organiserar")
    (has-no-presentation . "Mten utan presentationer")
    (highlight-conferences . "Mten:")
    (highlight-face . "Utseende:")
    (highlight-conflist . "Mteslista")

    (yes-dont-pop . "Ja, men avikonifiera inte fnstret")
    (language . "Sprk")

    (specific-extended-info . "Enbart vald information")
    (extended-info-show . "Visa:")
    (extended-info-type . "Informationstyp:")

    (extended-server-info . "All utkad serverinformation")
    (extended-conf-info . "All utkad mtesinformation")
    (extended-pers-info . "All utkad personinformation")
    (extended-read-faq-info . "Lsta FAQ")
    (extended-statistics-info . "Fullstndig serverstatistik")
    (extended-all-other-info . "Annan information")

    (show-presence . "Visa nrvaromeddelanden")
    (conflist . "Mtes/Personlista")
    (pers-list-1 . "Mtes/personlista 1")
    (pers-list-2 . "Mtes/personlista 2")
    (pers-list-3 . "Mtes/personlista 3")
    (pers-list-4 . "Mtes/personlista 4")
    (other-list . "Annan lista")
    (always-show-presence . "Visa alla nrvaromeddelanden")
    (never-show-presence . "Visa inga nrvaromeddelanden")
    (obsolete-setting . "Frldrad instllning")
    (detailed-setting . "Detaljerad instllning")

    ;;
    ;; Misc doc strings
    ;;

    (lyskom . "Instllningar fr LysKOM")
    (lyskom-doc . "\
Dessa tangenter fungerar utanfr redigerbara textflt.
\\[lyskom-customize-save-and-quit] fr att spara och avsluta,
\\[lyskom-customize-apply] fr att applicera utan att spara eller avsluta,
\\[lyskom-customize-save] fr att spara utan att avsluta,
\\[lyskom-customize-quit] fr att avsluta utan att spara.
\\[widget-forward] flyttar till nsta instllning
\\[widget-button-press] ndrar vrdet
Tryck C-h m fr en fullstndig lista av kommandon.

Hjlptexter: [?] Visa hjlptext    [!] Gm hjlptext
Listor mm.:  [INS] Lgg till rad   [DEL] Ta bort rad    [*] ndra vrde

Om rutan fre instllningens namn r ikryssad kommer vrdet att sparas
i servern. Annars sparas det i din .emacs.

Klicka med musens mittenknapp p ledtexterna fr att ndra vrde eller
ta fram menyer.")

    (section . "------------------------------------------------------------------------------\n")
    (look-and-feel-misc . "Diverse utseende och beteende\n")
    (window-locations   . "Fnster\n")
    (windows-where      . "Hur skall fnster skapas:\n")
    (reading .            "Beteende vid lsning\n")
    (writing .            "Beteende vid skrivning\n")
    (urls .               "Hantering av URLer\n")
    (personal-messages .  "Hantering av personliga meddelanden\n")
    (remote-control .     "Fjrrstyrning av LysKOM\n")
    (hooks .              "Hook-funktioner\n")

    (audio-cues .         "Ljudsignaler\n")
    (audio-cues-when    . "Ge ljudsignal:\n")
    (automatic-replies .  "Automatiskt svar\n")

    (new-window-netscape . "ppna URLer i nytt fnster")
    (new-tab-netscape . "ppna URLer i ny tab")
    (default-netscape . "ppna URLer dr de rkar hamna")
    
    (audio-cues-doc . "\
  Efterfljande instllningar bestmmer vilken ljudsignal LysKOM skall ge 
  i olika situationer. Fljande alternativ gr att vlja:

    Avslaget
        Ingen ljudsignal alls kommer att ges.

    Ngra gnger
        Emacs kommer att pipa en eller flera gnger nr hndelsen
        intrffar. Antal pip anges ocks. 

    Ljudfil
        Emacs kommer att spela upp den angivna ljudfilen. Programmet som
        angavs ovan som ljudspelarprogram anvnds fr att spela ljudet.")
    

    (sending-doc . "\
  Fljande instllningar slr p eller av vissa kontroller vid inskickning
  av inlgg. Kontrollerna r avsedda att hindra att man gr ngonting dumt.

    Bekrfta multipla mottagare
        Om ett inlgg eller kommentar har flera mottagare s kan LysKOM
        frga vilka av mottagarna som r relevanta fr inlgget. Antingen
        grs detta innan man skriver inlgget (d fr man en frga fr
        varje defaultmottagare), eller nr man skickar in inlgget (d fr
        man bekrfta alla mottagare i klump). Det gr ocks att sl av
        helt.

    Kontroll av kommenterad frfattares medlemskap
        Kontrollera att frfattaren till det kommenterade inlgget r
        medlem i ngon av mottagarna fr kommentaren. Om s inte r fallet,
        erbjuder LysKOM att lgga till frfattaren som mottagare till
        inlgget. 

    Frfattare som inte kontrolleras
        En lista av frfattare som inte skall kontrolleras ven om
        kontroll av kommenterad frfattares medlemskap r pslaget.

    Kontroll av olsta kommentarer
        Nr detta r pslaget s kontrollerar LysKOM att det inlgg man
        kommenterar inte har ngra kommentarer man inte har lst. Detta r
        frmst anvndbart fr att undvika att man skriver ngonting som
        ngon annan redan har skrivit.")


    (windows-doc . "\
  Fljande instllningar bestmmer hur fnster skapas i LysKOM. Alternativen
  som finns r fljande:

    Ngot annat fnster 
        I ett annat fnster i samma frame som LysKOM. Om det bara finns ett
        fnster s kommer ett nytt att skapas (och tas bort nr man r klar).

    I en annan frame
        I en annan frame n LysKOM. Om det bara finns en frame s kommer en
        ny frame att skapas, och (tas bort nr man r klar).

    I en ny frame
        En ny frame skapas fr ndamlet, och tas bort nr man r klar.

    LysKOM-buffertens fnster 
        LysKOM-buffertens fnster kommer att anvndas, och LysKOM kommer
        att terstllas till fnstret nr man r frdig.

    Ett fnster som visar bufferten 
        Om det finns ett fnster ngonstans som visar den angivna bufferten
        s kommer detta fnster att anvndas. Det kan till exempel vara
        anvndbart om man hela tiden har ett fnster ppet, men inte bever
        det just medan man utfr ngot visst kommando.")

    ;;
    ;; Doc strings for variables
    ;;

    (kom-ansaphone-replies-doc . "\
  Den hr instllningen styr automatsvar i detalj. Det gr att stlla in 
  svar fr specifika avsndare, mottagare och till och med meddelanden. Om
  meddelandet som skall besvaras inte stmmer in p ngot i den hr listan
  s anvnds svarsmeddelandet ovan istllet.

  Fr varje mnster gr det att stlla in meddelandetyp, avsndare som 
  meddelandet skall ha, mottagare som meddelandet skall ha, ett mnster
  som meddelandet skall innehlla och vilket svar som skall skickas.

  Det r lmpligt att stlla in att inget svar skall skickas p ngot
  gruppmeddelande eller alarmmeddelande.")

    (kom-bury-buffers-doc . "\
  Bestmmer hur bufferten hanteras nr man gr till ett annat KOM med Nsta
  LysKOM och liknande funktioner. Pslaget innebr att den aktuella bufferten
  lggs sist i buffertlistan nr man byter LysKOM.")

    (kom-personal-messages-in-window-doc . "\
  Bestmmer i vilket fnster som bufferten med personliga meddelanden visas.
  Fr att den hr instllningen skall spela ngon roll s mste personliga
  meddelanden visas i en separat buffert, och bufferten mste visas varje
  gng det kommer meddelanden.")

    (kom-write-texts-in-window-doc . "\
  Bestmmer i vilket fnster nya texter skrivs.")

    (kom-prioritize-in-window-doc . "\
  Bestmmer i vilket fnster man prioriterar om mten.")

    (kom-edit-filters-in-window-doc . "\
  Bestmmer i vilket fnster man ndrar filter.")

    (kom-customize-in-window-doc . "\
  Bestmmer i vilket fnster man gr dessa instllningar.")

    (kom-view-commented-in-window-doc . "\
  Bestmmer i vilket fnster man visar kommenterarer medan man skriver nya.")

    (kom-list-membership-in-window-doc . "\
  Bestmmer i vilket fnster man listar medlemskap.")


    (kom-user-prompt-format-doc . "\
  Format fr LysKOM-prompten. Vissa teckenkombinationer stter in speciella
  texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-user-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET.  Vissa
  teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    
    (kom-anonymous-prompt-format-doc . "\
  Format fr LysKOM-prompten nr man r anonym. Vissa teckenkombinationer 
  stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-anonymous-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET och r
  anonym.  Vissa teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    (kom-enabled-prompt-format-doc . "\
  Format fr LysKOM-prompten nr man r i administratrsmod. Vissa
  teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%] - \"             Standardprompt
    \"%[%s: %c% %m%] - \"         Till exempel \"LysKOM: Se tiden - \"")

    (kom-enabled-prompt-format-executing-doc . "\
  Format fr LysKOM-prompten efter man trycker p SPC eller RET och r i
  administratrsmod.  Vissa teckenkombinationer stter in speciella texter:

    %c - Stter in kommandot som krs om man trycker p SPC eller RET.
    %[ - Stter in '[' om automatsvar r pslaget.
    %] - Stter in ']' om automatsvar r pslaget.     
    %m - Stter in information om antal inspelade meddelanden.
    %s - Stter in LysKOM-systemets namn
    %S - Stter in LysKOM-serverns namn
    %p - Stter in namnet p den person som r inloggad.
    %w - Stter in namn p aktuellt mte.
    %a - Stter in \"anonym\"
    %A - Stter in \"Anonym\"
    %# - Stter in sessionsnummer.
    %  - Stter in mellanslag om det ser ut att behvas.
    %% - Stter in ett procenttecken.

  Ngra exempel:

    \"%[%c% %m%].\"             Standardprompt
    \"%[%s: Kr %c% %m%]...\"   Till exempel \"LysKOM: Kr Se tiden...\"")

    (kom-cite-string-doc . "\
  Text som stts in fre varje rad i ett citerat inlgg. Normalt brukar
  ngonting i stil med \"> \" anvndas. Notera dock att det inte r brukligt
  att citera KOM-inlgg som man gr med sladdpost och News eftersom det
  kommenterade inlgget oftast finns tillgngligt.")


    (kom-created-texts-are-read-doc . "\
  Om detta r pslaget kommer alla inlgg man sjlv skriver att lsmarkeras
  automatiskt. Om instllningen r avslagen s fr man lsa sdant man
  sjlv skriver.")


    (kom-default-mark-doc . "\
  Den markeringstyp som anvnds fr nya markeringar. En markeringstyp r ett
  heltal mellan 0 och 255 (inklusive). Om ingen defaultmarkeringstyp r vald
  frgar LysKOM efter markeringstyp varje gng man markerar en text. Detta
  kan anvndas fr att hlla isr olika sorters markeringar. Till exempel
  kan man markera inlgg som innehller intressant information med ett visst
  tal och inlgg som man ska komma ihg att kommentera vid ett senare
  tillflle med ett annat tal.")

    (kom-symbolic-marks-alist-doc . "\
  Fr att slippa behva memorera vad man tnkte sig att de heltaliga
  markeringstyperna ska innebra kan man definiera en lista med symboliska
  markeringstyper. En symbolisk markeringstyp r en beskrivande strng som
  associeras med en heltalig markeringstyp.")

    (kom-reading-puts-comments-in-pointers-last-doc . "\
  Bestmmer om kommentarslnkar visas fre eller efter en text. Normalt brukar
  man visa kommentarslnkar efter texten.

  Fre:

    398331 1996-09-24  13:22  /2 rader/ George Berkeley
    Mottagare: Filosofimtet <1226>
    Kommentar i text 398374 av John Locke
    rende: 
    ------------------------------------------------------------
    En abstrakt id r en sjlvmotsgelse. 
    (398331) -----------------------------------

  Efter:

    398331 1996-09-24  13:22  /2 rader/ George Berkeley
    Mottagare: Filosofimtet <1226>
    rende: 
    ------------------------------------------------------------
    En abstrakt id r en sjlvmotsgelse. 
    (398331) -----------------------------------
    Kommentar i text 398374 av John Locke
")

    (kom-show-author-at-end-doc . "\
  Om detta r pslaget s visas namnet p frfattaren efter inlggstexten.
  Naturligtvis s visas ven namnet i inlggshuvudet. 

  Pslaget (med streckade linjer ocks pslaget):

    892342 1996-09-24  19:21  /2 rader/ Claude Shannon
    Mottagare: Presentation (av nya) Medlemmar
    rende: Claude Shannon
    ------------------------------------------------------------
    Informationsteoretiker
    (892342) /Claude Shannon/------------------------------

  Avslaget:

    892342 1996-09-24  19:21  /2 rader/ Claude Shannon
    Mottagare: Presentation (av nya) Medlemmar
    rende: Claude Shannon
    ------------------------------------------------------------
    Informationsteoretiker
    (892342) -----------------------------------

  Om man har streckade linjer avslaget s visas frfattaren p samma 
  stt, men de streckade linjerna finns naturligtvis inte med.")

    (kom-truncate-threshold-doc . "\
  Om detta r pslaget kommer inlgg som r lngre n maxantalet att kortas
  ner nr man terser kommentarer, terser markerade inlgg eller terser de
  senaste eller frsta.  Inlgg kortas inte av d man terser inlgg, terser
  trd eller bara lser nsta inlgg.")

    (kom-truncate-show-lines-doc . "\
  Antalet rader som visas nr ett inlgg avkortats.")
     
    (kom-dashed-lines-doc . "\
  Om detta r pslaget visas streckade linjer fre och efter inlggstexten,
  annars visas en tomrad efter renderaden, och ingenting speciellt i slutet.

  Pslaget:

    892343 1996-09-24  19:21  /2 rader/ Tycho Brahe
    Mottagare: Presentation (av nya) Medlemmar
    rende: Tycho Brahe
    ------------------------------------------------------------
    Astronom och upptckare av stjrnor med hemvist p Ven.
    (892343) -----------------------------------

  Avslaget:

    892343 1996-09-24  19:21  /2 rader/ Tycho Brahe
    Mottagare: Presentation (av nya) Medlemmar
    rende: Tycho Brahe

    Astronom och upptckare av stjrnor med hemvist p Ven.
    (892343)

  De flesta brukar ha detta pslaget.")

    (kom-autowrap-doc . "\
  Om detta r pslaget s kommer LysKOM att frska bryta om raderna i
  stycken vars rader r fr lnga. Stycken som verkar vara
  frformatterade av frfattaren bryts dock aldrig om. Det gr att ange
  en maximal lngd i tecken p inlgg som fr brytas om (vilket kan vara
  anvndbart fr att undvika mycket lnga inlgg).")

    (kom-autowrap-timeout-doc . "\
  Denna instllning begrnsar hur lng tid automatisk ombrytning av
  raderna i ett inlgg fr ta (i sekunder). En begrnsning r srskilt
  anvndbar nr man lser mycket lnga inlgg. Notera att tiden r
  hgst ungefrlig. Ombrytningen kan pg i flera sekunder lngre n
  detta vrde. Begrnsningen gr ocks att all inlggsvisning gr
  aningen lngsammare. Om begrnsningen r avstngd kan man nd
  avbryta ombrytningen genom att trycka C-g.") 

    (kom-print-number-of-unread-on-entrance-doc . "\
  Om detta r pslaget s visas antalet olsta i ett mte nr man gr till 
  mtet:

  Pslaget:

    G till nsta mte...
    Presentation (av nya) medlemmar - 3 olsta
    Lsa nsta text - 

  Avslaget:

    G till nsta mte...
    Presentation (av nya) medlemmar
    Lsa nsta text - ")


    (kom-presence-messages-in-echo-area-doc . "\

  Om man vill ha meddelanden i ekoarean nr ngon loggar in, ut eller
  byter namn i LysKOM br man sl p den hr instllningen. Meddelanden
  visas i ekoarean. Om man vill ha information om endast vissa personer
  gr det att ange en lista av personer. Vill man inte ha ngra
  meddelanden alls r det bara att ange en tom lista.")

    (kom-presence-messages-in-buffer-doc . "\
  Om man vill ha meddelanden i LysKOM-bufferten nr ngon loggar in, ut eller
  byter namn i LysKOM br man sl p den hr instllningen.  Meddelanden
  visas i LysKOM-bufferten. Om man vill ha information om endast vissa 
  personer gr det att ange en lista av personer. Vill man inte ha ngra 
  meddelanden alls r det bara att ange en tom lista.")

    (kom-show-where-and-what-doc . "\
  Information i vilkalistan om varifrn en person r inloggad och vad personen
  gr visas bara om detta r pslaget.

  Pslaget:

        Anvndare                            Nrvarande i mte              
        Kr frn                             Gr                             
    --------------------------------------------------------------------------
     6810 George Berkeley                      Filosofimtet                  
          berkeley@emp1.tcd.ie                 (Skriver en kommentar.)        
     7571 John Locke                           Filosofimtet                  
          eridy@cc.ox.ac.uk                    (Vntar.)                      

  Avslaget:

        Anvndare                            Nrvarande i mte              
    --------------------------------------------------------------------------
     6810 George Berkeley                      Filosofimtet                  
     7571 John Locke                           Filosofimtet")

    (kom-show-since-and-when-doc . "\
  Information i vilkalistan om nr en person loggade in och hur lnge sedan
  personen var aktiv.")

    (kom-remember-password-doc . "\
  Om denna instllning r pslagen sparas lsenordet till LysKOM-servern
  som en lokal variabel i sessionsbufferten och kan p s vis anvndas
  vid terinloggning ifall sessionen kopplas ner. OBS: Lsenordet sparas
  i klartext, detta gr att om ngon fr tillgng till din LysKOM-
  sessionsbuffer (ven nedkopplad sdan) kan han/hon f reda p ditt
  lsenord ifall du aktiverar detta val.")

    (kom-idle-hide-doc . "\
  I vilkalistan visas normalt enbart de sessioner som har varit aktiva
  under den senaste tiden. Denna instllning bestmmer hur mnga minuter
  en session fr ha varit inaktiv och nd visas i vilkalistan.")


    (kom-show-footnotes-immediately-doc . "\
  Fotnoter visas normalt p samma stt som kommentarer, men om detta r
  pslaget s visas fotnoter direkt efter inlgget de hr till.")


    (kom-follow-comments-outside-membership-doc . "\
  Normalt s visar inte LysKOM kommentarer till ett inlgg om man inte r
  medlem i ngot av mtena kommentaren har som mottagare. Om man vill
  flja kommentarskedjor utanfr de mten man r medlem i kan man sl
  p den hr instllningen.")


    (kom-read-depth-first-doc . "\
  LysKOM kan visa inlgg antingen i den ordning de skapades, eller i den
  ordning de ligger i kommentarstrdet. Ta till exempel fljande inlgg:

  Inlgg 1002 r inte en kommentar till ngonting. Inlgg 1003 och 1004
  r kommentarer till inlgg 1002. Inlgg 1005 och 1007 r kommentarer
  till inlgg 1004 och inlgg 1006 r en kommentar till inlgg 1003. D
  ser kommentarstrdet ut ungefr s hr:
        
  1002 +-- 1003 --- 1006
       |
       +-- 1004 +-- 1005
                |
                +-- 1007

  Om man lser inlggen i tidsordning kommer de att visas i ordningen
  1002, 1003, 1004, 1005, 1006 och 1007. I kommentarsordning blir det
  i stllet 1002, 1003, 1006, 1004, 1005 och 1007.")


    (kom-read-related-first-doc . "\
  Nr LysKOM bestmt sig fr en text som ska visas enligt reglerna som
  styrs av variabeln kom-read-depth-first, kan den ta hnsyn till att
  en annan relaterad olst text borde visas frst.  Fljande vrden r
  tilltna:

    nil (Av)
        Gr ingen mer processning.

    'oldest-ancestor (Ls olsta kommenterade frst)
        Om texten r en kommentar eller fotnot till en frldratext,
        och om anvndaren r medlem i minst en mottagare av den
        texten, och texten r olst, s blir texten en kandidat till
        att anvndas i stllet.  Processen upprepas s lnge ngon
        kandidat har en frlder som uppfyller villkoren.  Den
        kandidat som har det lgsta textnumret kommer att anvndas.
        Den hr instllningen betyder att ett kommentarstrd som
        brjar i ett annat mte n det du just nu lser kommer att
        visas i en mer logisk ordning: du fr se hela det olsta
        trdet i kommentarsordning.

    'oldest-relative (Ls olsta relaterade frst)
        Den hr instllningen r snarlik 'oldest-ancestor, men
        undersker ven rekursivt alla kommentarer till alla
        kandidater.  Nackdelen med denna metod r att den kan behva
        kontrollera hundratals texter, och det kan f klienten att bli
        lngsam.")


    (kom-continuous-scrolling-doc . "\
  Pslaget innebr att klienten scrollar bufferten medan ny text stts in, s
  man ser det senaste som har satts in. Detta fungerar bra om man har en
  snabb terminal, men kan vara vrt att sl av om terminalen r lngsam, och
  scrollning i Emacs tar tid.")


    (kom-deferred-printing-doc . "\
  Fr att snabba upp LysKOM s skrivs vissa saker, som person- och mtesnamn
  inte ut omedelbart, utan skrivs frst ut som \"[...]\", vilket sedan byts
  ut mot den rtta utskriften nr texten finns tillgnglig. Detta snabbar
  upp svarstiderna i klienten ganska mycket, men gr att stnga av med den
  hr instllningen om man tycker det ser otrevligt ut.")


    (kom-higher-priority-breaks-doc . "\
  Nr texter kommer in till mten som har hgre prioritet n det man lser
  kan klienten lta en lsa dessa texter omedelbart, efter den aktuella
  kommentarskedjan eller efter man har lst ut mtet.")
    

    (kom-login-hook-doc . "\
  Kommandon som skall kras nr man loggar in, innan ngon inmatning frn
  tangentbordet tas emot. Till exempel kan man gra Lista nyheter hr fr
  att f se en lista av nyheter varje gng man loggar in.")


    (kom-do-when-done-doc . "\
  Kommandon som skall kras nr man har lst ut alla inlgg. Det r ganska
  vanligt att man har terse alla markerade hr. Bde tangentbordsmakron
  och regelrtta funktioner gr bra.")


    (kom-page-before-command-doc . "\
  LysKOM-bufferten kan scrollas fre alla kommandon s att text som stts in
  av kommandot hamnar verst i fnstret. Denna variabel talar om fre vilka
  kommandon detta skall ske.")


    (kom-permissive-completion-doc . "\
  Om detta r pslaget s kommer TAB bara att fylla ut namn p inloggade
  personer nr kommandot bara kan utfras p inloggade personer (till
  exempel Status (fr) session och Snda meddelande). Om det r avslaget
  kommer TAB att fylla ut ven med namn p personer som inte r inloggade.")


    (kom-membership-default-priority-doc . "\
  Detta bestmmer hur prioriteten p mten man gr med i stts. Om det r
  en siffra mellan 1 och 255 s kommer nya medlemskap att f den prioriteten.
  I annat fall kommer klienten att frga fr varje nytt medlemskap vilken
  prioritet det skall ha.")

    (kom-membership-default-message-flag-doc . "\
  Detta bestmmer om gruppmeddelanden tas emot i mten man gr med i. `Ja'  
  betyder att gruppmeddelanden tas emot, `Nej' att meddelanden inte tas
  emot. `Frga varje gng' att klienten frgar nr du gr med i mten.")

    (kom-show-personal-messages-in-buffer-doc . "\
  Denna instllning bestmmer var personliga meddelanden, gruppmeddelanden
  och alarmmeddelanden visas. Meddelanden kan antingen visas i 
  LysKOM-bufferten, kastas bort helt eller visas i en namngiven buffert.")


    (kom-pop-personal-messages-doc . "\
  Om personliga meddelanden skall visas i en egen buffert och denna instllning
  ocks r pslagen s kommer den bufferten att visas s fort ett meddelande
  anlnder.")


    (kom-audio-player-doc . "\
  Om man vill att LysKOM skall spela ljudfiler i stllet fr att pipa vid 
  olika tillfllen mste denna instllning peka ut ett program som klarar
  att spela ljudfilerna. Programmet skall ta ett argument: namnet p filen
  som skall spelas.")


    (kom-default-message-recipient-doc . "\
  Denna instllning bestmmer vem som kommer att vara defaultmottagare
  fr personliga meddelanden man skickar. Alternativen som finns r
  att meddelanden normalt r allmnna, att avsndaren fr det senast
  mottagna meddelandet skall vara default eller att mottagaren fr det
  senaste gruppmeddelandet (eller avsndaren av det senaste personliga
  eller allmnna meddelandet) skall vara mottagare.")


    (kom-filter-outgoing-messages-doc . "\
  Om denna instllning r pslagen s kommer meddelanden som skickas 
  automatiskt, till exempel automatiska svar och svar p fjrrkontrollfrsk
  ven att visas som om man hade skickat det manuellt.")

    (kom-friends-doc . "\
  Namnen p personerna i denna lista kan visas med ett speciellt utseende
  i LysKOM-bufferten. Kommandot Vilka vnner r inloggade (och andra
  liknande kommandon) anvnder ocks denna lista.")

    (kom-morons-doc . "\
  Namnen p personerna i denna lista kan visas med ett varnande 
  utseende i LysKOM-bufferten.")

    (kom-person-list-1-doc . "\
  Den hr listan har ingen frutbestmd betydelse, utan kan anvndas fr
  att stlla in att personerna ska visas med ett speciellt utseende (se
  kom-highlight-conferences) eller fr att konfigurera in- och utloggningar
  (se kom-presence-messages-in-buffer) med mera.")

    (kom-person-list-2-doc . "\
  Den hr listan har ingen frutbestmd betydelse, utan kan anvndas fr
  att stlla in att personerna ska visas med ett speciellt utseende (se
  kom-highlight-conferences) eller fr att konfigurera in- och utloggningar
  (se kom-presence-messages-in-buffer) med mera.")

    (kom-person-list-3-doc . "\
  Den hr listan har ingen frutbestmd betydelse, utan kan anvndas fr
  att stlla in att personerna ska visas med ett speciellt utseende (se
  kom-highlight-conferences) eller fr att konfigurera in- och utloggningar
  (se kom-presence-messages-in-buffer) med mera.")

    (kom-person-list-4-doc . "\
  Den hr listan har ingen frutbestmd betydelse, utan kan anvndas fr
  att stlla in att personerna ska visas med ett speciellt utseende (se
  kom-highlight-conferences) eller fr att konfigurera in- och utloggningar
  (se kom-presence-messages-in-buffer) med mera.")

    (kom-url-viewer-preferences-doc . "\
  Denna instllning bestmmer vilken WWW-lsare som i frsta hand skall 
  anvndas fr att ppna URLer som frekommer i LysKOM. Om den frsta lsaren 
  i listan inte klarar den typ av URL som man frsker ppna s anvnds nsta
  lsare och s vidare.")

    (kom-windows-browser-command-doc . "\
  Denna instllning talar om vilket kommando som skall anvndas fr att starta
  en WWW-lsare i Windows. Om fltet r tomt testas ett antal kommandon som
  typiskt brukar fungera i Windows.")

    (kom-mosaic-command-doc . "\
  Denna instllning talar om vilket kommando som skall anvndas fr att starta
  Mosaic.")

    (kom-netscape-command-doc . "\
  Denna instllning anger kommandot fr att kra Firefox, Mozilla, Opera 
  eller Netscape.")

    (kom-galeon-command-doc . "\
  Denna instllning anger kommandot fr att kra Galeon.")

    (kom-inhibit-typeahead-doc . "\
  Normalt sparas tangenttryckningar som grs medan klienten r upptagen, och
  utfrs nr det blir mjligt. Om denna instllning r avslagen s kommer
  LysKOM enbart att utfra kommandon som ges nr klienten inte arbetar.")

    (kom-max-buffer-size-doc . "\
  Det r mjligt att begrnsa LysKOM-buffertens storlek genom att ange hur
  stor den fr bli i den hr variabeln. Om bufferten blir fr stor kommer
  information frn buffertens brjan att tas bort.")

    (kom-ansaphone-record-messages-doc . "\
  LysKOM kan \"spela in\" meddelanden som kommer nr funktionen fr automatiskt
  svar r pslagen. Denna instllning bestmmer om s sker eller inte.")

    (kom-ansaphone-show-messages-doc . "\
  Om denna instllning r pslagen kommer LysKOM att visa inkomna personliga
  meddelanden ven om automatiskt svar r pslaget.")

    (kom-ansaphone-default-reply-doc . "\
  Automatsvararen skickar detta meddelande om inget annat meddelande har
  specificerats via ngon annan mekanism (och den r bara till fr frsiktiga
  experter).")

    (kom-remote-control-doc . "\
  Pslagen innebr att det gr att fjrrstyra klienten. Fjrrstyrningen r
  dock begrnsad till vissa personer.")

    (kom-remote-controllers-doc . "\
  Personerna i denna lista fr fjrrstyra klienten.")

    (kom-self-control-doc . "\
  Om detta r pslaget fr anvndaren som r inloggad styra klienten frn
  en annan session. Detta r ett alternativ till att lgga in sig sjlv i
  listan ver tilltna fjrrstyrare.")

    (kom-customize-format-doc . "\
  Dokumentation till instllningarna kan vara p eller avslagen nr 
  instllningsfnstret ppnas. Dokumentationen kan alltid visas eller
  gmmas fr varje enskild instllning genom att anvnda frgetecknet
  eller utropstecknet som str till hger om instllningen.")

    (kom-default-language-doc . "\
  Sprk som skall anvndas i LysKOM. Om du ndrar instllningen hr s kommer
  inte instllningen ndras fr aktuell session, utan du mste ge kommandot
  ndra sprk ocks. Det frsta sprk p listan som r tillgngligt kommer
  att vljas av alla klienter med std fr funktionen.")

    (kom-ispell-dictionary-doc . "\
  Ordlista som skall anvndas av stavningskontrollen i LysKOM. Om detta
  r satt till kom-ispell-dictionary s kommer variabeln ispell-dictionary
  att anvndas istllet.")

    (kom-show-namedays-doc . "\
  Pslaget innebr att dagens namn visas nr man ser tiden. Det gr att
  vlja att se namnsdagarna frn namnsdagslngden som hr till det sprk
  man fr nrvarande anvnder eller att anvnda en specifik lista med
  namn.")

    (kom-show-week-number-doc . "\
  Se tiden visar veckonummer om detta r pslaget. Annars visas inte 
  veckonummer.")

    (kom-relogin-behaviour-doc . "\
  Denna instllning styr om klienten ska frska teransluta om ett 
  kommando ges i en nedkopplad session. P betyder att det sker 
  automatiskt, av att klienten inte frgar om man vill teransluta.")

    (kom-relogin-inhibit-commands-doc . "\
  Kommandon som inte skall orsaka ngon teranslutning. Dessa kommandon
  kommer inte att orsaka att en nedkopplad klient teransluter.")

    (kom-membership-default-placement-doc . "\
  Denna instllning styr var nya medlemskap hamnar. Frst betyder att nya
  medlemskap hamnar fre gamla med samma prioritet. Sist betyder att nya 
  medlemskap hamnar efter gamla med samma prioritet. En siffra r en fix
  placering i medlemskapslistan (men medlemskapet kommer att flyttas
  ssmningom).")

    (kom-show-imported-importer-doc . "\
  Pslaget betyder visa vilken person som importerade ett importerat e-mail.")

    (kom-show-imported-envelope-sender-doc . "\
  Visa den verkliga avsndaren till ett importerat e-mail om detta r 
  pslaget.")

    (kom-show-imported-external-recipients-doc . "\
  Visa externa mottagare och extra-kopiemottagare om detta r pslaget.")

    (kom-show-imported-message-id-doc . "\
  Pslaget betyder visa meddelande-id.")

    (kom-agree-text-doc . "\
  Text som anvnds av kommandot Hlla med. Det kan antingen vara en text
  eller en lista av texter. Om det r en lista s vljs ett alternativ
  slumpmssigt.")

    (kom-silent-ansaphone-doc . "\
  On detta r avslaget s piper inte klienten nr det kommer meddelanden och
  automatsvar r pslaget.")

    (kom-default-session-priority-doc . "\
  Lsniv fr nya sessioner. Detta r den lsniv som nya sessioner fr
  automatiskt.")

    (kom-unsubscribe-makes-passive-doc . "\
  Om detta r pslaget s gr kommandot Uttrda ur mte att man frst blir
  passiv medlem i mtet. Om man uttrder ur mtet igen s gr man ur p
  riktigt. Om detta r avslaget s gr man ur mtet frsta gngen man frsker
  uttrda.")

    (kom-review-priority-doc . "\
  Prioritet fr tersekommandon. Detta r den prioritet som inlggen man ser
  nr man gr terse fr. Det anvnds fr att avgra om nya inlgg skall
  avbryta tersefunktionen. Stt till 256 eller hgre om du inte vill att nya
  inlgg ngonsin skall avbryta en tersefunktion.")

    (kom-show-creating-software-doc . "\
  Om detta r pslaget s visas vilken klient som skapade inlgget tillsammans
  med varje inlgg, frutsatt att informationen finns verhuvudtaget.")

    (kom-text-footer-format-doc . "\
  Format fr inlggsfoten. I texten erstts %n med inlggsnumret, %P med
  frfattarens namn, %p med frfattarens nummer, %f med information om
  inlgget (ombruten, HTML mm.) och %- med en lagom lng streckad linje.
  En siffra efter procenttecknet r minsta bredd p texten. Ett minustecken
  fre siffran betyder att texten skall vnsterjusteras. Ett likhetstecken
  betyder att fltlngden r exakt och texten kanske kortas av.")

    (kom-long-lines-doc . "\
  Om detta r pslaget s grs de flesta streckade linjer i klienten mycket
  lngre n normalt.")

    (kom-postpone-default-doc . "\
  Antalet inlgg som inte skall uppskjutas med Uppskjuta lsning.")

    (kom-allow-incompleteness-doc . "\
  Pslaget betyder att klienten inte vntar p att information om alla
  olsta har kommit fram innan den tillter kommandon som Lista nyheter.
  Avslaget innebr att klienten vntar p information om olsta inlgg om
  den upptcker att informationen behvs och inte har kommit fram.")

    (kom-smileys-doc . "\
  Gladmn, som :-), visas grafiskt nr denna instllning r p, frutsatt
  att Emacs klarar det och paketet smiley.el (en del av Gnus) r installerat.")

    (kom-ignore-message-senders-doc . "\
  Visa inte personliga, grupp- och alarmmeddelanden frn dessa personer.")

    (kom-ignore-message-recipients-doc . "\
  Visa inte gruppmeddelanden riktade till dessa mten.")

    (kom-text-footer-dash-length-doc . "\
  Den totala lngden p inlggsfoten nr streckade linjer, men inte extra
  lnga linjer, och inte ett eget format anvnds.")

    (kom-text-header-dash-length-doc . "\
  Den totala lngden p den streckade linjen ovanfr inlggstexten nr
  extra lnga linjer inte anvnds.")

    (kom-show-personal-message-date-doc . "\
  Nr detta r pslaget s visas datum och klockslag fr alla personliga,
  grupp- och alarmmeddelanden.")

    (kom-w3-simplify-body-doc . "\
  Nr detta r pslaget s visas HTML utan de frger som anges i HTML-koden.")

    (kom-mercial-doc . "\
  Denna text visas i vilkalistan d du har lst frdigt alla mten.")

    (kom-session-nickname-doc . "\
  Hur sessionsnamn bestms. Detta r det namn som visas i mode-raden och
  av Lista sessioner.")

    (kom-server-priority-doc . "\
  Prioritet fr sessionen. Sessioner med hg prioritet kan avbryta andra
  sessioner, beroende p instllningen av YYY.")

    (kom-server-priority-breaks-doc . "\
  Denna instllning styr hur prioriterade sessioner avbryter andra
  sessioner. En session r hgre prioriterad n en annan om dess
  sessionsprioritet r hgre n den andra sessionens.

  Omedelbart            S fort der kommer ett inlgg i en prioriterad 
                        session s fr man prompt om att g till den
                        sessionen.

  Omedelbart om det kommer brev     S fort det kommer ett personligt
                        brev i en prioriterad session s fr man prompt 
                        om att g till den sessionen.

  Efter aktuell kommentarskedja     Om det kommer inlgg i en 
                        prioriterad session s fr man prompt om att
                        g till sessionen nr man har lst klart den
                        aktuella kommentarskedjan.

  Efter aktuell kommentarskedja om det kommer brev      Om det kommer
                        personliga brev i en prioriterad session s 
                        fr man prompt om att g till sessionen nr
                        man har lst klart den aktuella kommentarskedjan.

  Efter aktuellt mte   Om det kommer inlgg i en prioriterad session 
                        s fr man prompt om att g till sessionen nr
                        man har lst klart det aktuella mtet.

  Efter aktuellt mte nr det kommer brev       Om det kommer brev i en
                        prioriterad session s fr man prompt om att g
                        till sessionen nr man har lst klart det 
                        aktuella mtet.

  Nr allt r utlst    Ge prompt om att byta till nsta LysKOM med 
                        olsta inlgg nr allt r klart, oberoende av
                        sessionernas prioritet.

  Aldrig                Ge aldrig prompt om att byta session.")

    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-personal-messages-doc . "")
    (kom-ding-on-group-messages-doc . "")
    (kom-ding-on-common-messages-doc . "")
    (kom-ding-on-no-subject-doc . "")
    (kom-ding-on-wait-done-doc . "")
    (kom-ding-on-priority-break-doc . "")
    (kom-ding-on-new-letter-doc . "")

    (kom-check-for-new-comments-doc . "")
    (kom-check-commented-author-membership . "")
    (kom-confirm-multiple-recipients-doc . "")
    (kom-check-commented-author-membership-doc . "")
    (kom-complete-numbers-before-names-doc . "\
  Nr detta r pslaget och man matar in en text som kan tolkas bde som
  ett mtesnamn eller ett mtesnummer vid inlsning av mtesnamn, s
  tolkar klienten det i frsta hand som ett nummer. Nr detta r avslaget
  s tolkas det i frsta hand som ett mtesnamn.")
    (kom-keep-alive-interval-doc . "\
  Antalet sekunder som skall g mellan de meddelanden som anvnds fr att
  hlla ntverkskopplingen till LysKOM-servern aktiv. Om din frbindelse
  kopplar ned efter en stunds inaktivitet s kan du stta detta till ungefr 
  hlften och sedan ge kommandot \"Hll frbindelsen aktiv\".")
    (kom-lost-session-notification-doc . "\
  Hur notifiering av onormalt avslutade session sker. Ett meddelande skrivs
  alltid ut i den avslutade sessionens LysKOM-buffert. Om denna instllning
  r satt till \"Pip\" kommer klienten dessutom att pipa. Om du har valt \"Visa
  notifiering i alla aktiva LysKOM-buffrar\" kommer klienten att pipa och
  skriva ut ett kort meddelande i alla aktiva LysKOM-buffrar.")
    (kom-text-no-prompts-doc . "\
  Den hr instllningen styr vilka kommandon som alltid frgar efter 
  textnummer (om man inte anger ett explicit som prefixargument). Fr 
  kommandon som inte str med hr anvnds inbyggda standardinstllningar.")
    (kom-saved-file-name-doc . "\
  Anger vilken fil som inlgg skall arkiveras till. Klienten kommer nd
  att frga, men detta blir det frifyllda svaret.")
    (kom-follow-attachments-doc . "\
  Anger om bilagor till importerade brev skall lsas som kommentarer. 
  Om detta r avstngt s lsmarkeras bilagor automatiskt, utan att
  man lser dem.")
    (kom-show-unread-in-frame-title-doc . "\
  Om detta r pslaget s visas \"(Olsta)\" i titelraden fr de
  fnster vars valda buffert hr till en LysKOM-session med olsta. 
  Det r inte skert att titelraden ndras om fnstret inte r ppet.")
    (kom-unread-mode-line-type-doc . "\
  Denna instllning bestmmer hur olsta indikeras i mode-raden. `Enkel'
  betyder en gemensam indikering fr samtliga sessioner ifall du har 
  olsta texter eller brev. 

  `Visa alla sessioner med olsta' betyder att alla sessioner med olsta 
  texter indikeras separat. Frekomst med brev indikeras genom att 
  sessionsnamnet visas med stora bokstver (till exempel LYSLYS istllet 
  fr LysLys). Om sessionsnamnet bara innehller versaler (exempelvis 
  LYSLYS) visas det mellan asterisker (*LYSLYS*).

  Notera att denna instllning br vara samma fr alla aktiva 
  LysKom-sessioner varfr det troligen r bst att spara den i
  din .emacs.")

   (kom-created-texts-are-saved-doc . "\
  Om detta r ett filnamn s sparas alla inlgg man skriver till den
  filen i ungefr samma format som de har nr man lser dem. Inlgg
  som inte kan skapas sparas inte.")
    (kom-confirm-add-recipients-doc . "\
  Om detta r pslaget och man adderar en mottagare till ett inlgg s
  frgar klienten om man vill att kommentarer till inlgget ocks
  skall skickas till den nya mottagaren. Om detta r avslaget s
  kommer kommentarer alltid att skickas ven till den nya mottagaren. 
  Det r oftast bra att ha pslaget.")
    (kom-trim-buffer-minimum-doc . "\
  Om du begrnsar LysKOM-buffertens storlek s mste den bli s hr mycket
  fr stor innan text i bufferten raderas. Variablen ska vara ett heltal,
  default r 4096.")
    (kom-dont-check-commented-authors-doc . "")
    (kom-print-relative-dates-doc . "\
  Tidsangivelsen fr inlgg (och en del andra saker) kommer att bli
  \"idag\" alternativt \"igr\" om denna instllning r pslagen och
  inlgget skrevs idag alternativt igr. Om den r avslagen kommer ett
  absolut datum alltid att visas.")
    (kom-show-mx-date-as-local-doc . "\
  Om denna instllning r pslagen visas tidstmplar fr importerade
  inlgg i lokal tidzon i stllet fr tidzonen i tidstmpeln.")
    (kom-print-seconds-in-time-strings-doc . "\
  Om denna instllning r pslagen kommer en del tidsangivelser (till
  exempel fr visade inlgg och snda meddelanden) att inkludera
  sekunder.")
    (kom-review-uses-cache-doc . "\
  Om detta r pslaget s kommer kommandon som terser inlgg att 
  anvnda sparade kopior av inlggen om de finns. Det gr att kommandona
  gr lite snabbare, men det finns en viss risk fr att ett inlgg kan
  ha ndrats sedan kopian sparades.")
    (kom-review-marks-texts-as-read-doc . "\
  Om detta r pslaget s kommer kommandon som terser inlgg att 
  lsmarkera de inlgg som visas. I annat fall lmnar tersekommandona
  din lshistorik orrd, precis som vanligt.")
    (kom-auto-review-faqs-doc . "\
  Om detta r pslaget s kommer olsta FAQer inte att terses automatiskt
  nr du loggar in eller gr till ett mte med en olst FAQ.")
    (kom-auto-list-faqs-doc . "\
  Om detta r pslaget s kommer olsta FAQer att listas automatiskt nr
  du loggar in eller gr till ett mte med en olst FAQ.")
    (kom-extended-status-information-doc . "\
  Om detta r pslaget s visas extra statusinformation i kommandona
  Status (fr) person, Status (fr) mte och Status (fr) servern 
  (om sdan information finns tillgnglig).")
    (kom-highlight-first-line-doc . "\
  Om detta r pslaget s visas frsta raden i varje inlgg (den med
  inlggsnummer, datum och frfattare) med ett annorlunda utseende n
  normal text.")
    (kom-highlight-dashed-lines-doc . "\
  Om detta r pslaget s visas raderna fre och efter inlggstexten med
  ett annorlunda utseende n normal text.")
    (kom-highlight-text-body-doc . "\
  Om detta r pslaget s visas inlggstexter med ett annorlunda utseende
  n normal text.")
    (kom-async-highlight-dashed-lines-doc . "\
  Om detta r pslaget s visas raderna fre och efter personliga, grupp-
  och alarmmeddelanden med ett annorlunda utseende n normal text.")
    (kom-async-highlight-text-body-doc . "\
  Om detta r pslaget s visas personliga, grupp- och alarmmeddelanden 
  med ett annorlunda utseende n normal text.")
    (kom-edit-hide-add-button-doc . "\
  Om detta r pslaget s kommer knappen [Addera...] att visas efter
  mottagare och tillggsinformation nr man skriver inlgg.")
    (kom-format-html-authors-doc . "\
  Den hr instllningen styr vilka frfattares HTML-meddelanden som
  elispklienten kommer att frska formattera.")
    (kom-format-show-images-doc . "\
  Den hr instllningen styr om inlgg uppmrkta som bilder specialhanteras
  eller visas som traditionella inlgg.")
    (kom-keyboard-menu-immediate-selection-doc . "\
  Den hr instllningen styr huruvida snabbtangenter automatiskt bekrftar
  val i textbaserade menyer eller inte. Om detta r pslaget s mste man
  alltid trycka retur fr att vlja i textbaserade menyer.")
    (kom-max-overlays-doc . "\
  Med denna instllning kan man begrnsa antalet frgmarkeringar (som
  anvnds bland annat fr frgade inlggsbakgrunder). Genom att begrnsa
  antalet markeringar kan scrollning g mycket fortare. Varje inlgg
  behver mellan 1 och 4 markeringar beroende p andra instllningar.")
    (kom-mark-read-texts-as-read-in-new-recipient-doc . "\
  Om detta r pslaget s lsmarkeras redan lsta inlgg automatiskt i
  mten de adderas till medan man r inloggad. Om man inte r inloggad
  s sker inte denna lsmarkering. Inlgg som adderas till ens brevlda
  lsmarkeras dock aldrig automatiskt.")
    (kom-url-transformation-rules-doc . "\
  Regler fr att transformera URLer innan de skickas till en webblsare.
  \"Frn\" r ett mnster (en regexp) som skall versttas till texten
  i \"Till\". Dokumentation om regexpar finns i Emacs-manualen. \"Till\" 
  kan innehlla fljande specialtecken:

      \\& erstts med den text som matchar regexpen
      \\N erstts med den text som matchar \(...\)-uttryck N i regexpen
      \\\\ erstts med en \\.")
    (kom-text-links-doc . "\
  Definition av textlnkar. Varje rad definierar en lnk fr inlgg i ett
  visst mte. Alla frekomster av lnkmnstret blir URL-lnkar genom att
  texten som lnkmnstret matchar substitueras enligt lnksubstitutionen.
  Den text som faktist visas som lnk i LysKOM-bufferten bestms av 
  instllningen \"Visa grupp\". Anvnd 0 fr att visa hela den matchande
  texten eller en siffta frn 1 till 9 fr att visa den N-te gruppen i
  lnkmnstret (anvnd 0 om du inte frstr vad som avses med detta). 
  Om instllningen \"Versaler och gemener lika\" r p s rknas versaker
  och gemener av samma bokstav som lika.

  Lnksubstitutionen kan innehlla fljande specialtecken:

      \\& erstts med den text som matchar regexpen
      \\N erstts med den text som matchar \(...\)-uttryck N i regexpen
      \\\\ erstts med en \\.")

    (kom-active-face-doc . "\
  Teckensnitt fr klickbara texter frutom URLer, mten, vnner och
  bekanta, idioter och knppskallar, och inlggsnummer. Vrdet skall 
  vara namnet p en s kallad `face'.")
    (kom-active-highlight-face-doc . "\ 
  Teckensnitt avsett fr klickbara texter som skall markeras extra
  tydligt. Vrdet skall vara namnet p en s kallad `face'.")    
    (kom-active-strikethrough-face-doc . "\ 
  Teckensnitt avsett fr klickbara texter som skall markeras extra
  tydligt. Vrdet skall vara namnet p en s kallad `face'.")
    (kom-url-face-doc . "\
  Teckensnitt fr klickbara URLer.")
    (kom-me-face-doc . "\
  Teckensnitt fr ens eget namn.")
    (kom-highlight-face-doc . "\
  Teckensnitt fr markering av klickbara ytor nr muspekaren frs ver
  dem.")
    (kom-subject-face-doc . "\
  Teckensnitt fr renderader.")
    (kom-text-no-face-doc . "\
  Teckensnitt fr inlggsnummer.")
    (kom-friends-face-doc . "\
  Teckensnitt fr vnner och bekanta. De personer som rknas upp i
  listan \"vnner och bekanta\" kommer att markeras med detta
  teckensnitt.")
    (kom-morons-face-doc . "\
  Teckensnitt fr idioter och knppskallar. De personer som rknas upp
  i listan \"Idioter och knppskallar\" kommer att markeras med detta
  teckensnitt.")
    (kom-presence-face-doc . "\
  Teckensnitt fr nrvaromeddelanden.")
    (kom-first-line-face-doc . "\
  Teckensnitt fr frsta raden i inlggshuvudet. Detta teckensnitt
  verlagras p standardteckensnitten i frsta raden, s de egenskaper
  som inte stts av detta teckensnitt kommer inte att pverkas.")
    (kom-warning-face-doc . "\
  Teckensnitt fr viktiga varningar.")
    (kom-mark-face-doc . "\
  Teckensnitt fr diverse markeringar. Bland annat anvnds detta
  teckensnitt fr markeringen nr elispklienten blddrar mindre n en
  hel skrmsida. Detta teckensnitt verlagras p standardteckensnitten
  dr det anvnds, s de egenskaper som inte stts av detta
  teckensnitt kommer inte att pverkas.")
    (kom-dim-face-doc . "\
  Teckensnitt fr diverse diskreta texter. Detta teckensnitt anvnds
  bland annat fr att visa passiva medlemskap.")
    (kom-text-body-face-doc . "\
  Teckensnitt fr inlggstexter. Detta teckensnitt verlagras p
  standardteckensnitten i inlggstexten, s de egenskaper som inte
  stts av detta teckensnitt kommer inte att pverkas.")
    (kom-dashed-lines-face-doc . "\
  Teckensnitt fr streckrader runt inlgg. Detta teckensnitt
  verlagras p standardteckensnitten i streckraden, s de egenskaper
  som inte stts av detta teckensnitt kommer inte att pverkas.")
    (kom-async-text-body-face-doc . "\
  Teckensnitt fr meddelanden. Detta teckensnitt verlagras p
  standardteckensnitten i meddelandet, s de egenskaper som inte
  stts av detta teckensnitt kommer inte att pverkas.")
    (kom-async-dashed-lines-face-doc . "\
  Teckensnitt fr streckrader runt meddelanden. Detta teckensnitt
  verlagras p standardteckensnitten i streckraderna, s de
  egenskaper som inte stts av detta teckensnitt kommer inte att
  pverkas.") 
    (kom-lynx-terminal-doc . "\
  Lynx kan kras inuti Emacs eller i en xterm (eller motsvarande). Hr
  vljer du vilket.")
    (kom-lynx-terminal-command-doc . "\
  Kommandot som anvnds fr att starta Lynx i Emacs terminal-mode. 
  Ska normalt vara s enkelt som \"lynx\".")
    (kom-lynx-xterm-command-doc . "\
  Kommandot som anvnds fr att starta Lynx i en xterm. Kommandot ska
  starta bde xterm och lynx.")
    (kom-show-sync-messages-doc . "\
  Om denna instllning r pslagen s kommer klienten att visa ett
  meddelande i ekoarean nt servern signallerar att den hller p
  spara databasen.")
    (kom-highlight-conferences-doc . "\
  Denna instllning styr hur mtesnamn frglggs. Fr varje val
  kan ett utseende anges. Utseendena r namn p faces i Emacs.")
    (kom-netscape-variant-doc . "\
  Denna instllning styr var elispklienten frsker ppna URLer. Hur
  bra de olika valen fungerar beror p vilken variant av Firefox, 
  Mozilla, Netscape eller Opera man anvnder, och till och med vilket 
  operativsystem man anvnder.")
    (kom-auto-confirm-new-conferences-doc . "\
  Om den hr instllningen r pslagen s kommer kommandona \"Lista
  nya mten\" och \"Lista nya personer\" automatiskt markera nya
  mten och personer som knda.")
    (kom-text-properties-doc . "\
  Om den hr instllningen r p s kommer klienten att anvnda olika
  typsnitt och frger till olika saker. Till exempel kommer textnummer
  och annat man kan klicka p att visas med en avvikande frg.")
    (kom-fontify-text-doc . "\
  Om den hr instllningen r p s kommer fet och kursiv stil att
  anvndas i inlggstext. Till exempel s kommer ord och fraser
  omgivna av understrykningstecken att visas med kursiv text.")

    ;;
    ;; Tags for variables
    ;;

    (kom-ansaphone-replies-tag . "Detaljerade automatsvar")
    (kom-bury-buffers-tag . "Begrav buffertar nr man byter LysKOM:")

    (kom-personal-messages-in-window-tag . "Personliga meddelanden:   ")
    (kom-customize-in-window-tag       . "Instllningar fr LysKOM: ")
    (kom-write-texts-in-window-tag     . "Skriv inlgg:             ")
    (kom-prioritize-in-window-tag      . "Prioritera mten:         ")
    (kom-edit-filters-in-window-tag    . "ndra filter:             ")
    (kom-view-commented-in-window-tag  . "terse kommentarer:       ")
    (kom-list-membership-in-window-tag . "Lista medlemskap:         ")

    (kom-user-prompt-format-tag . "Promptformat:")
    (kom-user-prompt-format-executing-tag . "Promptformat vid krning:")
    (kom-anonymous-prompt-format-tag . "Promptformat (anonym):")
    (kom-anonymous-prompt-format-executing-tag . "Promptformat vid krning (anonym):")
    (kom-enabled-prompt-format-tag . "Promptformat (admin):")
    (kom-enabled-prompt-format-executing-tag . "Promptformat vid krning (admin):")

    (kom-higher-priority-breaks-tag . 
"Ls prioriterade texter:                  ")
    (kom-created-texts-are-read-tag . 
"Lsmarkera skapade texter:                ")
    (kom-default-mark-tag           . 
"Defaultmarkering:                         ")
    (kom-print-number-of-unread-on-entrance-tag . 
"Visa olsta nr man gr till ett mte:    ")
    (kom-follow-comments-outside-membership-tag .
"Flj kommentarskedjor utanfr medlemskap: ")
    (kom-show-footnotes-immediately-tag .
"Visa fotnoter omedelbart:                 ")
    (kom-membership-default-priority-tag . 
"Prioritet fr nya medlemskap:             ")
    (kom-membership-default-message-flag-tag . 
"Mottag gruppmeddelanden fr nya medlemskap: ")
    (kom-dashed-lines-tag . 
"Streckade linjer kring inlggstexten:     ")
    (kom-autowrap-tag . 
"Automatisk radbrytning vid lsning:       ")
    (kom-autowrap-timeout-tag . 
"Tidsbegrnsning av automatisk radbrytning: ")
    (kom-show-author-at-end-tag .
"Visa frfattarens namn efter inlgget:    ")

    (kom-truncate-threshold-tag .
"Korta av lnga inlgg:                    ")
    (kom-truncate-show-lines-tag .
"Rader att visa vid avkortade inlgg:      ")
    
    (kom-reading-puts-comments-in-pointers-last-tag . "Kommentarslnkar visas:")
    (kom-read-depth-first-tag . "Lsordning:")
    (kom-read-related-first-tag . "Ls relaterade texter frst:")
    (kom-deferred-printing-tag . "Frdrjda utskrifter:")
    (kom-continuous-scrolling-tag . "Omedelbar scrollning:")

    (kom-presence-messages-in-echo-area-tag . 
"Nrvaromeddelanden i ekoarean:        ")
    (kom-presence-messages-in-buffer-tag .
"Nrvaromeddelanden i LysKOM-bufferten:")
    (kom-page-before-command-tag . "Rensa skrmen:")

    (kom-remember-password-tag . "Kom ihg LysKOM-sessionslsenordet:")

    (kom-idle-hide-tag . 
"Antal minuter en session fr vara inaktiv och nd visas: ")
    (kom-show-where-and-what-tag . 
"Visa varifrn personer r inloggade och vad de gr:         ")
    (kom-show-since-and-when-tag . 
"Visa nr personer loggade in och nr de var aktiva:         ")



    (kom-login-hook-tag . "Kommandon som krs vid login:")
    (kom-do-when-done-tag . "Kommandon som krs efter allt r utlst:")
    (kom-permissive-completion-tag . "Petig utfyllnad av namn:")
    (kom-show-personal-messages-in-buffer-tag . 
"Var visas meddelanden:           ")
    (kom-pop-personal-messages-tag . 
"Ploppa upp meddelandebufferten:  ")
    (kom-default-message-recipient-tag . 
"Defaultmottagare fr meddelanden:")

    (kom-audio-player-tag . "Ljudspelarprogram:")
    (kom-ding-on-new-letter-tag        . "Nr det kommer brev:                ")
    (kom-ding-on-priority-break-tag    . "Nr det kommer prioriterade inlgg: ")
    (kom-ding-on-wait-done-tag         . "Nr man har vntat klart:           ")
    (kom-ding-on-common-messages-tag   . "Vid alarmmeddelanden:               ")
    (kom-ding-on-group-messages-tag    . "Vid gruppmeddelanden:               ")
    (kom-ding-on-personal-messages-tag . "Vid personliga meddelanden:         ")
    (kom-ding-on-no-subject-tag        . "Nr renderad saknas:               ")

    (kom-filter-outgoing-messages-tag . "Visa automatiska meddelanden:")
    (kom-friends-tag . "Vnner och bekanta:")
    (kom-morons-tag . "Idioter och knppskallar:")
    (kom-person-list-1-tag . "Mtes/personlista (1):")
    (kom-person-list-2-tag . "Mtes/personlista (2):")
    (kom-person-list-3-tag . "Mtes/personlista (3):")
    (kom-person-list-4-tag . "Mtes/personlista (4):")
    (kom-url-viewer-preferences-tag . "ppna URLer med fljande program:")
    (kom-windows-browser-command-tag . "Kommando fr att starta en WWW-lsare i Windows:")
    (kom-mosaic-command-tag . "Kommando fr att starta NCSA Mosaic:")
    (kom-netscape-command-tag . "Kommando fr att starta Netscape-liknande WWW-lsare:")
    (kom-galeon-command-tag . "Kommando fr att starta Galeon:")

    (kom-symbolic-marks-alist-tag . "Symboliska markeringstyper:")

    (kom-cite-string-tag . "Citatmarkering:")
    (kom-confirm-multiple-recipients-tag . 
"Bekrfta multipla mottagare:                   ")
    (kom-check-commented-author-membership-tag . 
"Kontrollera kommenterad frfattares medlemskap:")
    (kom-check-for-new-comments-tag . 
"Kontrollera olsta kommentarer:                ")

    (kom-ansaphone-record-messages-tag . 
"Spara meddelanden d automatiskt svar r pslaget: ")
    (kom-ansaphone-show-messages-tag . 
"Visa meddelanden d automatiskt svar r pslaget:  ")
    (kom-ansaphone-default-reply-tag . "Svarsmeddelande:")


    (kom-inhibit-typeahead-tag . "Buffra tangenttryckningar:")
    (kom-max-buffer-size-tag . "Maximal buffertstorlek:")

    (kom-remote-control-tag .     "Fjrrstyrning:                     ")
    (kom-self-control-tag .       "Tillt fjrrstyrning av mig sjlv: ")
    (kom-remote-controllers-tag . "Tilltna fjrrstyrare:")

    (kom-customize-format-tag . "Visa hjlptexterna fr instllningar:")
    (kom-default-language-tag . "Sprklista:")
    (kom-ispell-dictionary-tag . "Ordlista:")
    (kom-show-namedays-tag .    "Visa dagens namn:")
    (kom-show-week-number-tag . "Visa veckonummer:")

    (kom-relogin-behaviour-tag . "teranslut automatiskt:")
    (kom-relogin-inhibit-commands-tag . "Kommandon fr vilka teranslutning aldrig sker automatiskt:")
    (kom-membership-default-placement-tag . "Placering av nya medlemskap:")
    (kom-show-imported-importer-tag . "Visa importr av importerade inlgg:")
    (kom-show-imported-envelope-sender-tag . "Visa avsndare av importerade inlgg:")
    (kom-show-imported-external-recipients-tag . "Visa externa mottagare till importerade inlgg:")
    (kom-show-imported-message-id-tag . "Visa meddelande-id fr importerade inlgg:")
    (kom-agree-text-tag . "Text fr Hlla med:")
    (kom-silent-ansaphone-tag . "Pip nr automatsvar r pslaget:")
    (kom-default-session-priority-tag . "Lsniv fr nya sessioner:")
    (kom-unsubscribe-makes-passive-tag . "Uttrda ur mte gr om medlemskap till passiva:")
    (kom-review-priority-tag . "Prioritet fr tersekommandon:")
    (kom-show-creating-software-tag . "Visa skapande klient:")
    (kom-text-footer-format-tag . "Format fr inlggsfot:")
    (kom-long-lines-tag . "Lnga streckade linjer:")
    (kom-postpone-default-tag . "Sknsvrde fr uppskjuta lsning:")
    (kom-allow-incompleteness-tag . "Tillt ofullstndig information om olsta:")
    (kom-smileys-tag . "Visa gladmn grafiskt:")
    (kom-ignore-message-senders-tag . "Visa inte meddelanden frn:")
    (kom-ignore-message-recipients-tag . "Visa inte meddelanden till:")
    (kom-text-footer-dash-length-tag . "Inlggsfotens lngd:")
    (kom-text-header-dash-length-tag . "Lngden p linjen ovanfr inlggstexten:")
    (kom-show-personal-message-date-tag . "Visa datum fr alla meddelanden:")
    (kom-w3-simplify-body-tag . "Visa HTML utan standardfrger:")
    (kom-mercial-tag . "Text nr allt r utlst:")
    (kom-session-nickname-tag . "Hur bestms sessionsnamn:")
    (kom-server-priority-tag . "Sessionsprioritet:")   
    (kom-server-priority-breaks-tag . "Byt till LysKOM med olsta:")
    (kom-complete-numbers-before-names-tag . "Ls mtesnummer fre mtesnamn:")
    (kom-keep-alive-interval-tag . "Intervall fr hll frbindelsen igng:")
    (kom-lost-session-notification-tag . "Notifiering av onormalt avslutade sessioner:")
    (kom-text-no-prompts-tag . "Hur kommandon frgar efter textnummer:")
    (kom-saved-file-name-tag . "Fil att arkivera inlgg i:")
    (kom-follow-attachments-tag . "Ls importerade bilagor som vanligt:")
    (kom-show-unread-in-frame-title-tag . "Visa olstamarkering i titelraden:")
    (kom-unread-mode-line-type-tag . "Typ av olstaindikering i mode-raden:")
    (kom-created-texts-are-saved-tag . "Spara frfattade inlgg:")
    (kom-confirm-add-recipients-tag . "Frga om kommentarer skall sndas till nya mottagare:")
    (kom-trim-buffer-minimum-tag . "Minsta storlek av LysKOM-bufferten som tas bort:")
    (kom-dont-check-commented-authors-tag . "Frfattare som inte kontrolleras:")
    (kom-print-relative-dates-tag . "Visa relativa datumangivelser:")
    (kom-show-mx-date-as-local-tag . "Visa tidstmplar i lokal tidzon:")
    (kom-print-seconds-in-time-strings-tag . "Inkludera sekunder i tidsangivelser:")
    (kom-review-uses-cache-tag . "tersekommandon anvnder sparade inlgg:")
    (kom-review-marks-texts-as-read-tag . "tersekommandon lsmarkerar visade texter:")
    (kom-auto-review-faqs-tag . "Visa nya FAQer automatiskt:")
    (kom-auto-list-faqs-tag . "Lista nya FAQer automatiskt:")
    (kom-extended-status-information-tag . "Utkad statusinformation:")
    (kom-highlight-first-line-tag . "Annorlunda bakgrundsfrg p frsta raden:")
    (kom-highlight-dashed-lines-tag . "Annorlunda bakgrundsfrg fre och efter inlggstexten:")
    (kom-highlight-text-body-tag . "Annorlunda bakgrundsfrg p inlggstexten:")
    (kom-async-highlight-dashed-lines-tag . "Annorlunda bakgrundsfrg fre och efter meddelanden:")
    (kom-async-highlight-text-body-tag . "Annorlunda bakgrundsfrg p meddelanden:")
    (kom-edit-hide-add-button-tag . "Visa Addera-knappen nr man skriver inlgg:")
    (kom-format-html-authors-tag . "Formattera HTML-meddelanden per frfattare:")
    (kom-format-show-images-tag . "Visa bildinlgg som bilder:")
    (kom-keyboard-menu-immediate-selection-tag . "Snabbval i textmenyer krver bekrftelse:")
    (kom-max-overlays-tag . "Hgsta antal frgmarkeringar:")
    (kom-mark-read-texts-as-read-in-new-recipient-tag . "Markera lsta inlgg lsta ven i nya mottagare:")
    (kom-url-transformation-rules-tag . "Transformation av URLer:")
    (kom-text-links-tag . "Textlnkar:")
    (kom-active-face-tag . "vriga klickbara texter:")
    (kom-active-highlight-face-tag . "Tydligare markerade klickbara texter:")
    (kom-active-strikethrough-face-tag . "verstrukna klickbara texter:")
    (kom-url-face-tag . "Klickbara URLer:")
    (kom-me-face-tag . "Mitt eget namn:")
    (kom-highlight-face-tag . "Markering av klickbara ytor:")
    (kom-subject-face-tag . "renderader:")
    (kom-text-no-face-tag . "Inlggsnummer:")
    (kom-friends-face-tag . "Vnner och bekanta:")
    (kom-morons-face-tag . "Idioter och knppskallar:")
    (kom-presence-face-tag . "Nrvaromeddelanden:")
    (kom-first-line-face-tag . "Frsta raden i inlggshuvudet:")
    (kom-warning-face-tag . "Viktiga varningar:")
    (kom-mark-face-tag . "Diverse markeringar:")
    (kom-dim-face-tag . "Diverse diskreta texter:")
    (kom-text-body-face-tag . "Inlggstexter:")
    (kom-dashed-lines-face-tag . "Streckrader runt inlgg:")
    (kom-async-text-body-face-tag . "Meddelanden:")
    (kom-async-dashed-lines-face-tag . "Streckrader runt meddelanden:")
    (kom-lynx-terminal-command-tag . "Kommando fr Lynx i Emacs:")
    (kom-lynx-terminal-tag . "Var ska Lynx kra:")
    (kom-lynx-xterm-command-tag . "Kommando fr Lynx i xterm:")
    (kom-show-sync-messages-tag . "Visa databasen-sparar-meddelanden:")
    (kom-highlight-conferences-tag . "Frglggning av namn:")
    (kom-netscape-variant-tag . "Var ska Netscape-liknande WWW-lsare ppna URLer:")
    (kom-auto-confirm-new-conferences-tag . "Markera alltid nya mten och personer som knda:")
    (kom-text-properties-tag . "Anvnd typsnitt och frger:")
    (kom-fontify-text-tag . "Visa fetstil och kursiv text i inlgg:")
    )
)

  
;;;; ============================================================
;;;; The default Ansaphone message goes here. The more complex 
;;;; message specification probably should too, but it's not here
;;;; yet. People who know how to use it are smart enough to do it
;;;; right.

(lyskom-language-var local kom-ansaphone-default-reply sv
  "Jag lser inte LysKOM just nu. Skicka grna ett brev i stllet.")

;;;; ============================================================
;;;; Other language-dependent variables
;;;;

(lyskom-language-var local kom-ispell-dictionary sv
  "svenska")


;;;; ================================================================
;;;; Tell phrases should really be configured with the default
;;;; language used at the server and not for person reading if they
;;;; happen to differ. This is of coarse because they are sent to the
;;;; server for everybody else to see.

;;;; Aronsson was here 4 DEC 1990, thus creating version 0.18
					; Created *-tell-*


;;;; kom-tell-phrases 

;;; To coders of the elisp-client:
;;; if you change kom-tell-phrases here, make sure the list of valid
;;; keywords is updated it in vars.el.
;;; lyskom-tell-phrases-validation-keyword-list, lyskom-tell-phrases-validate

(eval-when-compile (defvar kom-tell-phrases))

(lyskom-language-strings local kom-tell-phrases sv
 '((kom-tell-silence		. "")   ; Why ?
   (kom-tell-send		. "Frsker lgga in en text.")
   (kom-tell-login		. "Loggar in.")
   (kom-tell-read		. "Lser.")
   (kom-tell-1st-pres		. "Skriver den frsta presentationen.")
   (kom-tell-write-comment	. "Skriver en kommentar.")
   (kom-tell-write-footnote	. "Skriver en fotnot.")
   (kom-tell-write-letter	. "Skriver ett brev.")
   (kom-tell-write-reply	. "Skriver ett privat svar.")
   (kom-tell-write-text	. "Skriver inlgg.")
   (kom-tell-conf-pres		. "Skriver presentation fr ett nytt mte.")
   (kom-tell-recover		. "terstartar kom. Suck.")
   (kom-tell-wait		. "Vntar.")
   (kom-tell-regret		. "ngrar sig och slnger inlgget.")
   (kom-tell-review		. "terser.")
   (kom-tell-change-name       . "ndrar sitt namn till ngot annat.")
   (kom-tell-change-supervisor . "ndrar organisatr fr ngot.")
   (kom-tell-next-lyskom       . "Hoppar till ett annat LysKOM.")))

(if (and (boundp 'kom-tell-phrases)
         kom-tell-phrases)
    (lyskom-language-strings local kom-tell-phrases sv
      (mapcar (function 
               (lambda (x)
                 (cond ((and (consp x)
                             (symbolp (car x))
                             (stringp (cdr x))) x)
                       ((and (consp x)
                             (symbolp (car x))
                             (consp (cdr x))
                             (stringp (car (cdr x))))
                        (cons (car x) (car (cdr x))))
                       (t nil))))
              kom-tell-phrases)))


;; Placed here because this must NOT be evaluated before 
;; kom-tell-phrases is defined:

(lyskom-language-var local kom-mercial sv
                     (lyskom-get-string 'kom-tell-wait 'kom-tell-phrases))

;;;


(lyskom-language-strings local lyskom-error-texts sv
  '((error-0 . "Inget fel har intrffat")
    (error-2 . "nnu ej implementerat i servern")
    (error-3 . "Inte lngre implementerat i servern")
    (error-4 . "Felaktigt lsenord")
    (error-5 . "Strngen fr lng")
    (error-6 . "Du r inte inloggad")
    (error-7 . "Ingen fr logga in i LysKOM just nu")
    (error-8 . "Du frskte anvnda mte nummer 0")
    (error-9 . "Odefinierat eller hemligt mte")
    (error-10 . "Odefinierad eller hemlig person")
    (error-11 . "Ingen skriv- eller lsrttighet")
    (error-12 . "Otillten operation")
    (error-13 . "Du r inte medlem i mtet")
    (error-14 . "Inget sdant textnummer")
    (error-15 . "Du kan inte anvnda globalt textnummer 0")
    (error-16 . "Inget sdant lokalt textnummer")
    (error-17 . "Du kan inte anvnda lokalt textnummer 0")
    (error-18 . "Namnet fr kort, fr lngt eller innehller felaktiga tecken")
    (error-19 . "Index utanfr grnserna")
    (error-20 . "Mtet existerar redan")
    (error-21 . "Personen existerar redan")
    (error-22 . "Hemligt, men ej lsskyddat")
    (error-23 . "Du fr inte ndra person/mtesflaggan")
    (error-24 . "Fel i databasen. Attans otur.")
    (error-25 . "Otillten mottagartyp eller kommentarslnk")
    (error-26 . "Otillten infotyp. (Bug i klienten)")
    (error-27 . "Redan mottagare till denna text")
    (error-28 . "Redan kommentar till denna text")
    (error-29 . "Redan fotnot till denna text")
    (error-30 . "Inte mottagare till denna text")
    (error-31 . "Inte kommentar till denna text")
    (error-32 . "Inte fotnot till denna text")
    (error-33 . "Fr mnga mottagare")
    (error-34 . "Fr mnga kommentarer")
    (error-35 . "Fr mnga fotnoter")
    (error-36 . "Fr mnga markeringar")
    (error-37 . "Du r inte frfattare till texten")
    (error-38 . "Du kan inte koppla upp dig till servern")
    (error-39 . "Minnet slut")
    (error-40 . "Servern har ballat ur")
    (error-41 . "Klienten tror att servern sger att den inte frstr klienten")
    (error-42 . "Ingen sdan session finns")
    (error-43 . "Ogiltigt reguljrt uttryck")
    (error-44 . "Texten r inte markerad")
    (error-45 . "Tillflligt fel. Frsk senare")
    (error-46 . "Serven vgrade ta emot en array")
    (error-47 . "Mottagaren tar inte emot anonyma texter")
    (error-48 . "Otillten tillggsinformation")
    (error-49 . "Otillten ndring av tillggsinformation")
    (error-50 . "Oknt asynkront meddelande")
    (error-51 . "Internt fel i servern")
    (error-52 . "Funktionen avstngd i servern")
    (error-53 . "Mottagaren var kanske inte inloggad")
    (error-54 . "Otillten typ p medlemskap")
    (error-55 . "Ogiltigt intervall")
    (error-56 . "Ogiltig kombination av intervall")
    (error-57 . "Odefinierad mtning")
    (error-58 . "Otillten prioritet")
    (error-59 . "Otillten viktning")
    (error-60 . "Viktning noll ej giltig")
    (error-61 . "Ogiltigt sanningsvrde")

    (error--1 . "Du r inte medlem i ngot mottagarmte")
))

(lyskom-language-var global lyskom-unread-mode-line sv
  (lyskom-make-lyskom-unread-mode-line))

(lyskom-language-var global lyskom-unread-title-format sv
  (lyskom-make-lyskom-unread-title-format))

(lyskom-language-var local lyskom-help-data sv lyskom-sv-help-data)

(provide 'lyskom-language-sv)

;;; swedish-strings.el ends here
