/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFStream;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class PDFImage
extends PDFStream
implements ImageObserver,
Serializable {
    private int objwidth;
    private int objheight;
    private int width;
    private int height;
    private Image img;
    private String name;

    public PDFImage() {
        super("/XObject");
    }

    public PDFImage(Image image) {
        this();
        this.setImage(image, 0, 0, image.getWidth(this), image.getHeight(this), this);
    }

    public PDFImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this();
        this.objwidth = n3;
        this.objheight = n4;
        this.setImage(image, n, n2, image.getWidth(this), image.getHeight(this), imageObserver);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.img = image;
        this.width = n3;
        this.height = n4;
    }

    private String base85Encoding(String string) throws NumberFormatException {
        long l;
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() > 8 || string.length() % 2 != 0) {
            System.out.println("PDFImage.base85Encoding, Incorrect tuple length: " + string.length());
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length() / 2;
        int n2 = 4 - n;
        for (int i = 0; i < n2; ++i) {
            string = string + "00";
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        for (l = Long.parseLong(string, 16); l >= 85L; l /= 85L) {
            n3 = (int)(l % 85L);
            vector.add(0, n3);
        }
        vector.add(0, (int)l);
        for (int i = 0; i < vector.size(); ++i) {
            char c = (char)((Integer)vector.elementAt(i) + 33);
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        int n4 = string2.length();
        switch (n4) {
            case 1: {
                string2 = "!!!!" + string2;
                break;
            }
            case 2: {
                string2 = "!!!" + string2;
                break;
            }
            case 3: {
                string2 = "!!" + string2;
                break;
            }
            case 4: {
                string2 = "!" + string2;
                break;
            }
        }
        return string2;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        this.buf.writeTo(deflaterOutputStream);
        deflaterOutputStream.finish();
        deflaterOutputStream.close();
        outputStream.write("/Filter [/FlateDecode /ASCII85Decode]\n".getBytes());
        outputStream.write("/Length ".getBytes());
        outputStream.write(Integer.toString(byteArrayOutputStream.size()).getBytes());
        outputStream.write("\n>>\nstream\n".getBytes());
        byteArrayOutputStream.writeTo(outputStream);
        outputStream.write("\nendstream\nendobj\n".getBytes());
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Subtype /Image\n/Name ".getBytes());
        outputStream.write(this.name.getBytes());
        outputStream.write("\n/Width ".getBytes());
        outputStream.write(Integer.toString(this.width).getBytes());
        outputStream.write("\n/Height ".getBytes());
        outputStream.write(Integer.toString(this.height).getBytes());
        outputStream.write("\n/BitsPerComponent 8\n/ColorSpace /DeviceRGB\n".getBytes());
        ByteArrayOutputStream byteArrayOutputStream = this.getStream();
        int n = this.width;
        int n2 = this.height;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(this.img, n3, n4, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                stringBuilder.append(PDFImage.handlePixel(n3 + j, n4 + i, nArray[i * n + j]));
                if (stringBuilder.toString().length() < 8) continue;
                String string = stringBuilder.substring(0, 8);
                stringBuilder.delete(0, 8);
                String string2 = this.base85Encoding(string);
                if (string2.equals("!!!!!")) {
                    string2 = "z";
                }
                byteArrayOutputStream.write(string2.getBytes());
            }
        }
        String string = this.base85Encoding(stringBuilder.toString());
        byteArrayOutputStream.write(string.getBytes());
        byteArrayOutputStream.write("~".getBytes());
        this.setDeflate(false);
        this.writeStream(outputStream);
    }

    public static String handlePixel(int n, int n2, int n3) {
        int n4 = n3 >> 24 & 0xFF;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        String string = Integer.toHexString(n5);
        String string2 = Integer.toHexString(n6);
        String string3 = Integer.toHexString(n7);
        if (string.length() == 1) {
            string = "0" + string;
        }
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        System.err.println("img=" + image + "\ninfoflags=" + n + "\nx=" + n2 + " y=" + n3 + " w=" + n4 + " h=" + n5);
        if (n == 1) {
            this.width = n4;
        }
        if (n == 2) {
            this.height = n5;
        }
        return false;
    }
}

