### NAME

sntrup - C API for the libntruprime implementation of the Streamlined NTRU Prime cryptosystem

### SYNOPSIS

Using libntruprime:

    #include <ntruprime.h>

Link with `-lntruprime`.

Key generation (for, e.g., `sntrup1277`):

    unsigned char pk[sntrup1277_PUBLICKEYBYTES];
    unsigned char sk[sntrup1277_SECRETKEYBYTES];

    sntrup1277_keypair(pk,sk);

Encapsulation (for, e.g., `sntrup1277`):

    unsigned char ct[sntrup1277_CIPHERTEXTBYTES];
    unsigned char k[sntrup1277_BYTES];
    const unsigned char pk[sntrup1277_PUBLICKEYBYTES];

    sntrup1277_enc(ct,k,pk);

Decapsulation (for, e.g., `sntrup1277`):

    unsigned char k[sntrup1277_BYTES];
    const unsigned char ct[sntrup1277_CIPHERTEXTBYTES];
    const unsigned char sk[sntrup1277_SECRETKEYBYTES];

    sntrup1277_dec(k,ct,sk);

### DESCRIPTION

libntruprime is an implementation
of the [Streamlined NTRU Prime](https://ntruprime.cr.yp.to) cryptosystem.
The C API for libntruprime
provides the following functions:

    sntrup{653,761,857,953,1013,1277}_keypair
    sntrup{653,761,857,953,1013,1277}_enc
    sntrup{653,761,857,953,1013,1277}_dec

All of these functions follow the
[SUPERCOP API for KEMs](https://bench.cr.yp.to/call-kem.html)
except that

* the function names are libntruprime-specific instead of `crypto_kem_*`,
* message lengths are `long long` instead of `unsigned long long`, and
* the functions return `void` instead of `int`.

The details below use `sntrup1277` as an example.

### KEY GENERATION

The `sntrup1277_keypair` function randomly generates
Alice's secret key
`sk[0]`, `sk[1]`, ..., `sk[sntrup1277_SECRETKEYBYTES-1]`
and
Alice's corresponding public key
`pk[0]`, `pk[1]`, ..., `pk[sntrup1277_PUBLICKEYBYTES-1]`.

### ENCAPSULATION

The `sntrup1277_enc` function randomly generates
a ciphertext `ct[0]`, `ct[1]`, ..., `ct[sntrup1277_CIPHERTEXTBYTES-1]`
and the corresponding session key
`k[0]`, `k[1]`, ..., `k[sntrup1277_BYTES-1]`
given Alice's public key
`pk[0]`, `pk[1]`, ..., `pk[sntrup1277_PUBLICKEYBYTES-1]`.

### DECAPSULATION

The `sntrup1277_dec` function,
given Alice's secret key
`sk[0]`, `sk[1]`, ..., `sk[sntrup1277_SECRETKEYBYTES-1]`,
computes the session key
`k[0]`, `k[1]`, ..., `k[sntrup1277_BYTES-1]`
corresponding to a ciphertext
`ct[0]`, `ct[1]`, ..., `ct[sntrup1277_CIPHERTEXTBYTES-1]`
that was encapsulated to Alice.

### SEE ALSO

**sntrup**(1), **randombytes**(3)
